/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.GeoStyle;
import com.supermap.data.InternalHandle;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeDotDensityNative;

public class ThemeDotDensity
extends Theme {
    private GeoStyle m_geoStyle = null;

    public ThemeDotDensity() {
        long l = ThemeDotDensityNative.jni_New();
        this.setHandle(l, true);
    }

    public ThemeDotDensity(ThemeDotDensity themeDotDensity) {
        if (themeDotDensity == null) {
            String string = InternalResource.loadString("themeDotDensity", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = themeDotDensity.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("themeDotDensity", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ThemeDotDensityNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeDotDensity));
    }

    ThemeDotDensity(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
    }

    public double getValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeDotDensityNative.jni_GetValue(this.getHandle());
    }

    public void setValue(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setValue(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("setValue(double value)", "Global_ArgumentShouldNotBeNegative", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeDotDensityNative.jni_SetValue(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public String getDotExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDotExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeDotDensityNative.jni_GetDotExpression(this.getHandle());
    }

    public void setDotExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDotExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeDotDensityNative.jni_SetDotExpression(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public GeoStyle getStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoStyle == null && (l = ThemeDotDensityNative.jni_GetStyle(this.getHandle())) != 0L) {
            this.m_geoStyle = InternalGeoStyle.createInstance(l);
        }
        return this.m_geoStyle;
    }

    public void setStyle(GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        GeoStyle geoStyle = style.clone();
        long l2 = com.supermap.data.InternalHandleDisposable.getHandle((InternalHandle)geoStyle);
        ThemeDotDensityNative.jni_SetStyle(this.getHandle(), l2);
        this.m_lock.unlock();
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    @Override
    public boolean fromXML(String xml) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = super.fromXML(xml);
            if (bl && this.m_geoStyle != null) {
                InternalGeoStyle.clearHandle(this.m_geoStyle);
                this.m_geoStyle = null;
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeDotDensityNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Value = ");
        stringBuffer.append(this.getValue());
        stringBuffer.append(",DotExpression = ");
        stringBuffer.append(this.getDotExpression());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    @Override
    protected void clearHandle() {
        if (this.m_geoStyle != null) {
            InternalGeoStyle.clearHandle(this.m_geoStyle);
            this.m_geoStyle = null;
        }
        this.setHandle(0L);
    }
}

