/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.DatasetMosaic;
import com.supermap.data.InternalHandle;
import com.supermap.data.Workspace;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerMosaicNative;
import com.supermap.mapping.LayerSetting;
import com.supermap.mapping.LayerSettingImage;
import com.supermap.mapping.Layers;
import com.supermap.mapping.Map;
import com.supermap.mapping.MosaicClipModeType;

public class LayerMosaic
extends Layer {
    private LayerSettingImage m_settingImage;
    private DatasetMosaic m_dtMosaic;

    protected LayerMosaic(long handle, Layers layers, Map map) {
        super(handle, layers, map);
    }

    protected LayerMosaic(long handle, Layers layers) {
        super(handle, layers, null);
        this.m_settingImage = null;
    }

    public String getPathFieldName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPathFieldName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerMosaicNative.jni_GetPathFiledName(this.getHandle());
    }

    public void setPathFieldName(String pathFieldName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPathFieldName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (pathFieldName == null || pathFieldName.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerMosaicNative.jni_SetPathFiledName(this.getHandle(), pathFieldName);
    }

    public String getMINPSFiledName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMINPSFiledName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerMosaicNative.jni_GetMINPSFiledName(this.getHandle());
    }

    public void setMINPSFiledName(String minPSFieldName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMINPSFiledName", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (minPSFieldName == null || minPSFieldName.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerMosaicNative.jni_SetMINPSFiledName(this.getHandle(), minPSFieldName);
    }

    public String getMAXPSFiledName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMAXPSFiledName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerMosaicNative.jni_GetMAXPSFiledName(this.getHandle());
    }

    public void setMAXPSFiledName(String maxPSFieldName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMAXPSFiledName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (maxPSFieldName == null || maxPSFieldName.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerMosaicNative.jni_SetMAXPSFiledName(this.getHandle(), maxPSFieldName);
    }

    public boolean isUseBlockCache() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isUseBlockCache()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerMosaicNative.jni_IsUseBlockCache(this.getHandle());
    }

    public void setUseBlockCache(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUseBlockCache()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerMosaicNative.jni_SetUseBlockCache(this.getHandle(), value);
    }

    public int getBlockCacheCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBlockCacheCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerMosaicNative.jni_GetBlockCacheCount(this.getHandle());
    }

    public void setBlockCacheCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBlockCacheCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 1) {
            String string = InternalResource.loadString("value", "ThemeLabel_TheArgumentOfRangeParameterShouldNotBeLessThanOneRange", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        LayerMosaicNative.jni_SetBlockCacheCount(this.getHandle(), value);
    }

    public boolean isUseFileHandleCache() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isUseBlockCache()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerMosaicNative.jni_IsUseFileHandleCache(this.getHandle());
    }

    public void setUseFileHandleCache(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUseBlockCache()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerMosaicNative.jni_SetUseFileHandleCache(this.getHandle(), value);
    }

    public int getFileHandleCacheCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFileHandleCacheCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerMosaicNative.jni_GetFileHandleCacheCount(this.getHandle());
    }

    public void setFileHandleCacheCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFileHandleCacheCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 1) {
            String string = InternalResource.loadString("value", "ThemeLabel_TheArgumentOfRangeParameterShouldNotBeLessThanOneRange", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        LayerMosaicNative.jni_SetFileHandleCacheCount(this.getHandle(), value);
    }

    public LayerSettingImage getLayerSettingImage() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLayerSettingImage()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_settingImage == null) {
            this.m_settingImage = new LayerSettingImage(this, this.m_layers);
        }
        return this.m_settingImage;
    }

    public void setLayerSettingImage(LayerSetting layerSetting) {
        LayerSettingImage layerSettingImage = (LayerSettingImage)layerSetting;
        if (this.m_settingImage == null) {
            this.m_settingImage = new LayerSettingImage(this, this.m_layers);
        }
        this.m_settingImage.setOpaqueRate(layerSettingImage.getOpaqueRate());
        this.m_settingImage.setTransparentColorEnabled(layerSettingImage.isTransparentColorEnabled());
        this.m_settingImage.setTransparentColor(layerSettingImage.getTransparentColor());
        this.m_settingImage.setBrightness(layerSettingImage.getBrightness());
        this.m_settingImage.setContrast(layerSettingImage.getContrast());
        this.m_settingImage.setTransparentColorTolerance(layerSettingImage.getTransparentColorTolerance());
        this.m_settingImage.setImageBackgroundReplace(layerSettingImage.isImageBackgroundReplace());
        this.m_settingImage.setBackgroundTransparent(layerSettingImage.isBackgroundTransparent());
        this.m_settingImage.setBackgroundColor(layerSettingImage.getBackgroundColor());
        this.m_settingImage.setBackgroundValue(layerSettingImage.getBackgroundValue());
        this.m_settingImage.setImageSpecialValueReplace(layerSettingImage.isImageSpecialValueReplace());
        this.m_settingImage.setSpecialValue(layerSettingImage.getSpecialValue());
        this.m_settingImage.setSpecialValueColor(layerSettingImage.getSpecialValueColor());
        this.m_settingImage.setSpecialValueTransparent(layerSettingImage.isSpecialValueTransparent());
        this.m_settingImage.setColorDictionary(layerSettingImage.getColorDictionary());
        if (layerSettingImage.getDisplayBandIndexes() != null) {
            this.m_settingImage.setDisplayColorSpace(layerSettingImage.getDisplayColorSpace());
            this.m_settingImage.setDisplayBandIndexes(layerSettingImage.getDisplayBandIndexes());
        }
        this.m_settingImage.setImageInterpolationMode(layerSettingImage.getImageInterpolationMode());
        if (layerSettingImage.getImageStretchOption() != null) {
            this.m_settingImage.setImageStretchOption(layerSettingImage.getImageStretchOption());
        }
        if (layerSettingImage.getColorTable() != null) {
            this.m_settingImage.setColorTable(layerSettingImage.getColorTable());
        }
    }

    public DatasetMosaic getDatasetMosaic() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDatasetMosaic()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_dtMosaic == null) {
            long l = LayerMosaicNative.jni_GetMosaicDataset(this.getHandle());
            Workspace workspace = this.m_map.getWorkspace();
            this.m_dtMosaic = (DatasetMosaic)InternalToolkitMapping.toMangedDataset(workspace, l);
        }
        return this.m_dtMosaic;
    }

    public boolean isPaintByFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isPaintByFile()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerMosaicNative.jni_IsPaintByFile(this.getHandle());
    }

    public void setPaintByFile(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPaintByFile()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerMosaicNative.jni_SetPaintByFile(this.getHandle(), value);
    }

    public MosaicClipModeType getClipMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = LayerMosaicNative.jni_GetClipMode(this.getHandle());
        return (MosaicClipModeType)InternalEnum.parseUGCValue(MosaicClipModeType.class, n);
    }

    public void setClipMode(MosaicClipModeType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(value);
        LayerMosaicNative.jni_SetClipMode(this.getHandle(), n);
    }

    static boolean isLayerMosaicChildLayer(Layer layer) {
        if (LayerMosaic.getHandle((InternalHandle)layer) == 0L) {
            String string = InternalResource.loadString("setClipMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = LayerMosaicNative.jni_IsLayerMosaicChildLayer(LayerMosaic.getHandle((InternalHandle)layer));
        return bl;
    }
}

