/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.mapping.DynamicLayerNative;
import com.supermap.mapping.InternalGeometry;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;

public class DynamicLayer
extends InternalHandleDisposable {
    ReentrantLock m_lock;
    private HashMap<String, Geometry> m_tagGeoDic;

    public DynamicLayer() {
        long l = DynamicLayerNative.jni_New();
        this.setHandle(l, true);
        this.m_tagGeoDic = new HashMap();
        this.m_lock = new ReentrantLock();
    }

    public DynamicLayer(long handle) {
        this.setHandle(handle, false);
        this.m_tagGeoDic = new HashMap();
        this.m_lock = new ReentrantLock();
        this.reset();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            DynamicLayerNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return DynamicLayerNative.jni_GetCount(this.getHandle());
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return DynamicLayerNative.jni_GetIsVisible(this.getHandle());
    }

    public void setVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        DynamicLayerNative.jni_SetIsVisible(this.getHandle(), value);
    }

    public boolean isSymbolScalable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsSymbolScalable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return DynamicLayerNative.jni_GetIsSymbolScalable(this.getHandle());
    }

    public void setSymbolScalable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsSymbolScalable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        DynamicLayerNative.jni_SetIsSymbolScalable(this.getHandle(), value);
    }

    public double getSymbolScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return DynamicLayerNative.jni_GetSymbolScale(this.getHandle());
    }

    public void setSymbolScale(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "TrackingLayer_SymbolScaleShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        DynamicLayerNative.jni_SetSymbolScale(this.getHandle(), value);
    }

    public boolean isAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return DynamicLayerNative.jni_GetIsAntialias(this.getHandle());
    }

    public void setAntialias(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAntialias(value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        DynamicLayerNative.jni_SetAntialias(this.getHandle(), value);
    }

    public int hitTest(Point2D point, double tolerance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D point, double tolerance)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "TrackingLayer_InvalidTolerance", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return DynamicLayerNative.jni_HitTest(this.getHandle(), point.getX(), point.getY(), tolerance);
    }

    public int add(Geometry geometry, String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Geometry geometry, String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (tag == null || tag.equals("")) {
            String string = InternalResource.loadString("tag", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        int n = -1;
        if (DynamicLayerNative.jni_Add(this.getHandle(), l, tag)) {
            InternalGeometry.setIsDisposable(geometry, false);
            this.m_tagGeoDic.put(tag, geometry);
            n = this.m_tagGeoDic.size() - 1;
            DynamicLayer.makeSureNativeObjectLive((Object)geometry);
        }
        this.m_lock.unlock();
        return n;
    }

    public Geometry get(String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (tag == null || tag.equals("")) {
            String string = InternalResource.loadString("get(String tag)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_tagGeoDic.get(tag);
    }

    public boolean set(String tag, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set(String tag, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (tag == null || tag.equals("")) {
            String string = InternalResource.loadString("tag", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = DynamicLayerNative.jni_Set(this.getHandle(), tag, l);
        if (bl) {
            this.m_tagGeoDic.remove(tag);
            this.m_tagGeoDic.put(tag, geometry);
        }
        return bl;
    }

    public boolean contains(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_tagGeoDic.containsValue(geometry);
    }

    public boolean containsTag(String tag) {
        if (tag == null || tag.equals("")) {
            String string = InternalResource.loadString("tag", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_tagGeoDic.containsKey(tag);
    }

    public boolean remove(String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (tag == null || tag.equals("")) {
            String string = InternalResource.loadString("remove(String tag)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (DynamicLayerNative.jni_Remove(this.getHandle(), tag)) {
            this.m_tagGeoDic.remove(tag);
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        for (Geometry geometry : this.m_tagGeoDic.values()) {
            InternalGeometry.clearHandle(geometry);
            geometry = null;
        }
        this.m_tagGeoDic.clear();
        DynamicLayerNative.jni_Clear(this.getHandle());
        this.m_lock.unlock();
    }

    public boolean isAvailableTag(String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAvailableTag(String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (tag == null || tag.equals("")) {
            String string = InternalResource.loadString("isAvailableTag(String tag)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return DynamicLayerNative.jni_IsAvailableTag(this.getHandle(), tag);
    }

    public String getAvailableTag(String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAvailableTag(String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (tag == null || tag.equals("")) {
            String string = InternalResource.loadString("getAvailableTag(String tag)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        String string = DynamicLayerNative.jni_FindAvailableTag(this.getHandle(), tag);
        if (string.trim().equals("")) {
            return "";
        }
        return string;
    }

    private void reset() {
        DynamicLayerNative.jni_Reset(this.getHandle());
    }

    protected void clearHandle() {
        if (this.m_tagGeoDic != null) {
            for (Geometry geometry : this.m_tagGeoDic.values()) {
                InternalGeometry.clearHandle(geometry);
            }
            this.m_tagGeoDic.clear();
            this.m_tagGeoDic = null;
        }
        this.setHandle(0L);
    }

    @Deprecated
    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this.m_lock.lock();
        String string = this.getTag(index);
        boolean bl = this.remove(string);
        this.m_lock.unlock();
        return bl;
    }

    @Deprecated
    public Geometry get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        String string = this.getTag(index);
        return this.m_tagGeoDic.get(string);
    }

    @Deprecated
    public boolean set(int index, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.contains(geometry)) {
            return false;
        }
        this.m_lock.lock();
        String string = this.getTag(index);
        boolean bl = this.set(string, geometry);
        this.m_lock.unlock();
        return bl;
    }

    @Deprecated
    public String getTag(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTag(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DynamicLayerNative.jni_GetTag(this.getHandle(), index);
    }

    @Deprecated
    public boolean setTag(int index, String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTag(int index, String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (tag == null || tag.equals("")) {
            String string = InternalResource.loadString("indexOf(String tag)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        if (this.get(tag) != null) {
            return false;
        }
        boolean bl = DynamicLayerNative.jni_SetTag(this.getHandle(), index, tag);
        this.m_lock.unlock();
        return bl;
    }

    @Deprecated
    public int indexOf(String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (tag == null || tag.equals("")) {
            String string = InternalResource.loadString("indexOf(String tag)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return DynamicLayerNative.jni_IndexOf(this.getHandle(), tag);
    }

    @Deprecated
    public int indexOf(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return DynamicLayerNative.jni_IndexOf(this.getHandle(), l);
    }

    private void makeSureNativeObjectLive(InternalHandleDisposable obj) {
        InternalHandle.getHandle((com.supermap.data.InternalHandle)obj);
    }
}

