/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Point2D;
import com.supermap.mapping.BookMarkNative;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;

public class BookMark
extends InternalHandleDisposable {
    public BookMark() {
        long l = BookMarkNative.jni_New();
        this.setHandle(l, true);
    }

    public BookMark(String name, Point2D pntCenter, double dScale) {
        if (name == null) {
            String string = InternalResource.loadString("BookMark(String name, Point2D pntCenter, double dScale)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (pntCenter == null) {
            String string = InternalResource.loadString("BookMark(String name, Point2D pntCenter, double dScale)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = BookMarkNative.jni_New(name, pntCenter.getX(), pntCenter.getY(), dScale);
        this.setHandle(l, true);
    }

    public BookMark(long handle) {
        this.setHandle(handle, false);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return BookMarkNative.jni_GetName(this.getHandle());
    }

    public void setName(String strName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String strName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (strName == null) {
            String string = InternalResource.loadString("setName(String strName)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        BookMarkNative.jni_SetName(this.getHandle(), strName);
    }

    public Point2D getMapCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapCenter()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        BookMarkNative.jni_GetMapCenter(this.getHandle(), dArray);
        Point2D point2D = new Point2D(dArray[0], dArray[1]);
        return point2D;
    }

    public void setMapCenter(Point2D pntMapCenter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapCenter(Point2D pntMapCenter)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (pntMapCenter == null) {
            String string = InternalResource.loadString("pntMapCenter", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        BookMarkNative.jni_SetMapCenter(this.getHandle(), pntMapCenter.getX(), pntMapCenter.getY());
    }

    public double getMapScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return BookMarkNative.jni_GetMapScale(this.getHandle());
    }

    public void setMapScale(double dMapScale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapScale(double dMapScale)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (dMapScale <= 0.0) {
            String string = InternalResource.loadString("dMapScale", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        BookMarkNative.jni_SetMapScale(this.getHandle(), dMapScale);
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDescription()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return BookMarkNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String description) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDescription(String description)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        BookMarkNative.jni_SetDescription(this.getHandle(), description);
    }

    public String getCreateTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCreateTime()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return BookMarkNative.jni_GetCreateTime(this.getHandle());
    }

    public void setCreateTime(String createTime) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCreateTime(String createTime)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        BookMarkNative.jni_SetCreateTime(this.getHandle(), createTime);
    }

    public void fromXML(String strXML) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapScale(double dMapScale)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (strXML == null || strXML.equals("")) {
            String string = InternalResource.loadString("fromXML(String strXML)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        BookMarkNative.jni_FromXML(this.getHandle(), strXML);
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("String toXML())", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return BookMarkNative.jni_ToXML(this.getHandle());
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            BookMarkNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }
}

