/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Datasource;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.realspace.Scene;
import com.supermap.realspace.spatialanalyst.InternalDatasetGrid;
import com.supermap.realspace.spatialanalyst.InternalDatasets;
import com.supermap.realspace.spatialanalyst.InternalGeometry;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import com.supermap.realspace.spatialanalyst.ObliquePhotogrammetry3DModelNative;
import java.util.ArrayList;
import java.util.Vector;

public class ObliquePhotogrammetry3DModel {
    private static License m_license;
    private Scene m_scene;
    private boolean m_bCreateNewDataset;
    private static transient Vector m_steppedListeners;
    private static String m_senderMethodName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public ObliquePhotogrammetry3DModel(Scene scene) {
        ObliquePhotogrammetry3DModel.verifyLicense();
        this.m_scene = scene;
        this.m_bCreateNewDataset = true;
    }

    public String modelToDSM(Datasource targetDatasource, String dtName, Rectangle2D bounds, double dResolution, double camHeight) {
        if (this.m_scene == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene) == 0L || bounds == null) {
            return "";
        }
        if (dResolution < 0.01) {
            String string = InternalResource.loadString("modelToDSM", "ArgumentInvalid", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        dtName = targetDatasource.getDatasets().getAvailableDatasetName(dtName);
        long l = ObliquePhotogrammetry3DModelNative.jni_ModelToDSM2(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene), InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource), dtName, bounds.getTop(), bounds.getBottom(), bounds.getLeft(), bounds.getRight(), dResolution, camHeight);
        if (l != 0L) {
            if (this.m_bCreateNewDataset) {
                DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(l, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            return dtName;
        }
        return "";
    }

    public String modelToDSM(Dataset targetDataset, Rectangle2D bounds, double camHeight) {
        if (targetDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDataset) == 0L || bounds == null) {
            return "";
        }
        String string = "TempDSM";
        this.m_bCreateNewDataset = false;
        double d = ObliquePhotogrammetry3DModelNative.jni_GetResolution(InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDataset), bounds.getTop(), bounds.getBottom(), bounds.getLeft(), bounds.getRight());
        Datasource datasource = targetDataset.getDatasource();
        String string2 = this.modelToDSM(datasource, string, bounds, d, camHeight);
        this.m_bCreateNewDataset = true;
        boolean bl = ObliquePhotogrammetry3DModelNative.jni_ModelToDSM(InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource), InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDataset), string2);
        if (bl) {
            return targetDataset.getName();
        }
        return "";
    }

    public boolean modelToDOM(String strPicPath, Rectangle2D bounds, double dResolution, double camHeight) {
        if (this.m_scene == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene) == 0L || bounds == null) {
            return false;
        }
        if (dResolution < 0.01) {
            String string = InternalResource.loadString("dResolution", "ArgumentInvalid", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ObliquePhotogrammetry3DModelNative.jni_ModelToDOM(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene), strPicPath, bounds.getTop(), bounds.getBottom(), bounds.getLeft(), bounds.getRight(), dResolution, camHeight);
    }

    public boolean modelToDOMDSM(Datasource targetDatasource, String dtName, String strPicPath, Rectangle2D bounds, double dResolution, double camHeight, double additionalHeight) {
        if (this.m_scene == null || targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene) == 0L || bounds == null) {
            return false;
        }
        if (dResolution < 0.01) {
            String string = InternalResource.loadString("modelToDOMDSM", "ArgumentInvalid", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        dtName = targetDatasource.getDatasets().getAvailableDatasetName(dtName);
        boolean bl = ObliquePhotogrammetry3DModelNative.jni_ModelToDOMDSM(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene), InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource), dtName, strPicPath, bounds.getTop(), bounds.getRight(), bounds.getBottom(), bounds.getLeft(), dResolution, camHeight, additionalHeight);
        return bl;
    }

    public boolean output25DMap(String path, boolean bGenerateVectorPlane, Rectangle2D bounds, double resolution, double heading, double tilt, double minHeight, double maxHeight) {
        if (this.m_scene == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene) == 0L || bounds == null) {
            return false;
        }
        if (resolution < 0.01) {
            String string = InternalResource.loadString("output25DMap", "ArgumentInvalid", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ObliquePhotogrammetry3DModelNative.jni_Output25DMap(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene), path, bounds.getTop(), bounds.getBottom(), bounds.getLeft(), bounds.getRight(), resolution, heading, tilt, minHeight, maxHeight);
    }

    public GeoRegion output25DRegion(Geometry geo, Rectangle2D bounds, double heading, double tilt, double minHeight, double maxHeight) {
        if (this.m_scene == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene) == 0L || bounds == null) {
            return null;
        }
        if (geo == null) {
            String string = InternalResource.loadString("Geometry", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geo);
        if (l == 0L) {
            String string = InternalResource.loadString("Geometry", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        GeoRegion geoRegion = null;
        long l2 = ObliquePhotogrammetry3DModelNative.jni_Output25DRegion(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene), l, bounds.getTop(), bounds.getBottom(), bounds.getLeft(), bounds.getRight(), heading, tilt, minHeight, maxHeight);
        if (l2 != 0L) {
            geoRegion = (GeoRegion)InternalGeometry.createInstance(l2);
        }
        return geoRegion;
    }

    public boolean outputStreetFacade(String path, GeoLine3D geoLine3D, double resolution, double farDist, double minHeight, double maxHeight) {
        if (this.m_scene == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene) == 0L) {
            return false;
        }
        if (resolution < 0.01) {
            String string = InternalResource.loadString("outputStreetFacade", "ArgumentInvalid", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (geoLine3D == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLine3D) == 0L || geoLine3D.isEmpty() || geoLine3D.getPart(0).getCount() < 2) {
            return false;
        }
        double d = geoLine3D.getPart(0).getItem(0).getX();
        double d2 = geoLine3D.getPart(0).getItem(0).getY();
        double d3 = geoLine3D.getPart(0).getItem(0).getZ();
        double d4 = geoLine3D.getPart(0).getItem(1).getX();
        double d5 = geoLine3D.getPart(0).getItem(1).getY();
        double d6 = geoLine3D.getPart(0).getItem(1).getZ();
        return ObliquePhotogrammetry3DModelNative.jni_outputStreetFacade(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene), d, d2, d3, d4, d5, d6, path, resolution, farDist, minHeight, maxHeight);
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(ObliquePhotogrammetry3DModel source, int percent, long remainTime, String title, String message, long cancelHandle) {
        Object object = new Object();
        m_senderMethodName = "ObliquePhotogrammetry3DModel";
        boolean bl = InternalToolkitSpatialAnalyst3D.getHandleBooleanValue(cancelHandle);
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, m_senderMethodName, bl);
        ObliquePhotogrammetry3DModel.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst3D.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    public void dispose() {
        this.m_scene = null;
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

