/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVolume;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.GeoTIM;
import com.supermap.data.PixelFormat;
import com.supermap.data.Point3D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Toolkit;
import com.supermap.realspace.spatialanalyst.InternalDatasetVolume;
import com.supermap.realspace.spatialanalyst.InternalDatasets;
import com.supermap.realspace.spatialanalyst.InternalEnum;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalHandleDisposable;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import com.supermap.realspace.spatialanalyst.Interpolation3DNative;
import com.supermap.realspace.spatialanalyst.InterpolationParameter3D;
import java.util.ArrayList;
import java.util.Vector;

public class Interpolator3D {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private Interpolator3D() {
    }

    public static DatasetVolume interpolate(InterpolationParameter3D parameter, DatasetVector interpolatedPoint, String zValueFieldName, double zValueScale, Datasource targetDatasource, String targetDatasetName, PixelFormat pixelFormat) {
        if (!interpolatedPoint.getType().equals((Object)DatasetType.POINT3D)) {
            String string = InternalResource.loadString("interpolatedPoint", "Interpolator_UnsupportedDatasetType", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        Recordset recordset = interpolatedPoint.getRecordset(false, CursorType.STATIC);
        DatasetVolume datasetVolume = Interpolator3D.interpolate(parameter, recordset, zValueFieldName, zValueScale, targetDatasource, targetDatasetName, pixelFormat);
        recordset.dispose();
        return datasetVolume;
    }

    public static DatasetVolume interpolate(InterpolationParameter3D parameter, Recordset interpolatedPointRecordset, String zValueFieldName, double zValueScale, Datasource targetDatasource, String targetDatasetName, PixelFormat pixelFormat) {
        Interpolator3D.verifyLicense();
        double[] dArray = parameter.getSliceAltitudes();
        if (dArray.length < 1) {
            String string = InternalResource.loadString("SliceAltitudes", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (interpolatedPointRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)interpolatedPointRecordset) == 0L) {
            String string = InternalResource.loadString("interpolatedPoint", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        DatasetVector datasetVector = interpolatedPointRecordset.getDataset();
        if (!datasetVector.getType().equals((Object)DatasetType.POINT3D)) {
            String string = InternalResource.loadString("interpolatedPoint", "Interpolator_UnsupportedDatasetType", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (pixelFormat.equals((Object)PixelFormat.BIT64)) {
            String string = InternalResource.loadString("pixelFormat", "InterPolator_UnsupportedPixelFormat", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (interpolatedPointRecordset.getFieldInfos().indexOf(zValueFieldName) == -1) {
            String string = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        FieldInfo fieldInfo = interpolatedPointRecordset.getFieldInfos().get(zValueFieldName);
        if (fieldInfo == null || fieldInfo.getType() != FieldType.DOUBLE && fieldInfo.getType() != FieldType.INT16 && fieldInfo.getType() != FieldType.INT32 && fieldInfo.getType() != FieldType.INT64 && fieldInfo.getType() != FieldType.SINGLE) {
            String string = InternalResource.loadString("zValueFieldName", "InterPolator_UnsupportedFieldType", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasetName == null) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "Global_DatasetNameInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = parameter.getBounds().isEmpty();
        if (bl) {
            parameter.setBounds(datasetVector.getBounds());
        }
        boolean bl2 = false;
        double d = parameter.getResolution();
        if (Toolkit.isZero((double)parameter.getResolution()) || parameter.getResolution() < 0.0) {
            bl2 = true;
            double d2 = Math.min(parameter.getBounds().getHeight(), parameter.getBounds().getWidth());
            parameter.setResolution(d2 / 500.0);
        }
        boolean bl3 = true;
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)interpolatedPointRecordset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l4 = Interpolation3DNative.jni_Interpolate(l, l2, zValueFieldName, zValueScale, l3, targetDatasetName, InternalEnum.getUGCValue((Enum)pixelFormat), bl3);
        if (bl) {
            parameter.setBounds(Rectangle2D.getEMPTY());
        }
        if (bl2) {
            parameter.setResolution(d);
        }
        DatasetVolume datasetVolume = null;
        if (l4 != 0L) {
            datasetVolume = InternalDatasetVolume.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVolume);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)interpolatedPointRecordset);
        return datasetVolume;
    }

    public static DatasetVolume interpolate(InterpolationParameter3D parameter, GeoTIM tim, Datasource targetDatasource, String targetDatasetName, PixelFormat pixelFormat) {
        Interpolator3D.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        double[] dArray = parameter.getSliceAltitudes();
        if (dArray.length < 1) {
            String string = InternalResource.loadString("SliceAltitudes", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (tim == null) {
            String string = InternalResource.loadString("tim", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)tim);
        if (l == 0L) {
            String string = InternalResource.loadString("tim", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        if (l2 == 0L || !targetDatasource.isOpened()) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "Global_DatasetNameInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (pixelFormat == PixelFormat.BIT64) {
            String string = InternalResource.loadString("pixelFormat", "InterPolator_UnsupportedPixelFormat", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter);
        long l4 = Interpolation3DNative.jni_Interpolate2(l3, l, l2, targetDatasetName, InternalEnum.getUGCValue((Enum)pixelFormat));
        DatasetVolume datasetVolume = null;
        if (l4 != 0L) {
            datasetVolume = InternalDatasetVolume.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVolume);
        }
        return datasetVolume;
    }

    public static DatasetVolume interpolate(InterpolationParameter3D parameter, Point3D[] points, double[] values, PrjCoordSys prjCoordSys, double zValueScale, Datasource targetDatasource, String targetDatasetName, PixelFormat pixelFormat) {
        int n;
        Interpolator3D.verifyLicense();
        double[] dArray = parameter.getSliceAltitudes();
        if (dArray.length < 1) {
            String string = InternalResource.loadString("SliceAltitudes", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (points == null || points.length == 0) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (values == null || values.length == 0) {
            String string = InternalResource.loadString("values", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (pixelFormat.equals((Object)PixelFormat.BIT64)) {
            String string = InternalResource.loadString("pixelFormat", "InterPolator_UnsupportedPixelFormat", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (points.length != values.length) {
            String string = InternalResource.loadString("points values", "CountMustEqual", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasetName == null) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "Global_DatasetNameInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (zValueScale == 0.0) {
            String string = InternalResource.loadString("zValueScale", "GlobalGreaterThanZero", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (prjCoordSys == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)prjCoordSys) == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray2 = new double[points.length];
        double[] dArray3 = new double[points.length];
        double[] dArray4 = new double[points.length];
        for (n = 0; n < values.length; ++n) {
            dArray2[n] = points[n].getX();
            dArray3[n] = points[n].getY();
            dArray4[n] = points[n].getZ();
        }
        n = parameter.getBounds().isEmpty() ? 1 : 0;
        boolean bl = false;
        double d = parameter.getResolution();
        if (Toolkit.isZero((double)parameter.getResolution()) || parameter.getResolution() < 0.0) {
            bl = true;
            double d2 = Math.min(parameter.getBounds().getHeight(), parameter.getBounds().getWidth());
            parameter.setResolution(d2 / 500.0);
        }
        boolean bl2 = true;
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)prjCoordSys);
        long l4 = Interpolation3DNative.jni_Interpolate3(l, dArray2, dArray3, dArray4, values, l3, zValueScale, l2, targetDatasetName, InternalEnum.getUGCValue((Enum)pixelFormat), bl2);
        if (n != 0) {
            parameter.setBounds(Rectangle2D.getEMPTY());
        }
        if (bl) {
            parameter.setResolution(d);
        }
        DatasetVolume datasetVolume = null;
        if (l4 != 0L) {
            datasetVolume = InternalDatasetVolume.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVolume);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        return datasetVolume;
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "Interpolate3D";
        boolean bl = InternalToolkitSpatialAnalyst3D.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        Interpolator3D.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst3D.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

