/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.threeddesigner;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PrjCoordSys;
import com.supermap.realspace.threeddesigner.FileType;
import com.supermap.realspace.threeddesigner.ImportSetting3DNative;
import com.supermap.realspace.threeddesigner.InternalDatasourceConnectionInfo;
import com.supermap.realspace.threeddesigner.InternalEnum;
import com.supermap.realspace.threeddesigner.InternalResource;
import com.supermap.realspace.threeddesigner.ModelImportMode;
import com.supermap.realspace.threeddesigner.XmlFileType;
import java.util.ArrayList;

public abstract class ImportSetting3D
extends InternalHandleDisposable {
    private ArrayList<Boolean> m_states;
    private DatasourceConnectionInfo m_datasourceConnectionInfo;
    private Datasource m_datasource;
    private PrjCoordSys m_prjCoordSys = null;
    private String _soureFilePath = null;
    private ModelImportMode importMode = ModelImportMode.Append;

    ArrayList<Boolean> getStates() {
        return this.m_states;
    }

    void setStates(ArrayList<Boolean> states) {
        this.m_states = states;
    }

    protected void clearHandle() {
        this.m_datasourceConnectionInfo = null;
        if (this.m_prjCoordSys != null) {
            this.m_prjCoordSys = null;
        }
        this.setHandle(0L);
    }

    protected FileType getFileType() {
        return FileType.NONE;
    }

    public FileType toFileType(XmlFileType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toFileType)", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSetting3DNative.jni_ToUGFileType(this.getHandle(), type.value());
        FileType fileType = n == 1 ? FileType.Model3DXML : (n == 2 ? FileType.ModelIFC : FileType.NONE);
        return fileType;
    }

    public XmlFileType toXmlFileType(FileType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXmlFileType)", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSetting3DNative.jni_ToFileType(this.getHandle(), type.value());
        XmlFileType xmlFileType = n == 1 ? XmlFileType.Model3DXML : (n == 2 ? XmlFileType.ModelIFC : XmlFileType.NONE);
        return xmlFileType;
    }

    public String getSourceFilePath() {
        String string = null;
        if (this.getFileType() == FileType.CityGML) {
            string = this._soureFilePath;
        } else {
            if (this.getHandle() == 0L) {
                String string2 = InternalResource.loadString("getSourceFilePath)", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
                throw new IllegalStateException(string2);
            }
            string = ImportSetting3DNative.jni_GetSourceFilePath(this.getHandle());
        }
        return string;
    }

    public void setSourceFilePath(String value) {
        if (this.getFileType() == FileType.CityGML) {
            this._soureFilePath = value;
        } else {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setSourceFilePath)", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
                throw new IllegalStateException(string);
            }
            ImportSetting3DNative.jni_SetSourceFilePath(this.getHandle(), value);
        }
    }

    public String getTargetDatasetName() {
        if (this.getFileType() != FileType.CityGML && this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDatasetName)", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        String string = ImportSetting3DNative.jni_GetTargetDatasetName(this.getHandle());
        return string;
    }

    public void setTargetDatasetName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetDatasetName)", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        ImportSetting3DNative.jni_SetTargetDatasetName(this.getHandle(), value);
    }

    public XmlFileType getSourceFileType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceFileType)", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSetting3DNative.jni_GetSourceFileType(this.getHandle());
        XmlFileType xmlFileType = n == 518 ? XmlFileType.Model3DXML : (n == 519 ? XmlFileType.ModelIFC : XmlFileType.NONE);
        return xmlFileType;
    }

    public ModelImportMode getImportMode() {
        if (this.getFileType() == FileType.CityGML) {
            return this.importMode;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportMode)", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSetting3DNative.jni_GetImportMode(this.getHandle());
        return (ModelImportMode)InternalEnum.parseUGCValue(ModelImportMode.class, n);
    }

    public void setImportMode(ModelImportMode mode) {
        if (this.getFileType() == FileType.CityGML) {
            this.importMode = mode;
        } else {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setImportMode)", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
                throw new IllegalStateException(string);
            }
            int n = mode.value();
            ImportSetting3DNative.jni_SetImportMode(this.getHandle(), n);
        }
    }

    public DatasourceConnectionInfo getTargetDatasourceConnectionInfo() {
        if (this.getFileType() != FileType.CityGML && this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDatasourceConnectionInfo()", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasourceConnectionInfo;
    }

    public void setTargetDatasourceConnectionInfo(DatasourceConnectionInfo connectionInfo) {
        if (this.getFileType() != FileType.CityGML && this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetDatasourceConnectionInfo()", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        if (connectionInfo == null) {
            if (this.m_datasourceConnectionInfo != null) {
                InternalDatasourceConnectionInfo.clearHandle(this.m_datasourceConnectionInfo);
                this.m_datasourceConnectionInfo = null;
            }
        } else {
            long l = InternalHandle.getHandle((InternalHandle)connectionInfo);
            if (l == 0L) {
                String string = InternalResource.loadString("setTargetDatasourceConnectionInfo(DatasourceConnectionInfo connectionInfo)", "Datasources_ConnectionInfoIsInvalid", "ThreeDDesigner_resources");
                throw new IllegalStateException(string);
            }
            this.m_datasourceConnectionInfo = this.cloneDatasourceConnectionInfo(connectionInfo);
            this.setTargetDatasource(null);
        }
    }

    public Datasource getTargetDatasource() {
        if (this.getFileType() != FileType.CityGML && this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDatasource()", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasource;
    }

    public void setTargetDatasource(Datasource datasource) {
        if (this.getFileType() != FileType.CityGML && this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetDatasource(Datasource datasource)", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        this.m_datasource = datasource;
        if (this.m_datasource != null) {
            this.setTargetDatasourceConnectionInfo(null);
        }
    }

    public PrjCoordSys getTargetPriCoordSys() {
        if (this.getFileType() != FileType.CityGML && this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetPriCoordSys", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        return this.m_prjCoordSys;
    }

    public void setTargetPriCoordSys(PrjCoordSys prjCoordSys) {
        if (this.getFileType() != FileType.CityGML) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTargetPriCoordSys", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((InternalHandle)prjCoordSys);
            ImportSetting3DNative.jni_SetTargetPriCoordSys(this.getHandle(), l);
        }
        this.m_prjCoordSys = prjCoordSys;
    }

    protected DatasourceConnectionInfo cloneDatasourceConnectionInfo(DatasourceConnectionInfo connectionInfo) {
        long l = InternalHandle.getHandle((InternalHandle)connectionInfo);
        long l2 = ImportSetting3DNative.jni_CloneDatasourceConnectionInfo(l);
        DatasourceConnectionInfo datasourceConnectionInfo = InternalDatasourceConnectionInfo.createInstance(l2);
        InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)datasourceConnectionInfo, (boolean)true);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)connectionInfo);
        return datasourceConnectionInfo;
    }

    protected String[] run() {
        return null;
    }
}

