/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.SpatialIndexInfo;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingGJB9121Native;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.InternalSpatialIndexInfo;

public class ImportSettingGJB9121
extends ImportSetting {
    private SpatialIndexInfo m_spatialIndexInfo;

    public ImportSettingGJB9121() {
        long l = ImportSettingGJB9121Native.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingGJB9121(ImportSettingGJB9121 importSettingGJB) {
        if (importSettingGJB == null) {
            String string = InternalResource.loadString("ImportSettingGJB9121", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingGJB);
        if (l == 0L) {
            String string = InternalResource.loadString("ImportSettingGJB9121", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingGJB9121Native.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingGJB.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingGJB.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingGJB.getTargetPrjCoordSys());
        super.setDataType(DataType.VECTOR);
        this.setImportEmptyDataset(importSettingGJB.isImportEmptyDataset());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingGJB));
    }

    public ImportSettingGJB9121(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public ImportSettingGJB9121(String sourceFilePath, Datasource targetDatasource) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
        super.setDataType(DataType.VECTOR);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingGJB9121Native.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }

    public void setImportEmptyDataset(boolean bImportEmptyDT) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingGJB9121Native.jni_SetImportEmptyDT(this.getHandle(), bImportEmptyDT);
    }

    public boolean isImportEmptyDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingGJB9121Native.jni_IsImportEmptyDT(this.getHandle());
    }

    public SpatialIndexInfo getSpatialIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpatialIndex()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_spatialIndexInfo == null) {
            long l = ImportSettingGJB9121Native.jni_GetSpatialIndex(this.getHandle());
            this.m_spatialIndexInfo = InternalSpatialIndexInfo.createInstance(l);
        }
        return this.m_spatialIndexInfo;
    }

    public void setSpatialIndex(SpatialIndexInfo value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpatialIndex(SpatialIndexInfo value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = value == null ? 0L : com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)value);
        ImportSettingGJB9121Native.jni_SetSpatialIndex(this.getHandle(), l);
        this.m_spatialIndexInfo = null;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public void setImportLayerName(String[] layerNames) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportLayerName()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (layerNames.length == 0) {
            return;
        }
        ImportSettingGJB9121Native.jni_SetImportLayerName(this.getHandle(), layerNames);
    }
}

