/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.conversion.CADRasterImageSetting;
import com.supermap.data.conversion.CADVersion;
import com.supermap.data.conversion.ExportSetting;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.InternalResource;

public class ExportSettingDXF
extends ExportSetting {
    boolean m_isExportingExternalData;
    boolean m_isExpBorder;
    boolean m_isExportXrecord;
    CADVersion m_version;
    CADRasterImageSetting[] m_arrRasterImage;
    boolean m_isExportPolylineWidth;

    public ExportSettingDXF() {
        this.m_isExportingExternalData = false;
        this.m_isExportXrecord = false;
        this.m_version = CADVersion.CAD2004;
        this.m_type = FileType.DXF;
        this.m_isExpBorder = true;
        this.m_arrRasterImage = null;
        this.m_isExportPolylineWidth = false;
    }

    public ExportSettingDXF(ExportSettingDXF ExportSettingDXF2) {
        super(ExportSettingDXF2);
        this.setExportingExternalData(ExportSettingDXF2.isExportingExternalData());
        this.setExportingBorder(ExportSettingDXF2.isExportingBorder());
        this.setExportingXRecord(ExportSettingDXF2.isExportingXRecord());
        this.setVersion(ExportSettingDXF2.getVersion());
        this.m_type = FileType.DXF;
        this.setRasterImageSettings(ExportSettingDXF2.getRasterImageSettings());
        this.setExportPolylineWidth(ExportSettingDXF2.isExportPolylineWidth());
        this.m_isExportPolylineWidth = false;
    }

    public ExportSettingDXF(Object sourceData, String targetFilePath, FileType targetFileType) {
        super(sourceData, targetFilePath, targetFileType);
        this.m_type = FileType.DXF;
    }

    public CADVersion getVersion() {
        return this.m_version;
    }

    public void setVersion(CADVersion value) {
        this.m_version = value;
    }

    public boolean isExportingExternalData() {
        return this.m_isExportingExternalData;
    }

    public void setExportingExternalData(boolean value) {
        this.m_isExportingExternalData = value;
    }

    public boolean isExportingBorder() {
        return this.m_isExpBorder;
    }

    public void setExportingBorder(boolean isExporttingBorder) {
        this.m_isExpBorder = isExporttingBorder;
    }

    public boolean isExportingXRecord() {
        return this.m_isExportXrecord;
    }

    public void setExportingXRecord(boolean bXrecord) {
        this.m_isExportXrecord = bXrecord;
    }

    @Override
    public FileType getTargetFileType() {
        return this.m_type;
    }

    @Override
    public void setTargetFileType(FileType type) {
        if (FileType.DXF != type) {
            String string = InternalResource.loadString("setTargetFileType(FileType type)", "SetTargetFileTypeIsNotAllowed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_type = FileType.DXF;
    }

    public CADRasterImageSetting[] getRasterImageSettings() {
        return this.m_arrRasterImage;
    }

    public void setRasterImageSettings(CADRasterImageSetting[] rasterImageSettings) {
        this.m_arrRasterImage = rasterImageSettings;
    }

    public void setExportPolylineWidth(boolean bExport) {
        this.m_isExportPolylineWidth = bExport;
    }

    public boolean isExportPolylineWidth() {
        return this.m_isExportPolylineWidth;
    }
}

