/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.conversion.ExportSetting;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.InternalResource;
import java.io.File;

public class ExportSettingBMP
extends ExportSetting {
    private String m_worldFilePath;

    public ExportSettingBMP() {
        this.m_worldFilePath = "";
        this.m_type = FileType.BMP;
    }

    public ExportSettingBMP(ExportSettingBMP exportSettingBMP) {
        super(exportSettingBMP);
        this.m_type = FileType.BMP;
        this.setWorldFilePath(exportSettingBMP.getWorldFilePath());
    }

    public ExportSettingBMP(Object sourceData, String targetFilePath, FileType targetFileType) {
        super(sourceData, targetFilePath, targetFileType);
        this.m_type = FileType.BMP;
        this.m_worldFilePath = "";
    }

    public String getWorldFilePath() {
        return this.m_worldFilePath;
    }

    public void setWorldFilePath(String path) {
        File file;
        File file2 = new File(path);
        if (file2.isDirectory()) {
            String string = this.getTargetFilePath();
            File file3 = new File(string);
            path = path + file3.getName() + ".tga";
        } else if (file2.getParent() != null && !(file = new File(file2.getParent())).exists()) {
            String string = InternalResource.loadString("", "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_worldFilePath = path;
    }

    @Override
    public FileType getTargetFileType() {
        return this.m_type;
    }

    @Override
    public void setTargetFileType(FileType type) {
        if (FileType.BMP != type) {
            String string = InternalResource.loadString("setTargetFileType(FileType type)", "SetTargetFileTypeIsNotAllowed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_type = FileType.BMP;
    }
}

