/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.AnalystType;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.StopType;
import com.supermap.analyst.networkanalyst.TransportationAnalystParameterNative;
import com.supermap.analyst.networkanalyst.VRPDirectionType;
import com.supermap.analyst.networkanalyst.VehicleType;
import com.supermap.data.Point2Ds;

public class VRPAnalystParameter
extends InternalHandleDisposable {
    private String m_weightName = "";
    private int[] m_barrierNodes = null;
    private int[] m_barrierEdges = null;
    private Point2Ds m_barrierPoints = null;
    private String m_turnWeightField = "";
    private boolean m_isRoutesReturn = false;
    private boolean m_isNodesReturn = false;
    private boolean m_isEdgesReturn = false;
    private boolean m_isPathGuidesReturn = false;
    private boolean m_isStopsReturn = false;
    private StopType m_stopType = StopType.NONE;
    private AnalystType m_analystType = AnalystType.LEASTCOST;
    private VehicleType m_vehicleType = VehicleType.TYPE0;
    private VRPDirectionType m_directionType = VRPDirectionType.ROUNDROUTE;
    private String m_timeWeightField = "";
    private int m_routeCount = 0;

    public VRPAnalystParameter() {
        long l = TransportationAnalystParameterNative.jni_New();
        this.setHandle(l, true);
        this.reset();
    }

    void reset() {
        long l = super.getHandle();
        if (l != 0L) {
            TransportationAnalystParameterNative.jni_Reset(l);
        }
    }

    public VRPAnalystParameter(VRPAnalystParameter analystParameter) {
        long l = TransportationAnalystParameterNative.jni_New();
        this.setHandle(l, true);
        this.reset();
        this.copyFrom(analystParameter);
    }

    void copyFrom(VRPAnalystParameter value) {
        if (value != null) {
            this.setWeightName(value.getWeightName());
            this.setBarrierNodes(value.getBarrierNodes());
            this.setBarrierEdges(value.getBarrierEdges());
            this.setBarrierPoints(value.getBarrierPoints());
            this.setTurnWeightField(value.getTurnWeightField());
            this.setNodesReturn(value.isNodesReturn());
            this.setEdgesReturn(value.isEdgesReturn());
            this.setPathGuidesReturn(value.isPathGuidesReturn());
            this.setRoutesReturn(value.isRoutesReturn());
            this.setStopIndexesReturn(value.isStopIndexesReturn());
            this.setStopType(value.getStopType());
            this.setAnalystType(value.getAnalystType());
            this.setVehicleType(value.getVehicleType());
            this.setVRPDirectionType(value.getVRPDirectionType());
            this.setTimeWeight(value.getTimeWeight());
            this.setRouteCount(value.getRouteCount());
        }
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            TransportationAnalystParameterNative.jni_SetIsRoutesReturn(l, this.m_isRoutesReturn);
            TransportationAnalystParameterNative.jni_SetIsNodesReturn(l, this.m_isNodesReturn);
            TransportationAnalystParameterNative.jni_SetIsEdgesReturn(l, this.m_isEdgesReturn);
            TransportationAnalystParameterNative.jni_SetIsPathGuidesReturn(l, this.m_isPathGuidesReturn);
            TransportationAnalystParameterNative.jni_SetIsStopsReturn(l, this.m_isStopsReturn);
            TransportationAnalystParameterNative.jni_SetWeightName(l, this.m_weightName);
            if (this.m_barrierNodes != null) {
                TransportationAnalystParameterNative.jni_SetBarrierNodes(l, this.m_barrierNodes);
            } else {
                TransportationAnalystParameterNative.jni_SetBarrierNodes(l, new int[0]);
            }
            if (this.m_barrierEdges != null) {
                TransportationAnalystParameterNative.jni_SetBarrierEdges(l, this.m_barrierEdges);
            } else {
                TransportationAnalystParameterNative.jni_SetBarrierEdges(l, new int[0]);
            }
            if (this.m_barrierPoints != null && this.m_barrierPoints.getCount() != 0) {
                int n = this.m_barrierPoints.getCount();
                double[] dArray = new double[n];
                double[] dArray2 = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = this.m_barrierPoints.getItem(i).getX();
                    dArray2[i] = this.m_barrierPoints.getItem(i).getY();
                }
                TransportationAnalystParameterNative.jni_SetBarrierPoints(l, dArray, dArray2);
            }
            TransportationAnalystParameterNative.jni_SetTurnWeightField(l, this.m_turnWeightField);
            TransportationAnalystParameterNative.jni_SetTimeWeight(l, this.m_timeWeightField);
            TransportationAnalystParameterNative.jni_SetVRPRouteCount(l, this.m_routeCount);
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            TransportationAnalystParameterNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    public boolean isRoutesReturn() {
        return this.m_isRoutesReturn;
    }

    public void setRoutesReturn(boolean value) {
        this.m_isRoutesReturn = value;
    }

    public boolean isNodesReturn() {
        return this.m_isNodesReturn;
    }

    public void setNodesReturn(boolean value) {
        this.m_isNodesReturn = value;
    }

    public boolean isEdgesReturn() {
        return this.m_isEdgesReturn;
    }

    public void setEdgesReturn(boolean value) {
        this.m_isEdgesReturn = value;
    }

    public boolean isPathGuidesReturn() {
        return this.m_isPathGuidesReturn;
    }

    public void setPathGuidesReturn(boolean value) {
        this.m_isPathGuidesReturn = value;
    }

    public boolean isStopIndexesReturn() {
        return this.m_isStopsReturn;
    }

    public void setStopIndexesReturn(boolean value) {
        this.m_isStopsReturn = value;
    }

    public String getWeightName() {
        return this.m_weightName;
    }

    public void setWeightName(String value) {
        this.m_weightName = value;
    }

    public int[] getBarrierNodes() {
        if (this.m_barrierNodes != null) {
            return this.m_barrierNodes;
        }
        return null;
    }

    public void setBarrierNodes(int[] value) {
        if (value == null) {
            this.m_barrierNodes = null;
        } else {
            int n = value.length;
            this.m_barrierNodes = new int[n];
            for (int i = 0; i < n; ++i) {
                this.m_barrierNodes[i] = value[i];
            }
        }
    }

    public int[] getBarrierEdges() {
        if (this.m_barrierEdges != null) {
            return (int[])this.m_barrierEdges.clone();
        }
        return null;
    }

    public Point2Ds getBarrierPoints() {
        if (this.m_barrierPoints != null) {
            return this.m_barrierPoints.clone();
        }
        return null;
    }

    public void setBarrierPoints(Point2Ds value) {
        if (value == null) {
            this.m_barrierPoints = null;
        } else {
            if (this.m_barrierPoints == null) {
                this.m_barrierPoints = new Point2Ds();
            }
            this.m_barrierPoints.clear();
            this.m_barrierPoints.addRange(value.toArray());
        }
    }

    public void setBarrierEdges(int[] value) {
        if (value == null) {
            this.m_barrierEdges = null;
        } else {
            int n = value.length;
            this.m_barrierEdges = new int[n];
            for (int i = 0; i < n; ++i) {
                this.m_barrierEdges[i] = value[i];
            }
        }
    }

    public String getTurnWeightField() {
        return this.m_turnWeightField;
    }

    public void setTurnWeightField(String value) {
        this.m_turnWeightField = value;
    }

    protected StopType getStopType() {
        return this.m_stopType;
    }

    protected void setStopType(StopType value) {
        this.m_stopType = value;
    }

    public AnalystType getAnalystType() {
        return this.m_analystType;
    }

    public void setAnalystType(AnalystType value) {
        this.m_analystType = value;
    }

    protected VehicleType getVehicleType() {
        return this.m_vehicleType;
    }

    protected void setVehicleType(VehicleType value) {
        this.m_vehicleType = value;
    }

    public VRPDirectionType getVRPDirectionType() {
        return this.m_directionType;
    }

    public void setVRPDirectionType(VRPDirectionType value) {
        this.m_directionType = value;
    }

    public String getTimeWeight() {
        return this.m_timeWeightField;
    }

    public void setTimeWeight(String value) {
        this.m_timeWeightField = value;
    }

    public int getRouteCount() {
        return this.m_routeCount;
    }

    public void setRouteCount(int value) {
        this.m_routeCount = value;
    }
}

