/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.networkanalyst.AllocationAnalystParameter;
import com.supermap.analyst.networkanalyst.AllocationAnalystResult;
import com.supermap.analyst.networkanalyst.AllocationDemandType;
import com.supermap.analyst.networkanalyst.CenterPointInfo;
import com.supermap.analyst.networkanalyst.DemandPointInfo;
import com.supermap.analyst.networkanalyst.GroupAnalystParameter;
import com.supermap.analyst.networkanalyst.GroupAnalystResult;
import com.supermap.analyst.networkanalyst.GroupPointInfo;
import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.InternalToolkitNetworkAnalyst;
import com.supermap.analyst.networkanalyst.LocationAnalystParameter;
import com.supermap.analyst.networkanalyst.LocationAnalystResult;
import com.supermap.analyst.networkanalyst.MultiTransportationAnalystParameter;
import com.supermap.analyst.networkanalyst.MultiTransportationAnalystPoint;
import com.supermap.analyst.networkanalyst.MultiTransportationAnalystRelation;
import com.supermap.analyst.networkanalyst.MultiTransportationAnalystSetting;
import com.supermap.analyst.networkanalyst.ServiceAreaResult;
import com.supermap.analyst.networkanalyst.SupplyCenters;
import com.supermap.analyst.networkanalyst.TransportationAnalystCheckResult;
import com.supermap.analyst.networkanalyst.TransportationAnalystNative;
import com.supermap.analyst.networkanalyst.TransportationAnalystParameter;
import com.supermap.analyst.networkanalyst.TransportationAnalystParameterNative;
import com.supermap.analyst.networkanalyst.TransportationAnalystResult;
import com.supermap.analyst.networkanalyst.TransportationAnalystSetting;
import com.supermap.analyst.networkanalyst.VRPAnalystParameter;
import com.supermap.analyst.networkanalyst.VRPAnalystResult;
import com.supermap.analyst.networkanalyst.VRPDirectionType;
import com.supermap.analyst.networkanalyst.VehicleInfo;
import com.supermap.analyst.networkanalyst.VehicleType;
import com.supermap.analyst.networkanalyst.WeightFieldInfo;
import com.supermap.analyst.networkanalyst.WeightFieldInfos;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.FieldInfos;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Toolkit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;

public class TransportationAnalyst
extends InternalHandleDisposable {
    private TransportationAnalystSetting m_analystSetting = null;
    private MultiTransportationAnalystSetting m_multiAnalystSetting = null;
    private boolean m_isMultiAnalyst = false;
    private boolean m_modelLoaded = false;
    private License m_license;
    private long[] m_analystHandles = null;
    private boolean m_bLoadFile = false;
    private static transient Vector m_steppedListeners;

    public TransportationAnalyst() {
        this.checkLicense();
        this.m_analystHandles = new long[4];
        long l = TransportationAnalystNative.jni_New(this.m_analystHandles);
        this.setHandle(l, true);
        this.m_multiAnalystSetting = new MultiTransportationAnalystSetting();
        this.m_analystSetting = new TransportationAnalystSetting();
        this.m_modelLoaded = false;
    }

    private void checkLicense() {
        ArrayList<ProductType> arrayList = InternalToolkitNetworkAnalyst.managerProducts(InternalToolkitNetworkAnalyst.getNetworkAnalystProducts());
        this.m_license = InternalToolkitNetworkAnalyst.verifyLicense(arrayList);
    }

    private void unLoadLicense() {
        if (this.m_license != null) {
            this.m_license.disconnect();
            this.m_license.dispose();
            this.m_license = null;
        }
    }

    private void verifyLicense() {
        int n = this.m_license.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    public void dispose() {
        this.unLoadLicense();
        if (this.getHandle() != 0L) {
            TransportationAnalystNative.jni_Delete(this.getHandle(), this.m_analystHandles);
            this.setHandle(0L);
            this.m_analystHandles[0] = 0L;
            this.m_analystHandles[1] = 0L;
            this.m_analystHandles[2] = 0L;
            this.m_analystHandles[3] = 0L;
            this.m_analystHandles = null;
            this.clearHandle();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean load() {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("load()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.m_analystSetting.getNeedSet()) {
            this.setAnalsytSettingToUGC();
        }
        boolean bl3 = this.m_analystSetting.getNeedLoadModel();
        boolean bl4 = this.m_analystSetting.getNeedLoadTurnModel();
        if (bl3) {
            Toolkit.clearErrors();
            if (this.m_analystSetting.isBoundsSet()) {
                if (!this.m_analystSetting.getNetworkDataset().getBounds().hasIntersection(this.m_analystSetting.getBounds())) {
                    String string = InternalResource.loadString("getBounds()", "BoundsInvalid", "networkanalyst_resources");
                    throw new IllegalStateException(string);
                }
                bl = TransportationAnalystNative.jni_LoadModelByBounds(this.getHandle(), this.m_analystSetting.getBounds().getTop(), this.m_analystSetting.getBounds().getBottom(), this.m_analystSetting.getBounds().getLeft(), this.m_analystSetting.getBounds().getRight());
            } else {
                bl = TransportationAnalystNative.jni_LoadModel(this.getHandle());
            }
            if (!bl) {
                this.m_analystSetting.setNeedLoadModel(true);
                String string = Toolkit.getLastError();
                throw new IllegalArgumentException(string);
            }
            this.m_analystSetting.setNeedLoadModel(false);
        } else {
            bl = true;
        }
        if (bl4) {
            DatasetVector datasetVector = this.m_analystSetting.getTurnDataset();
            if (datasetVector != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) != 0L) {
                bl2 = TransportationAnalystNative.jni_LoadTurnModel(this.getHandle());
            } else {
                TransportationAnalystNative.jni_UnLoadTurnModel(this.getHandle());
                bl2 = true;
            }
            if (bl2) {
                this.m_analystSetting.setNeedLoadTurnModel(false);
            } else {
                this.m_analystSetting.setNeedLoadTurnModel(true);
            }
        } else {
            bl2 = true;
        }
        boolean bl5 = true;
        if (bl3 || bl4) {
            // empty if block
        }
        this.m_modelLoaded = bl && bl2;
        if (!bl) return false;
        if (!bl2) return false;
        if (!bl5) return false;
        return true;
    }

    public TransportationAnalystSetting getAnalystSetting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnalystSetting()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_analystSetting;
    }

    public void setAnalystSetting(TransportationAnalystSetting value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnalystSetting(NetworkAnalystSetting value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setAnalystSetting(NetworkAnalystSetting value)", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!this.getAnalystSetting().equals(value)) {
            this.m_analystSetting.copyFrom(value);
        }
    }

    public double updateEdgeWeight(int edgeID, int fromNodeID, int toNodeID, String weightName, double weight) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("updateEdgeWeight(int edgeID,int fromNodeID,int toNodeID,String weightField,Double weight)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (fromNodeID <= 0) {
            String string = InternalResource.loadString("fromNodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (toNodeID <= 0) {
            String string = InternalResource.loadString("toNodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            String string = InternalResource.loadString("weightField", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        double d = InternalToolkitNetworkAnalyst.DBL_MIN_VALUE;
        double d2 = TransportationAnalystNative.jni_UpdateEdgeWeight(this.getHandle(), edgeID, fromNodeID, toNodeID, weightName, weight);
        if (d2 != -1000.0) {
            d = d2;
        }
        return d;
    }

    public double updateTurnNodeWeight(int nodeID, int fromEdgeID, int toEdgeID, String turnWeightField, double weight) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("updateTurnNodeWeight(int nodeID,int fromEdgeID,int toEdgeID,String turnWeightField,double weight)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (fromEdgeID <= 0) {
            String string = InternalResource.loadString("fromEdgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (toEdgeID <= 0) {
            String string = InternalResource.loadString("toEdgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (turnWeightField == null || turnWeightField.trim().length() == 0) {
            String string = InternalResource.loadString("turnWeightField", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        double d = InternalToolkitNetworkAnalyst.DBL_MIN_VALUE;
        double d2 = TransportationAnalystNative.jni_UpdateTurnWeightField(this.getHandle(), nodeID, fromEdgeID, toEdgeID, turnWeightField, weight);
        if (d2 != -1000.0) {
            d = d2;
        }
        return d;
    }

    public TransportationAnalystResult findPath(TransportationAnalystParameter parameter, boolean hasLeastEdgeCount) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPath(TransportationAnalystParameter parameter, boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!(parameter.getNodes() != null && parameter.getNodes().length != 0 || parameter.getPoints() != null && parameter.getPoints().getCount() != 0)) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = parameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            parameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = parameter.getTurnWeightField();
        if (null == parameter.getTurnWeightField()) {
            parameter.setTurnWeightField("");
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter)) == 0L) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string4);
        }
        for (int i = 0; i < parameter.getNodes().length; ++i) {
            if (parameter.getNodes()[i] >= 0) continue;
            String string5 = InternalResource.loadString("Nodes", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new NullPointerException(string5);
        }
        Toolkit.clearErrors();
        long l2 = TransportationAnalystNative.jni_FindPath(this.m_analystHandles[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter), hasLeastEdgeCount);
        parameter.setWeightName(string);
        parameter.setTurnWeightField(string3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        if (l2 != 0L) {
            return new TransportationAnalystResult(l2);
        }
        String string6 = Toolkit.getLastError();
        throw new IllegalArgumentException(string6);
    }

    public TransportationAnalystResult findTSPPath(TransportationAnalystParameter parameter, boolean isEndNodeAssigned) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findTSPPath(TransportationAnalystParameter,parameter, boolean isEndNodeAssigned)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!(parameter.getNodes() != null && parameter.getNodes().length != 0 || parameter.getPoints() != null && parameter.getPoints().getCount() != 0)) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = parameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            parameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = parameter.getTurnWeightField();
        if (null == parameter.getTurnWeightField()) {
            parameter.setTurnWeightField("");
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter)) == 0L) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string4);
        }
        long l2 = TransportationAnalystNative.jni_FindTSPPath(this.m_analystHandles[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter), isEndNodeAssigned);
        parameter.setWeightName(string);
        parameter.setTurnWeightField(string3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        if (l2 != 0L) {
            return new TransportationAnalystResult(l2);
        }
        return null;
    }

    public TransportationAnalystResult findClosestFacility(TransportationAnalystParameter parameter, int eventID, int facilityCount, boolean isFromEvent, double maxWeight) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findClosestFacility(TransportationAnalystParameter parameter, int eventID, int facilityCount, boolean isFromEvent,double maxImpedance)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!(parameter.getNodes() != null && parameter.getNodes().length != 0 || parameter.getPoints() != null && parameter.getPoints().getCount() != 0)) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = parameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            parameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = parameter.getTurnWeightField();
        if (null == parameter.getTurnWeightField()) {
            parameter.setTurnWeightField("");
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter)) == 0L) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (maxWeight < 0.0) {
            String string5 = InternalResource.loadString("maxWeight", "TransportationAnalyst_MaxWeightMustEqualsOrGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (facilityCount <= 0) {
            String string6 = InternalResource.loadString("facilityCount", "TransportationAnalyst_FacilityCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (eventID <= 0) {
            String string7 = InternalResource.loadString("eventID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        long l2 = TransportationAnalystNative.jni_FindClosestFacility(this.m_analystHandles[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter), eventID, facilityCount, isFromEvent, maxWeight);
        parameter.setWeightName(string);
        parameter.setTurnWeightField(string3);
        TransportationAnalystResult transportationAnalystResult = null;
        if (l2 != 0L) {
            transportationAnalystResult = new TransportationAnalystResult(l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        return transportationAnalystResult;
    }

    public TransportationAnalystResult findClosestFacility(TransportationAnalystParameter parameter, Point2D eventPoint, int facilityCount, boolean isFromEvent, double maxWeight) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findClosestFacility(TransportationAnalystParameter parameter, Point2D eventPoint, int facilityCount,boolean isFromEvent,double maxImpedance)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!(parameter.getNodes() != null && parameter.getNodes().length != 0 || parameter.getPoints() != null && parameter.getPoints().getCount() != 0)) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = parameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            parameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = parameter.getTurnWeightField();
        if (null == parameter.getTurnWeightField()) {
            parameter.setTurnWeightField("");
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter)) == 0L) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (eventPoint == null) {
            String string5 = InternalResource.loadString("eventPoint", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (maxWeight < 0.0) {
            String string6 = InternalResource.loadString("maxWeight", "TransportationAnalyst_MaxWeightMustEqualsOrGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (facilityCount <= 0) {
            String string7 = InternalResource.loadString("facilityCount", "TransportationAnalyst_FacilityCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        long l2 = TransportationAnalystNative.jni_FindClosestFacility2(this.m_analystHandles[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter), eventPoint.getX(), eventPoint.getY(), facilityCount, isFromEvent, maxWeight);
        parameter.setWeightName(string);
        parameter.setTurnWeightField(string3);
        TransportationAnalystResult transportationAnalystResult = null;
        if (l2 != 0L) {
            transportationAnalystResult = new TransportationAnalystResult(l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        return transportationAnalystResult;
    }

    public TransportationAnalystResult findMTSPPath(TransportationAnalystParameter parameter, int[] centerNodes, boolean hasLeastTotalCost) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("FindMTSPPath(TransportationAnalystParameter parameter, int[] centerNodes, boolean hasLeastTotalCost)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter);
        if (l == 0L) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (parameter.getNodes() == null || parameter.getNodes().length == 0) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = parameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            parameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = parameter.getTurnWeightField();
        if (null == parameter.getTurnWeightField()) {
            parameter.setTurnWeightField("");
        }
        long l2 = TransportationAnalystNative.jni_findMTSPPath(this.m_analystHandles[1], InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter), centerNodes, hasLeastTotalCost);
        parameter.setWeightName(string);
        parameter.setTurnWeightField(string3);
        TransportationAnalystResult transportationAnalystResult = null;
        if (l2 == 0L) {
            String string4 = Toolkit.getLastError();
            throw new NullPointerException(string4);
        }
        transportationAnalystResult = new TransportationAnalystResult(l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        return transportationAnalystResult;
    }

    public TransportationAnalystResult findMTSPPath(TransportationAnalystParameter parameter, Point2Ds centerPoints, boolean hasLeastTotalCost) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("FindMTSPPath(TransportationAnalystParameter parameter, int[] centerNodes, boolean hasLeastTotalCost)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter);
        if (l == 0L) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        String string = parameter.getTurnWeightField();
        if (null == parameter.getTurnWeightField()) {
            parameter.setTurnWeightField("");
        }
        if (parameter.getPoints() == null || parameter.getPoints().getCount() == 0) {
            String string2 = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = parameter.getWeightName();
        if (string3 == null || string3.trim().length() == 0) {
            parameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(string3) < 0) {
            String string4 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        double[] dArray = null;
        double[] dArray2 = null;
        TransportationAnalystResult transportationAnalystResult = null;
        long l2 = 0L;
        if (centerPoints != null && centerPoints.getCount() != 0) {
            int n = centerPoints.getCount();
            dArray = new double[n];
            dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = centerPoints.getItem(i).getX();
                dArray2[i] = centerPoints.getItem(i).getY();
            }
            l2 = TransportationAnalystNative.jni_findMTSPPath1(this.m_analystHandles[1], InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter), dArray, dArray2, hasLeastTotalCost);
        }
        parameter.setWeightName(string3);
        parameter.setTurnWeightField(string);
        if (l2 == 0L) {
            String string5 = Toolkit.getLastError();
            throw new NullPointerException(string5);
        }
        transportationAnalystResult = new TransportationAnalystResult(l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        return transportationAnalystResult;
    }

    public ServiceAreaResult findServiceArea(TransportationAnalystParameter parameter, double[] weights, boolean isFromCenter, boolean isCenterMutuallyExclusive) {
        long l;
        String string;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("findServiceArea(TransportationAnalystParameter parameter,double[] weights,boolean isFromCenter,boolean isCenterMutuallyExclusive)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isLoadModelNeeded()) {
            String string3 = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (parameter == null) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!(parameter.getNodes() != null && parameter.getNodes().length != 0 || parameter.getPoints() != null && parameter.getPoints().getCount() != 0)) {
            String string5 = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (weights == null || weights.length == 0) {
            String string6 = InternalResource.loadString("weights", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        int n = weights.length;
        for (int i = 0; i < n; ++i) {
            if (!(weights[i] <= 0.0)) continue;
            String string7 = InternalResource.loadString("weights{" + i + "]", "TransportationAnalyst_WeightShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        if (parameter.getNodes() != null && parameter.getNodes().length > 0) {
            if (parameter.getNodes().length != n) {
                String string8 = InternalResource.loadString("", "TransportationAnalyst_FindServiceAreaWeightCountShouldEqualsCenterPointCount", "networkanalyst_resources");
                throw new IllegalArgumentException(string8);
            }
        } else if (parameter.getPoints() != null && parameter.getPoints().getCount() > 0 && parameter.getPoints().getCount() != n) {
            String string9 = InternalResource.loadString("", "TransportationAnalyst_FindServiceAreaWeightCountShouldEqualsCenterPointCount", "networkanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        if ((string = parameter.getWeightName()) == null || string.trim().length() == 0) {
            parameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(string) < 0) {
            String string10 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string10);
        }
        String string11 = parameter.getTurnWeightField();
        if (null == parameter.getTurnWeightField()) {
            parameter.setTurnWeightField("");
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter)) == 0L) {
            String string12 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string12);
        }
        long l2 = TransportationAnalystNative.jni_FindServiceArea(this.m_analystHandles[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter), weights, isFromCenter, isCenterMutuallyExclusive);
        parameter.setWeightName(string);
        parameter.setTurnWeightField(string11);
        ServiceAreaResult serviceAreaResult = null;
        if (l2 != 0L) {
            serviceAreaResult = new ServiceAreaResult(l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        return serviceAreaResult;
    }

    public AllocationAnalystResult allocate(AllocationAnalystParameter parameter) {
        String string;
        String[] stringArray;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("allocate(AllocationAnalystParameter parameter)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isLoadModelNeeded()) {
            String string3 = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (parameter == null) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter);
        if (l == 0L) {
            String string5 = InternalResource.loadString("parameter", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (parameter.getSupplyCenters().getCount() <= 0) {
            String string6 = InternalResource.loadString("parameter", "TransportationAnalyst_AllocationAnalystSupplyCentersCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        String string7 = parameter.getWeightName();
        if (string7 == null || string7.length() == 0) {
            String string8 = InternalResource.loadString("parameter", "TransportationAnalyst_AllocationAnalystWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        String string9 = parameter.getTurnWeightField();
        DatasetVector datasetVector = this.m_analystSetting.getTurnDataset();
        if (datasetVector != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) != 0L) {
            if (string9 == null || string9.length() == 0) {
                stringArray = this.m_analystSetting.getTurnWeightFields();
                if (stringArray == null || stringArray.length <= 0) {
                    String string10 = InternalResource.loadString("m_analystSetting.getTurnWeightFields()", "TransportationAnalyst_TurnWeightFieldsShouldBeSet", "networkanalyst_resources");
                    throw new IllegalStateException(string10);
                }
                string = stringArray[0];
                if (string == null || string.trim().length() == 0) {
                    String string11 = InternalResource.loadString("m_analystSetting.getTurnWeightFields()", "TransportationAnalyst_TurnWeightFieldsShouldBeSet", "networkanalyst_resources");
                    throw new IllegalStateException(string11);
                }
                parameter.setTurnWeightField(string);
            }
        } else {
            parameter.setTurnWeightField("");
        }
        stringArray = parameter.getNodeDemandField();
        if (parameter.getDemandType().equals((Object)AllocationDemandType.NODE) && (stringArray == null || stringArray.trim().length() == 0)) {
            string = InternalResource.loadString("parameter", "TransportationAnalyst_AllocationAnalystNodeDemandFieldNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        string = parameter.getEdgeDemandField();
        if (parameter.getDemandType().equals((Object)AllocationDemandType.EDGE) && (string == null || string.trim().length() == 0)) {
            String string12 = InternalResource.loadString("parameter", "TransportationAnalyst_AllocationAnalystEdgeDemandFieldNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string12);
        }
        if (!(!parameter.getDemandType().equals((Object)AllocationDemandType.BOTH) || string != null && string.trim().length() != 0 || stringArray != null && stringArray.length() != 0)) {
            String string13 = InternalResource.loadString("parameter", "TransportationAnalyst_AllocationAnalystNodeAndEdgeDemandFieldNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string13);
        }
        SupplyCenters supplyCenters = parameter.getSupplyCenters();
        int n = supplyCenters.getCount();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = supplyCenters.get(i).getType().value();
            nArray2[i] = supplyCenters.get(i).getID();
            dArray[i] = supplyCenters.get(i).getResourceValue();
            dArray2[i] = supplyCenters.get(i).getMaxWeight();
        }
        long l2 = TransportationAnalystNative.jni_Allocation(this.m_analystHandles[2], parameter.getHandle(), nArray, nArray2, dArray, dArray2, parameter.getNodeDemandField(), parameter.getEdgeDemandField());
        AllocationAnalystResult allocationAnalystResult = null;
        if (l2 != 0L) {
            allocationAnalystResult = new AllocationAnalystResult(l2);
        }
        return allocationAnalystResult;
    }

    public LocationAnalystResult findLocation(LocationAnalystParameter parameter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("FindLocation(LocationAnalystParameter parameter)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("LoadModel", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter);
        if (l == 0L) {
            String string = InternalResource.loadString("parameter", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == parameter.getTurnWeightField()) {
            parameter.setTurnWeightField("");
        }
        if (parameter.getSupplyCenters().getCount() <= 0) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_LocationAnalystSupplyCentersCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (parameter.getExpectedSupplyCenterCount() < 0) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_LocationAnalystExceptCentersShouldNotBeNegative", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (parameter.getSupplyCenters().getCount() < parameter.getExpectedSupplyCenterCount()) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_LocationAnalystSupplyCentersCountShouldGreaterThanExpectedCount", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        String string = parameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            parameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = string;
        SupplyCenters supplyCenters = parameter.getSupplyCenters();
        int n = supplyCenters.getCount();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = supplyCenters.get(i).getType().value();
            nArray2[i] = supplyCenters.get(i).getID();
            dArray[i] = supplyCenters.get(i).getResourceValue();
            dArray2[i] = supplyCenters.get(i).getMaxWeight();
        }
        long l2 = TransportationAnalystNative.jni_findLocation(this.m_analystHandles[2], InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter), nArray, nArray2, dArray, dArray2, string3);
        parameter.setWeightName(string);
        LocationAnalystResult locationAnalystResult = null;
        if (l2 != 0L) {
            locationAnalystResult = new LocationAnalystResult(l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        return locationAnalystResult;
    }

    public double[][] computeWeightMatrix(TransportationAnalystParameter parameter) {
        long l;
        if (this.getHandle() == 0L || this.m_analystHandles[0] == 0L) {
            String string = InternalResource.loadString("computeWeightMatrix(TransportationAnalystParameter parameter)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!(parameter.getNodes() != null && parameter.getNodes().length != 0 || parameter.getPoints() != null && parameter.getPoints().getCount() != 0)) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = parameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            parameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = parameter.getTurnWeightField();
        if (null == parameter.getTurnWeightField()) {
            parameter.setTurnWeightField("");
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter)) == 0L) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string4);
        }
        int n = 0;
        n = parameter.getPoints() != null && parameter.getPoints().getCount() != 0 ? parameter.getPoints().getCount() : parameter.getNodes().length;
        double[] dArray = new double[n * n];
        boolean bl = TransportationAnalystNative.jni_GetWeightMatrixArray(this.m_analystHandles[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter), dArray);
        double[][] dArray2 = new double[0][0];
        if (bl) {
            dArray2 = new double[n][n];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray2[i][j] = dArray[i * n + j];
                }
            }
        }
        parameter.setWeightName(string);
        parameter.setTurnWeightField(string3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        return dArray2;
    }

    protected void clearHandle() {
        if (this.m_analystSetting != null) {
            this.m_analystSetting = null;
        }
    }

    void setAnalsytSettingToUGC() {
        String[] stringArray;
        WeightFieldInfos weightFieldInfos;
        if (!this.m_analystSetting.getNeedSet()) {
            return;
        }
        DatasetVector datasetVector = this.m_analystSetting.getNetworkDataset();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset()", "TransportationAnalyst_NetworkDatasetHasNotBeenSet", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        DatasetType datasetType = datasetVector.getType();
        if (datasetType != DatasetType.NETWORK) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset().getType()", "TransportationAnalyst_DatasetTypeMustBeNetwork", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        String[] stringArray2 = new String[]{this.m_analystSetting.getNodeIDField(), this.m_analystSetting.getEdgeIDField(), this.m_analystSetting.getFNodeIDField(), this.m_analystSetting.getTNodeIDField(), this.m_analystSetting.getTurnNodeIDField(), this.m_analystSetting.getTurnFEdgeIDField(), this.m_analystSetting.getTurnTEdgeIDField(), this.m_analystSetting.getNodeNameField(), this.m_analystSetting.getEdgeNameField(), this.m_analystSetting.getRuleField()};
        DatasetVector datasetVector2 = this.m_analystSetting.getTurnDataset();
        if (datasetVector2 != null && !datasetVector2.isOpen()) {
            datasetVector2.open();
        }
        String[] stringArray3 = this.m_analystSetting.getTurnWeightFields();
        String[] stringArray4 = this.m_analystSetting.getFTSingleWayRuleValues();
        String[] stringArray5 = this.m_analystSetting.getTFSingleWayRuleValues();
        String[] stringArray6 = this.m_analystSetting.getProhibitedWayRuleValues();
        String[] stringArray7 = this.m_analystSetting.getTwoWayRuleValues();
        String[] stringArray8 = new String[]{stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3]};
        if (!TransportationAnalyst.isNetworkFieldsAllRight(stringArray8, datasetVector)) {
            String string = InternalResource.loadString("fields", "TransportationAnalystSetting_FieldIsNotInNetworkDataset", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (datasetVector2 != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector2);
            weightFieldInfos = datasetVector2.getType();
            if (weightFieldInfos != DatasetType.TABULAR) {
                String string = InternalResource.loadString("m_analystSetting.getTurnDataset().getType()", "TransportationAnalyst_DatasetTypeMustBeTabular", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            if (stringArray2[4] == null || stringArray2[4].trim().length() == 0) {
                String string = InternalResource.loadString("m_analystSetting.getTurnNodeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            if (stringArray2[5] == null || stringArray2[5].trim().length() == 0) {
                String string = InternalResource.loadString("m_analystSetting.getTurnFEdgeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            if (stringArray2[6] == null || stringArray2[6].trim().length() == 0) {
                String string = InternalResource.loadString("m_analystSetting.getTurnTEdgeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            stringArray = new String[]{stringArray2[4], stringArray2[5], stringArray2[6]};
            if (!TransportationAnalyst.isTurnFieldsAllRight(stringArray, datasetVector2)) {
                String string = InternalResource.loadString("fields", "TransportationAnalystSetting_FieldIsNotInTurnDataset", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!TransportationAnalyst.isTurnFieldsAllRight(stringArray3, datasetVector2)) {
                String string = InternalResource.loadString("turnWeightFields", "TransportationAnalystSetting_FieldIsNotInTurnDataset", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((weightFieldInfos = this.m_analystSetting.getWeightFieldInfos()) == null || weightFieldInfos.getCount() <= 0) {
            stringArray = InternalResource.loadString("m_analystSetting.getWeightFieldInfos()", "TransportationAnalyst_WeightFieldInfoCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException((String)stringArray);
        }
        stringArray = null;
        String[] stringArray9 = null;
        String[] stringArray10 = null;
        int n = weightFieldInfos.getCount();
        stringArray = new String[n];
        stringArray9 = new String[n];
        stringArray10 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = weightFieldInfos.get(i).getName();
            stringArray9[i] = weightFieldInfos.get(i).getFTWeightField();
            stringArray10[i] = weightFieldInfos.get(i).getTFWeightField();
        }
        int[] nArray = this.m_analystSetting.getBarrierNodes();
        int[] nArray2 = this.m_analystSetting.getBarrierEdges();
        double d = this.m_analystSetting.getTolerance();
        String string = this.m_analystSetting.getEdgeFilter();
        boolean bl = this.m_analystSetting.getUseBasicLoad();
        TransportationAnalystNative.jni_SetAnalystSettingToUGC(this.getHandle(), l, l2, stringArray2, stringArray, stringArray9, stringArray10, stringArray3, nArray, nArray2, stringArray4, stringArray5, stringArray6, stringArray7, d, string, bl);
        this.m_analystSetting.setNeedSet(false);
    }

    private boolean isLoadModelNeeded() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLoadModelNeeded()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_isMultiAnalyst) {
            return this.m_multiAnalystSetting.getNeedSet() || !this.m_modelLoaded;
        }
        return this.m_analystSetting.getNeedSet() || !this.m_modelLoaded;
    }

    static boolean isNetworkFieldsAllRight(String[] fields, DatasetVector networkDataset) {
        int n;
        boolean bl = true;
        if (!networkDataset.open()) {
            networkDataset.open();
        }
        FieldInfos fieldInfos = networkDataset.getChildDataset().getFieldInfos();
        boolean bl2 = false;
        for (n = 0; n < fieldInfos.getCount(); ++n) {
            if (fieldInfos.get(n).getName().compareToIgnoreCase(fields[0]) != 0) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return bl2;
        }
        bl2 = false;
        fieldInfos = networkDataset.getFieldInfos();
        n = fields.length;
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < fieldInfos.getCount(); ++j) {
                if (fieldInfos.get(j).getName().compareToIgnoreCase(fields[i]) != 0) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return bl2;
        }
        return bl;
    }

    static boolean isTurnFieldsAllRight(String[] fields, DatasetVector networkDataset) {
        boolean bl = false;
        FieldInfos fieldInfos = networkDataset.getFieldInfos();
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < fieldInfos.getCount(); ++j) {
                if (fieldInfos.get(j).getName().compareToIgnoreCase(fields[i]) != 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return bl;
        }
        return bl;
    }

    public TransportationAnalystCheckResult check() {
        int n;
        int n2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("check()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_analystSetting.getNeedSet()) {
            this.setAnalsytSettingToUGC();
        }
        int[] nArray = TransportationAnalystNative.jni_CheckNew(this.getHandle(), this.m_analystSetting.getEdgeIDField(), this.m_analystSetting.getFNodeIDField(), this.m_analystSetting.getTNodeIDField(), this.m_analystSetting.getNodeIDField(), this.m_analystSetting.getTurnFEdgeIDField(), this.m_analystSetting.getTurnTEdgeIDField(), this.m_analystSetting.getTurnNodeIDField());
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap3 = new HashMap<Integer, Integer>();
        if (nArray.length == 3) {
            return new TransportationAnalystCheckResult(hashMap2, hashMap, hashMap3);
        }
        int n3 = 0;
        int n4 = nArray[0];
        int n5 = 1;
        int n6 = nArray[0];
        for (n3 = n5; n3 < n6; n3 += 2) {
            n2 = nArray[n3];
            n = nArray[n3 + 1];
            hashMap2.put(n2, n);
        }
        n5 += n4 + 1;
        n4 = nArray[n6 + 1];
        n6 = n5 + n4 - 1;
        for (n3 = n5; n3 < n6; n3 += 2) {
            n2 = nArray[n3];
            n = nArray[n3 + 1];
            hashMap.put(n2, n);
        }
        n5 += n4 + 1;
        n4 = nArray[n6 + 1];
        n6 = n5 + n4 - 1;
        for (n3 = n5; n3 < n6; n3 += 2) {
            n2 = nArray[n3];
            n = nArray[n3 + 1];
            hashMap3.put(n2, n);
        }
        return new TransportationAnalystCheckResult(hashMap2, hashMap, hashMap3);
    }

    @Deprecated
    public boolean check(ArrayList<Integer> networks, ArrayList<Integer> turns) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("check()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_analystSetting.getNeedSet()) {
            this.setAnalsytSettingToUGC();
        }
        if (networks == null) {
            String string = InternalResource.loadString("networks", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (turns == null) {
            String string = InternalResource.loadString("turns", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int[] nArray = TransportationAnalystNative.jni_Check(this.getHandle(), this.m_analystSetting.getEdgeIDField(), this.m_analystSetting.getFNodeIDField(), this.m_analystSetting.getTNodeIDField(), this.m_analystSetting.getNodeIDField(), this.m_analystSetting.getTurnFEdgeIDField(), this.m_analystSetting.getTurnTEdgeIDField(), this.m_analystSetting.getTurnNodeIDField());
        boolean bl = true;
        if (nArray.length > 2) {
            bl = false;
        } else if (nArray.length == 2) {
            return bl;
        }
        for (n = 1; n <= nArray[0]; ++n) {
            networks.add(nArray[n]);
        }
        for (n = nArray[0] + 2; n < nArray.length; ++n) {
            turns.add(nArray[n]);
        }
        return bl;
    }

    boolean checkWeightField() {
        DatasetVector datasetVector = this.m_analystSetting.getNetworkDataset();
        if (datasetVector == null) {
            return false;
        }
        for (int i = 0; i < this.m_analystSetting.getWeightFieldInfos().getCount(); ++i) {
            int n;
            String string = this.m_analystSetting.getWeightFieldInfos().get(i).getFTWeightField();
            String string2 = this.m_analystSetting.getWeightFieldInfos().get(i).getTFWeightField();
            FieldInfos fieldInfos = datasetVector.getFieldInfos();
            int n2 = fieldInfos.getCount();
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                String string3 = fieldInfos.get(n).getName();
                if (!string3.equalsIgnoreCase(string)) continue;
                bl = true;
            }
            if (!bl) {
                String string4 = InternalResource.loadString(string, "Global_EnumValueIsError", "networkanalyst_resources");
                throw new IllegalArgumentException(string4);
            }
            n = 0;
            for (int j = 0; j < n2; ++j) {
                String string5 = fieldInfos.get(j).getName();
                if (!string5.equalsIgnoreCase(string2)) continue;
                n = 1;
            }
            if (n != 0) continue;
            String string6 = InternalResource.loadString(string2, "Global_EnumValueIsError", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        return true;
    }

    private boolean loadModel(String filePath) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("loadModel", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.getFileType(filePath) == 1) {
            String string = InternalResource.loadString("loadModel", "FileTypeNotMatch", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getFileType(filePath) == -1) {
            String string = InternalResource.loadString("loadModel", "FileError", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        bl = TransportationAnalystNative.jni_LoadModelFromFile(this.getHandle(), filePath, 0L);
        if (bl) {
            this.getAnalystSettingFromUGC();
            this.m_analystSetting.setNeedSet(false);
            this.m_modelLoaded = true;
        } else {
            this.m_analystSetting.setNeedSet(true);
            this.m_modelLoaded = false;
        }
        return bl;
    }

    public boolean loadModel(String filePath, DatasetVector networkDataset) {
        this.verifyLicense();
        if (this.getFileType(filePath) == 0) {
            String string = InternalResource.loadString("loadModel", "FileTypeNotMatch", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.getFileType(filePath) == -1) {
            String string = InternalResource.loadString("loadModel", "FileError", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("loadModel", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (networkDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)networkDataset) == 0L) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset()", "TransportationAnalyst_NetworkDatasetHasNotBeenSet", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        DatasetType datasetType = networkDataset.getType();
        if (datasetType != DatasetType.NETWORK) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset().getType()", "TransportationAnalyst_DatasetTypeMustBeNetwork", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)networkDataset);
        boolean bl = false;
        bl = TransportationAnalystNative.jni_LoadModelFromFile(this.getHandle(), filePath, l);
        if (bl) {
            this.getAnalystSettingFromUGC();
            this.m_analystSetting.setNetworkDataset(networkDataset);
            this.m_analystSetting.setNeedSet(false);
            this.m_modelLoaded = true;
            this.m_bLoadFile = true;
        } else {
            this.m_analystSetting.setNeedSet(true);
            this.m_modelLoaded = false;
            this.m_bLoadFile = false;
        }
        return bl;
    }

    public boolean createModel(String filePath) {
        boolean bl;
        this.m_analystSetting.setUseBasicLoad(true);
        boolean bl2 = this.m_analystSetting.getNeedLoadModel();
        boolean bl3 = this.m_analystSetting.getNeedLoadTurnModel();
        if (bl2 || bl3) {
            bl = this.load();
            if (!bl) {
                return bl;
            }
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("createModelFile", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
        }
        bl = false;
        bl = TransportationAnalystNative.jni_SaveModelToFile(this.getHandle(), filePath);
        this.m_analystSetting.setUseBasicLoad(false);
        if (bl) {
            TransportationAnalystNative.jni_Delete(this.getHandle(), this.m_analystHandles);
            this.setHandle(0L);
            long l = TransportationAnalystNative.jni_New(this.m_analystHandles);
            this.setHandle(l, true);
        }
        return bl;
    }

    void getAnalystSettingFromUGC() {
        String[] stringArray = new String[13];
        int[] nArray = new int[8];
        double[] dArray = new double[1];
        TransportationAnalystNative.jni_GetAnalystFromUGC(this.getHandle(), stringArray, nArray, dArray);
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        String string6 = stringArray[5];
        String string7 = stringArray[6];
        String string8 = stringArray[7];
        String string9 = stringArray[8];
        String string10 = stringArray[9];
        String string11 = stringArray[10];
        String string12 = stringArray[11];
        String string13 = stringArray[12];
        double d = dArray[0];
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = nArray[4];
        int n6 = nArray[5];
        int n7 = nArray[6];
        int n8 = nArray[7];
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        String[] stringArray5 = null;
        String[] stringArray6 = null;
        String[] stringArray7 = null;
        String[] stringArray8 = null;
        String[] stringArray9 = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        if (n != 0) {
            stringArray2 = new String[n];
            stringArray3 = new String[n];
            stringArray4 = new String[n];
            TransportationAnalystNative.jni_GetWeightInfo(this.getHandle(), stringArray2, stringArray3, stringArray4);
        }
        if (n2 != 0) {
            nArray2 = new int[n2];
            TransportationAnalystNative.jni_GetBarrierNodeID(this.getHandle(), nArray2);
        }
        if (n3 != 0) {
            nArray3 = new int[n3];
            TransportationAnalystNative.jni_GetBarrierEdgeID(this.getHandle(), nArray3);
        }
        if (n4 != 0) {
            stringArray5 = new String[n4];
            TransportationAnalystNative.jni_GetTurnWeightField(this.getHandle(), stringArray5);
        }
        if (n5 != 0 || n6 != 0 || n7 != 0 || n8 != 0) {
            stringArray6 = new String[n5];
            stringArray7 = new String[n6];
            stringArray8 = new String[n7];
            stringArray9 = new String[n8];
            TransportationAnalystNative.jni_GetRuleInfo(this.getHandle(), stringArray6, stringArray7, stringArray8, stringArray9);
        }
        int n9 = 0;
        this.m_analystSetting.setEdgeIDField(string2);
        this.m_analystSetting.setNodeIDField(string3);
        this.m_analystSetting.setFNodeIDField(string4);
        this.m_analystSetting.setTNodeIDField(string5);
        WeightFieldInfos weightFieldInfos = new WeightFieldInfos();
        if (stringArray2.length == n && stringArray3.length == n && stringArray4.length == n) {
            for (n9 = 0; n9 < n; ++n9) {
                WeightFieldInfo weightFieldInfo = new WeightFieldInfo();
                weightFieldInfo.setName(stringArray2[n9]);
                weightFieldInfo.setFTWeightField(stringArray3[n9]);
                weightFieldInfo.setTFWeightField(stringArray4[n9]);
                weightFieldInfos.add(weightFieldInfo);
            }
        }
        this.m_analystSetting.setWeightFieldInfos(weightFieldInfos);
        this.m_analystSetting.setTolerance(d);
        this.m_analystSetting.setBarrierNodes(nArray2);
        this.m_analystSetting.setBarrierEdges(nArray3);
        this.m_analystSetting.setTurnNodeIDField(string7);
        this.m_analystSetting.setTurnFEdgeIDField(string8);
        this.m_analystSetting.setTurnTEdgeIDField(string9);
        this.m_analystSetting.setTurnWeightFields(stringArray5);
        this.m_analystSetting.setNodeNameField(string10);
        this.m_analystSetting.setEdgeNameField(string11);
        this.m_analystSetting.setRuleField(string12);
        this.m_analystSetting.setFTSingleWayRuleValues(stringArray6);
        this.m_analystSetting.setTFSingleWayRuleValues(stringArray7);
        this.m_analystSetting.setProhibitedWayRuleValues(stringArray8);
        this.m_analystSetting.setTwoWayRuleValues(stringArray9);
        this.m_analystSetting.setEdgeFilter(string13);
    }

    int getFileType(String filePath) {
        int n = TransportationAnalystNative.jni_GetFileType(this.getHandle(), filePath);
        return n;
    }

    private TransportationAnalystResult FindMTSPPathEx(TransportationAnalystParameter parameter, Point2D center, int[] arrDemand, double dLimitCost, int nMaxDemand, boolean isSplitStation, boolean isFromCenter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("FindMTSPPath(TransportationAnalystParameter parameter, int[] centerNodes, boolean hasLeastTotalCost)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter);
        if (l == 0L) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        String string = parameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            parameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = parameter.getTurnWeightField();
        if (null == parameter.getTurnWeightField()) {
            parameter.setTurnWeightField("");
        }
        long l2 = TransportationAnalystNative.jni_findMTSPPathEx(this.m_analystHandles[1], InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter), center.getX(), center.getY(), arrDemand, dLimitCost, nMaxDemand, isSplitStation, isFromCenter);
        parameter.setWeightName(string);
        parameter.setTurnWeightField(string3);
        TransportationAnalystResult transportationAnalystResult = null;
        if (l2 == 0L) {
            String string4 = Toolkit.getLastError();
            throw new NullPointerException(string4);
        }
        transportationAnalystResult = new TransportationAnalystResult(l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        return transportationAnalystResult;
    }

    public VRPAnalystResult findVRPPath(VRPAnalystParameter parameter, VehicleInfo[] vehicleInfos, CenterPointInfo[] centerInfos, DemandPointInfo[] demandInfos) {
        int n;
        Calendar calendar;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPath(TransportationAnalystParameter parameter, boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        String string = parameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            parameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = parameter.getTurnWeightField();
        if (null == parameter.getTurnWeightField()) {
            parameter.setTurnWeightField("");
        }
        this.checkVRPParameter(parameter, vehicleInfos, centerInfos, demandInfos);
        long[] lArray = new long[vehicleInfos.length];
        long[] lArray2 = new long[centerInfos.length];
        long[] lArray3 = new long[demandInfos.length];
        int n2 = 0;
        int n3 = 1440;
        int n4 = 0;
        for (n2 = 0; n2 < vehicleInfos.length; ++n2) {
            vehicleInfos[n2].setVehicleID(n2);
            lArray[n2] = vehicleInfos[n2].getHandle();
            if (!vehicleInfos[n2].isSetTime()) continue;
            calendar = Calendar.getInstance();
            calendar.setTime(vehicleInfos[n2].getStartTime());
            n = calendar.get(11) * 60 + calendar.get(12);
            if (n < n3) {
                n3 = n;
            }
            calendar = Calendar.getInstance();
            calendar.setTime(vehicleInfos[n2].getEndTime());
            n = calendar.get(11) * 60 + calendar.get(12);
            if (n <= n4) continue;
            n4 = n;
        }
        for (n2 = 0; n2 < centerInfos.length; ++n2) {
            lArray2[n2] = centerInfos[n2].getHandle();
        }
        for (n2 = 0; n2 < demandInfos.length; ++n2) {
            lArray3[n2] = demandInfos[n2].getHandle();
            if (!demandInfos[n2].isSetTime()) continue;
            calendar = Calendar.getInstance();
            calendar.setTime(demandInfos[n2].getStartTime());
            n = calendar.get(11) * 60 + calendar.get(12);
            calendar.setTime(demandInfos[n2].getEndTime());
            int n5 = calendar.get(11) * 60 + calendar.get(12);
            if (n5 >= n3 && n <= n4) continue;
            String string4 = InternalResource.loadString("demandInfos[" + n2 + "].Time", "ServerTimeIllegal", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (vehicleInfos.length > 1) {
            parameter.setVehicleType(VehicleType.TYPE1);
        }
        long l = TransportationAnalystNative.jni_findVRPPath(this.m_analystHandles[1], InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter), lArray, lArray2, lArray3, parameter.getAnalystType().value(), parameter.getVRPDirectionType().value(), parameter.getStopType().value(), parameter.getVehicleType().value());
        parameter.setTurnWeightField(string3);
        VRPAnalystResult vRPAnalystResult = null;
        if (l == 0L) {
            String string5 = Toolkit.getLastError();
            throw new NullPointerException(string5);
        }
        vRPAnalystResult = new VRPAnalystResult(l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        return vRPAnalystResult;
    }

    private boolean checkVRPParameter(VRPAnalystParameter parameter, VehicleInfo[] vehicleInfos, CenterPointInfo[] centerInfos, DemandPointInfo[] demandInfos) {
        int n;
        int n2 = 0;
        if (vehicleInfos.length < 1 || centerInfos.length < 1 || demandInfos.length < 1) {
            String string = InternalResource.loadString("VehicleInfo[],CenterPointInfo[],DemandPointInfo[]", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = centerInfos[0].getCenterID() != -1;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < centerInfos.length; ++n2) {
            if (centerInfos[n2].getCenterID() == -1) {
                ++n4;
                continue;
            }
            ++n3;
        }
        if (bl) {
            if (n3 != centerInfos.length) {
                String string = InternalResource.loadString("centerInfos", "TheTypeShouldBeSame", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        } else if (n4 != centerInfos.length) {
            String string = InternalResource.loadString("centerInfos", "TheTypeShouldBeSame", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        n3 = 0;
        n4 = 0;
        boolean bl2 = true;
        boolean bl3 = parameter.getVRPDirectionType() == VRPDirectionType.ROUNDROUTE;
        int n5 = vehicleInfos[0].getLoadWeights().length;
        for (n2 = 0; n2 < vehicleInfos.length; ++n2) {
            if (n5 != vehicleInfos[n2].getLoadWeights().length) {
                String string = InternalResource.loadString("vehicleInfos[" + n2 + "].getLoadWeight().length", "VehicleLoadWeightSizeNotSame", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            for (n = 0; n < vehicleInfos[n2].getLoadWeights().length; ++n) {
                if (!(vehicleInfos[n2].getLoadWeights()[n] <= 0.0)) continue;
                String string = InternalResource.loadString("vehicleInfos[" + n2 + "].getLoadWeight()[" + n + "]", "VehicleLoadWeightGreaterThanZero", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (vehicleInfos[0].getSE() != vehicleInfos[n2].getSE() && bl2) {
                bl2 = false;
            }
            if (bl3) {
                vehicleInfos[n2].setSE(!bl3);
                continue;
            }
            if (vehicleInfos[n2].getSEID() == -1) {
                ++n4;
                continue;
            }
            ++n3;
        }
        if (!bl3 && vehicleInfos[0].getSE()) {
            if (bl) {
                if (n3 != vehicleInfos.length) {
                    String string = InternalResource.loadString("vehicleInfos", "TheTypeShouldBeSame", "networkanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
            } else if (n4 != vehicleInfos.length) {
                String string = InternalResource.loadString("vehicleInfos", "TheTypeShouldBeSame", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        n3 = 0;
        n4 = 0;
        for (n2 = 0; n2 < demandInfos.length; ++n2) {
            if (n5 != demandInfos[n2].getDemands().length) {
                String string = InternalResource.loadString("demandInfos[" + n2 + "].getDemands().length", "DemandSizeAndLoadWeightCountNotSame", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            for (n = 0; n < demandInfos[n2].getDemands().length; ++n) {
                if (!(demandInfos[n2].getDemands()[n] < 0.0)) continue;
                String string = InternalResource.loadString("demandInfos[" + n2 + "].getDemand()[" + n + "]", "DemandGreaterThanZero", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (demandInfos[n2].getDemandID() == -1) {
                ++n4;
                continue;
            }
            ++n3;
        }
        if (bl) {
            if (n3 != demandInfos.length) {
                String string = InternalResource.loadString("demandInfos", "TheTypeShouldBeSame", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        } else if (n4 != demandInfos.length) {
            String string = InternalResource.loadString("demandInfos", "TheTypeShouldBeSame", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return true;
    }

    public int[] findCriticalNodes(int startPoint, int endPoint) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCriticalNodes(int startPoint, int endPoint)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        TransportationAnalystParameter transportationAnalystParameter = new TransportationAnalystParameter();
        transportationAnalystParameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        if (this.m_analystSetting.getTurnWeightFields() != null && this.m_analystSetting.getTurnWeightFields().length > 0) {
            transportationAnalystParameter.setTurnWeightField(this.m_analystSetting.getTurnWeightFields()[0]);
        }
        transportationAnalystParameter.setNodes(new int[]{startPoint, endPoint});
        transportationAnalystParameter.setNodesReturn(true);
        int[] nArray = TransportationAnalystNative.jni_FindCriticalElement(this.m_analystHandles[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter), true);
        return nArray;
    }

    public int[] findCriticalEdges(int startPoint, int endPoint) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCriticalNodes(int startPoint, int endPoint)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        TransportationAnalystParameter transportationAnalystParameter = new TransportationAnalystParameter();
        transportationAnalystParameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        if (this.m_analystSetting.getTurnWeightFields() != null && this.m_analystSetting.getTurnWeightFields().length > 0) {
            transportationAnalystParameter.setTurnWeightField(this.m_analystSetting.getTurnWeightFields()[0]);
        }
        transportationAnalystParameter.setNodes(new int[]{startPoint, endPoint});
        transportationAnalystParameter.setEdgesReturn(true);
        int[] nArray = TransportationAnalystNative.jni_FindCriticalElement(this.m_analystHandles[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter), false);
        return nArray;
    }

    public GroupAnalystResult findGroup(GroupAnalystParameter parameter, GroupPointInfo[] pointInfo, double maxCost, double maxLoad) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPath(TransportationAnalystParameter parameter, boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        String string = parameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            parameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = parameter.getTurnWeightField();
        if (null == parameter.getTurnWeightField()) {
            parameter.setTurnWeightField("");
        }
        long[] lArray = new long[pointInfo.length];
        int n = 0;
        for (n = 0; n < lArray.length; ++n) {
            lArray[n] = TransportationAnalystParameterNative.jni_SetBuildingPointInfo(pointInfo[n].getLoad(), pointInfo[n].getPoint().getX(), pointInfo[n].getPoint().getY());
        }
        long l = TransportationAnalystNative.jni_FindGroup(this.m_analystHandles[1], InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter), lArray, maxCost, maxLoad, parameter.isAlongRoad(), parameter.getGroupMode().value());
        parameter.setTurnWeightField(string3);
        GroupAnalystResult groupAnalystResult = null;
        if (l == 0L) {
            String string4 = Toolkit.getLastError();
            throw new NullPointerException(string4);
        }
        groupAnalystResult = new GroupAnalystResult(l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        return groupAnalystResult;
    }

    private TransportationAnalystResult findPathAStar(TransportationAnalystParameter parameter) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPath(TransportationAnalystParameter parameter, boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!(parameter.getNodes() != null && parameter.getNodes().length != 0 || parameter.getPoints() != null && parameter.getPoints().getCount() != 0)) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_bLoadFile) {
            String string = InternalResource.loadString("Please Use Load() to load model", "UseErrorLoadInterface", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = parameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            parameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = parameter.getTurnWeightField();
        if (null == parameter.getTurnWeightField()) {
            parameter.setTurnWeightField("");
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter)) == 0L) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string4);
        }
        for (int i = 0; i < parameter.getNodes().length; ++i) {
            if (parameter.getNodes()[i] >= 0) continue;
            String string5 = InternalResource.loadString("Nodes", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new NullPointerException(string5);
        }
        Toolkit.clearErrors();
        long l2 = TransportationAnalystNative.jni_FindAStarPath(this.m_analystHandles[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter));
        parameter.setWeightName(string);
        parameter.setTurnWeightField(string3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        if (l2 != 0L) {
            return new TransportationAnalystResult(l2);
        }
        String string6 = Toolkit.getLastError();
        throw new IllegalArgumentException(string6);
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "TransportationAnalyst";
        boolean bl = InternalToolkitNetworkAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        TransportationAnalyst.fireStepped(steppedEvent);
        InternalToolkitNetworkAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean loadMultiAnalyst() {
        void var6_12;
        DatasetVector[] datasetVectorArray;
        int n;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("load()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.m_multiAnalystSetting.getNeedSet()) {
            this.setMultiAnalystSettingToUGC();
        }
        if ((n = (datasetVectorArray = this.m_multiAnalystSetting.getNetworkDatasets()).length) < 1) {
            String string = InternalResource.loadString("m_multiAnalystSetting.getNetworkDatasets()", "TransportationAnalyst_NetworkDatasetHasNotBeenSet", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        for (int i = 0; i < n; ++i) {
            if (datasetVectorArray[i] == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorArray[i]) == 0L) {
                String string = InternalResource.loadString("m_multiAnalystSetting.getNetworkDataset(" + i + ")", "TransportationAnalyst_NetworkDatasetHasNotBeenSet", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            DatasetType datasetType = datasetVectorArray[i].getType();
            if (datasetType == DatasetType.NETWORK) continue;
            String string = InternalResource.loadString("m_multiAnalystSetting.getNetworkDataset(" + i + ").getType()", "TransportationAnalyst_DatasetTypeMustBeNetwork", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[n];
        boolean bl3 = false;
        while (var6_12 < n) {
            lArray[var6_12] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorArray[var6_12]);
            ++var6_12;
        }
        String[] stringArray = this.m_multiAnalystSetting.getNetworkDatasetsName();
        MultiTransportationAnalystRelation[] multiTransportationAnalystRelationArray = this.m_multiAnalystSetting.getRelations();
        int n2 = multiTransportationAnalystRelationArray.length;
        if (n2 < 1) {
            String string = InternalResource.loadString("MultiTransportationAnalystRelation", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        int[] nArray3 = new int[n2];
        for (int i = 0; i < multiTransportationAnalystRelationArray.length; ++i) {
            nArray[i] = multiTransportationAnalystRelationArray[i].getStartIndex();
            nArray2[i] = multiTransportationAnalystRelationArray[i].getEndIndex();
            dArray[i] = multiTransportationAnalystRelationArray[i].getStartPoint().x;
            dArray2[i] = multiTransportationAnalystRelationArray[i].getStartPoint().y;
            dArray3[i] = multiTransportationAnalystRelationArray[i].getEndPoint().x;
            dArray4[i] = multiTransportationAnalystRelationArray[i].getEndPoint().y;
            dArray5[i] = multiTransportationAnalystRelationArray[i].getCost();
            nArray3[i] = multiTransportationAnalystRelationArray[i].getRelationType().value();
        }
        String[] stringArray2 = this.m_multiAnalystSetting.getNetworkDatasetsName();
        boolean bl4 = TransportationAnalystNative.jni_SetEnvAndRelation(this.m_analystHandles[3], lArray, stringArray2, nArray, nArray2, dArray5, nArray3, dArray, dArray2, dArray3, dArray4);
        boolean bl5 = this.m_multiAnalystSetting.getNeedLoadModel();
        if (!bl5) return true;
        Toolkit.clearErrors();
        bl = TransportationAnalystNative.jni_LoadMultiModel(this.m_analystHandles[3]);
        if (!bl) {
            this.m_multiAnalystSetting.setNeedLoadModel(true);
            this.m_modelLoaded = false;
            String string = Toolkit.getLastError();
            throw new IllegalArgumentException(string);
        }
        this.m_multiAnalystSetting.setNeedLoadModel(false);
        this.m_multiAnalystSetting.setNeedSet(false);
        this.m_modelLoaded = true;
        return bl;
    }

    public void setMultiAnalystSetting(MultiTransportationAnalystSetting value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMultiAnalystSetting(NetworkAnalystSetting value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setMultiAnalystSetting(NetworkAnalystSetting value)", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_isMultiAnalyst = true;
        if (!this.m_multiAnalystSetting.equals(value)) {
            this.m_multiAnalystSetting.copyFrom(value);
        }
    }

    public TransportationAnalystResult findPathByMultiNetwork(MultiTransportationAnalystParameter parameter) {
        long l;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPathByMultiNetwork(MultiTransportationAnalystParameter parameter)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        String string = parameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            parameter.setWeightName(this.m_analystSetting.getWeightFieldInfos().get(0).getName());
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = parameter.getTurnWeightField();
        if (null == parameter.getTurnWeightField()) {
            parameter.setTurnWeightField("");
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter)) == 0L) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string4);
        }
        MultiTransportationAnalystPoint[] multiTransportationAnalystPointArray = parameter.getPoints();
        double[] dArray = new double[multiTransportationAnalystPointArray.length];
        double[] dArray2 = new double[multiTransportationAnalystPointArray.length];
        int[] nArray = new int[multiTransportationAnalystPointArray.length];
        for (int i = 0; i < multiTransportationAnalystPointArray.length; ++i) {
            Point2D point2D = multiTransportationAnalystPointArray[i].getPoint();
            dArray[i] = point2D.x;
            dArray2[i] = point2D.y;
            nArray[i] = multiTransportationAnalystPointArray[i].getIndex();
        }
        Toolkit.clearErrors();
        long l2 = TransportationAnalystNative.jni_FindPathByMultiNetwork(this.m_analystHandles[3], InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter), dArray, dArray2, nArray);
        parameter.setWeightName(string);
        parameter.setTurnWeightField(string3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        if (l2 != 0L) {
            return new TransportationAnalystResult(l2);
        }
        String string5 = Toolkit.getLastError();
        throw new IllegalArgumentException(string5);
    }

    void setMultiAnalystSettingToUGC() {
        String[] stringArray;
        WeightFieldInfos weightFieldInfos;
        if (!this.m_multiAnalystSetting.getNeedSet()) {
            return;
        }
        DatasetVector[] datasetVectorArray = this.m_multiAnalystSetting.getNetworkDatasets();
        String[] stringArray2 = new String[]{this.m_multiAnalystSetting.getNodeIDField(), this.m_multiAnalystSetting.getEdgeIDField(), this.m_multiAnalystSetting.getFNodeIDField(), this.m_multiAnalystSetting.getTNodeIDField(), this.m_multiAnalystSetting.getTurnNodeIDField(), this.m_multiAnalystSetting.getTurnFEdgeIDField(), this.m_multiAnalystSetting.getTurnTEdgeIDField(), this.m_multiAnalystSetting.getNodeNameField(), this.m_multiAnalystSetting.getEdgeNameField(), this.m_multiAnalystSetting.getRuleField()};
        DatasetVector datasetVector = this.m_multiAnalystSetting.getTurnDataset();
        if (datasetVector != null && !datasetVector.isOpen()) {
            datasetVector.open();
        }
        String[] stringArray3 = this.m_multiAnalystSetting.getTurnWeightFields();
        String[] stringArray4 = this.m_multiAnalystSetting.getFTSingleWayRuleValues();
        String[] stringArray5 = this.m_multiAnalystSetting.getTFSingleWayRuleValues();
        String[] stringArray6 = this.m_multiAnalystSetting.getProhibitedWayRuleValues();
        String[] stringArray7 = this.m_multiAnalystSetting.getTwoWayRuleValues();
        String[] stringArray8 = new String[]{stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3]};
        long l = 0L;
        if (datasetVector != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
            weightFieldInfos = datasetVector.getType();
            if (weightFieldInfos != DatasetType.TABULAR) {
                String string = InternalResource.loadString("m_analystSetting.getTurnDataset().getType()", "TransportationAnalyst_DatasetTypeMustBeTabular", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            if (stringArray2[4] == null || stringArray2[4].trim().length() == 0) {
                String string = InternalResource.loadString("m_analystSetting.getTurnNodeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            if (stringArray2[5] == null || stringArray2[5].trim().length() == 0) {
                String string = InternalResource.loadString("m_analystSetting.getTurnFEdgeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            if (stringArray2[6] == null || stringArray2[6].trim().length() == 0) {
                String string = InternalResource.loadString("m_analystSetting.getTurnTEdgeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            stringArray = new String[]{stringArray2[4], stringArray2[5], stringArray2[6]};
            if (!TransportationAnalyst.isTurnFieldsAllRight(stringArray, datasetVector)) {
                String string = InternalResource.loadString("fields", "TransportationAnalystSetting_FieldIsNotInTurnDataset", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!TransportationAnalyst.isTurnFieldsAllRight(stringArray3, datasetVector)) {
                String string = InternalResource.loadString("turnWeightFields", "TransportationAnalystSetting_FieldIsNotInTurnDataset", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((weightFieldInfos = this.m_multiAnalystSetting.getWeightFieldInfos()) == null || weightFieldInfos.getCount() <= 0) {
            stringArray = InternalResource.loadString("m_analystSetting.getWeightFieldInfos()", "TransportationAnalyst_WeightFieldInfoCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException((String)stringArray);
        }
        stringArray = null;
        String[] stringArray9 = null;
        String[] stringArray10 = null;
        int n = weightFieldInfos.getCount();
        stringArray = new String[n];
        stringArray9 = new String[n];
        stringArray10 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = weightFieldInfos.get(i).getName();
            stringArray9[i] = weightFieldInfos.get(i).getFTWeightField();
            stringArray10[i] = weightFieldInfos.get(i).getTFWeightField();
        }
        int[] nArray = this.m_multiAnalystSetting.getBarrierNodes();
        int[] nArray2 = this.m_multiAnalystSetting.getBarrierEdges();
        double d = this.m_multiAnalystSetting.getTolerance();
        String string = this.m_multiAnalystSetting.getEdgeFilter();
        boolean bl = this.m_multiAnalystSetting.getUseBasicLoad();
        TransportationAnalystNative.jni_SetAnalystSettingToUGC(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorArray[0]), l, stringArray2, stringArray, stringArray9, stringArray10, stringArray3, nArray, nArray2, stringArray4, stringArray5, stringArray6, stringArray7, d, string, bl);
        this.m_multiAnalystSetting.setNeedSet(false);
    }
}

