/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.SupplyCenterType;

public class SupplyCenter {
    private double m_maxWeight;
    private double m_resourceValue;
    private SupplyCenterType m_supplyCenterType;
    private int m_id;

    public SupplyCenter() {
        this.m_id = -1;
        this.m_resourceValue = 0.0;
        this.m_maxWeight = 0.0;
        this.m_supplyCenterType = SupplyCenterType.NULL;
    }

    public SupplyCenter(SupplyCenter supplyCenter) {
        if (supplyCenter == null) {
            String string = InternalResource.loadString("supplyCenter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_id = supplyCenter.m_id;
        this.m_maxWeight = supplyCenter.m_maxWeight;
        this.m_resourceValue = supplyCenter.m_resourceValue;
        this.m_supplyCenterType = supplyCenter.m_supplyCenterType;
    }

    public SupplyCenterType getType() {
        return this.m_supplyCenterType;
    }

    public void setType(SupplyCenterType type) {
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_supplyCenterType = type;
    }

    public int getID() {
        return this.m_id;
    }

    public void setID(int value) {
        this.m_id = value;
    }

    public double getMaxWeight() {
        return this.m_maxWeight;
    }

    public void setMaxWeight(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("SetMaxWeight(double value)", "SupplyCenters_MaxWeightShouldNotBeNegative", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_maxWeight = value;
    }

    public double getResourceValue() {
        return this.m_resourceValue;
    }

    public void setResourceValue(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("SetMaxWeight(double value)", "SupplyCenter_ResourceValueShouldNotBeNegative", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_resourceValue = value;
    }
}

