/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.MapMatchingLikelyResult;
import com.supermap.analyst.networkanalyst.MapMatchingLikelyResultsNative;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSys;
import java.util.ArrayList;

class MapMatchingLikelyResults {
    private MapMatchingLikelyResults() {
    }

    public static MapMatchingLikelyResult[] parse(long handle, boolean bDisposeHandle, PrjCoordSys prj) {
        if (handle == 0L) {
            return null;
        }
        int n = MapMatchingLikelyResultsNative.jni_GetCount(handle);
        ArrayList<MapMatchingLikelyResult> arrayList = new ArrayList<MapMatchingLikelyResult>();
        double[] dArray = new double[2];
        for (int i = 0; i < n; ++i) {
            MapMatchingLikelyResultsNative.jni_GetPointOnRoad(handle, i, dArray);
            Point2D point2D = new Point2D(dArray[0], dArray[1]);
            double d = MapMatchingLikelyResultsNative.jni_GetDistanceToRoad(handle, i);
            double d2 = MapMatchingLikelyResultsNative.jni_GetProbability(handle, i);
            int[] nArray = MapMatchingLikelyResultsNative.jni_GetEdges(handle, i);
            double[] dArray2 = MapMatchingLikelyResultsNative.jni_GetRoutePoints(handle, i);
            int n2 = dArray2.length / 2;
            Point2D[] point2DArray = new Point2D[n2];
            for (int j = 0; j < n2; ++j) {
                point2DArray[j] = new Point2D(dArray2[2 * j], dArray2[2 * j + 1]);
            }
            arrayList.add(new MapMatchingLikelyResult(point2D, d, nArray, d2, point2DArray, prj));
        }
        if (bDisposeHandle) {
            MapMatchingLikelyResultsNative.jni_Delete(handle);
        }
        MapMatchingLikelyResult[] mapMatchingLikelyResultArray = new MapMatchingLikelyResult[arrayList.size()];
        arrayList.toArray(mapMatchingLikelyResultArray);
        return mapMatchingLikelyResultArray;
    }
}

