/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.DemandResult;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.LocationAnalystResultNative;
import com.supermap.analyst.networkanalyst.SupplyResult;

public class LocationAnalystResult
extends InternalHandleDisposable {
    private SupplyResult[] m_supplyResult = null;
    private DemandResult[] m_demandResult = null;

    LocationAnalystResult(long handle) {
        this.setHandle(handle, true);
    }

    public SupplyResult[] getSupplyResults() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetSupplyResults()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = LocationAnalystResultNative.jni_getSupplyResults(this.getHandle());
        if (this.m_supplyResult == null) {
            if (lArray.length > 0) {
                this.m_supplyResult = new SupplyResult[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    this.m_supplyResult[i] = new SupplyResult(lArray[i]);
                }
            } else {
                this.m_supplyResult = new SupplyResult[0];
            }
        }
        return this.m_supplyResult;
    }

    public DemandResult[] getDemandResults() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetDemandResults()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = LocationAnalystResultNative.jni_getDemandResults(this.getHandle());
        if (this.m_demandResult == null) {
            if (lArray.length > 0) {
                this.m_demandResult = new DemandResult[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    this.m_demandResult[i] = new DemandResult(lArray[i]);
                }
            } else {
                this.m_demandResult = new DemandResult[0];
            }
        }
        return this.m_demandResult;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "networkanalyst_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            LocationAnalystResultNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

