/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.topology;

import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.TopologyDatasetRelationItem;
import com.supermap.data.topology.InternalHandle;
import com.supermap.data.topology.InternalResource;
import com.supermap.data.topology.InternalToolkitTolopogy;
import com.supermap.data.topology.TopologyPreprocessOptions;
import com.supermap.data.topology.TopologyValidatorNative3D;
import java.util.Vector;

public class TopologyValidator3D {
    private static transient Vector m_steppedListeners;

    private TopologyValidator3D() {
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "TopologyValidator3D";
        boolean bl = InternalToolkitTolopogy.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        TopologyValidator3D.fireStepped(steppedEvent);
        InternalToolkitTolopogy.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    public static boolean preprocess3D(DatasetVector[] datasetVectors, int[] precisionOrders, TopologyPreprocessOptions options, double tolerance) {
        int n;
        if (datasetVectors == null) {
            String string = InternalResource.loadString("datasetVectors", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (precisionOrders == null) {
            String string = InternalResource.loadString("precisionOrders", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVectors.length != precisionOrders.length) {
            String string = InternalResource.loadString("datasetVectors  &  precisionOrders", "TopologyValidator_TheNumberOfTheDatasetVectorsAndPrecisionOrdersIsNoEqual", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (options == null) {
            String string = InternalResource.loadString("options", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance <= 0.0) {
            String string = InternalResource.loadString("tolerance", "TopologyProcessingToleranceShouldGreaterThanZero", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVectors.length > 1) {
            DatasetVector datasetVector = datasetVectors[0];
            datasetVector.open();
            PrjCoordSys prjCoordSys = datasetVector.getPrjCoordSys();
            for (int i = 1; i < datasetVectors.length; ++i) {
                if (datasetVectors[i].getPrjCoordSys().getType() == prjCoordSys.getType()) continue;
                String string = InternalResource.loadString("tolerance", "Projection_Not_Same", "topology_resources");
                throw new IllegalArgumentException(string);
            }
        }
        boolean bl = true;
        int n2 = datasetVectors.length;
        long[] lArray = new long[n2];
        for (n = 0; n < lArray.length; ++n) {
            if (datasetVectors[n].getType() != DatasetType.LINE3D) {
                bl = false;
                break;
            }
            lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectors[n]);
            if (lArray[n] != 0L) continue;
            bl = false;
            break;
        }
        if (!bl) {
            String string = InternalResource.loadString("datasetVectors", "Global_ArgumentTypeInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        n = 0;
        if (bl) {
            n = TopologyValidatorNative3D.jni_preprocess3D2(lArray, precisionOrders, options.areArcsInserted(), options.areVertexArcInserted(), options.areVertexesSnapped(), options.arePolygonsChecked(), tolerance) ? 1 : 0;
        }
        return n != 0;
    }

    public static boolean preprocess3D(DatasetVector[] datasetVectors, int[] precisionOrders, double tolerance) {
        TopologyDatasetRelationItem[] topologyDatasetRelationItemArray;
        if (datasetVectors == null) {
            String string = InternalResource.loadString("datasetVectors", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (precisionOrders == null) {
            String string = InternalResource.loadString("precisionOrders", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVectors.length != precisionOrders.length) {
            String string = InternalResource.loadString("datasetVectors  &  precisionOrders", "TopologyValidator_TheNumberOfTheDatasetVectorsAndPrecisionOrdersIsNoEqual", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance <= 0.0) {
            String string = InternalResource.loadString("tolerance", "TopologyProcessingToleranceShouldGreaterThanZero", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVectors.length > 1) {
            topologyDatasetRelationItemArray = datasetVectors[0];
            topologyDatasetRelationItemArray.open();
            PrjCoordSys prjCoordSys = topologyDatasetRelationItemArray.getPrjCoordSys();
            for (int i = 1; i < datasetVectors.length; ++i) {
                if (datasetVectors[i].getPrjCoordSys().getType() == prjCoordSys.getType()) continue;
                String string = InternalResource.loadString("tolerance", "Projection_Not_Same", "topology_resources");
                throw new IllegalArgumentException(string);
            }
        }
        topologyDatasetRelationItemArray = new TopologyDatasetRelationItem[datasetVectors.length];
        for (int i = 0; i < topologyDatasetRelationItemArray.length; ++i) {
            if (datasetVectors[i].getType() != DatasetType.LINE3D) {
                String string = InternalResource.loadString("datasetVectors", "Global_ArgumentTypeInvalid", "topology_resources");
                throw new IllegalArgumentException(string);
            }
            topologyDatasetRelationItemArray[i] = new TopologyDatasetRelationItem(datasetVectors[i], precisionOrders[i]);
        }
        return TopologyValidator3D.preprocess3D(topologyDatasetRelationItemArray, tolerance);
    }

    private static boolean preprocess3D(TopologyDatasetRelationItem[] items, double tolerance) {
        int n;
        if (items == null) {
            String string = InternalResource.loadString("items", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int n2 = items.length;
        long[] lArray = new long[n2];
        int[] nArray = new int[n2];
        for (n = 0; n < lArray.length; ++n) {
            lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)items[n].getDataset());
            if (lArray[n] == 0L) {
                bl = false;
                break;
            }
            if (items[n].getDataset().getType() != DatasetType.LINE3D) {
                bl = false;
                break;
            }
            nArray[n] = items[n].getPrecisionOrder();
        }
        if (!bl) {
            String string = InternalResource.loadString("items", "TopologyValidator_TopologyDatasetRelationItemInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        n = 0;
        if (bl) {
            n = TopologyValidatorNative3D.jni_preprocess3D1(lArray, nArray, tolerance) ? 1 : 0;
        }
        return n != 0;
    }
}

