/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.topology;

import com.supermap.data.Recordset;
import com.supermap.data.topology.ArcAndVertexFilterMode;
import com.supermap.data.topology.InternalResource;

public class TopologyProcessingOptions {
    private boolean m_pseudoNodesCleaned;
    private boolean m_overshootsCleaned;
    private boolean m_redundantVerticesCleaned;
    private boolean m_undershootsExtended;
    private boolean m_duplicatedLinesCleaned;
    private boolean m_linesIntersected;
    private boolean m_adjacentEndpointsMerged;
    private double m_overshootsTolerance;
    private double m_undershootsTolerance;
    private double m_nodeTolerance;
    private Recordset m_filterVertexRecordset;
    private String m_arcFilterString;
    private ArcAndVertexFilterMode m_filterMode;

    public TopologyProcessingOptions() {
        this.m_pseudoNodesCleaned = false;
        this.m_overshootsCleaned = false;
        this.m_redundantVerticesCleaned = false;
        this.m_undershootsExtended = false;
        this.m_duplicatedLinesCleaned = false;
        this.m_linesIntersected = true;
        this.m_adjacentEndpointsMerged = false;
        this.m_overshootsTolerance = 0.0;
        this.m_undershootsTolerance = 0.0;
        this.m_nodeTolerance = 0.0;
        this.m_filterVertexRecordset = null;
        this.m_arcFilterString = "";
        this.m_filterMode = ArcAndVertexFilterMode.NONE;
    }

    public TopologyProcessingOptions(TopologyProcessingOptions topologyProcessingOptions) {
        this.m_pseudoNodesCleaned = topologyProcessingOptions.m_pseudoNodesCleaned;
        this.m_overshootsCleaned = topologyProcessingOptions.m_overshootsCleaned;
        this.m_redundantVerticesCleaned = topologyProcessingOptions.m_redundantVerticesCleaned;
        this.m_undershootsExtended = topologyProcessingOptions.m_undershootsExtended;
        this.m_duplicatedLinesCleaned = topologyProcessingOptions.m_duplicatedLinesCleaned;
        this.m_linesIntersected = topologyProcessingOptions.m_linesIntersected;
        this.m_adjacentEndpointsMerged = topologyProcessingOptions.m_adjacentEndpointsMerged;
        this.m_overshootsTolerance = topologyProcessingOptions.m_overshootsTolerance;
        this.m_undershootsTolerance = topologyProcessingOptions.m_undershootsTolerance;
        this.m_nodeTolerance = topologyProcessingOptions.m_nodeTolerance;
        this.m_filterVertexRecordset = topologyProcessingOptions.m_filterVertexRecordset;
        this.m_arcFilterString = topologyProcessingOptions.m_arcFilterString;
        this.m_filterMode = topologyProcessingOptions.m_filterMode;
    }

    public double getOvershootsTolerance() {
        return this.m_overshootsTolerance;
    }

    public void setOvershootsTolerance(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "TopologyProcessingOptions_OvershootsToleranceShouldGreaterThanZero", "topology_resources");
            throw new IllegalStateException(string);
        }
        this.m_overshootsTolerance = value;
    }

    public double getUndershootsTolerance() {
        return this.m_undershootsTolerance;
    }

    public void setUndershootsTolerance(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "TopologyProcessingOptions_UndershootsToleranceShouldGreaterThanZero", "topology_resources");
            throw new IllegalStateException(string);
        }
        this.m_undershootsTolerance = value;
    }

    public boolean arePseudoNodesCleaned() {
        return this.m_pseudoNodesCleaned;
    }

    public void setPseudoNodesCleaned(boolean value) {
        this.m_pseudoNodesCleaned = value;
    }

    public boolean areOvershootsCleaned() {
        return this.m_overshootsCleaned;
    }

    public void setOvershootsCleaned(boolean value) {
        this.m_overshootsCleaned = value;
    }

    public boolean areRedundantVerticesCleaned() {
        return this.m_redundantVerticesCleaned;
    }

    public void setRedundantVerticesCleaned(boolean value) {
        this.m_redundantVerticesCleaned = value;
    }

    public boolean areUndershootsExtended() {
        return this.m_undershootsExtended;
    }

    public void setUndershootsExtended(boolean value) {
        this.m_undershootsExtended = value;
    }

    public boolean areDuplicatedLinesCleaned() {
        return this.m_duplicatedLinesCleaned;
    }

    public void setDuplicatedLinesCleaned(boolean value) {
        this.m_duplicatedLinesCleaned = value;
    }

    public boolean areLinesIntersected() {
        return this.m_linesIntersected;
    }

    public void setLinesIntersected(boolean value) {
        this.m_linesIntersected = value;
    }

    public boolean areAdjacentEndpointsMerged() {
        return this.m_adjacentEndpointsMerged;
    }

    public void setAdjacentEndpointsMerged(boolean value) {
        this.m_adjacentEndpointsMerged = value;
    }

    public double getVertexTolerance() {
        return this.m_nodeTolerance;
    }

    public void setVertexTolerance(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "TopologyProcessingOptions_AdjacentEndpointsToleranceShouldGreaterThanZero", "topology_resources");
            throw new IllegalStateException(string);
        }
        this.m_nodeTolerance = value;
    }

    public Recordset getVertexFilterRecordset() {
        return this.m_filterVertexRecordset;
    }

    public void setVertexFilterRecordset(Recordset value) {
        this.m_filterVertexRecordset = value;
    }

    public String getArcFilterString() {
        return this.m_arcFilterString;
    }

    public void setArcFilterString(String value) {
        this.m_arcFilterString = value;
    }

    public ArcAndVertexFilterMode getFilterMode() {
        return this.m_filterMode;
    }

    public void setFilterMode(ArcAndVertexFilterMode value) {
        this.m_filterMode = value;
    }
}

