/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.topology;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Recordset;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.topology.InternalDatasetVector;
import com.supermap.data.topology.InternalDatasets;
import com.supermap.data.topology.InternalHandle;
import com.supermap.data.topology.InternalResource;
import com.supermap.data.topology.InternalToolkitTolopogy;
import com.supermap.data.topology.TopologyProcessingNative;
import com.supermap.data.topology.TopologyProcessingOptions;
import java.util.ArrayList;
import java.util.Vector;

public class TopologyProcessing {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private TopologyProcessing() {
    }

    public static DatasetVector buildRegions(DatasetVector sourceDataset, Datasource outputDatasource, String outputDatasetName) {
        TopologyProcessing.verifyLicense();
        if (sourceDataset == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        if (l == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getType() != DatasetType.LINE && sourceDataset.getType() != DatasetType.NETWORK && sourceDataset.getType() != DatasetType.LINE3D && sourceDataset.getType() != DatasetType.NETWORK3D) {
            String string = InternalResource.loadString("sourceDataset", "TopoloygProcessing_InavlidDatasetType", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l2 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = TopologyProcessingNative.jni_BuildRegions(l, l2, outputDatasetName);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector buildRegions(DatasetVector sourceDataset, Datasource outputDatasource, String outputDatasetName, TopologyProcessingOptions options) {
        if (options != null) {
            TopologyProcessing.clean(sourceDataset, options);
        }
        return TopologyProcessing.buildRegions(sourceDataset, outputDatasource, outputDatasetName);
    }

    public static boolean clean(DatasetVector datasetVector, TopologyProcessingOptions options) {
        TopologyProcessing.verifyLicense();
        if (datasetVector == null) {
            String string = InternalResource.loadString("datasetVector", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string = InternalResource.loadString("datasetVector", "Global_ArgumentObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.NETWORK && datasetVector.getType() != DatasetType.LINE3D && datasetVector.getType() != DatasetType.NETWORK3D) {
            String string = InternalResource.loadString("datasetVector", "TopoloygProcessing_InavlidDatasetType", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (options == null) {
            String string = InternalResource.loadString("options", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (options.getVertexFilterRecordset() != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)options.getVertexFilterRecordset());
        }
        boolean bl = TopologyProcessingNative.jni_Clean(l, options.arePseudoNodesCleaned(), options.areOvershootsCleaned(), options.areRedundantVerticesCleaned(), options.areUndershootsExtended(), options.areDuplicatedLinesCleaned(), options.areLinesIntersected(), options.areAdjacentEndpointsMerged(), options.getOvershootsTolerance(), options.getUndershootsTolerance(), options.getVertexTolerance(), l2, options.getArcFilterString(), options.getFilterMode().value());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)options.getVertexFilterRecordset());
        return bl;
    }

    public static boolean pickupLeftRightRegions(DatasetVector regionDataset, DatasetVector lineDataset, boolean preProcessed) {
        TopologyProcessing.verifyLicense();
        if (regionDataset == null) {
            String string = InternalResource.loadString("regionDataset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)regionDataset);
        if (l == 0L) {
            String string = InternalResource.loadString("regionDataset", "Global_ArgumentObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (lineDataset == null) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)lineDataset);
        if (l2 == 0L) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (lineDataset.getType() != DatasetType.LINE && regionDataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("regionDataset and lineDataset", "TopoloygProcessing_InavlidDatasetType", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = TopologyProcessingNative.jni_pickupLeftRightRegions(l, l2, preProcessed);
        return bl;
    }

    public static DatasetVector pickupBorder(DatasetVector sourceDataset, Datasource outputDatasource, String outputDatasetName, boolean preProcessed) {
        TopologyProcessing.verifyLicense();
        if (sourceDataset == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        if (l == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getType() != DatasetType.REGION && sourceDataset.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDataset", "TopoloygProcessing_InavlidDatasetType", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l2 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = TopologyProcessingNative.jni_pickupBorder(l, l2, outputDatasetName, preProcessed);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static boolean splitLinesByRegions(Recordset lineRecordset, Recordset regionRecordset) {
        TopologyProcessing.verifyLicense();
        if (lineRecordset == null) {
            String string = InternalResource.loadString("lineRecordset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)lineRecordset);
        if (l == 0L) {
            String string = InternalResource.loadString("lineRecordset", "Global_ArgumentObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (regionRecordset == null) {
            String string = InternalResource.loadString("regionRecordset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)regionRecordset);
        if (l2 == 0L) {
            String string = InternalResource.loadString("regionRecordset", "Global_ArgumentObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = TopologyProcessingNative.jni_splitLinesByRegions(l, l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)lineRecordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)regionRecordset);
        return bl;
    }

    public static DatasetVector pickupBorder(DatasetVector sourceDataset, Datasource outputDatasource, String outputDatasetName, int[] extractIDs, boolean preProcessed) {
        TopologyProcessing.verifyLicense();
        if (sourceDataset == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        if (l == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getType() != DatasetType.REGION && sourceDataset.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDataset", "TopoloygProcessing_InavlidDatasetType", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l2 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = TopologyProcessingNative.jni_pickupBorder1(l, l2, outputDatasetName, extractIDs, preProcessed);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "TopologyProcessing";
        boolean bl = InternalToolkitTolopogy.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        TopologyProcessing.fireStepped(steppedEvent);
        InternalToolkitTolopogy.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitTolopogy.managerProducts(InternalToolkitTolopogy.getTopologyProducts());
        m_license = InternalToolkitTolopogy.verifyLicense(arrayList);
    }
}

