/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.plot;

import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.plot.AnimationAttribute;
import com.supermap.plot.AnimationBlink;
import com.supermap.plot.AnimationDefine;
import com.supermap.plot.AnimationGO;
import com.supermap.plot.AnimationGroupNative;
import com.supermap.plot.AnimationGrow;
import com.supermap.plot.AnimationRotate;
import com.supermap.plot.AnimationScale;
import com.supermap.plot.AnimationShow;
import com.supermap.plot.AnimationWay;
import java.util.ArrayList;
import java.util.List;

public class AnimationGroup
extends InternalHandleDisposable {
    protected List<AnimationGO> m_arrAnimation = null;

    public AnimationGroup() {
        this.m_arrAnimation = new ArrayList<AnimationGO>();
    }

    public AnimationGroup(long handle) {
        this.setHandle(handle, false);
        this.m_arrAnimation = new ArrayList<AnimationGO>();
    }

    public void addAnimation(AnimationGO pAnimation) {
        if (pAnimation == null) {
            return;
        }
        long l = InternalHandle.getHandle((InternalHandle)pAnimation);
        AnimationGroupNative.jni_AddAnimation(this.getHandle(), l);
        this.m_arrAnimation.add(pAnimation);
    }

    public String getGroupName() {
        return AnimationGroupNative.jni_GetGroupName(this.getHandle());
    }

    public void setGroupName(String groupName) {
        AnimationGroupNative.jni_setGroupName(this.getHandle(), groupName);
    }

    public int getAnimationCount() {
        return AnimationGroupNative.jni_GetAnimationCount(this.getHandle());
    }

    public AnimationGO getAnimationByIndex(int index) {
        long l = AnimationGroupNative.jni_GetAnimationByIndex(this.getHandle(), index);
        if (l == 0L) {
            return null;
        }
        return this.newAnimationGO(l);
    }

    public AnimationGO[] getAllAnimationByGeometry(int geomtryID, String controlName, String layerName) {
        int n = AnimationGroupNative.jni_GetAnimationCountByGeometry(this.getHandle(), geomtryID, controlName, layerName);
        long[] lArray = new long[n];
        AnimationGroupNative.jni_GetAllAnimationByGeometry(this.getHandle(), geomtryID, controlName, layerName, lArray);
        AnimationGO[] animationGOArray = new AnimationGO[n];
        for (int i = 0; i < n; ++i) {
            animationGOArray[i] = 0L == lArray[i] ? null : this.newAnimationGO(lArray[i]);
        }
        return animationGOArray;
    }

    public AnimationGO[] GetAllAnimationByType(AnimationDefine.AnimationType type) {
        int n = AnimationGroupNative.jni_GetAnimationCountByType(this.getHandle(), type.value());
        long[] lArray = new long[n];
        AnimationGroupNative.jni_GetAllAnimationByType(this.getHandle(), type.value(), lArray);
        AnimationGO[] animationGOArray = new AnimationGO[n];
        for (int i = 0; i < n; ++i) {
            animationGOArray[i] = 0L == lArray[i] ? null : this.newAnimationGO(lArray[i]);
        }
        return animationGOArray;
    }

    public List<AnimationGO> getAllAnimation() {
        for (int i = 0; i < this.m_arrAnimation.size(); ++i) {
            AnimationGO animationGO = this.m_arrAnimation.get(i);
            long l = AnimationGroupNative.jni_GetAnimationByName(this.getHandle(), animationGO.getName());
            if (l != 0L) continue;
            this.m_arrAnimation.remove(i);
            --i;
        }
        return this.m_arrAnimation;
    }

    public boolean removeAnimation(String animationName) {
        for (int i = 0; i < this.m_arrAnimation.size(); ++i) {
            AnimationGO animationGO = this.m_arrAnimation.get(i);
            if (!animationGO.getName().equals(animationName)) continue;
            this.m_arrAnimation.remove(i);
            break;
        }
        return AnimationGroupNative.jni_RemoveAnimation(this.getHandle(), animationName);
    }

    public void removeAllAnimations() {
        this.m_arrAnimation.clear();
        AnimationGroupNative.jni_RemoveAllAnimations(this.getHandle());
    }

    public boolean RemoveAllAnimationByGeometry(int geometryId, String controlName, String layerName) {
        for (int i = 0; i < this.m_arrAnimation.size(); ++i) {
            AnimationGO animationGO = this.m_arrAnimation.get(i);
            if (geometryId != animationGO.getGeometryID() || !animationGO.getName().equals(controlName) || !animationGO.getLayerName().equals(layerName)) continue;
            this.m_arrAnimation.remove(i);
        }
        return AnimationGroupNative.jni_RemoveAllAnimationByGeometry(this.getHandle(), geometryId, controlName, layerName);
    }

    public boolean deleteAnimation(String animationName) {
        for (int i = 0; i < this.m_arrAnimation.size(); ++i) {
            AnimationGO animationGO = this.m_arrAnimation.get(i);
            if (!animationGO.getName().equals(animationName)) continue;
            this.m_arrAnimation.remove(i);
            break;
        }
        return AnimationGroupNative.jni_DeleteAnimation(this.getHandle(), animationName);
    }

    public void deleteAllAnimations() {
        this.m_arrAnimation.clear();
        AnimationGroupNative.jni_DeleteAllAnimations(this.getHandle());
    }

    public void setStartTime(double time) {
        AnimationGroupNative.jni_SetStartTime(this.getHandle(), time);
    }

    public double getStartTime() {
        return AnimationGroupNative.jni_GetStartTime(this.getHandle());
    }

    public double getDuration() {
        return AnimationGroupNative.jni_GetDuration(this.getHandle());
    }

    public AnimationDefine.AnimationGroupPlayState GetAnimationGroupPlayState() {
        int n = AnimationGroupNative.jni_GetAnimationGroupPlayState(this.getHandle());
        return new AnimationDefine.AnimationGroupPlayState(n, n);
    }

    public AnimationGO GetAnimationByName(String AnimatinoName) {
        long l = AnimationGroupNative.jni_GetAnimationByName(this.getHandle(), AnimatinoName);
        if (l == 0L) {
            return null;
        }
        return this.newAnimationGO(l);
    }

    public void dispose() {
    }

    private AnimationGO newAnimationGO(long handle) {
        AnimationGO animationGO = new AnimationGO(handle);
        AnimationDefine.AnimationType animationType = animationGO.getAnimationType();
        AnimationGO animationGO2 = null;
        if (animationType.equals((Object)AnimationDefine.AnimationType.WayAnimation)) {
            animationGO2 = new AnimationWay(handle);
        } else if (animationType.equals((Object)AnimationDefine.AnimationType.BlinkAnimation)) {
            animationGO2 = new AnimationBlink(handle);
        } else if (animationType.equals((Object)AnimationDefine.AnimationType.AttribAnimation)) {
            animationGO2 = new AnimationAttribute(handle);
        } else if (animationType.equals((Object)AnimationDefine.AnimationType.ShowAnimation)) {
            animationGO2 = new AnimationShow(handle);
        } else if (animationType.equals((Object)AnimationDefine.AnimationType.RotateAnimation)) {
            animationGO2 = new AnimationRotate(handle);
        } else if (animationType.equals((Object)AnimationDefine.AnimationType.ScaleAnimation)) {
            animationGO2 = new AnimationScale(handle);
        } else if (animationType.equals((Object)AnimationDefine.AnimationType.GrowAnimation)) {
            animationGO2 = new AnimationGrow(handle);
        }
        return animationGO2;
    }

    public AnimationGO[] getAllAnimationByUUID(String UuID) {
        int n = this.m_arrAnimation.size();
        long[] lArray = new long[n];
        AnimationGroupNative.jni_GetAllAnimationByUUID(this.getHandle(), UuID, lArray);
        AnimationGO[] animationGOArray = new AnimationGO[n];
        for (int i = 0; i < n; ++i) {
            animationGOArray[i] = 0L == lArray[i] ? null : this.newAnimationGO(lArray[i]);
        }
        return animationGOArray;
    }

    public boolean removeAllAnimationByUUID(String UuID) {
        for (int i = 0; i < this.m_arrAnimation.size(); ++i) {
            AnimationGO animationGO = this.m_arrAnimation.get(i);
            if (!animationGO.getGeometryUuID().equals(UuID)) continue;
            this.m_arrAnimation.remove(i);
        }
        return AnimationGroupNative.jni_RemoveAllAnimationByUUID(this.getHandle(), UuID);
    }

    public boolean deleteAllAnimationByUUID(String UuID) {
        for (int i = 0; i < this.m_arrAnimation.size(); ++i) {
            AnimationGO animationGO = this.m_arrAnimation.get(i);
            if (!animationGO.getGeometryUuID().equals(UuID)) continue;
            this.m_arrAnimation.remove(i);
        }
        return AnimationGroupNative.jni_DeleteAllAnimationByUUID(this.getHandle(), UuID);
    }
}

