/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.CellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.InternalResource;
import java.util.ArrayList;
import java.util.Map;

public class PCACellularAutomataParameter {
    private ArrayList<Double> m_arrComponentWeight;
    private double m_dK;
    private int m_nAlpha;
    private Map<Integer, Boolean> m_arrConversionRule;
    private int m_dConversionTarget;
    CellularAutomataParameter m_CellularAutomataParameter;

    public PCACellularAutomataParameter() {
        this.m_arrComponentWeight = null;
        this.m_dK = 4.0;
        this.m_nAlpha = 2;
        this.m_arrConversionRule = null;
        this.m_CellularAutomataParameter = null;
    }

    public PCACellularAutomataParameter(PCACellularAutomataParameter para) {
        this.m_arrComponentWeight = para.m_arrComponentWeight;
        this.m_dK = para.m_dK;
        this.m_nAlpha = para.m_nAlpha;
        this.m_arrConversionRule = para.m_arrConversionRule;
        this.m_dConversionTarget = para.m_dConversionTarget;
        if (this.m_CellularAutomataParameter == null) {
            this.m_CellularAutomataParameter = new CellularAutomataParameter();
        }
        this.m_CellularAutomataParameter.Reset(para.m_CellularAutomataParameter);
    }

    public CellularAutomataParameter getCellularAutomataParameter() {
        return this.m_CellularAutomataParameter;
    }

    public void setCellularAutomataParameter(CellularAutomataParameter value) {
        if (value == null) {
            String string = InternalResource.loadString("CellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_CellularAutomataParameter == null) {
            this.m_CellularAutomataParameter = new CellularAutomataParameter();
        }
        this.m_CellularAutomataParameter.Reset(value);
    }

    public double[] getComponentWeights() {
        if (this.m_arrComponentWeight == null) {
            return null;
        }
        int n = this.m_arrComponentWeight.size();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.m_arrComponentWeight.get(i);
        }
        return dArray;
    }

    public void setComponentWeights(double[] value) {
        int n;
        if (value == null) {
            String string = InternalResource.loadString("ComponentWeights", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = value.length;
        for (n = 0; n < n2; ++n) {
            if (!(value[n] <= 0.0) && !(value[n] > 1.0)) continue;
            String string = InternalResource.loadString("value[" + n + "]", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_arrComponentWeight != null) {
            this.m_arrComponentWeight.clear();
        } else {
            this.m_arrComponentWeight = new ArrayList();
        }
        for (n = 0; n < n2; ++n) {
            this.m_arrComponentWeight.add(value[n]);
        }
    }

    public double getIndexK() {
        return this.m_dK;
    }

    public void setIndexK(double value) {
        if (value <= 0.0 || value >= 100.0) {
            String string = InternalResource.loadString("IndexK", "ShouldBetweenZeroAndHundred", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dK = value;
    }

    public int getAlpha() {
        return this.m_nAlpha;
    }

    public void setAlpha(int value) {
        if (value <= 0 || value > 10) {
            String string = InternalResource.loadString("Alpha", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nAlpha = value;
    }

    public Map<Integer, Boolean> getConversionRules() {
        return this.m_arrConversionRule;
    }

    public void setConversionRules(Map<Integer, Boolean> value) {
        if (value == null || value.size() == 0) {
            String string = InternalResource.loadString("ConversionRules", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (Integer n : value.keySet()) {
            if (n != null && value.get(n) != null) continue;
            String string = InternalResource.loadString("ConversionRules key or value", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_arrConversionRule = value;
    }

    public int getConversionTarget() {
        return this.m_dConversionTarget;
    }

    public void setConversionTarget(int value) {
        this.m_dConversionTarget = value;
    }
}

