/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.DensityAnalystNative;
import com.supermap.analyst.spatialanalyst.DensityAnalystParameter;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.NeighbourShape;
import com.supermap.analyst.spatialanalyst.NeighbourShapeAnnulus;
import com.supermap.analyst.spatialanalyst.NeighbourShapeCircle;
import com.supermap.analyst.spatialanalyst.NeighbourShapeRectangle;
import com.supermap.analyst.spatialanalyst.NeighbourShapeWedge;
import com.supermap.analyst.spatialanalyst.NeighbourUnitType;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.FieldType;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Toolkit;
import java.util.ArrayList;
import java.util.Vector;

public class DensityAnalyst {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private DensityAnalyst() {
    }

    public static DatasetGrid kernelDensity(DensityAnalystParameter parameter, DatasetVector sourceDataset, String valueFieldName, Datasource targetDatasource, String targetDatasetName) {
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        Recordset recordset = sourceDataset.getRecordset(false, CursorType.STATIC);
        DatasetGrid datasetGrid = DensityAnalyst.kernelDensity(parameter, recordset, valueFieldName, targetDatasource, targetDatasetName);
        recordset.dispose();
        return datasetGrid;
    }

    private static DatasetGrid kernelDensity(DensityAnalystParameter parameter, Recordset sourceRecordset, String valueFieldName, Datasource targetDatasource, String targetDatasetName) {
        String string;
        DensityAnalyst.verifyLicense();
        if (sourceRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset) == 0L) {
            String string2 = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        DatasetVector datasetVector = sourceRecordset.getDataset();
        if (valueFieldName != null && !valueFieldName.isEmpty()) {
            if (sourceRecordset.getFieldInfos().indexOf(valueFieldName) == -1) {
                String string3 = InternalResource.loadString("valueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string3);
            }
            string = sourceRecordset.getFieldInfos().get(valueFieldName);
            if (string == null || string.getType() != FieldType.DOUBLE && string.getType() != FieldType.INT16 && string.getType() != FieldType.INT32 && string.getType() != FieldType.INT64 && string.getType() != FieldType.SINGLE) {
                String string4 = InternalResource.loadString("valueFieldName", "InterPolator_UnsupportedFieldType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string4);
            }
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasetName == null) {
            string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = parameter.getBounds().isEmpty();
        if (bl) {
            parameter.setBounds(datasetVector.getBounds());
        }
        boolean bl2 = false;
        double d = parameter.getResolution();
        if (Toolkit.isZero((double)parameter.getResolution()) || parameter.getResolution() < 0.0) {
            bl2 = true;
            double d2 = Math.min(parameter.getBounds().getHeight(), parameter.getBounds().getWidth());
            parameter.setResolution(d2 / 500.0);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l4 = DensityAnalystNative.jni_KernelDensity(l, l2, valueFieldName, l3, targetDatasetName);
        if (bl) {
            parameter.setBounds(Rectangle2D.getEMPTY());
        }
        if (bl2) {
            parameter.setResolution(d);
        }
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRecordset);
        return datasetGrid;
    }

    public static DatasetGrid pointDensity(DensityAnalystParameter parameter, DatasetVector sourceDataset, String valueFieldName, Datasource targetDatasource, String targetDatasetName) {
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        Recordset recordset = sourceDataset.getRecordset(false, CursorType.STATIC);
        DatasetGrid datasetGrid = DensityAnalyst.pointDensity(parameter, recordset, valueFieldName, targetDatasource, targetDatasetName);
        recordset.dispose();
        return datasetGrid;
    }

    private static DatasetGrid pointDensity(DensityAnalystParameter parameter, Recordset sourceRecordset, String valueFieldName, Datasource targetDatasource, String targetDatasetName) {
        String string;
        DensityAnalyst.verifyLicense();
        if (parameter == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter) == 0L) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (parameter.getSearchNeighbourhood() == null) {
            String string3 = InternalResource.loadString("parameter.SearchNeighbourhood", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (sourceRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset) == 0L) {
            String string4 = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        DatasetVector datasetVector = sourceRecordset.getDataset();
        if (valueFieldName != null && !valueFieldName.isEmpty()) {
            if (sourceRecordset.getFieldInfos().indexOf(valueFieldName) == -1) {
                String string5 = InternalResource.loadString("valueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            string = sourceRecordset.getFieldInfos().get(valueFieldName);
            if (string == null || string.getType() != FieldType.DOUBLE && string.getType() != FieldType.INT16 && string.getType() != FieldType.INT32 && string.getType() != FieldType.INT64 && string.getType() != FieldType.SINGLE) {
                String string6 = InternalResource.loadString("valueFieldName", "InterPolator_UnsupportedFieldType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasetName == null) {
            string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = parameter.getBounds().isEmpty();
        if (bl) {
            parameter.setBounds(datasetVector.getBounds());
        }
        boolean bl2 = false;
        double d = parameter.getResolution();
        double d2 = Math.min(parameter.getBounds().getHeight(), parameter.getBounds().getWidth());
        if (Toolkit.isZero((double)parameter.getResolution()) || parameter.getResolution() < 0.0) {
            bl2 = true;
            parameter.setResolution(d2 / 500.0);
        }
        int n = (int)(d2 / parameter.getResolution());
        int n2 = InternalEnum.getUGCValue(parameter.getSearchNeighbourhood().getShapeType());
        switch (n2) {
            case 1: {
                NeighbourShape neighbourShape = (NeighbourShapeRectangle)parameter.getSearchNeighbourhood();
                if (neighbourShape.getUnitType() == NeighbourUnitType.CELL) {
                    if (!(((NeighbourShapeRectangle)neighbourShape).getHeight() > (double)(n / 2)) && !(((NeighbourShapeRectangle)neighbourShape).getWidth() > (double)(n / 2))) break;
                    String string7 = InternalResource.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string7);
                }
                if (!(((NeighbourShapeRectangle)neighbourShape).getHeight() > d2 / 2.0) && !(((NeighbourShapeRectangle)neighbourShape).getWidth() > d2 / 2.0)) break;
                String string8 = InternalResource.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                throw new IllegalArgumentException(string8);
            }
            case 2: {
                NeighbourShape neighbourShape = (NeighbourShapeCircle)parameter.getSearchNeighbourhood();
                if (neighbourShape.getUnitType() == NeighbourUnitType.CELL) {
                    if (!(((NeighbourShapeCircle)neighbourShape).getRadius() > (double)(n / 2))) break;
                    String string9 = InternalResource.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string9);
                }
                if (!(((NeighbourShapeCircle)neighbourShape).getRadius() > d2 / 2.0)) break;
                String string10 = InternalResource.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                throw new IllegalArgumentException(string10);
            }
            case 3: {
                NeighbourShape neighbourShape = (NeighbourShapeAnnulus)parameter.getSearchNeighbourhood();
                if (neighbourShape.getUnitType() == NeighbourUnitType.CELL) {
                    if (!(((NeighbourShapeAnnulus)neighbourShape).getInnerRadius() > (double)(n / 2)) && !(((NeighbourShapeAnnulus)neighbourShape).getOuterRadius() > (double)(n / 2))) break;
                    String string11 = InternalResource.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string11);
                }
                if (!(((NeighbourShapeAnnulus)neighbourShape).getInnerRadius() > d2 / 2.0) && !(((NeighbourShapeAnnulus)neighbourShape).getOuterRadius() > d2 / 2.0)) break;
                String string12 = InternalResource.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                throw new IllegalArgumentException(string12);
            }
            case 4: {
                NeighbourShape neighbourShape = (NeighbourShapeWedge)parameter.getSearchNeighbourhood();
                if (neighbourShape.getUnitType() == NeighbourUnitType.CELL) {
                    if (!(((NeighbourShapeWedge)neighbourShape).getRadius() > (double)(n / 2))) break;
                    String string13 = InternalResource.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string13);
                }
                if (!(((NeighbourShapeWedge)neighbourShape).getRadius() > d2 / 2.0)) break;
                String string14 = InternalResource.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                throw new IllegalArgumentException(string14);
            }
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l4 = DensityAnalystNative.jni_PointDensity(l, l2, valueFieldName, l3, targetDatasetName);
        if (bl) {
            parameter.setBounds(Rectangle2D.getEMPTY());
        }
        if (bl2) {
            parameter.setResolution(d);
        }
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRecordset);
        return datasetGrid;
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "Interpolate";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        DensityAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

