/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.BoundsType;
import com.supermap.analyst.spatialanalyst.ConversionAnalystNative;
import com.supermap.analyst.spatialanalyst.ConversionAnalystParameter;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetImage;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalGeometry;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PixelFormat;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class ConversionAnalyst {
    private static transient Vector m_steppedListeners;
    private static License m_license;
    private static GridAnalystSetting m_gridAnalystSetting;

    private ConversionAnalyst() {
        m_gridAnalystSetting = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return m_gridAnalystSetting;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            m_gridAnalystSetting = null;
            return;
        }
        if (m_gridAnalystSetting == null) {
            m_gridAnalystSetting = new GridAnalystSetting();
        }
        m_gridAnalystSetting.setBounds(gridAnalystSetting.getBounds());
        m_gridAnalystSetting.setBoundsType(gridAnalystSetting.getBoundsType());
        m_gridAnalystSetting.setCellSizeType(gridAnalystSetting.getCellSizeType());
        m_gridAnalystSetting.setCellSize(gridAnalystSetting.getCellSize());
        m_gridAnalystSetting.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        m_gridAnalystSetting.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        m_gridAnalystSetting.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        m_gridAnalystSetting.setValidRegion(gridAnalystSetting.getValidRegion());
        m_gridAnalystSetting.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static DatasetGrid vectorToRaster(ConversionAnalystParameter parameter) {
        String string;
        ConversionAnalyst.verifyLicense();
        if (parameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        Dataset dataset = parameter.getSourceDataset();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string3 = InternalResource.loadString("srcDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.LINE && dataset.getType() != DatasetType.REGION) {
            String string4 = InternalResource.loadString("srcDataset DatasetType", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        Datasource datasource = parameter.getTargetDatasource();
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : dataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string5 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        String string6 = parameter.getTargetDatasetName();
        if (null == string6) {
            String string7 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            string6 = m_gridAnalystSetting.getGridOutputNamePrefix() + string6;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string6)) {
            String string8 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        double d = parameter.getCellSize();
        boolean bl = false;
        Rectangle2D rectangle2D = new Rectangle2D(0.0, 0.0, 0.0, 0.0);
        int n = BoundsType.INTERSECTION.value();
        if (null != m_gridAnalystSetting) {
            bl = m_gridAnalystSetting.isShowProgress();
            n = m_gridAnalystSetting.getBoundsType().value();
            rectangle2D = m_gridAnalystSetting.getBounds();
            if (d <= 0.0) {
                d = m_gridAnalystSetting.getCellSize();
            }
        }
        if (null == (string = parameter.getValueFieldName()) || string.isEmpty()) {
            String string9 = InternalResource.loadString("ValueFieldName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = 0L;
        GeoRegion geoRegion = parameter.getClipRegion();
        if (geoRegion != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        } else if (m_gridAnalystSetting != null && m_gridAnalystSetting.getValidRegion() != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_gridAnalystSetting.getValidRegion());
        }
        PixelFormat pixelFormat = parameter.getPixelFormat();
        int n2 = InternalEnum.getUGCValue((Enum)pixelFormat);
        double d2 = parameter.getNoValue();
        long l4 = ConversionAnalystNative.jni_VectorToRaster(l, string, d, n2, d2, l3, l2, string6, bl, n, rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)parameter);
        return datasetGrid;
    }

    public static DatasetVector rasterToVector(ConversionAnalystParameter parameter) {
        String string;
        ConversionAnalyst.verifyLicense();
        if (parameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (parameter.getSourceDataset() == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getSourceDataset()) == 0L) {
            String string3 = InternalResource.loadString("getSourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (parameter.getSourceDataset().getType() != DatasetType.IMAGE && parameter.getSourceDataset().getType() != DatasetType.GRID) {
            String string4 = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        Datasource datasource = parameter.getTargetDatasource();
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : parameter.getSourceDataset().getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string5 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        String string6 = parameter.getTargetDatasetName();
        if (null == string6) {
            String string7 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getVectorOutputNamePrefix()) {
            string6 = m_gridAnalystSetting.getVectorOutputNamePrefix() + string6;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string6)) {
            String string8 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        boolean bl = false;
        if (null != m_gridAnalystSetting) {
            bl = m_gridAnalystSetting.isShowProgress();
        }
        if ((string = parameter.getValueFieldName()) == null || string.length() == 0) {
            String string9 = InternalResource.loadString("valueField", "StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        if (string != null && ConversionAnalyst.isSystemFieldName(string)) {
            String string10 = InternalResource.loadString("valueField", "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new UnsupportedOperationException(string10);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getSourceDataset());
        long l2 = 0L;
        if (parameter.getClipRegion() != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getClipRegion());
        } else if (m_gridAnalystSetting != null && m_gridAnalystSetting.getValidRegion() != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_gridAnalystSetting.getValidRegion());
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        int n = InternalEnum.getUGCValue((Enum)parameter.getTargetDatasetType());
        long l4 = parameter.getSpecifiedValue();
        double d = parameter.getSpecifiedValueTolerance();
        long l5 = parameter.getBackOrNoValue();
        double d2 = parameter.getBackOrNoValueTolerance();
        int n2 = InternalEnum.getUGCValue(parameter.getSmoothMethod());
        int n3 = parameter.getSmoothDegree();
        boolean bl2 = parameter.isThinRaster();
        long l6 = ConversionAnalystNative.jni_RasterToVector(l, n, string, l4, d, l2, l5, d2, bl2, n2, n3, l3, string6, bl);
        DatasetVector datasetVector = null;
        if (l6 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l6, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)parameter);
        return datasetVector;
    }

    public static GeoRegion extractRegion(Dataset sourceDataset, GeoLine geoLineIn, GeoLine geoLineOut, int lineWidth, int boundWidth) {
        long l;
        long l2;
        ConversionAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceDataset.getType() != DatasetType.IMAGE && sourceDataset.getType() != DatasetType.GRID) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoLineIn == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLineIn) == 0L) {
            String string = InternalResource.loadString("geoLineIn", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (geoLineOut == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLineOut) == 0L) {
            String string = InternalResource.loadString("geoLineOut", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (lineWidth < 1) {
            String string = InternalResource.loadString("lineWidth", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (boundWidth < 1) {
            String string = InternalResource.loadString("boundWidth", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRegion geoRegion = null;
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l4 = ConversionAnalystNative.jni_ExtractRegion(l3, l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLineIn), l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLineOut), lineWidth, boundWidth);
        if (l4 != 0L) {
            geoRegion = (GeoRegion)InternalGeometry.createInstance(l4);
        }
        return geoRegion;
    }

    public static Dataset thinRaster(Dataset sourceDataset, long backOrNoValue, double backOrNoDataTolerance, Datasource targetDatasource, String targetDatasetName) {
        ConversionAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceDataset.getType() != DatasetType.IMAGE && sourceDataset.getType() != DatasetType.GRID) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (null != m_gridAnalystSetting) {
            bl = m_gridAnalystSetting.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l3 = ConversionAnalystNative.jni_ThinRaster(l2, backOrNoValue, backOrNoDataTolerance, l, targetDatasetName, bl);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            DatasetType datasetType = sourceDataset.getType();
            if (datasetType == DatasetType.GRID) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            } else if (datasetType == DatasetType.IMAGE) {
                datasetGrid = InternalDatasetImage.createInstance(l3, targetDatasource);
            } else {
                return null;
            }
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static Dataset thinRaster(Dataset sourceDataset, Datasource targetDatasource, String targetDatasetName, long backOrNoValue, boolean isSaveAsGrid) {
        ConversionAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceDataset.getType() != DatasetType.IMAGE && sourceDataset.getType() != DatasetType.GRID) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l3 = ConversionAnalystNative.jni_ThinRasterBinary(l2, l, targetDatasetName, backOrNoValue, isSaveAsGrid);
        Object object = null;
        if (l3 != 0L) {
            DatasetType datasetType = sourceDataset.getType();
            if (datasetType == DatasetType.GRID) {
                object = InternalDatasetGrid.createInstance(l3, targetDatasource);
            } else if (datasetType == DatasetType.IMAGE) {
                object = isSaveAsGrid ? InternalDatasetGrid.createInstance(l3, targetDatasource) : InternalDatasetImage.createInstance(l3, targetDatasource);
            } else {
                return null;
            }
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)object);
        }
        return object;
    }

    public static GeoRegion3D rasterBoundaryRegion(Dataset sourceDataset) {
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ConversionAnalystNative.jni_RasterBoundaryRegion3D(InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset));
        GeoRegion3D geoRegion3D = null;
        if (l != 0L) {
            geoRegion3D = (GeoRegion3D)InternalGeometry.createInstance(l);
        }
        return geoRegion3D;
    }

    public static GeoLine3D rasterBoundaryLine(Dataset sourceDataset) {
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ConversionAnalystNative.jni_RasterBoundaryLine3D(InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset));
        GeoLine3D geoLine3D = null;
        if (l != 0L) {
            geoLine3D = (GeoLine3D)InternalGeometry.createInstance(l);
        }
        return geoLine3D;
    }

    private static boolean isSystemFieldName(String fieldName) {
        String string = fieldName;
        int n = string.indexOf(".");
        if (n > 0) {
            string = string.substring(n, string.length() - n - 1);
        }
        if (string.substring(0, 2).compareToIgnoreCase("Sm") == 0) {
            if (string.compareToIgnoreCase("SmUserID") == 0) {
                return false;
            }
            if (string.compareToIgnoreCase("SmID") == 0 || string.compareToIgnoreCase("SmSdriN") == 0 || string.compareToIgnoreCase("SmSdriS") == 0 || string.compareToIgnoreCase("SmSdriW") == 0 || string.compareToIgnoreCase("SmSdriE") == 0 || string.compareToIgnoreCase("SmGeometry") == 0 || string.compareToIgnoreCase("SmX") == 0 || string.compareToIgnoreCase("SmY") == 0 || string.compareToIgnoreCase("SmZ") == 0 || string.compareToIgnoreCase("SmKey") == 0 || string.compareToIgnoreCase("SmGranule") == 0 || string.compareToIgnoreCase("SmLength") == 0 || string.compareToIgnoreCase("SmArea") == 0 || string.compareToIgnoreCase("SmPerimeter") == 0 || string.compareToIgnoreCase("SmLibTileID") == 0 || string.compareToIgnoreCase("SmEdgeID") == 0 || string.compareToIgnoreCase("SmFNode") == 0 || string.compareToIgnoreCase("SmTNode") == 0 || string.compareToIgnoreCase("SmResistanceA") == 0 || string.compareToIgnoreCase("SmResistanceB") == 0 || string.compareToIgnoreCase("SmTopoError") == 0 || string.compareToIgnoreCase("SmNodeID") == 0 || string.compareToIgnoreCase("SmGeoType") == 0 || string.compareToIgnoreCase("SmRouteID") == 0 || string.compareToIgnoreCase("SMMAXMEASURE") == 0 || string.compareToIgnoreCase("SMMINMEASURE") == 0 || string.compareToIgnoreCase("SmGeometrySize") == 0 || string.compareToIgnoreCase("SmVertexSeq") == 0) {
                return true;
            }
        }
        return false;
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "ConversionAnalyst";
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        ConversionAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

