/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.BufferAnalystNative;
import com.supermap.analyst.spatialanalyst.BufferAnalystParameter;
import com.supermap.analyst.spatialanalyst.BufferEndType;
import com.supermap.analyst.spatialanalyst.BufferRadiusUnit;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Recordset;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Toolkit;
import java.util.ArrayList;
import java.util.Vector;

public class BufferAnalyst {
    private static transient Vector<SteppedListener> m_steppedListeners;
    private static License m_license;

    private BufferAnalyst() {
    }

    public static boolean createBuffer(DatasetVector sourceDataset, DatasetVector resultDataset, BufferAnalystParameter bufferAnalystParameter, boolean isUnion, boolean isAttributeRetained) {
        int n;
        BufferAnalyst.verifyLicense();
        BufferEndType bufferEndType = bufferAnalystParameter.getEndType();
        BufferRadiusUnit bufferRadiusUnit = bufferAnalystParameter.getRadiusUnit();
        int n2 = bufferAnalystParameter.getSemicircleLineSegment();
        Object object = bufferAnalystParameter.getLeftDistance();
        Object object2 = bufferAnalystParameter.getRightDistance();
        String string = null;
        String string2 = null;
        double d = 0.0;
        double d2 = 0.0;
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string3 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string4 = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        DatasetType datasetType = resultDataset.getType();
        if (datasetType != DatasetType.REGION) {
            String string5 = InternalResource.loadString("", "BufferAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        int n3 = -1;
        boolean bl = false;
        DatasetType datasetType2 = sourceDataset.getType();
        if (bufferEndType.equals((Object)BufferEndType.FLAT)) {
            if (object == null && object2 == null) {
                String string6 = InternalResource.loadString("objLeftDistance and objRightDistance", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string6);
            }
            if (isUnion) {
                isAttributeRetained = false;
            }
            if (datasetType2 != DatasetType.LINE && datasetType2 != DatasetType.NETWORK) {
                String string7 = InternalResource.loadString("", "BufferAnalyst_BufferDatasetTypeInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string7);
            }
            if (object != null && object2 != null && object instanceof String ^ object2 instanceof String) {
                String string8 = InternalResource.loadString("", "BufferAnalyst_LeftDistenceAndRightDistanceMustBeTheSameType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string8);
            }
            if (object2 == null) {
                if (object instanceof String) {
                    string = (String)object;
                    if (string == null || string.trim().length() == 0) {
                        String string9 = InternalResource.loadString("LeftDistance", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string9);
                    }
                } else {
                    d = InternalToolkitSpatialAnalyst.objectToDouble(object);
                    if (d <= 0.0) {
                        String string10 = InternalResource.loadString("leftDistance", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string10);
                    }
                }
                n3 = InternalToolkitSpatialAnalyst.BufferSideType.LEFT.value();
            }
            if (object == null) {
                if (object2 instanceof String) {
                    string2 = (String)object2;
                    if (string2 == null || string2.trim().length() == 0) {
                        String string11 = InternalResource.loadString("LeftDistance", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string11);
                    }
                } else {
                    d2 = InternalToolkitSpatialAnalyst.objectToDouble(object2);
                    if (d2 <= 0.0) {
                        String string12 = InternalResource.loadString("rightDistance", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string12);
                    }
                }
                n3 = InternalToolkitSpatialAnalyst.BufferSideType.RIGHT.value();
            }
            if (object != null && object2 != null) {
                if (object instanceof String) {
                    string = (String)object;
                    if (string == null || string.trim().length() == 0) {
                        String string13 = InternalResource.loadString("LeftDistance", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string13);
                    }
                    string2 = (String)object2;
                    if (string2 == null || string2.trim().length() == 0) {
                        String string14 = InternalResource.loadString("RightDistance", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string14);
                    }
                    n3 = string.equals(string2) ? InternalToolkitSpatialAnalyst.BufferSideType.FULL.value() : InternalToolkitSpatialAnalyst.BufferSideType.FULLDIFFR.value();
                } else {
                    d = InternalToolkitSpatialAnalyst.objectToDouble(object);
                    if (d <= 0.0) {
                        String string15 = InternalResource.loadString("leftDistance", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string15);
                    }
                    d2 = InternalToolkitSpatialAnalyst.objectToDouble(object2);
                    if (d2 <= 0.0) {
                        String string16 = InternalResource.loadString("rightDistance", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string16);
                    }
                    n3 = d == d2 ? InternalToolkitSpatialAnalyst.BufferSideType.FULL.value() : InternalToolkitSpatialAnalyst.BufferSideType.FULLDIFFR.value();
                }
            }
            n = BufferEndType.FLAT.value();
            bl = string != null || string2 != null ? BufferAnalystNative.jni_CreateLineDatasetBuffer2(l, 0L, l2, string, string2, bufferRadiusUnit.value(), n2, n3, n, isUnion, isAttributeRetained) : BufferAnalystNative.jni_CreateLineDatasetBuffer(l, 0L, l2, d, d2, bufferRadiusUnit.value(), n2, n3, n, isUnion, isAttributeRetained);
        }
        if (bufferEndType.equals((Object)BufferEndType.ROUND)) {
            if (object == null) {
                String string17 = InternalResource.loadString("objLeftDistance", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string17);
            }
            if (isUnion) {
                isAttributeRetained = false;
            }
            if (datasetType2 != DatasetType.LINE && datasetType2 != DatasetType.NETWORK && datasetType2 != DatasetType.POINT && datasetType2 != DatasetType.REGION) {
                String string18 = InternalResource.loadString("", "BufferAnalyst_BufferDatasetTypeInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string18);
            }
            if (object instanceof String) {
                string = (String)object;
                if (string == null || string.trim().length() == 0) {
                    String string19 = InternalResource.loadString("LeftDistance", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string19);
                }
            } else {
                d = InternalToolkitSpatialAnalyst.objectToDouble(object);
                if (!datasetType2.equals((Object)DatasetType.REGION) && d <= 0.0) {
                    String string20 = InternalResource.loadString("", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string20);
                }
                if (datasetType2.equals((Object)DatasetType.REGION) && Toolkit.isZero((double)d)) {
                    String string21 = InternalResource.loadString("", "BufferAnalyst_BufferDistanceShouldNotBeZero", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string21);
                }
            }
            if (datasetType2.equals((Object)DatasetType.LINE) || datasetType2.equals((Object)DatasetType.NETWORK)) {
                n3 = InternalToolkitSpatialAnalyst.BufferSideType.FULL.value();
            }
            n = BufferEndType.ROUND.value();
            bl = string != null ? BufferAnalystNative.jni_CreateDatasetBuffer2(l, 0L, l2, string, bufferRadiusUnit.value(), n2, n3, n, isUnion, isAttributeRetained) : BufferAnalystNative.jni_CreateDatasetBuffer(l, 0L, l2, d, bufferRadiusUnit.value(), n2, n3, n, isUnion, isAttributeRetained);
        }
        return bl;
    }

    public static boolean createBuffer(Recordset sourceRecordset, DatasetVector resultDataset, BufferAnalystParameter bufferAnalystParameter, boolean isUnion, boolean isAttributeRetained) {
        int n;
        BufferAnalyst.verifyLicense();
        BufferEndType bufferEndType = bufferAnalystParameter.getEndType();
        BufferRadiusUnit bufferRadiusUnit = bufferAnalystParameter.getRadiusUnit();
        int n2 = bufferAnalystParameter.getSemicircleLineSegment();
        Object object = bufferAnalystParameter.getLeftDistance();
        Object object2 = bufferAnalystParameter.getRightDistance();
        String string = null;
        String string2 = null;
        double d = 0.0;
        double d2 = 0.0;
        if (sourceRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset) == 0L) {
            String string3 = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string4 = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        DatasetType datasetType = resultDataset.getType();
        if (datasetType != DatasetType.REGION) {
            String string5 = InternalResource.loadString("", "BufferAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        int n3 = -1;
        boolean bl = false;
        DatasetType datasetType2 = sourceRecordset.getDataset().getType();
        if (bufferEndType.equals((Object)BufferEndType.FLAT)) {
            if (object == null && object2 == null) {
                String string6 = InternalResource.loadString("objLeftDistance and objRightDistance", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string6);
            }
            if (isUnion) {
                isAttributeRetained = false;
            }
            if (datasetType2 != DatasetType.LINE && datasetType2 != DatasetType.NETWORK) {
                String string7 = InternalResource.loadString("", "BufferAnalyst_BufferDatasetTypeInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string7);
            }
            if (object != null && object2 != null && object instanceof String ^ object2 instanceof String) {
                String string8 = InternalResource.loadString("", "BufferAnalyst_LeftDistenceAndRightDistanceMustBeTheSameType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string8);
            }
            if (object2 == null) {
                if (object instanceof String) {
                    string = (String)object;
                    if (string == null || string.trim().length() == 0) {
                        String string9 = InternalResource.loadString("LeftDistance", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string9);
                    }
                } else {
                    d = InternalToolkitSpatialAnalyst.objectToDouble(object);
                    if (d <= 0.0) {
                        String string10 = InternalResource.loadString("leftDistance", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string10);
                    }
                }
                n3 = InternalToolkitSpatialAnalyst.BufferSideType.LEFT.value();
            }
            if (object == null) {
                if (object2 instanceof String) {
                    string2 = (String)object2;
                    if (string2 == null || string2.trim().length() == 0) {
                        String string11 = InternalResource.loadString("LeftDistance", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string11);
                    }
                } else {
                    d2 = InternalToolkitSpatialAnalyst.objectToDouble(object2);
                    if (d2 <= 0.0) {
                        String string12 = InternalResource.loadString("rightDistance", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string12);
                    }
                }
                n3 = InternalToolkitSpatialAnalyst.BufferSideType.RIGHT.value();
            }
            if (object != null && object2 != null) {
                if (object instanceof String) {
                    string = (String)object;
                    if (string == null || string.trim().length() == 0) {
                        String string13 = InternalResource.loadString("LeftDistance", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string13);
                    }
                    string2 = (String)object2;
                    if (string2 == null || string2.trim().length() == 0) {
                        String string14 = InternalResource.loadString("RightDistance", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string14);
                    }
                    n3 = string.equals(string2) ? InternalToolkitSpatialAnalyst.BufferSideType.FULL.value() : InternalToolkitSpatialAnalyst.BufferSideType.FULLDIFFR.value();
                } else {
                    d = InternalToolkitSpatialAnalyst.objectToDouble(object);
                    if (d <= 0.0) {
                        String string15 = InternalResource.loadString("leftDistance", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string15);
                    }
                    d2 = InternalToolkitSpatialAnalyst.objectToDouble(object2);
                    if (d2 <= 0.0) {
                        String string16 = InternalResource.loadString("rightDistance", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string16);
                    }
                    n3 = d == d2 ? InternalToolkitSpatialAnalyst.BufferSideType.FULL.value() : InternalToolkitSpatialAnalyst.BufferSideType.FULLDIFFR.value();
                }
            }
            n = BufferEndType.FLAT.value();
            bl = string != null || string2 != null ? BufferAnalystNative.jni_CreateLineDatasetBuffer2(0L, l, l2, string, string2, bufferRadiusUnit.value(), n2, n3, n, isUnion, isAttributeRetained) : BufferAnalystNative.jni_CreateLineDatasetBuffer(0L, l, l2, d, d2, bufferRadiusUnit.value(), n2, n3, n, isUnion, isAttributeRetained);
        }
        if (bufferEndType.equals((Object)BufferEndType.ROUND)) {
            if (isUnion) {
                isAttributeRetained = false;
            }
            if (datasetType2 != DatasetType.LINE && datasetType2 != DatasetType.NETWORK && datasetType2 != DatasetType.POINT && datasetType2 != DatasetType.REGION) {
                String string17 = InternalResource.loadString("", "BufferAnalyst_BufferDatasetTypeInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string17);
            }
            if (object == null) {
                String string18 = InternalResource.loadString("objLeftDistance", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string18);
            }
            if (object instanceof String) {
                string = (String)object;
                if (string == null || string.trim().length() == 0) {
                    String string19 = InternalResource.loadString("LeftDistance", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string19);
                }
            } else {
                d = InternalToolkitSpatialAnalyst.objectToDouble(object);
                if (!datasetType2.equals((Object)DatasetType.REGION) && d <= 0.0) {
                    String string20 = InternalResource.loadString("", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string20);
                }
                if (datasetType2.equals((Object)DatasetType.REGION) && Toolkit.isZero((double)d)) {
                    String string21 = InternalResource.loadString("", "BufferAnalyst_BufferDistanceShouldNotBeZero", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string21);
                }
            }
            if (datasetType2.equals((Object)DatasetType.LINE) || datasetType2.equals((Object)DatasetType.NETWORK)) {
                n3 = InternalToolkitSpatialAnalyst.BufferSideType.FULL.value();
            }
            n = BufferEndType.ROUND.value();
            bl = string != null ? BufferAnalystNative.jni_CreateDatasetBuffer2(0L, l, l2, string, bufferRadiusUnit.value(), n2, n3, n, isUnion, isAttributeRetained) : BufferAnalystNative.jni_CreateDatasetBuffer(0L, l, l2, d, bufferRadiusUnit.value(), n2, n3, n, isUnion, isAttributeRetained);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRecordset);
        return bl;
    }

    public static boolean createMultiBuffer(DatasetVector sourceDataset, DatasetVector resultDataset, double[] bufferRadii, BufferRadiusUnit bufferRadiusUnit, int semicircleSegments, boolean isUnion, boolean isAttributeRetained, boolean isRing) {
        BufferAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        for (double d : bufferRadii) {
            if (!(d <= 0.0)) continue;
            String string = InternalResource.loadString("bufferRadii", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        DatasetType datasetType = resultDataset.getType();
        if (datasetType != DatasetType.REGION) {
            String string = InternalResource.loadString("", "BufferAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = BufferAnalystNative.jni_CreateDatasetMultiBuffer(l, l2, bufferRadii, bufferRadiusUnit.value(), semicircleSegments, isUnion, isAttributeRetained, isRing);
        return bl;
    }

    public static boolean createMultiBuffer(Recordset sourceRecordset, DatasetVector resultDataset, double[] bufferRadii, BufferRadiusUnit bufferRadiusUnit, int semicircleSegments, boolean isUnion, boolean isAttributeRetained, boolean isRing) {
        BufferAnalyst.verifyLicense();
        if (sourceRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset) == 0L) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        for (double d : bufferRadii) {
            if (!(d <= 0.0)) continue;
            String string = InternalResource.loadString("bufferRadii", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        DatasetType datasetType = resultDataset.getType();
        if (datasetType != DatasetType.REGION) {
            String string = InternalResource.loadString("", "BufferAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = BufferAnalystNative.jni_CreateRecordsetMultiBuffer(l, l2, bufferRadii, bufferRadiusUnit.value(), semicircleSegments, isUnion, isAttributeRetained, isRing);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRecordset);
        return bl;
    }

    public static boolean createLineOneSideMultiBuffer(DatasetVector sourceDataset, DatasetVector resultDataset, double[] bufferRadii, BufferRadiusUnit bufferRadiusUnit, int semicircleSegments, boolean isLeft, boolean isUnion, boolean isAttributeRetained, boolean isRing) {
        BufferAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceDataset.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDataset", "BufferAnalyst_BufferDatasetTypeShouldBeLine", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (double d : bufferRadii) {
            if (!(d <= 0.0)) continue;
            String string = InternalResource.loadString("bufferRadii", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        DatasetType datasetType = resultDataset.getType();
        if (datasetType != DatasetType.REGION) {
            String string = InternalResource.loadString("", "BufferAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = BufferAnalystNative.jni_CreateDatasetLineOneSideMultiBuffer(l, l2, bufferRadii, bufferRadiusUnit.value(), semicircleSegments, isLeft, isUnion, isAttributeRetained, isRing);
        return bl;
    }

    public static boolean createLineOneSideMultiBuffer(Recordset sourceRecordset, DatasetVector resultDataset, double[] bufferRadii, BufferRadiusUnit bufferRadiusUnit, int semicircleSegments, boolean isLeft, boolean isUnion, boolean isAttributeRetained, boolean isRing) {
        BufferAnalyst.verifyLicense();
        if (sourceRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset) == 0L) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resultDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset) == 0L) {
            String string = InternalResource.loadString("resultDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceRecordset.getDataset().getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceRecordset", "BufferAnalyst_BufferDatasetTypeShouldBeLine", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (double d : bufferRadii) {
            if (!(d <= 0.0)) continue;
            String string = InternalResource.loadString("bufferRadii", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resultDataset);
        DatasetType datasetType = resultDataset.getType();
        if (datasetType != DatasetType.REGION) {
            String string = InternalResource.loadString("", "BufferAnalyst_ResultDatasetTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = BufferAnalystNative.jni_CreateRecordsetLineOneSideMultiBuffer(l, l2, bufferRadii, bufferRadiusUnit.value(), semicircleSegments, isLeft, isUnion, isAttributeRetained, isRing);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRecordset);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector<SteppedListener> vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "BufferAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        BufferAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

