/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.CellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.data.DatasetGrid;
import java.util.ArrayList;

public class ANNCellularAutomataParameter {
    private boolean m_bCheckResult;
    private DatasetGrid m_EndCellGrid;
    private double m_dThreshold;
    private int m_nAlpha;
    private ArrayList[] m_arrConversionRule;
    private ArrayList<Integer> m_arrConversionClassID;
    CellularAutomataParameter m_CellularAutomataParameter;

    public ANNCellularAutomataParameter() {
        this.m_bCheckResult = true;
        this.m_dThreshold = 0.75;
        this.m_nAlpha = 1;
        this.m_arrConversionRule = null;
        this.m_arrConversionClassID = null;
        this.m_CellularAutomataParameter = null;
    }

    public ANNCellularAutomataParameter(ANNCellularAutomataParameter para) {
        this.m_bCheckResult = para.m_bCheckResult;
        this.m_EndCellGrid = para.m_EndCellGrid;
        this.m_dThreshold = para.m_dThreshold;
        this.m_nAlpha = para.m_nAlpha;
        this.m_arrConversionRule = para.m_arrConversionRule;
        this.m_arrConversionClassID = para.m_arrConversionClassID;
        if (this.m_CellularAutomataParameter == null) {
            this.m_CellularAutomataParameter = new CellularAutomataParameter();
        }
        this.m_CellularAutomataParameter.Reset(para.m_CellularAutomataParameter);
    }

    public CellularAutomataParameter getCellularAutomataParameter() {
        return this.m_CellularAutomataParameter;
    }

    public void setCellularAutomataParameter(CellularAutomataParameter value) {
        if (value == null) {
            String string = InternalResource.loadString("CellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_CellularAutomataParameter == null) {
            this.m_CellularAutomataParameter = new CellularAutomataParameter();
        }
        this.m_CellularAutomataParameter.Reset(value);
    }

    public boolean isCheckResult() {
        return this.m_bCheckResult;
    }

    public void setCheckResult(boolean value) {
        this.m_bCheckResult = value;
    }

    public DatasetGrid getEndCellGrid() {
        return this.m_EndCellGrid;
    }

    public void setEndCellGrid(DatasetGrid value) {
        if (value == null) {
            String string = InternalResource.loadString("EndCellGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_EndCellGrid = value;
    }

    public double getThreshold() {
        return this.m_dThreshold;
    }

    public void setThreshold(double value) {
        if (value <= 0.0 || value > 1.0) {
            String string = InternalResource.loadString("Threshold", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dThreshold = value;
    }

    public int getAlpha() {
        return this.m_nAlpha;
    }

    public void setAlpha(int value) {
        if (value <= 0 || value > 10) {
            String string = InternalResource.loadString("Alpha", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nAlpha = value;
    }

    public boolean[][] getConversionRules() {
        if (this.m_arrConversionRule == null) {
            return null;
        }
        int n = this.m_arrConversionRule.length;
        boolean[][] blArrayArray = new boolean[n][];
        for (int i = 0; i < n; ++i) {
            boolean[] blArray = new boolean[n];
            for (int j = 0; j < n; ++j) {
                blArray[j] = (Boolean)this.m_arrConversionRule[i].get(j);
            }
            blArrayArray[i] = blArray;
        }
        return blArrayArray;
    }

    public void setConversionRules(boolean[][] value) {
        int n;
        int n2;
        if (value == null || value.length == 0) {
            String string = InternalResource.loadString("ConversionRules", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (n2 = 0; n2 < value.length; ++n2) {
            if (value[n2] == null) {
                String string = InternalResource.loadString("ConversionRules[" + n2 + "]", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (value.length == value[n2].length) continue;
            String string = InternalResource.loadString("ConversionRules[" + n2 + "].length and ConversionRules.length must be the same length.", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        n2 = value.length;
        if (this.m_arrConversionRule != null) {
            for (n = 0; n < this.m_arrConversionRule.length; ++n) {
                this.m_arrConversionRule[n].clear();
            }
        } else {
            this.m_arrConversionRule = new ArrayList[n2];
            for (n = 0; n < n2; ++n) {
                this.m_arrConversionRule[n] = new ArrayList();
            }
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                this.m_arrConversionRule[n].add(value[n][i]);
            }
        }
    }

    public int[] getConversionClassIDs() {
        if (this.m_arrConversionClassID == null) {
            return null;
        }
        int n = this.m_arrConversionClassID.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.m_arrConversionClassID.get(i);
        }
        return nArray;
    }

    public void setConversionClassIDs(int[] value) {
        if (value == null) {
            String string = InternalResource.loadString("ConversionClassIDs", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = value.length;
        if (this.m_arrConversionClassID != null) {
            this.m_arrConversionClassID.clear();
        } else {
            this.m_arrConversionClassID = new ArrayList();
        }
        for (int i = 0; i < n; ++i) {
            this.m_arrConversionClassID.add(value[i]);
        }
    }
}

