/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.threeddesigner;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Environment;
import com.supermap.realspace.threeddesigner.ImageSetting;
import com.supermap.realspace.threeddesigner.ImageToolkitNative;
import com.supermap.realspace.threeddesigner.InternalResource;
import com.supermap.realspace.threeddesigner.InternalToolkitThreeDDesigner;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public abstract class ImageToolkit {
    private static License m_license;

    public static BufferedImage adjustProperties(BufferedImage inputBitmap, BufferedImage maskBitmap, ImageSetting imageSetting) {
        int n;
        int n2;
        if (imageSetting == null) {
            String string = InternalResource.loadString("imageSetting", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        int n3 = inputBitmap.getWidth();
        int n4 = inputBitmap.getHeight();
        int[] nArray = new int[n3 * n4];
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                nArray[n2 * n3 + n] = inputBitmap.getRGB(n, n2);
            }
        }
        n2 = 0;
        n = 0;
        int[] nArray2 = null;
        if (maskBitmap != null) {
            n2 = maskBitmap.getWidth();
            n = maskBitmap.getHeight();
            nArray2 = new int[n2 * n];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    nArray2[i * n2 + j] = maskBitmap.getRGB(j, i);
                }
            }
        }
        float[] fArray = new float[]{imageSetting.getBrightness(), imageSetting.getContrast(), imageSetting.getHue(), imageSetting.getSaturation()};
        byte[] byArray = ImageToolkitNative.jni_AdjustProperties(nArray, n3, n4, nArray2, n2, n, fArray);
        nArray = null;
        nArray2 = null;
        BufferedImage bufferedImage = null;
        if (byArray != null && n3 > 0 && n4 > 0) {
            bufferedImage = new BufferedImage(n3, n4, 4);
        }
        if (bufferedImage == null || byArray == null) {
            return null;
        }
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n5 = 0;
                int n6 = i * n3 * 4 + j * 4;
                int n7 = byArray[n6 + 3] & 0xFF;
                int n8 = byArray[n6 + 2] & 0xFF;
                int n9 = byArray[n6 + 1] & 0xFF;
                int n10 = byArray[n6] & 0xFF;
                Color color = new Color(n8, n9, n10, n7);
                n5 = color.getRGB();
                bufferedImage.setRGB(j, i, n5);
            }
        }
        BufferedImage bufferedImage2 = null;
        if (bufferedImage != null) {
            bufferedImage2 = new BufferedImage(n3, n4, bufferedImage.getColorModel().getTransparency());
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage(bufferedImage, n3, n4, 0, 0, n3, 0, 0, n4, null);
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public static BufferedImage adjustProperties(BufferedImage inputBitmap, BufferedImage maskBitmap, ImageSetting imageSetting, Color backgroundColor) {
        int n;
        int n2;
        if (imageSetting == null) {
            String string = InternalResource.loadString("imageSetting", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        int n3 = inputBitmap.getWidth();
        int n4 = inputBitmap.getHeight();
        int[] nArray = new int[n3 * n4];
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                nArray[n2 * n3 + n] = inputBitmap.getRGB(n, n2);
            }
        }
        n2 = 0;
        n = 0;
        int[] nArray2 = null;
        if (maskBitmap != null) {
            n2 = maskBitmap.getWidth();
            n = maskBitmap.getHeight();
            nArray2 = new int[n2 * n];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    nArray2[i * n2 + j] = maskBitmap.getRGB(j, i);
                }
            }
        }
        float[] fArray = new float[]{imageSetting.getBrightness(), imageSetting.getContrast(), imageSetting.getHue(), imageSetting.getSaturation()};
        int[] nArray3 = new int[]{backgroundColor.getAlpha(), backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue()};
        byte[] byArray = ImageToolkitNative.jni_AdjustProperties(nArray, n3, n4, nArray2, n2, n, fArray, nArray3);
        nArray = null;
        nArray2 = null;
        BufferedImage bufferedImage = null;
        if (byArray != null && n3 > 0 && n4 > 0) {
            bufferedImage = new BufferedImage(n3, n4, 4);
        }
        if (byArray != null && bufferedImage != null) {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n5 = 0;
                    int n6 = i * n3 * 4 + j * 4;
                    int n7 = byArray[n6 + 3] & 0xFF;
                    int n8 = byArray[n6 + 2] & 0xFF;
                    int n9 = byArray[n6 + 1] & 0xFF;
                    int n10 = byArray[n6] & 0xFF;
                    Color color = new Color(n8, n9, n10, n7);
                    n5 = color.getRGB();
                    bufferedImage.setRGB(j, i, n5);
                }
            }
        }
        BufferedImage bufferedImage2 = null;
        if (bufferedImage != null) {
            bufferedImage2 = new BufferedImage(n3, n4, bufferedImage.getColorModel().getTransparency());
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage(bufferedImage, n3, n4, 0, 0, n3, 0, 0, n4, null);
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public static BufferedImage inpaint(BufferedImage inputBitmap, BufferedImage maskBitmap, float inpaintRadius) {
        byte[] byArray;
        int n;
        int n2;
        int n3 = inputBitmap.getWidth();
        int n4 = inputBitmap.getHeight();
        int[] nArray = new int[n3 * n4];
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                nArray[n2 * n3 + n] = inputBitmap.getRGB(n, n2);
            }
        }
        n2 = 0;
        n = 0;
        int[] nArray2 = null;
        if (maskBitmap != null) {
            n2 = maskBitmap.getWidth();
            n = maskBitmap.getHeight();
            nArray2 = new int[n2 * n];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    nArray2[i * n2 + j] = maskBitmap.getRGB(j, i);
                }
            }
        }
        if ((byArray = ImageToolkitNative.jni_Inpaint(nArray, n3, n4, nArray2, n2, n, inpaintRadius)) == null) {
            return null;
        }
        BufferedImage bufferedImage = null;
        if (byArray != null && n3 > 0 && n4 > 0) {
            bufferedImage = new BufferedImage(n3, n4, 4);
        }
        if (bufferedImage == null) {
            return null;
        }
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n5 = 0;
                int n6 = i * n3 * 4 + j * 4;
                int n7 = byArray[n6 + 3] & 0xFF;
                int n8 = byArray[n6 + 2] & 0xFF;
                int n9 = byArray[n6 + 1] & 0xFF;
                int n10 = byArray[n6] & 0xFF;
                Color color = new Color(n8, n9, n10, n7);
                n5 = color.getRGB();
                bufferedImage.setRGB(j, i, n5);
            }
        }
        BufferedImage bufferedImage2 = null;
        if (bufferedImage != null) {
            bufferedImage2 = new BufferedImage(n3, n4, bufferedImage.getColorModel().getTransparency());
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage(bufferedImage, n3, n4, 0, 0, n3, 0, 0, n4, null);
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    static {
        Environment.LoadWrapJ();
        ArrayList<ProductType> arrayList = InternalToolkitThreeDDesigner.managerProducts(InternalToolkitThreeDDesigner.getThreeDDesignerProducts());
        m_license = InternalToolkitThreeDDesigner.verifyLicense(arrayList);
    }
}

