/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoText3D;
import com.supermap.data.GeoText3DNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import com.supermap.data.TextPart3DNative;

public class TextPart3D
extends InternalHandleDisposable {
    private Point3D m_anchorPoint = null;
    private GeoText3D m_geoText = null;

    public TextPart3D() {
        long l = TextPart3DNative.jni_New();
        this.setHandle(l, true);
        this.reset();
    }

    public TextPart3D(TextPart3D part) {
        if (part.getHandle() == 0L) {
            String string = InternalResource.loadString("part", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (part.m_geoText != null) {
            int n = part.m_geoText.getTextPart3DsList().indexOf(part);
            if (n == -1) {
                String string = InternalResource.loadString("TextPart(TextPart part)", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            l = GeoText3DNative.jni_GetSubHandle(part.m_geoText.getHandle(), n);
        } else {
            l = part.getHandle();
        }
        long l2 = TextPart3DNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setAnchorPoint(part.getAnchorPoint());
        part.makeSureNativeObjectLive();
    }

    public TextPart3D(String text, Point3D anchorPoint) {
        long l = TextPart3DNative.jni_New();
        this.setHandle(l, true);
        this.reset(anchorPoint, text);
    }

    public TextPart3D(String text, double x, double y, double z) {
        long l = TextPart3DNative.jni_New();
        this.setHandle(l, true);
        Point3D point3D = new Point3D(x, y, z);
        this.reset(point3D, text);
    }

    TextPart3D(GeoText3D geoText, int index) {
        if (geoText.getHandle() == 0L) {
            String string = InternalResource.loadString("geoText", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoText3DNative.jni_GetSubHandle(geoText.getHandle(), index);
        this.setHandle(l, false);
        this.m_geoText = geoText;
        geoText.makeSureNativeObjectLive();
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TextPart3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public String getText() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getText()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPart3DsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getText()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            return GeoText3DNative.jni_GetSubText(this.m_geoText.getHandle(), n);
        }
        return TextPart3DNative.jni_GetText(this.getHandle());
    }

    public void setText(String text) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setText(String text)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (text == null) {
            text = "";
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPart3DsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setText()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            GeoText3DNative.jni_SetSubText(this.m_geoText.getHandle(), text, n);
        } else {
            TextPart3DNative.jni_SetText(this.getHandle(), text);
        }
    }

    public Point3D getAnchorPoint() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPart3DsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[3];
            TextPart3DNative.jni_GetSubAnchor(this.m_geoText.getHandle(), dArray, n);
            return new Point3D(dArray[0], dArray[1], dArray[2]);
        }
        return this.m_anchorPoint;
    }

    public void setAnchorPoint(Point3D anchorPoint) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnchorPoint(Point2D anchorPoint)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPart3DsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            TextPart3DNative.jni_SetSubAnchor(this.m_geoText.getHandle(), anchorPoint.getX(), anchorPoint.getY(), anchorPoint.getZ(), n);
        } else {
            this.m_anchorPoint = anchorPoint.clone();
        }
    }

    public double getX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPart3DsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[3];
            TextPart3DNative.jni_GetSubAnchor(this.m_geoText.getHandle(), dArray, n);
            return dArray[0];
        }
        return this.m_anchorPoint.getX();
    }

    public double getY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPart3DsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[3];
            TextPart3DNative.jni_GetSubAnchor(this.m_geoText.getHandle(), dArray, n);
            return dArray[1];
        }
        return this.m_anchorPoint.getY();
    }

    public void setX(double x) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setX(double x)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPart3DsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            TextPart3DNative.jni_SetSubAnchor(this.m_geoText.getHandle(), x, this.getY(), this.getZ(), n);
        } else {
            this.m_anchorPoint.setX(x);
        }
    }

    public void setY(double y) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setY(double y)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPart3DsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            TextPart3DNative.jni_SetSubAnchor(this.m_geoText.getHandle(), this.getX(), y, this.getZ(), n);
        } else {
            this.m_anchorPoint.setY(y);
        }
    }

    public double getZ() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPart3DsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[3];
            TextPart3DNative.jni_GetSubAnchor(this.m_geoText.getHandle(), dArray, n);
            return dArray[2];
        }
        return this.m_anchorPoint.getZ();
    }

    public void setZ(double z) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setY(double y)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPart3DsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            TextPart3DNative.jni_SetSubAnchor(this.m_geoText.getHandle(), this.getX(), this.getY(), z, n);
        } else {
            this.m_anchorPoint.setZ(z);
        }
    }

    public void offset(double dx, double dy, double dz) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d = this.getX() + dx;
        double d2 = this.getY() + dy;
        double d3 = this.getZ() + dz;
        if (this.m_geoText != null) {
            int n = this.m_geoText.getTextPart3DsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            TextPart3DNative.jni_SetSubAnchor(this.m_geoText.getHandle(), d, d2, d3, n);
        } else {
            this.m_anchorPoint.setX(d);
            this.m_anchorPoint.setY(d2);
            this.m_anchorPoint.setZ(d3);
        }
    }

    public TextPart3D clone() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoText != null && (n = this.m_geoText.getTextPart3DsList().indexOf(this)) == -1) {
            String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new TextPart3D(this);
    }

    void reset() {
        this.reset(new Point3D(0.0, 0.0, 0.0), "");
    }

    void reset(Point3D anchorPoint, String text) {
        this.setAnchorPoint(anchorPoint);
        this.setText(text);
    }
}

