/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoModel3DNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Matrix;
import com.supermap.data.Model;
import com.supermap.data.NodeAnimation;
import com.supermap.data.Point3D;
import com.supermap.data.SkeletonID;
import java.io.File;

public class GeoModel3D
extends Geometry3D {
    private NodeAnimation m_nodeAnimation;

    public GeoModel3D() {
        this.setHandle(GeoModel3DNative.jni_New(), true);
    }

    public GeoModel3D(GeoModel3D geoModel) {
        if (geoModel == null) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoModel);
        if (l == 0L) {
            String string = InternalResource.loadString("geoModel", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoModel3DNative.jni_Clone(l);
        super.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoModel);
    }

    GeoModel3D(long handle) {
        this.setHandle(handle, false);
    }

    public GeoModel3D(GeoModel3D geoModel, SkeletonID skeletonId) {
        if (geoModel == null) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoModel);
        if (l == 0L) {
            String string = InternalResource.loadString("geoModel", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoModel3DNative.jni_Clone(l, skeletonId.getLODIndex(), skeletonId.getSkeletonIndex());
        super.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoModel);
    }

    public GeoModel3D(Model model) {
        if (model == null) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(model);
        if (l == 0L) {
            String string = InternalResource.loadString("model", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoModel3DNative.jni_New(l);
        super.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(model);
    }

    public GeoModel3D(Model model, SkeletonID id) {
        if (model == null) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(model);
        if (l == 0L) {
            String string = InternalResource.loadString("model", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoModel3DNative.jni_New(l, id.getLODIndex(), id.getSkeletonIndex());
        super.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(model);
    }

    public Model getModel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getModel()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoModel3DNative.jni_GetModel(this.getHandle());
        return new Model(l);
    }

    public void setModel(Model model) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setModel()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (model.getHandle() == 0L) {
            String string = InternalResource.loadString("Model", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoModel3DNative.jni_SetModel(this.getHandle(), model.getHandle());
    }

    @Override
    public double getVolume() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVolume()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoModel3DNative.jni_GetVolume(this.getHandle());
    }

    public boolean isLonLat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLonLat()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoModel3DNative.jni_IsLonLat(this.getHandle());
    }

    public void setIsLonLat(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsLonLat()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoModel3DNative.jni_SetIsLonLat(this.getHandle(), value);
    }

    public String getFilePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFilePath()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoModel3DNative.jni_GetFilePath(this.getHandle());
    }

    public void setFilePath(String file) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFilePath()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (file == null) {
            String string = InternalResource.loadString("file", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        File file2 = new File(file);
        if (!file2.exists()) {
            String string = InternalResource.loadString("file", "GeoModel_TheFileIsNotExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoModel3DNative.jni_SetFilePath(this.getHandle(), file);
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoModel3DNative.jni_GetArea(this.getHandle());
    }

    public double getMinZ() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoModel3DNative.jni_GetMinZ(this.getHandle());
    }

    public double getMaxZ() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoModel3DNative.jni_GetMaxZ(this.getHandle());
    }

    public NodeAnimation getNodeAnimation() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoModel3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_nodeAnimation == null && (l = GeoModel3DNative.jni_GetNodeAnimation(this.getHandle())) != 0L) {
            this.m_nodeAnimation = new NodeAnimation(l);
        }
        return this.m_nodeAnimation;
    }

    public GeoRegion convertToRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToRegion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoModel3DNative.jni_ConvertToRegion(this.getHandle());
        GeoRegion geoRegion = new GeoRegion();
        if (l != 0L) {
            geoRegion = new GeoRegion(l);
        }
        return geoRegion;
    }

    @Override
    public GeoModel3D clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoModel3D(this);
    }

    @Override
    protected void finalize() {
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoModel3DNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected static GeoModel3D creatInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoModel3D(handle);
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
    }

    public void setMatrix(Point3D point, Matrix matrix) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMatrix(Point3D point,Matrix matrix)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (matrix == null) {
            String string = InternalResource.loadString("matrix", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle(matrix);
        if (0L == l) {
            String string = InternalResource.loadString("matrix", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d = point.getX();
        double d2 = point.getY();
        double d3 = point.getZ();
        GeoModel3DNative.jni_SetMatrix(this.getHandle(), d, d2, d3, l);
    }
}

