/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoCylinderNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;

public class GeoCylinder
extends Geometry3D {
    public GeoCylinder() {
        long l = GeoCylinderNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoCylinder(GeoCylinder geoCylinder) {
        if (geoCylinder == null) {
            String string = InternalResource.loadString("geoCylinder", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoCylinder);
        if (l == 0L) {
            String string = InternalResource.loadString("geoCylinder", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoCylinderNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoCylinder);
    }

    public GeoCylinder(Point3D position, double topRadius, double bottomRadius, double height) {
        double d = position.getX();
        double d2 = position.getY();
        double d3 = position.getZ();
        if (topRadius <= 0.0) {
            String string = InternalResource.loadString("topRadius", "GeoCylinder_TopRadiusShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bottomRadius <= 0.0) {
            String string = InternalResource.loadString("bottomRadius", "GeoCylinder_BottomRadiusShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (height <= 0.0) {
            String string = InternalResource.loadString("height", "GeoCylinder_HeightShouldBePositive", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoCylinderNative.jni_New2(d, d2, d3, topRadius, bottomRadius, height);
        this.setHandle(l, true);
    }

    GeoCylinder(long handle) {
        this.setHandle(handle, false);
    }

    public double getTopRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTopRadius()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCylinderNative.jni_GetTopRadius(this.getHandle());
    }

    public void setTopRadius(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTopRadius(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoCylinder_TopRadiusShouldBePositive", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoCylinderNative.jni_SetTopRadius(this.getHandle(), value);
    }

    public double getBottomRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBottomRadius()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCylinderNative.jni_GetBottomRadius(this.getHandle());
    }

    public void setBottomRadius(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBottomRadius(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoCylinder_BottomRadiusShouldBePositive", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoCylinderNative.jni_SetBottomRadius(this.getHandle(), value);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCylinderNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("setHeight(double value)", "GeoCylinder_HeightShouldBePositive", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoCylinderNative.jni_SetHeight(this.getHandle(), value);
    }

    @Override
    public GeoCylinder clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoCylinder(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoCylinderNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }
}

