/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetVector;
import com.supermap.data.EngineType;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfosNative;
import com.supermap.data.FieldSign;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.util.ArrayList;

public class FieldInfos
extends InternalHandleDisposable {
    private DatasetVector m_datasetVector = null;
    private ArrayList m_fieldInfos = null;
    private static final Object m_lock = new Object();

    public FieldInfos() {
        this.m_fieldInfos = new ArrayList();
        this.setHandle(FieldInfosNative.jni_New(), true);
    }

    public FieldInfos(FieldInfos fieldInfos) {
        if (fieldInfos == null || fieldInfos.getHandle() == 0L) {
            String string = InternalResource.loadString("fieldInfos", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_fieldInfos = new ArrayList();
        this.setHandle(FieldInfosNative.jni_New(), true);
        int n = fieldInfos.getCount();
        for (int i = 0; i < n; ++i) {
            this.add(fieldInfos.get(i));
        }
        InternalHandleDisposable.makeSureNativeObjectLive(fieldInfos);
    }

    public FieldInfos(FieldInfo[] fieldInfos) {
        if (fieldInfos == null) {
            String string = InternalResource.loadString("fieldInfos", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_fieldInfos = new ArrayList();
        this.setHandle(FieldInfosNative.jni_New(), true);
        int n = fieldInfos.length;
        for (int i = 0; i < n; ++i) {
            this.add(fieldInfos[i]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(fieldInfos);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_fieldInfos.size();
    }

    public FieldInfo get(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.indexOf(name);
        FieldInfo fieldInfo = null;
        if (n != -1) {
            fieldInfo = this.get(n);
        }
        return fieldInfo;
    }

    public FieldInfo get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return (FieldInfo)this.m_fieldInfos.get(index);
    }

    public FieldInfos clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new FieldInfos(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(FieldInfo fieldInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fieldInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("fieldInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        Object object = m_lock;
        synchronized (object) {
            long l;
            if (this.m_datasetVector != null) {
                if (fieldInfo.isSystemField()) {
                    String string = InternalResource.loadString("add(FieldInfo fieldInfo)", "FieldInfos_CantAddTheFieldInfo", "data_resources");
                    throw new UnsupportedOperationException(string);
                }
                if (!this.m_datasetVector.isAvailableFieldName(fieldInfo.getName())) {
                    String string = InternalResource.loadString("fieldInfo", "FieldInfo_NameIsNotAvaliable", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (fieldInfo.isRequired() && fieldInfo.getDefaultValue().equals("")) {
                    String string = InternalResource.loadString("fieldInfo", "FieldInfos_RequiredFeildInfoMustBeSettedDefaultValue", "data_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            long l2 = 0L;
            if (this.m_datasetVector != null) {
                l2 = this.m_datasetVector.getHandle();
            }
            if ((l = FieldInfosNative.jni_Add(this.getHandle(), fieldInfo.getHandle(), l2)) != 0L) {
                FieldInfo fieldInfo2 = new FieldInfo(l, this);
                this.m_fieldInfos.add(fieldInfo2);
                this.resetItemsHandle();
                n = this.getCount() - 1;
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive(fieldInfo);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modify(String name, FieldInfo fieldInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fieldInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("fieldInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Object object = m_lock;
        synchronized (object) {
            if (this.m_datasetVector != null) {
                EngineType engineType = this.getDataset().getDatasource().getEngineType();
                if (engineType != EngineType.ORACLEPLUS && engineType != EngineType.SQLPLUS && engineType != EngineType.KINGBASE && engineType != EngineType.MYSQL && engineType != EngineType.POSTGRESQL) {
                    String string = InternalResource.loadString("EngineType_Unsupported", "", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (fieldInfo.isSystemField()) {
                    String string = InternalResource.loadString("modifyField", "FieldInfos_Unsupported", "data_resources");
                    throw new UnsupportedOperationException(string);
                }
                if (this.indexOf(name) < 0) {
                    String string = InternalResource.loadString("fieldInfo", "FieldInfo_NameIsNotAvaliable", "data_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            long l = 0L;
            if (this.m_datasetVector != null) {
                l = this.m_datasetVector.getHandle();
            }
            boolean bl = FieldInfosNative.jni_Modify(this.getHandle(), name, fieldInfo.getHandle(), l);
            this.resetItemsHandle();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRange(FieldInfo[] fieldInfos) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = 0;
        int n2 = fieldInfos.length;
        int n3 = -1;
        Object object = m_lock;
        synchronized (object) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < n2; ++i) {
                try {
                    n3 = this.add(fieldInfos[i]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    for (int j = 0; j < arrayList.size(); ++j) {
                        String string = arrayList.get(j).toString();
                        this.remove(string);
                    }
                    throw illegalArgumentException;
                }
                if (n3 == -1) continue;
                ++n;
            }
            this.resetItemsHandle();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasetVector != null) {
            String string = InternalResource.loadString("clear()", "FieldInfos_Unsupported", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        Object object = m_lock;
        synchronized (object) {
            FieldInfosNative.jni_Clear(this.getHandle());
            if (this.m_fieldInfos != null) {
                int n = this.m_fieldInfos.size();
                for (int i = 0; i < n; ++i) {
                    FieldInfo fieldInfo = (FieldInfo)this.m_fieldInfos.get(i);
                    fieldInfo.clearHandle();
                }
            }
            if (this.m_fieldInfos != null) {
                this.m_fieldInfos.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exchange(int index1, int index2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasetVector != null) {
            String string = InternalResource.loadString("exchange(int index1, int index2)", "FieldInfos_Unsupported", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (index1 < 0 || index1 >= this.getCount()) {
            String string = InternalResource.loadString("index1", "GlobalEnum_InvalidDerivedClass", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (index2 < 0 || index2 >= this.getCount()) {
            String string = InternalResource.loadString("index2", "GlobalEnum_InvalidDerivedClass", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (index1 == index2) {
            return;
        }
        Object object = m_lock;
        synchronized (object) {
            FieldInfosNative.jni_Exchange(this.getHandle(), index1, index2);
            FieldInfo fieldInfo = this.get(index1);
            FieldInfo fieldInfo2 = this.get(index2);
            this.m_fieldInfos.set(index1, fieldInfo2);
            this.m_fieldInfos.set(index2, fieldInfo);
            this.resetItemsHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(int index, FieldInfo newItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasetVector != null) {
            String string = InternalResource.loadString("insert(int index, FieldInfo newItem)", "FieldInfos_Unsupported", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "GlobalEnum_InvalidDerivedClass", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        String string = newItem.getName();
        if (this.contains(string)) {
            String string2 = InternalResource.loadString("newItem", "FieldInfos_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (newItem.isSystemField() || newItem.getName().toUpperCase().startsWith("SM")) {
            String string3 = InternalResource.loadString("insert(int index, FieldInfo newItem)", "FieldInfos_Unsupported", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        Object object = m_lock;
        synchronized (object) {
            if (index == this.getCount()) {
                return this.add(newItem) != -1;
            }
            long l = FieldInfosNative.jni_Insert(this.getHandle(), index, newItem.getHandle());
            if (l == 0L) {
                String string4 = InternalResource.loadString("newItem", "FieldInfos_FailToInsert", "data_resources");
                throw new IllegalArgumentException(string4);
            }
            FieldInfo fieldInfo = new FieldInfo(l, this);
            this.m_fieldInfos.add(index, fieldInfo);
            this.resetItemsHandle();
            InternalHandleDisposable.makeSureNativeObjectLive(newItem);
            return l != 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Object object = m_lock;
        synchronized (object) {
            int n = -1;
            if (name != null && name.trim().length() != 0) {
                n = FieldInfosNative.jni_IndexOf(this.getHandle(), name);
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Object object = m_lock;
        synchronized (object) {
            int n = this.indexOf(name);
            boolean bl = false;
            if (n != -1) {
                bl = this.remove(n);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Object object = m_lock;
        synchronized (object) {
            boolean bl;
            FieldInfo fieldInfo = (FieldInfo)this.m_fieldInfos.get(index);
            long l = 0L;
            if (this.m_datasetVector != null) {
                if (fieldInfo.isSystemField()) {
                    String string = InternalResource.loadString("remove(int index)", "FieldInfos_Unsupported", "data_resources");
                    throw new UnsupportedOperationException(string);
                }
                l = this.m_datasetVector.getHandle();
            }
            if (bl = FieldInfosNative.jni_Remove(this.getHandle(), index, l)) {
                fieldInfo.clearHandle();
                this.m_fieldInfos.remove(index);
            }
            this.resetItemsHandle();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfo[] toArray() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Object object = m_lock;
        synchronized (object) {
            int n = this.getCount();
            FieldInfo[] fieldInfoArray = new FieldInfo[n];
            for (int i = 0; i < n; ++i) {
                fieldInfoArray[i] = new FieldInfo(this.get(i));
            }
            return fieldInfoArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.m_datasetVector != null) {
            String string = InternalResource.loadString("dispose", "Handle_UndisposableObject", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Object object = m_lock;
        synchronized (object) {
            if (this.getHandle() != 0L) {
                long l = this.getHandle();
                this.clearHandle();
                FieldInfosNative.jni_Delete(l);
            }
        }
    }

    FieldInfos(long handle, DatasetVector datasetVector) {
        if (datasetVector == null || datasetVector.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetVector", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setIsDisposable(false);
        this.reset(handle);
        this.m_datasetVector = datasetVector;
    }

    FieldInfos(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setIsDisposable(true);
        this.reset(handle);
    }

    DatasetVector getDataset() {
        return this.m_datasetVector;
    }

    @Override
    protected void clearHandle() {
        if (this.m_fieldInfos != null) {
            int n = this.m_fieldInfos.size();
            for (int i = 0; i < n; ++i) {
                FieldInfo fieldInfo = (FieldInfo)this.m_fieldInfos.get(i);
                fieldInfo.clearHandle();
            }
        }
        this.m_datasetVector = null;
        this.setHandle(0L);
    }

    int indexOf(FieldInfo fieldInfo) {
        int n = -1;
        if (fieldInfo != null && fieldInfo.getHandle() != 0L && this.m_fieldInfos != null) {
            n = this.m_fieldInfos.indexOf(fieldInfo);
        }
        return n;
    }

    private void reset(long handle) {
        this.m_fieldInfos = new ArrayList();
        this.setHandle(handle, false);
        int n = FieldInfosNative.jni_GetCount(handle);
        long[] lArray = new long[n];
        FieldInfosNative.jni_GetFieldInfos(handle, lArray);
        FieldInfo fieldInfo = null;
        for (int i = 0; i < lArray.length; ++i) {
            fieldInfo = new FieldInfo(lArray[i], this);
            this.m_fieldInfos.add(fieldInfo);
        }
    }

    private void resetItemsHandle() {
        int n;
        int n2 = FieldInfosNative.jni_GetCount(this.getHandle());
        long[] lArray = new long[n2];
        FieldInfosNative.jni_GetFieldInfos(this.getHandle(), lArray);
        int n3 = n2 - this.m_fieldInfos.size();
        if (n3 > 0) {
            for (n = 0; n < n3; ++n) {
                this.m_fieldInfos.add(new FieldInfo(0L));
            }
        } else if (n3 < 0) {
            for (n = n3; n < 0; ++n) {
                int n4 = this.m_fieldInfos.size() - 1;
                FieldInfo fieldInfo = (FieldInfo)this.m_fieldInfos.get(n4);
                fieldInfo.clearHandle();
                this.m_fieldInfos.add(fieldInfo);
            }
        }
        for (n = 0; n < lArray.length; ++n) {
            FieldInfo fieldInfo = (FieldInfo)this.m_fieldInfos.get(n);
            fieldInfo.setHandle(lArray[n], false);
        }
    }

    private boolean contains(String name) {
        return this.indexOf(name) != -1;
    }

    protected static FieldInfos createInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new FieldInfos(handle);
    }

    protected static void clearHandle(FieldInfos fieldInfos) {
        fieldInfos.clearHandle();
    }

    @Deprecated
    public String getFieldNameBySign(FieldSign value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return FieldInfosNative.jni_GetFieldNameBySign(this.getHandle(), value.getUGCValue());
    }

    void refresh() {
        this.resetItemsHandle();
    }
}

