/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.navigation;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.navigation.CompilerParameter;
import com.supermap.analyst.navigation.CompilerParameterSSC;
import com.supermap.analyst.navigation.DataCompilerNative;
import com.supermap.analyst.navigation.InternalDatasetVector;
import com.supermap.analyst.navigation.InternalDatasets;
import com.supermap.analyst.navigation.InternalHandle;
import com.supermap.analyst.navigation.InternalResource;
import com.supermap.analyst.navigation.InternalToolkitNavigation;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.FieldInfos;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class DataCompiler {
    private static License m_license;
    transient Vector m_steppedListeners;
    protected long m_selfEventHandle;

    protected static boolean isDirectoryExisted(String fileName) {
        File file = new File(fileName);
        boolean bl = false;
        if (file.getParent() == null) {
            bl = true;
        } else {
            File file2 = new File(file.getParent());
            if (file2.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    private void checkParameter(CompilerParameter parameter) {
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        Datasource datasource = parameter.getDatasource();
        if (datasource == null) {
            String string = InternalResource.loadString("parameter.getDatasource", "Global_ArgumentNull", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        String string = parameter.getNameRoadLine();
        if (string == null || string.isEmpty()) {
            String string2 = InternalResource.loadString("NameRoadLine", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string2);
        }
        if (datasource.getDatasets().get(string) == null) {
            String string3 = InternalResource.loadString("NameRoadLine", "Global_DatasetNameInvalide", "navigation_resources");
            throw new IllegalArgumentException(string3);
        }
        String string4 = parameter.getNameRoadPoint();
        if (string4 == null || string4.isEmpty()) {
            String string5 = InternalResource.loadString("NameRoadPoint", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string5);
        }
        if (datasource.getDatasets().get(string4) == null) {
            String string6 = InternalResource.loadString("NameRoadPoint", "Global_DatasetNameInvalide", "navigation_resources");
            throw new IllegalArgumentException(string6);
        }
        String string7 = parameter.getNameCondPoint();
        if (string7 == null || string7.isEmpty()) {
            String string8 = InternalResource.loadString("NameCondPoint", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string8);
        }
        if (datasource.getDatasets().get(string7) == null) {
            String string9 = InternalResource.loadString("NameCondPoint", "Global_DatasetNameInvalide", "navigation_resources");
            throw new IllegalArgumentException(string9);
        }
        String string10 = parameter.getNameAdminCode();
        if (string10 == null || string10.isEmpty()) {
            String string11 = InternalResource.loadString("NameAdminCode", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string11);
        }
        if (datasource.getDatasets().get(string10) == null) {
            String string12 = InternalResource.loadString("NameAdminCode", "Global_DatasetNameInvalide", "navigation_resources");
            throw new IllegalArgumentException(string12);
        }
        String string13 = parameter.getExportPath();
        if (string13 == null || string13.isEmpty()) {
            String string14 = InternalResource.loadString("ExportPath", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string14);
        }
        if (!DataCompiler.isDirectoryExisted(string13)) {
            String string15 = InternalResource.loadString("ExportPath", "GlobalDirectoryNotFound", "navigation_resources");
            throw new IllegalArgumentException(string15);
        }
    }

    public boolean compileBaseRoad(CompilerParameter parameter, int[] mapIDs) {
        DataCompiler.verifyLicense();
        this.checkParameter(parameter);
        Datasource datasource = parameter.getDatasource();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long[] lArray = new long[10];
        this.m_selfEventHandle = DataCompilerNative.jni_NewSelfEventHandle(this);
        boolean bl = DataCompilerNative.jni_compileBaseRoad(l, parameter.getNameRoadLine(), parameter.getNameRoadPoint(), parameter.getNameCondPoint(), parameter.getNameAdminCode(), parameter.getExportPath(), parameter.getDistrictName(), this.m_selfEventHandle, parameter.getSourceDataVersion().value(), lArray, mapIDs);
        for (int i = 0; i < 10; ++i) {
            if (lArray[i] == 0L) continue;
            DatasetVector datasetVector = InternalDatasetVector.createInstance(lArray[i], datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        this.clearSelfEventHandle();
        return bl;
    }

    public boolean compileGuideData(CompilerParameter parameter, int[] mapIDs) {
        DataCompiler.verifyLicense();
        this.checkParameter(parameter);
        Datasource datasource = parameter.getDatasource();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long[] lArray = new long[10];
        this.m_selfEventHandle = DataCompilerNative.jni_NewSelfEventHandle(this);
        boolean bl = DataCompilerNative.jni_compileGuideData(l, parameter.getExportPath(), parameter.getDistrictName(), this.m_selfEventHandle, lArray, mapIDs);
        for (int i = 0; i < 10; ++i) {
            if (lArray[i] == 0L) continue;
            DatasetVector datasetVector = InternalDatasetVector.createInstance(lArray[i], datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        this.clearSelfEventHandle();
        return bl;
    }

    public boolean compileTopologyData(CompilerParameter parameter, int[] mapIDs) {
        DataCompiler.verifyLicense();
        this.checkParameter(parameter);
        Datasource datasource = parameter.getDatasource();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        this.m_selfEventHandle = DataCompilerNative.jni_NewSelfEventHandle(this);
        boolean bl = DataCompilerNative.jni_compileTopologyData(l, parameter.getExportPath(), parameter.getDistrictName(), this.m_selfEventHandle, mapIDs);
        this.clearSelfEventHandle();
        return bl;
    }

    public boolean packageData(CompilerParameter parameter, int[] mapIDs) {
        int n;
        DataCompiler.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        if (parameter.getPackageTypes() == null || parameter.getPackageTypes().length == 0) {
            String string = InternalResource.loadString("packageTypes", "Global_ArrayLengthShouldGreaterThanZero", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        String string = parameter.getExportPath();
        if (string == null || string.isEmpty()) {
            String string2 = InternalResource.loadString("ExportPath", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string2);
        }
        if (!DataCompiler.isDirectoryExisted(string)) {
            String string3 = InternalResource.loadString("ExportPath", "GlobalDirectoryNotFound", "navigation_resources");
            throw new IllegalArgumentException(string3);
        }
        int n2 = parameter.getPackageTypes().length;
        int[] nArray = new int[n2];
        for (n = 0; n < n2; n += 1) {
            nArray[n] = parameter.getPackageTypes()[n].value();
        }
        this.m_selfEventHandle = DataCompilerNative.jni_NewSelfEventHandle(this);
        n = DataCompilerNative.jni_packageData(parameter.getExportPath(), nArray, this.m_selfEventHandle, mapIDs) ? 1 : 0;
        this.clearSelfEventHandle();
        return n != 0;
    }

    public boolean updatePathName(CompilerParameter parameter) {
        DataCompiler.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        Datasource datasource = parameter.getDatasource();
        if (datasource == null) {
            String string = InternalResource.loadString("parameter.getDatasource", "Global_ArgumentNull", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        String string = parameter.getNameRoadLine();
        if (string == null || string.isEmpty()) {
            String string2 = InternalResource.loadString("NameRoadLine", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string2);
        }
        if (datasource.getDatasets().get(string) == null) {
            String string3 = InternalResource.loadString("NameRoadLine", "Global_DatasetNameInvalide", "navigation_resources");
            throw new IllegalArgumentException(string3);
        }
        String string4 = parameter.getNameRoadNameLink();
        if (string4 == null || string4.isEmpty()) {
            String string5 = InternalResource.loadString("NameRoadNameLink", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string5);
        }
        if (datasource.getDatasets().get(string4) == null) {
            String string6 = InternalResource.loadString("NameRoadNameLink", "Global_DatasetNameInvalide", "navigation_resources");
            throw new IllegalArgumentException(string6);
        }
        String string7 = parameter.getNameRoadName();
        if (string7 == null || string7.isEmpty()) {
            String string8 = InternalResource.loadString("NameRoadName", "Global_StringIsNullOrEmpty", "navigation_resources");
            throw new IllegalArgumentException(string8);
        }
        if (datasource.getDatasets().get(string7) == null) {
            String string9 = InternalResource.loadString("NameRoadName", "Global_DatasetNameInvalide", "navigation_resources");
            throw new IllegalArgumentException(string9);
        }
        int n = parameter.getLanguage();
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new IllegalArgumentException("language value is invalid");
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        this.m_selfEventHandle = DataCompilerNative.jni_NewSelfEventHandle(this);
        boolean bl = DataCompilerNative.jni_updatePathName(l, parameter.getNameRoadLine(), parameter.getNameRoadNameLink(), parameter.getNameRoadName(), this.m_selfEventHandle, n);
        this.clearSelfEventHandle();
        return bl;
    }

    public int[] compileMapID(CompilerParameter parameter, String resultCoverageDatasetName) {
        DataCompiler.verifyLicense();
        this.checkParameter(parameter);
        Datasource datasource = parameter.getDatasource();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long[] lArray = new long[10];
        long l2 = 0L;
        this.m_selfEventHandle = DataCompilerNative.jni_NewSelfEventHandle(this);
        int[] nArray = DataCompilerNative.jni_compileMapID(l, parameter.getNameRoadLine(), parameter.getNameRoadPoint(), parameter.getNameCondPoint(), parameter.getNameAdminCode(), parameter.getExportPath(), parameter.getDistrictName(), resultCoverageDatasetName, this.m_selfEventHandle, lArray);
        for (int i = 0; i < 10; ++i) {
            if (lArray[i] == 0L) continue;
            DatasetVector datasetVector = InternalDatasetVector.createInstance(lArray[i], datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        this.clearSelfEventHandle();
        return nArray;
    }

    public DatasetVector extractAdminCode(DatasetVector datasetAdmin, DatasetVector datasetFName, Datasource outputDatasource, String resultDatasetName, int language) {
        DataCompiler.verifyLicense();
        if (datasetAdmin == null) {
            String string = InternalResource.loadString("datasetAdmin", "Global_ArgumentNull", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetAdmin);
        if (l == 0L) {
            String string = InternalResource.loadString("datasetAdmin", "Global_ArgumentObjectHasBeenDisposed", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetFName == null) {
            String string = InternalResource.loadString("datasetFName", "Global_ArgumentNull", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetFName);
        if (l2 == 0L) {
            String string = InternalResource.loadString("datasetFName", "Global_ArgumentObjectHasBeenDisposed", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l3 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentObjectHasBeenDisposed", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDatasetName == null || resultDatasetName.isEmpty() || !outputDatasource.getDatasets().isAvailableDatasetName(resultDatasetName)) {
            String string = InternalResource.loadString("resultDatasetName", "Global_DatasetNameInvalide", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        if (language != 1 && language != 2 && language != 3 && language != 4) {
            throw new IllegalArgumentException("language value is invalid");
        }
        long l4 = DataCompilerNative.jni_ExtractAdminCode(l, l2, l3, resultDatasetName, language);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public DatasetVector extractAdminCode(DatasetVector datasetAdmin, DatasetVector datasetFName, Datasource outputDatasource, String resultDatasetName) {
        return this.extractAdminCode(datasetAdmin, datasetFName, outputDatasource, resultDatasetName, 1);
    }

    public DatasetVector extractRoadDirection(DatasetVector datasetRoad, double segmentLength, double spacingLength, String[] roadKinds, Datasource outputDatasource, String resultDatasetName) {
        DataCompiler.verifyLicense();
        if (datasetRoad == null) {
            String string = InternalResource.loadString("datasetRoad", "Global_ArgumentNull", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetRoad);
        if (l == 0L) {
            String string = InternalResource.loadString("datasetRoad", "Global_ArgumentObjectHasBeenDisposed", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l2 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentObjectHasBeenDisposed", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultDatasetName == null || resultDatasetName.isEmpty() || !outputDatasource.getDatasets().isAvailableDatasetName(resultDatasetName)) {
            String string = InternalResource.loadString("resultDatasetName", "Global_DatasetNameInvalide", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        if (segmentLength == 0.0 || segmentLength < 0.0) {
            String string = InternalResource.loadString("segmentLength", "Must_Larger_Than_Zero", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        if (spacingLength == 0.0 || spacingLength < 0.0) {
            String string = InternalResource.loadString("spacingLength", "Must_Larger_Than_Zero", "navigation_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = DataCompilerNative.jni_NewSelfEventHandle(this);
        long l3 = DataCompilerNative.jni_ExtractRoadDirection(l, segmentLength, spacingLength, roadKinds, l2, resultDatasetName, this.m_selfEventHandle);
        DatasetVector datasetVector = null;
        this.clearSelfEventHandle();
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    @Deprecated
    public boolean compileSSCData(CompilerParameterSSC parameter) {
        String[] stringArray;
        DatasetVector datasetVector = parameter.getNetworkDataset();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("setting.getNetworkDataset()", "Global_OwnerHasBeenDisposed", "navigation_resources");
            throw new IllegalStateException(string);
        }
        DatasetType datasetType = datasetVector.getType();
        if (datasetType != DatasetType.NETWORK) {
            String string = InternalResource.loadString("setting.getNetworkDataset().getType()", "DatasetTypeMustBeNetwork", "navigation_resources");
            throw new IllegalStateException(string);
        }
        String string = parameter.getFilePath();
        if (string.trim().equals("")) {
            String string2 = InternalResource.loadString("setting.getFilePath()", "FilePathNotExist", "navigation_resources");
            throw new IllegalStateException(string2);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        String[] stringArray2 = new String[]{parameter.getNodeIDField(), parameter.getEdgeIDField(), parameter.getFNodeIDField(), parameter.getTNodeIDField(), parameter.getTurnNodeIDField(), parameter.getTurnFEdgeIDField(), parameter.getTurnTEdgeIDField(), parameter.getEdgeNameField(), parameter.getRuleField()};
        DatasetVector datasetVector2 = parameter.getTurnDataset();
        if (datasetVector2 != null && !datasetVector2.isOpen()) {
            datasetVector2.open();
        }
        String[] stringArray3 = parameter.getFTSingleWayRuleValues();
        String[] stringArray4 = parameter.getTFSingleWayRuleValues();
        String[] stringArray5 = parameter.getProhibitedWayRuleValues();
        String[] stringArray6 = parameter.getTwoWayRuleValues();
        String string3 = parameter.getWeightField();
        String[] stringArray7 = new String[]{stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3], string3, stringArray2[7]};
        if (!DataCompiler.isNetworkFieldsAllRight(stringArray7, datasetVector)) {
            String string4 = InternalResource.loadString("fields", "FieldNotInDatasetVector", "navigation_resources");
            throw new IllegalArgumentException(string4);
        }
        String[] stringArray8 = new String[]{stringArray2[0], parameter.getLevelField()};
        if (!DataCompiler.isNetworkFieldsAllRight(stringArray8, datasetVector)) {
            String string5 = InternalResource.loadString("LevelField", "FieldNotInDatasetVector", "navigation_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!parameter.getSpeedField().trim().equals("") && !DataCompiler.isNetworkFieldsAllRight(stringArray = new String[]{stringArray2[0], parameter.getSpeedField()}, datasetVector)) {
            String string6 = InternalResource.loadString("SpeedField", "FieldNotInDatasetVector", "navigation_resources");
            throw new IllegalArgumentException(string6);
        }
        long l2 = 0L;
        if (datasetVector2 != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector2);
            DatasetType datasetType2 = datasetVector2.getType();
            if (datasetType2 != DatasetType.TABULAR) {
                String string7 = InternalResource.loadString("m_analystSetting.getTurnDataset().getType()", "DatasetTypeMustBeTabular", "navigation_resources");
                throw new IllegalStateException(string7);
            }
            if (stringArray2[4] == null || stringArray2[4].trim().length() == 0) {
                String string8 = InternalResource.loadString("m_analystSetting.getTurnNodeIDField()", "Global_StringIsNullOrEmpty", "navigation_resources");
                throw new IllegalStateException(string8);
            }
            if (stringArray2[5] == null || stringArray2[5].trim().length() == 0) {
                String string9 = InternalResource.loadString("m_analystSetting.getTurnFEdgeIDField()", "Global_StringIsNullOrEmpty", "navigation_resources");
                throw new IllegalStateException(string9);
            }
            if (stringArray2[6] == null || stringArray2[6].trim().length() == 0) {
                String string10 = InternalResource.loadString("m_analystSetting.getTurnTEdgeIDField()", "Global_StringIsNullOrEmpty", "navigation_resources");
                throw new IllegalStateException(string10);
            }
            String[] stringArray9 = new String[]{stringArray2[4], stringArray2[5], stringArray2[6]};
            if (!DataCompiler.isTurnFieldsAllRight(stringArray9, datasetVector2)) {
                String string11 = InternalResource.loadString("fields", "FieldNotInDatasetVector", "navigation_resources");
                throw new IllegalArgumentException(string11);
            }
        }
        this.m_selfEventHandle = DataCompilerNative.jni_NewSelfEventHandle(this);
        boolean bl = DataCompilerNative.jni_CompileSSCData(l, l2, stringArray2, string3, stringArray3, stringArray4, stringArray5, stringArray6, string, parameter.getLevelField(), parameter.getSpeedField(), this.m_selfEventHandle);
        return bl;
    }

    private static boolean isNetworkFieldsAllRight(String[] fields, DatasetVector networkDataset) {
        int n;
        boolean bl = true;
        if (!networkDataset.open()) {
            networkDataset.open();
        }
        FieldInfos fieldInfos = networkDataset.getChildDataset().getFieldInfos();
        boolean bl2 = false;
        for (n = 0; n < fieldInfos.getCount(); ++n) {
            if (fieldInfos.get(n).getName().compareToIgnoreCase(fields[0]) != 0) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return bl2;
        }
        bl2 = false;
        fieldInfos = networkDataset.getFieldInfos();
        n = fields.length;
        for (int i = 1; i < n; ++i) {
            bl2 = false;
            for (int j = 0; j < fieldInfos.getCount(); ++j) {
                if (fieldInfos.get(j).getName().compareToIgnoreCase(fields[i]) != 0) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return bl2;
        }
        return bl;
    }

    private static boolean isTurnFieldsAllRight(String[] fields, DatasetVector networkDataset) {
        boolean bl = false;
        FieldInfos fieldInfos = networkDataset.getFieldInfos();
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < fieldInfos.getCount(); ++j) {
                if (fieldInfos.get(j).getName().compareToIgnoreCase(fields[i]) != 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return bl;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(DataCompiler source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            boolean bl = InternalToolkitNavigation.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, null, bl);
            source.fireStepped(steppedEvent);
            InternalToolkitNavigation.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)source);
    }

    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DataCompilerNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitNavigation.managerProducts(InternalToolkitNavigation.getNavigationProducts());
        m_license = InternalToolkitNavigation.verifyLicense(arrayList);
    }
}

