/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.ColorGradientType;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Enum;
import com.supermap.data.PixelFormat;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeGridUniqueItem;
import com.supermap.mapping.ThemeGridUniqueNative;
import java.awt.Color;
import java.util.ArrayList;

public class ThemeGridUnique
extends Theme {
    private ArrayList m_gridUniqueItems = null;
    private Color m_specialValueColor = Color.white;
    double m_specialValue = -9999.0;
    boolean m_isSpecialValueTransparent = false;

    public ThemeGridUnique() {
        long l = ThemeGridUniqueNative.jni_New();
        this.setHandle(l, true);
        this.setDefaultColor(Color.black);
        this.m_gridUniqueItems = new ArrayList();
    }

    public ThemeGridUnique(ThemeGridUnique themeGridUnique) {
        if (themeGridUnique == null) {
            String string = InternalResource.loadString("themeGridUnique", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeGridUnique.getHandle() == 0L) {
            String string = InternalResource.loadString("themeGridUnique", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeGridUniqueNative.jni_Clone(themeGridUnique.getHandle());
        this.setHandle(l, true);
        this.m_gridUniqueItems = new ArrayList();
        int n = themeGridUnique.getGridUniqueItemsList().size();
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeGridUnique));
        for (int i = 0; i < n; ++i) {
            ThemeGridUniqueItem themeGridUniqueItem = new ThemeGridUniqueItem(this);
            this.m_gridUniqueItems.add(themeGridUniqueItem);
        }
    }

    ThemeGridUnique(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
        this.m_gridUniqueItems = new ArrayList();
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            ThemeGridUniqueItem themeGridUniqueItem = new ThemeGridUniqueItem(this);
            this.m_gridUniqueItems.add(themeGridUniqueItem);
        }
    }

    public ThemeGridUniqueItem getItem(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return (ThemeGridUniqueItem)this.m_gridUniqueItems.get(index);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGridUniqueNative.jni_GetCount(this.getHandle());
    }

    public Color getDefaultColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGridUniqueNative.jni_GetDefaultColor(this.getHandle());
        return new Color(n, true);
    }

    public void setDefaultColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDefaultColor(Color color)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = color.getRGB();
        ThemeGridUniqueNative.jni_SetDefaultColor(this.getHandle(), n);
    }

    public int add(ThemeGridUniqueItem item) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(ThemeGridUniqueItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (item == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ThemeGridUniqueNative.jni_IsExist(this.getHandle(), item.getUnique());
        if (bl) {
            String string = InternalResource.loadString("item.getUnique()", "ThemeGridUnique_TheUniqueIsExist", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeGridUniqueItem themeGridUniqueItem = new ThemeGridUniqueItem(item);
        int n = ThemeGridUniqueNative.jni_Add(this.getHandle(), themeGridUniqueItem.getUnique(), themeGridUniqueItem.isVisible(), themeGridUniqueItem.getCaption(), themeGridUniqueItem.getColor().getRGB());
        if (n != -1) {
            ThemeGridUniqueItem themeGridUniqueItem2 = new ThemeGridUniqueItem(this);
            this.m_gridUniqueItems.add(themeGridUniqueItem2);
        }
        this.m_lock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(int index, ThemeGridUniqueItem item) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, ThemeGridUniqueItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index > n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (item == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ThemeGridUniqueNative.jni_IsExist(this.getHandle(), item.getUnique());
        if (bl) {
            String string = InternalResource.loadString("item.getUnique()", "ThemeGridUnique_TheUniqueIsExist", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl2 = false;
        try {
            this.m_lock.lock();
            ThemeGridUniqueItem themeGridUniqueItem = new ThemeGridUniqueItem(item);
            bl2 = false;
            if (index == n) {
                int n2 = ThemeGridUniqueNative.jni_Add(this.getHandle(), themeGridUniqueItem.getUnique(), themeGridUniqueItem.isVisible(), themeGridUniqueItem.getCaption(), themeGridUniqueItem.getColor().getRGB());
                if (n2 == n) {
                    bl2 = true;
                    ThemeGridUniqueItem themeGridUniqueItem2 = new ThemeGridUniqueItem(this);
                    this.m_gridUniqueItems.add(themeGridUniqueItem2);
                }
            } else {
                bl2 = ThemeGridUniqueNative.jni_Insert(this.getHandle(), index, themeGridUniqueItem.getUnique(), themeGridUniqueItem.isVisible(), themeGridUniqueItem.getCaption(), themeGridUniqueItem.getColor().getRGB());
                ThemeGridUniqueItem themeGridUniqueItem3 = new ThemeGridUniqueItem(this);
                this.m_gridUniqueItems.add(index, themeGridUniqueItem3);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl2;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        boolean bl = ThemeGridUniqueNative.jni_Remove(this.getHandle(), index);
        if (bl) {
            this.m_gridUniqueItems.remove(index);
        }
        this.m_lock.unlock();
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGridUniqueNative.jni_Clear(this.getHandle());
        if (this.m_gridUniqueItems != null) {
            this.m_gridUniqueItems.clear();
        }
        this.m_lock.unlock();
    }

    public static ThemeGridUnique makeDefault(DatasetGrid dataset, ColorGradientType colorGradientType) {
        int n;
        long l;
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l2 == 0L) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        PixelFormat pixelFormat = dataset.getPixelFormat();
        if (pixelFormat == PixelFormat.DOUBLE || pixelFormat == PixelFormat.SINGLE) {
            String string = InternalResource.loadString("pixelFormat", "ThemeGridUnique_PixelFormatOnlyIntegerValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.TERRAIN;
        }
        if ((l = ThemeGridUniqueNative.jni_MakeDefault(l2, n = InternalEnum.getUGCValue((Enum)colorGradientType))) == 0L) {
            return null;
        }
        return new ThemeGridUnique(l, true);
    }

    public static ThemeGridUnique makeDefault(DatasetGrid dataset) {
        return ThemeGridUnique.makeDefault(dataset, null);
    }

    public int indexOf(double unique) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(double unique)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGridUniqueNative.jni_IndexOf(this.getHandle(), unique);
    }

    public void reverseColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverseColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGridUniqueNative.jni_ReverseColor(this.getHandle());
        this.m_lock.unlock();
    }

    @Override
    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count = ");
        stringBuffer.append(this.getCount());
        stringBuffer.append(",DefaultColor = ");
        stringBuffer.append(this.getDefaultColor().toString());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeGridUniqueNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fromXML(String xml) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = super.fromXML(xml);
            if (bl) {
                if (this.m_gridUniqueItems != null) {
                    this.m_gridUniqueItems.clear();
                }
                int n = this.getCount();
                for (int i = 0; i < n; ++i) {
                    ThemeGridUniqueItem themeGridUniqueItem = new ThemeGridUniqueItem(this);
                    this.m_gridUniqueItems.add(themeGridUniqueItem);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    @Override
    protected void clearHandle() {
        if (this.m_gridUniqueItems != null) {
            this.m_gridUniqueItems.clear();
            this.m_gridUniqueItems = null;
        }
        this.setHandle(0L);
    }

    ArrayList getGridUniqueItemsList() {
        return this.m_gridUniqueItems;
    }

    public void setSpecialValueTransparent(boolean bSpecialValueTransparent) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layer != null) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l != 0L) {
                LayerNative.jni_SetSpecialValueTransparent(l, bSpecialValueTransparent);
                ThemeGridUniqueNative.jni_SetSpecialValueTransparent(this.getHandle(), bSpecialValueTransparent);
            }
        } else {
            this.m_isSpecialValueTransparent = bSpecialValueTransparent;
        }
    }

    public boolean isSpecialValueTransparent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.m_layer != null) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l != 0L) {
                bl = LayerNative.jni_GetSpecialValueTransparent(l);
            }
        } else {
            bl = this.m_isSpecialValueTransparent;
        }
        return bl;
    }

    @Deprecated
    public void setSpecialValue(int nSpecialValue) {
        this.setThemeSpecialValue(nSpecialValue);
    }

    @Deprecated
    public int GetSpecialValue() {
        return (int)this.getThemeSpecialValue();
    }

    public void setThemeSpecialValue(double specialValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setThemeSpecialValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layer != null) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l != 0L) {
                LayerNative.jni_setGridSpecialValue(l, specialValue);
                ThemeGridUniqueNative.jni_SetSpecialValue(this.getHandle(), specialValue);
            }
        } else {
            this.m_specialValue = specialValue;
        }
    }

    public double getThemeSpecialValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getThemeSpecialValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double d = 0.0;
        if (this.m_layer != null) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l != 0L) {
                d = LayerNative.jni_getGridSpecialValue(l);
            }
        } else {
            d = this.m_specialValue;
        }
        return d;
    }

    public Color getSpecialValueColor() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpecialValueColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layer != null && (l = InternalHandle.getHandle(this.m_layer)) != 0L) {
            int n = LayerNative.jni_GetGridSpecialValueColor(l);
            return new Color(n, true);
        }
        return this.m_specialValueColor;
    }

    public void setSpecialValueColor(Color value) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpecialValueColor(Color value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layer != null && (l = InternalHandle.getHandle(this.m_layer)) != 0L) {
            LayerNative.jni_SetGridSpecialValueColor(l, value.getRGB());
        }
        this.m_specialValueColor = new Color(value.getRGB(), true);
    }
}

