/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.GeoStyle;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.ThemeGraph;
import com.supermap.mapping.ThemeGraphItemNative;
import com.supermap.mapping.ThemeRange;

public class ThemeGraphItem
extends InternalHandleDisposable {
    private GeoStyle m_style = null;
    private ThemeRange m_rangeSetting = null;
    private ThemeGraph m_themeGraph = null;
    private boolean m_isUserThemeGraph = false;

    public ThemeGraphItem() {
        long l = ThemeGraphItemNative.jni_New();
        this.setHandle(l, true);
        this.reset();
        this.m_isUserThemeGraph = false;
    }

    public ThemeGraphItem(ThemeGraphItem themeGraphItem) {
        long l;
        if (themeGraphItem == null) {
            String string = InternalResource.loadString("themeGraphItem", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeGraphItem.m_isUserThemeGraph) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeGraphItem.m_themeGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("themeGraphItem", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            int n = themeGraphItem.m_themeGraph.getGraphItemsList().indexOf((Object)themeGraphItem);
            if (n == -1) {
                String string = InternalResource.loadString("themeGraphItem", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        } else if (themeGraphItem.getHandle() == 0L) {
            String string = InternalResource.loadString("themeGraphItem", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        l = ThemeGraphItemNative.jni_Clone(themeGraphItem.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeGraphItem));
        this.setHandle(l, true);
        this.m_isUserThemeGraph = false;
    }

    ThemeGraphItem(long handle, ThemeGraph themeGraph) {
        this.setHandle(handle, false);
        this.m_isUserThemeGraph = true;
        this.m_themeGraph = themeGraph;
    }

    public String getCaption() {
        if (this.m_isUserThemeGraph) {
            int n = this.m_themeGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphItemNative.jni_GetCaption(this.getHandle());
    }

    public void setCaption(String caption) {
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_isUserThemeGraph) {
            int n = this.m_themeGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphItemNative.jni_SetCaption(this.getHandle(), caption);
    }

    public String getGraphExpression() {
        if (this.m_isUserThemeGraph) {
            int n = this.m_themeGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getGraphExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("getGraphExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGraphExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphItemNative.jni_GetGraphExpression(this.getHandle());
    }

    public void setGraphExpression(String graphExpression) {
        if (graphExpression == null || graphExpression.trim().length() == 0) {
            String string = InternalResource.loadString("graphExpression", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_isUserThemeGraph) {
            int n = this.m_themeGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("setGraphExpression(String graphExpression)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("setGraphExpression(String graphExpression)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGraphExpression(String graphExpression)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphItemNative.jni_SetGraphExpression(this.getHandle(), graphExpression);
    }

    public GeoStyle getUniformStyle() {
        long l;
        if (this.m_isUserThemeGraph) {
            int n = this.m_themeGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getUniformStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGraph);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getUniformStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getUniformStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (this.m_style == null && (l = ThemeGraphItemNative.jni_GetUniformStyle(this.getHandle())) != 0L) {
            this.m_style = InternalGeoStyle.createInstance(l);
        }
        return this.m_style;
    }

    public void setUniformStyle(GeoStyle uniformStyle) {
        if (this.m_isUserThemeGraph) {
            int n = this.m_themeGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("setUniformStyle(GeoStyle uniformStyle)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("setUniformStyle(GeoStyle uniformStyle)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUniformStyle(GeoStyle uniformStyle)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (uniformStyle == null) {
            String string = InternalResource.loadString("uniformStyle", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)uniformStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("uniformStyle", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle = uniformStyle.clone();
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        ThemeGraphItemNative.jni_SetUniformStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    public ThemeRange getRangeSetting() {
        long l;
        if (this.m_isUserThemeGraph) {
            int n = this.m_themeGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getRangeSetting()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGraph);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getRangeSetting()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRangeSetting()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_rangeSetting == null && (l = ThemeGraphItemNative.jni_GetRangeSetting(this.getHandle())) != 0L) {
            this.m_rangeSetting = new ThemeRange(l, false);
        }
        return this.m_rangeSetting;
    }

    public void setRangeSetting(ThemeRange rangeSetting) {
        if (this.m_isUserThemeGraph) {
            int n = this.m_themeGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("setRangeSetting(ThemeRange rangeSetting)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("setRangeSetting(ThemeRange rangeSetting)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRangeSetting(ThemeRange rangeSetting)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (rangeSetting == null) {
            if (this.m_rangeSetting != null) {
                this.m_rangeSetting.clearHandle();
                this.m_rangeSetting = null;
            }
            ThemeGraphItemNative.jni_SetRangeSetting(this.getHandle(), 0L);
        } else {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)rangeSetting);
            if (l == 0L) {
                String string = InternalResource.loadString("rangeSetting", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            ThemeGraphItemNative.jni_SetRangeSetting(this.getHandle(), l);
            if (this.m_rangeSetting != null) {
                this.m_rangeSetting.fromXML(rangeSetting.toXML());
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)rangeSetting));
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeGraphItemNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public double[] getMemoryDoubleValues() {
        if (this.m_isUserThemeGraph) {
            int n = this.m_themeGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getMemoryDoubleValues()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("getMemoryDoubleValues()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMemoryDoubleValues()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = ThemeGraphItemNative.jni_GetDoubleMemoryValues(this.getHandle());
        return dArray;
    }

    public void setMemoryDoubleValues(double[] values) {
        if (this.m_isUserThemeGraph) {
            int n = this.m_themeGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("SetMemoryDoubleValues(double[] values)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("SetMemoryDoubleValues(double[] values)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (values == null) {
                if (this.m_themeGraph.getMemoryKeys().length > 0) {
                    String string = InternalResource.loadString("values", "ThemeGraphItem_TheLengthOfArgumentShouldBeEqualWithTheLengthOfMemoryKeys", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
            } else if (values.length != this.m_themeGraph.getMemoryKeys().length) {
                String string = InternalResource.loadString("values", "ThemeGraphItem_TheLengthOfArgumentShouldBeEqualWithTheLengthOfMemoryKeys", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetMemoryDoubleValues(double[] values)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphItemNative.jni_SetDoubleMemoryValues(this.getHandle(), values);
    }

    public String toString() {
        if (this.m_isUserThemeGraph) {
            int n = this.m_themeGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Caption = ");
        stringBuffer.append(this.getCaption());
        stringBuffer.append(",GraphExpression = ");
        stringBuffer.append(this.getGraphExpression());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    protected void clearHandle() {
        if (this.m_style != null) {
            InternalGeoStyle.clearHandle(this.m_style);
            this.m_style = null;
        }
        if (this.m_rangeSetting != null) {
            this.m_rangeSetting.clearHandle();
            this.m_rangeSetting = null;
        }
        this.setHandle(0L);
    }

    protected void reset() {
        if (this.getHandle() != 0L) {
            ThemeGraphItemNative.jni_Reset(this.getHandle());
        }
    }

    private void changeHandle(long handle) {
        this.setHandle(handle, false);
    }

    void refreshItemAndStyle(long itemHandle, long styleHandle) {
        if (this.m_isUserThemeGraph) {
            this.changeHandle(itemHandle);
            if (this.m_style != null) {
                InternalGeoStyle.refreshHandle(this.m_style, styleHandle);
            }
        }
    }
}

