/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Colors;
import com.supermap.data.MemRecordset;
import com.supermap.mapping.AggregationFunctionType;
import com.supermap.mapping.ColorType;
import com.supermap.mapping.InternalColors;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalMapControl;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerHeatmapNative;
import com.supermap.mapping.Layers;
import com.supermap.mapping.Map;
import java.awt.Color;

public class LayerHeatmap
extends Layer {
    private MemRecordset m_MemRecordset = null;

    protected LayerHeatmap(long handle, Layers layers, Map map) {
        super(handle, layers, map);
    }

    public int getKernelRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getKernelRadius()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerHeatmapNative.jni_GetKernelRadius(this.getHandle());
    }

    public void setKernelRadius(int radius) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setKernelRadius(int radius)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerHeatmapNative.jni_SetKernelRadius(this.getHandle(), radius);
    }

    public Color getMaxColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(LayerHeatmapNative.jni_GetMaxColor(this.getHandle()), true);
        return color;
    }

    public void setMaxColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxColor(Color color)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerHeatmapNative.jni_SetMaxColor(this.getHandle(), color.getRGB());
    }

    public Color getMinColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(LayerHeatmapNative.jni_GetMinColor(this.getHandle()), true);
        return color;
    }

    public void setMinColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinColor(Color color)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerHeatmapNative.jni_SetMinColor(this.getHandle(), color.getRGB());
    }

    public void setMaxValue(double vlaue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxValue(int radius)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerHeatmapNative.jni_SetMaxValue(this.getHandle(), vlaue);
    }

    public double getMaxValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerHeatmapNative.jni_GetMaxValue(this.getHandle());
    }

    public void setMinValue(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinValue(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerHeatmapNative.jni_SetMinValue(this.getHandle(), value);
    }

    public double getMinValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerHeatmapNative.jni_GetMinValue(this.getHandle());
    }

    public void setIntensity(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIntensity(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerHeatmapNative.jni_SetIntensity(this.getHandle(), value);
    }

    public double getIntensity() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIntensity()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerHeatmapNative.jni_GetIntensity(this.getHandle());
    }

    public void setFuzzyDegree(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFuzzyDegree(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        InternalMapControl.waitDrawingCompleted(this.m_map.getMapControl());
        LayerHeatmapNative.jni_SetFuzzyDegree(this.getHandle(), value);
    }

    public double getFuzzyDegree() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFuzzyDegree()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerHeatmapNative.jni_GetFuzzyDegree(this.getHandle());
    }

    public void setWeightField(String field) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setConnectionInfo(String info)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (field == null) {
            String string = InternalResource.loadString("info", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerHeatmapNative.jni_SetWeightField(this.getHandle(), field);
    }

    public String getWeightField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWeightField()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerHeatmapNative.jni_GetWeightField(this.getHandle());
    }

    public boolean getIsUserDef() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsUserDef()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerHeatmapNative.jni_GetIsUserDef(this.getHandle());
    }

    public void setIsUserDef(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsUserDef(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerHeatmapNative.jni_SetIsUserDef(this.getHandle(), value);
    }

    public double getInternalMaxValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInternalMaxValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerHeatmapNative.jni_GetInternalMaxValue(this.getHandle());
    }

    public double getInternalMinValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInternalMinValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerHeatmapNative.jni_GetInternalMinValue(this.getHandle());
    }

    public boolean getIsUseCurrentView() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsUseCurrentView()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerHeatmapNative.jni_GetIsUseCurrentView(this.getHandle());
    }

    public void setIsUseCurrentView(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsUseCurrentView(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerHeatmapNative.jni_SetIsUseCurrentView(this.getHandle(), value);
    }

    public double getCurrentWindowMaxValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentWindowMaxValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerHeatmapNative.jni_GetCurrentWindowMaxValue(this.getHandle());
    }

    public double getCurrentWindowMinValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentWindowMinValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerHeatmapNative.jni_GetCurrentWindowMinValue(this.getHandle());
    }

    public MemRecordset getMemRecordset() {
        return this.m_MemRecordset;
    }

    protected void setMemRecordset(MemRecordset recodset) {
        this.m_MemRecordset = recodset;
    }

    public void updateData() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOpenMPThreadCount(int count)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        InternalMapControl.waitDrawingCompleted(this.m_map.getMapControl());
        LayerHeatmapNative.jni_UpdateData(this.getHandle());
    }

    public void setUserdefMaxScale(double scale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUserdefMaxScale(double scale)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerHeatmapNative.jni_SetUserdefMaxScale(this.getHandle(), scale);
    }

    public double getUserdefMaxScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString(" getUserdefMaxScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double d = LayerHeatmapNative.jni_GetUserdefMaxScale(this.getHandle());
        return d;
    }

    public AggregationFunctionType getAggregationFun() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAggregationFun()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = LayerHeatmapNative.jni_GetAggregationFun(this.getHandle());
        AggregationFunctionType aggregationFunctionType = AggregationFunctionType.toAggregationType(string);
        return aggregationFunctionType;
    }

    public void setAggregationFun(AggregationFunctionType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAggregationFun(AggregationFunctionType type)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = AggregationFunctionType.fromAggregationType(type);
        LayerHeatmapNative.jni_SetAggregationFun(this.getHandle(), string);
    }

    public void setColorset(Colors colors) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorset(Colors colors)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (colors == null) {
            String string = InternalResource.loadString("colors", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        if (l == 0L) {
            String string = InternalResource.loadString("colors", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerHeatmapNative.jni_SetColorset(this.getHandle(), l);
    }

    public Colors getColorset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorset()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = LayerHeatmapNative.jni_GetColorset(this.getHandle());
        Colors colors = InternalColors.createInstance(l, false);
        return colors;
    }

    public void setGradientColorType(ColorType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGradientColorType(ColorType type)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerHeatmapNative.jni_SetColorType(this.getHandle(), InternalEnum.getUGCValue(type));
    }

    public ColorType getGradientColorType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGradientColorType()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = LayerHeatmapNative.jni_GetColorType(this.getHandle());
        ColorType colorType = (ColorType)InternalEnum.parseUGCValue(ColorType.class, n);
        return colorType;
    }
}

