/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Colors;
import com.supermap.data.GeoStyle;
import com.supermap.data.MemRecordset;
import com.supermap.data.TextStyle;
import com.supermap.mapping.AggregationFunctionType;
import com.supermap.mapping.ColorType;
import com.supermap.mapping.InternalColors;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalTextStyle;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerGridAggregationNative;
import com.supermap.mapping.LayerGridAggregationType;
import com.supermap.mapping.Layers;
import com.supermap.mapping.Map;
import java.awt.Color;

public class LayerGridAggregation
extends Layer {
    private MemRecordset m_MemRecordset = null;

    protected LayerGridAggregation(long handle, Layers layers, Map map) {
        super(handle, layers, map);
    }

    public Color getMaxColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(LayerGridAggregationNative.jni_GetMaxColor(this.getHandle()), true);
        return color;
    }

    public void setMaxColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxColor(Color color)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerGridAggregationNative.jni_SetMaxColor(this.getHandle(), color.getRGB());
    }

    public Color getMinColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(LayerGridAggregationNative.jni_GetMinColor(this.getHandle()), true);
        return color;
    }

    public void setMinColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinColor(Color color)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerGridAggregationNative.jni_SetMinColor(this.getHandle(), color.getRGB());
    }

    public void setWeightField(String field) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWeightField(String field)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (field == null) {
            String string = InternalResource.loadString("info", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerGridAggregationNative.jni_SetWeightField(this.getHandle(), field);
    }

    public String getWeightField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWeightField()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerGridAggregationNative.jni_GetWeightField(this.getHandle());
    }

    public void setGridLineStyle(GeoStyle style) {
        if (style == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)style) == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle = style.clone();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        LayerGridAggregationNative.jni_SetGridLineStyle(this.getHandle(), l);
    }

    public GeoStyle getGridLineStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetGridLineStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        GeoStyle geoStyle = null;
        long l = LayerGridAggregationNative.jni_GetGridLineStyle(this.getHandle());
        if (l != 0L) {
            geoStyle = InternalGeoStyle.createInstance(l);
        }
        return geoStyle;
    }

    public void setGridLabelStyle(TextStyle style) {
        if (style == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)style) == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle = style.clone();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
        LayerGridAggregationNative.jni_SetGridLabelStyle(this.getHandle(), l);
    }

    public TextStyle getGridLabelStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetGridLineStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        TextStyle textStyle = null;
        long l = LayerGridAggregationNative.jni_GetGridLabelStyle(this.getHandle());
        if (l != 0L) {
            textStyle = InternalTextStyle.createInstance(l);
        }
        return textStyle;
    }

    public void setIsShowGridLabel(boolean isShow) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetIsShowGridLabel()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerGridAggregationNative.jni_SetIsShowLabel(this.getHandle(), isShow);
    }

    public boolean getIsShowGridLabel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetIsShowGridLabel()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = LayerGridAggregationNative.jni_GetIsShowLabel(this.getHandle());
        return bl;
    }

    public void setOriginalPointStyle(GeoStyle style) {
        if (style == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)style) == 0L) {
            String string = InternalResource.loadString("setOriginalPointStyle", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle = style.clone();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        LayerGridAggregationNative.jni_SetOriginalPointStyle(this.getHandle(), l);
    }

    public GeoStyle getOriginalPointStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOriginalPointStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        GeoStyle geoStyle = null;
        long l = LayerGridAggregationNative.jni_GetOriginalPointStyle(this.getHandle());
        if (l != 0L) {
            geoStyle = InternalGeoStyle.createInstance(l);
        }
        return geoStyle;
    }

    public void setGridAggregationType(LayerGridAggregationType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridAggregationType(LayerGridAggregationType type)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerGridAggregationNative.jni_SetGridType(this.getHandle(), type.value());
    }

    public LayerGridAggregationType getGridAggregationType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridAggregationType()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = LayerGridAggregationNative.jni_GetGridType(this.getHandle());
        return (LayerGridAggregationType)InternalEnum.parseUGCValue(LayerGridAggregationType.class, n);
    }

    public void setGridWidth(int width) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridWidth(int width)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerGridAggregationNative.jni_SetGridWidth(this.getHandle(), width);
    }

    public int getGridwidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridwidth()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = LayerGridAggregationNative.jni_GetGridWidth(this.getHandle());
        return n;
    }

    public void setGridHeight(int height) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridHeight(int height)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerGridAggregationNative.jni_SetGridHeight(this.getHandle(), height);
    }

    public int getGridHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridHeight()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = LayerGridAggregationNative.jni_GetGridHeight(this.getHandle());
        return n;
    }

    public MemRecordset getMemRecordset() {
        return this.m_MemRecordset;
    }

    protected void setMemRecordset(MemRecordset recodset) {
        this.m_MemRecordset = recodset;
    }

    public void updateData() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("updateData()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerGridAggregationNative.jni_UpdateData(this.getHandle());
    }

    public void setUserdefMaxScale(double scale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUserdefMaxScale(double scale)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerGridAggregationNative.jni_SetUserdefMaxScale(this.getHandle(), scale);
    }

    public double getUserdefMaxScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUserdefMaxScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double d = LayerGridAggregationNative.jni_GetUserdefMaxScale(this.getHandle());
        return d;
    }

    public AggregationFunctionType getAggregationFun() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAggregationFun()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = LayerGridAggregationNative.jni_GetAggregationFun(this.getHandle());
        AggregationFunctionType aggregationFunctionType = AggregationFunctionType.toAggregationType(string);
        return aggregationFunctionType;
    }

    public void setAggregationFun(AggregationFunctionType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAggregationFun(AggregationFunctionType type)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = AggregationFunctionType.fromAggregationType(type);
        LayerGridAggregationNative.jni_SetAggregationFun(this.getHandle(), string);
    }

    public void setColorset(Colors colors) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorset(Colors colors)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (colors == null) {
            String string = InternalResource.loadString("colors", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        if (l == 0L) {
            String string = InternalResource.loadString("colors", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerGridAggregationNative.jni_SetColorset(this.getHandle(), l);
    }

    public Colors getColorset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorset()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = LayerGridAggregationNative.jni_GetColorset(this.getHandle());
        Colors colors = InternalColors.createInstance(l, false);
        return colors;
    }

    public void setGradientColorType(ColorType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGradientColorType(ColorType type)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerGridAggregationNative.jni_SetColorType(this.getHandle(), InternalEnum.getUGCValue(type));
    }

    public ColorType getGradientColorType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGradientColorType()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = LayerGridAggregationNative.jni_GetColorType(this.getHandle());
        ColorType colorType = (ColorType)InternalEnum.parseUGCValue(ColorType.class, n);
        return colorType;
    }

    public void setValueDigit(int digit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setValueDigit(int digit)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerGridAggregationNative.jni_SetValueDigit(this.getHandle(), digit);
    }

    public int getValueDigit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getValueDigit()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerGridAggregationNative.jni_GetValueDigit(this.getHandle());
    }
}

