/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalResource;
import com.supermap.data.ToleranceNative;
import com.supermap.data.Toolkit;

public class Tolerance {
    private double m_dangle = 0.0;
    private double m_fuzzy = 0.0;
    private double m_grain = 0.0;
    private double m_nodeSnap = 0.0;
    private double m_smallPolygon = 0.0;
    private double m_extend = 0.0;
    private UserType m_type = UserType.NONE;
    private InternalHandle m_obj = null;
    private boolean m_isUserCreated = true;

    public Tolerance() {
        this.m_dangle = 0.0;
        this.m_fuzzy = 0.0;
        this.m_grain = 0.0;
        this.m_nodeSnap = 0.0;
        this.m_smallPolygon = 0.0;
        this.m_extend = 0.0;
        this.m_type = UserType.NONE;
        this.m_isUserCreated = true;
    }

    public Tolerance(Tolerance tolerance) {
        long l;
        if (tolerance == null) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance.getUserType() != UserType.NONE.value() && (l = tolerance.getHandle()) == 0L) {
            String string = InternalResource.loadString("tolerance", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setDangle(tolerance.getDangle());
        this.setFuzzy(tolerance.getFuzzy());
        this.setGrain(tolerance.getGrain());
        this.setNodeSnap(tolerance.getNodeSnap());
        this.setSmallPolygon(tolerance.getSmallPolygon());
        this.setExtend(tolerance.getExtend());
    }

    Tolerance(InternalHandle obj, UserType type) {
        if (obj == null || obj.getHandle() == 0L) {
            String string = InternalResource.loadString("obj", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (type.equals(UserType.NONE)) {
            String string = InternalResource.loadString("type", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_obj = obj;
        this.m_type = type;
        this.m_isUserCreated = false;
    }

    public double getDangle() {
        if (!this.isValid()) {
            String string = InternalResource.loadString("getDangle()", "Tolerance_ObjectIsDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserCreated()) {
            return this.m_dangle;
        }
        return ToleranceNative.jni_GetDangle(this.getHandle(), this.getUserType());
    }

    public void setDangle(double value) {
        if (!this.isValid()) {
            String string = InternalResource.loadString("setDangle(double value)", "Tolerance_ObjectIsDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Tolerance_DangleShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserCreated()) {
            this.m_dangle = value;
        } else {
            ToleranceNative.jni_SetDangle(this.getHandle(), this.getUserType(), value);
        }
    }

    @Deprecated
    public double getFuzzy() {
        if (!this.isValid()) {
            String string = InternalResource.loadString("getFuzzy()", "Tolerance_ObjectIsDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserCreated()) {
            return this.m_fuzzy;
        }
        return ToleranceNative.jni_GetFuzzy(this.getHandle(), this.getUserType());
    }

    @Deprecated
    public void setFuzzy(double value) {
        if (!this.isValid()) {
            String string = InternalResource.loadString("setFuzzy(double value)", "Tolerance_ObjectIsDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Tolerance_FuzzyShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserCreated()) {
            this.m_fuzzy = value;
        } else {
            ToleranceNative.jni_SetFuzzy(this.getHandle(), this.getUserType(), value);
        }
    }

    public double getGrain() {
        if (!this.isValid()) {
            String string = InternalResource.loadString("getGrain()", "Tolerance_ObjectIsDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserCreated()) {
            return this.m_grain;
        }
        return ToleranceNative.jni_GetGrain(this.getHandle(), this.getUserType());
    }

    public void setGrain(double value) {
        if (!this.isValid()) {
            String string = InternalResource.loadString("setGrain(double value)", "Tolerance_ObjectIsDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Tolerance_GrainShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserCreated()) {
            this.m_grain = value;
        } else {
            ToleranceNative.jni_SetGrain(this.getHandle(), this.getUserType(), value);
        }
    }

    public double getNodeSnap() {
        if (!this.isValid()) {
            String string = InternalResource.loadString("getNodeSnap()", "Tolerance_ObjectIsDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserCreated()) {
            return this.m_nodeSnap;
        }
        return ToleranceNative.jni_GetNodeSnap(this.getHandle(), this.getUserType());
    }

    public void setNodeSnap(double value) {
        if (!this.isValid()) {
            String string = InternalResource.loadString("setNodeSnap(double value)", "Tolerance_ObjectIsDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Tolerance_NodeSnapShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserCreated()) {
            this.m_nodeSnap = value;
        } else {
            ToleranceNative.jni_SetNodeSnap(this.getHandle(), this.getUserType(), value);
        }
    }

    public double getSmallPolygon() {
        if (!this.isValid()) {
            String string = InternalResource.loadString("getSmallPolygon()", "Tolerance_ObjectIsDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserCreated()) {
            return this.m_smallPolygon;
        }
        return ToleranceNative.jni_GetSmallPolygon(this.getHandle(), this.getUserType());
    }

    public void setSmallPolygon(double value) {
        if (!this.isValid()) {
            String string = InternalResource.loadString("setSmallPolygon(double value)", "Tolerance_ObjectIsDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Tolerance_SmallPolygonShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserCreated()) {
            this.m_smallPolygon = value;
        } else {
            ToleranceNative.jni_SetSmallPolygon(this.getHandle(), this.getUserType(), value);
        }
    }

    public double getExtend() {
        if (!this.isValid()) {
            String string = InternalResource.loadString("getDangle()", "Tolerance_ObjectIsDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserCreated()) {
            return this.m_extend;
        }
        return ToleranceNative.jni_GetExtend(this.getHandle(), this.getUserType());
    }

    public void setExtend(double value) {
        if (!this.isValid()) {
            String string = InternalResource.loadString("setDangle(double value)", "Tolerance_ObjectIsDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Tolerance_DangleShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserCreated()) {
            this.m_extend = value;
        } else {
            ToleranceNative.jni_SetExtend(this.getHandle(), this.getUserType(), value);
        }
    }

    public boolean isEmpty() {
        boolean bl = true;
        bl = bl && Toolkit.isZero(this.getDangle());
        bl = bl && Toolkit.isZero(this.getFuzzy());
        bl = bl && Toolkit.isZero(this.getGrain());
        bl = bl && Toolkit.isZero(this.getNodeSnap());
        bl = bl && Toolkit.isZero(this.getSmallPolygon());
        bl = bl && Toolkit.isZero(this.getExtend());
        return bl;
    }

    public void setEmpty() {
        if (!this.isValid()) {
            String string = InternalResource.loadString("setEmpty()", "Tolerance_ObjectIsDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.setDangle(0.0);
        this.setFuzzy(0.0);
        this.setGrain(0.0);
        this.setNodeSnap(0.0);
        this.setSmallPolygon(0.0);
        this.setExtend(0.0);
    }

    public void setDefault() {
        if (!this.isValid()) {
            String string = InternalResource.loadString("setDefault()", "Tolerance_ObjectIsDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserCreated()) {
            this.m_dangle = 0.0;
            this.m_fuzzy = 0.0;
            this.m_grain = 0.0;
            this.m_nodeSnap = 0.0;
            this.m_smallPolygon = 0.0;
            this.m_extend = 0.0;
        } else {
            ToleranceNative.jni_SetToleranceToDefault(this.getHandle(), this.getUserType());
        }
    }

    private boolean isUserCreated() {
        return this.m_isUserCreated;
    }

    private boolean isValid() {
        return this.isUserCreated() || this.m_obj != null && this.getHandle() != 0L;
    }

    private long getHandle() {
        return this.m_obj.getHandle();
    }

    private int getUserType() {
        return this.m_type.value();
    }

    static class UserType
    extends Enum {
        public static final UserType NONE = new UserType(1, 1);
        public static final UserType DATASETVECTOR = new UserType(2, 2);

        private UserType(int value, int ugcValue) {
            super(value, ugcValue);
        }
    }
}

