/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.Environment;
import com.supermap.data.LogFileNative;
import com.supermap.data.LogLevel;
import com.supermap.data.LogTimeInterval;

public class LogFile {
    private static String folder = "";
    private static LogTimeInterval timeInverval = LogTimeInterval.NONE;

    private LogFile() {
    }

    public static LogLevel getLevel() {
        int n = LogFileNative.jni_GetLogLevel();
        return (LogLevel)Enum.parseUGCValue(LogLevel.class, n);
    }

    public static void setLevel(LogLevel value) {
        LogFileNative.jni_SetLogLevel(value.getUGCValue());
    }

    public static String getFolder() {
        return folder;
    }

    public static void setFolder(String value) {
        if (value == null) {
            value = "";
        }
        folder = value;
    }

    public static int getMaxSize() {
        return LogFileNative.jni_GetMaxSize();
    }

    public static void setMaxSize(int value) {
        LogFileNative.jni_SetMaxSize(value);
    }

    public static LogTimeInterval getTimeInterval() {
        return timeInverval;
    }

    public static void setTimeInterval(LogTimeInterval value) {
        timeInverval = value;
    }

    public static boolean open() {
        return LogFileNative.jni_Open(folder, timeInverval.getUGCValue());
    }

    public static void close() {
        LogFileNative.jni_Close();
    }

    private static void reset() {
        LogFile.setFolder("");
        LogFile.setLevel(LogLevel.DEBUG);
        LogFile.setMaxSize(-1);
        LogFile.setTimeInterval(LogTimeInterval.NONE);
    }

    static {
        Environment.LoadWrapJ();
        LogFile.reset();
    }
}

