/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.supermap.data.Environment;
import com.supermap.data.License;
import com.supermap.data.LicenseFeatureInfo;
import com.supermap.data.LicenseService;
import com.supermap.data.ProductType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Deprecated
public class LicenseFileServiceImpl
implements LicenseService {
    private static String VERSION = "700";
    static int SuperMap_License_Error_Code_Base = 5000;
    static int SuperMap_License_Error_LaterExpiredDate = SuperMap_License_Error_Code_Base + 1;
    static int SuperMap_License_Error_EarlyStartDate = SuperMap_License_Error_Code_Base + 2;
    static int SuperMap_License_Error_WrongLicenseData = SuperMap_License_Error_Code_Base + 3;
    static int SuperMap_License_Error_WrongProductVersion = SuperMap_License_Error_Code_Base + 4;
    static int SuperMap_License_Error_EncryptFailed = SuperMap_License_Error_Code_Base + 5;
    static int SuperMap_License_Error_ComputerNameError = SuperMap_License_Error_Code_Base + 6;
    static int SuperMap_License_Error_FeatrueNotFound = SuperMap_License_Error_Code_Base + 7;
    static int SuperMap_License_Error_SpecifyMACNotFound = SuperMap_License_Error_Code_Base + 8;
    static int SuperMap_License_Error_WrongFeatureInLicData = SuperMap_License_Error_Code_Base + 9;
    static int SuperMap_License_Error_LostLicenseFile = SuperMap_License_Error_Code_Base + 10;
    private static String g_currentUsedLicFile;
    private static String g_inputLicFilePath;
    private static List<String> g_MACList;
    private static List<Long> g_MACNumList;
    private static String g_specifyLicenseXML;
    private static boolean g_useMemory;
    private LicenseFeatureInfo m_featureInfo = null;
    private String m_user = "";
    private String m_company = "";
    private boolean m_isCloudLicense = false;
    static String PROGRAM_PATH;
    static String OPT_PATH;

    public static boolean findAndReadLicFile() {
        Serializable serializable;
        g_useMemory = false;
        if (g_specifyLicenseXML != null && !g_specifyLicenseXML.isEmpty()) {
            g_useMemory = true;
            return true;
        }
        if (g_inputLicFilePath != null && !g_inputLicFilePath.isEmpty() && ((File)(serializable = new File(g_inputLicFilePath))).exists() && ((File)serializable).isFile()) {
            g_currentUsedLicFile = g_inputLicFilePath;
            return true;
        }
        serializable = new ArrayList<String>();
        ((ArrayList)serializable).add(g_inputLicFilePath);
        ((ArrayList)serializable).add(Environment.getUGOBasePath());
        ((ArrayList)serializable).add(PROGRAM_PATH);
        ((ArrayList)serializable).add(OPT_PATH);
        String string = System.getProperty("java.home");
        ((ArrayList)serializable).add(string);
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".LIC9D");
            }
        };
        File file = null;
        Iterator iterator = ((ArrayList)serializable).iterator();
        while (iterator.hasNext()) {
            File[] fileArray;
            String string2 = (String)iterator.next();
            if (string2 == null || string2.isEmpty() || !(file = new File(string2)).exists() || (fileArray = file.listFiles(filenameFilter)).length <= 0) continue;
            g_currentUsedLicFile = fileArray[0].getAbsolutePath();
            break;
        }
        return g_currentUsedLicFile != null && !g_currentUsedLicFile.isEmpty();
    }

    @Override
    public void dispose() {
    }

    @Override
    public int connect(ProductType product) {
        return this.connect(product.getUGCValue());
    }

    @Override
    public int connect(int featureID) {
        Object object;
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return SuperMap_License_Error_WrongLicenseData;
        }
        this.m_isCloudLicense = false;
        if (g_useMemory) {
            object = null;
            try {
                object = new ByteArrayInputStream(g_specifyLicenseXML.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            try {
                document = documentBuilder.parse((InputStream)object);
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
                return SuperMap_License_Error_WrongLicenseData;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return SuperMap_License_Error_WrongLicenseData;
            }
        }
        try {
            object = new File(g_currentUsedLicFile);
            if (!((File)object).exists()) {
                return SuperMap_License_Error_LostLicenseFile;
            }
            document = documentBuilder.parse((File)object);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return SuperMap_License_Error_WrongLicenseData;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return SuperMap_License_Error_WrongLicenseData;
        }
        catch (Exception exception) {
            return SuperMap_License_Error_WrongLicenseData;
        }
        this.m_featureInfo = new LicenseFeatureInfo();
        this.m_featureInfo.m_id = featureID;
        object = null;
        String string = "";
        Element element = document.getDocumentElement();
        String string2 = new Integer(featureID).toString();
        NodeList nodeList = element.getElementsByTagName("feature");
        Element element2 = null;
        boolean bl = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element2 = (Element)nodeList.item(i);
            object = License.getFirstElementByName(element2, "id");
            string = object.getFirstChild().getNodeValue();
            if (!string.equals(string2)) continue;
            bl = true;
            break;
        }
        if (bl) {
            object = License.getFirstElementByName(element, "signature");
            String string3 = object.getFirstChild().getNodeValue();
            object = License.getFirstElementByName(element2, "licdata");
            string = object.getFirstChild().getNodeValue();
            byte[] byArray = null;
            try {
                byArray = Base64.decode(string);
            }
            catch (Base64DecodingException base64DecodingException) {
                base64DecodingException.printStackTrace();
                return SuperMap_License_Error_WrongLicenseData;
            }
            String string4 = new String(LicenseFileServiceImpl.decrypt(byArray));
            int n = LicenseFileServiceImpl.verifyLicense(string4, this.m_featureInfo, string3);
            if (n != 0) {
                this.m_featureInfo = null;
                return n;
            }
            this.m_featureInfo.m_licData = string;
            object = License.getFirstElementByName(element2, "name");
            this.m_featureInfo.m_name = string = object.getFirstChild().getNodeValue();
            object = License.getFirstElementByName(element, "user");
            this.m_user = string = object.getFirstChild().getNodeValue();
            object = License.getFirstElementByName(element, "company");
            this.m_company = string = object.getFirstChild().getNodeValue();
            object = License.getFirstElementByName(element2, "maxlogins");
            if (object != null) {
                string = object.getFirstChild().getNodeValue();
                this.m_featureInfo.m_maxlogins = Integer.parseInt(string);
            }
            if ((object = License.getFirstElementByName(element, "access")) != null) {
                string = object.getFirstChild().getNodeValue();
                this.m_isCloudLicense = string.equals("cloud");
            }
            this.m_featureInfo.m_keyType = "File License";
            if (featureID >= 65400 && featureID < 65420) {
                this.m_featureInfo.m_isTrial = true;
            }
            return 0;
        }
        return SuperMap_License_Error_FeatrueNotFound;
    }

    @Override
    public int verify() {
        if (this.m_featureInfo != null) {
            return this.connect((int)this.m_featureInfo.getID());
        }
        return SuperMap_License_Error_WrongLicenseData;
    }

    @Override
    public void disconnect() {
        this.m_featureInfo = null;
    }

    @Override
    public String getUser() {
        return this.m_user;
    }

    @Override
    public String getCompany() {
        return this.m_company;
    }

    @Override
    public Boolean isCloudLicense() {
        return this.m_isCloudLicense;
    }

    public static String getSpecifyLicenseFilePath() {
        return g_inputLicFilePath;
    }

    public static void setSpecifyLicenseFilePath(String value) {
        g_inputLicFilePath = value;
        LicenseFileServiceImpl.findAndReadLicFile();
    }

    public static String getSpecifyLicenseXML() {
        return g_specifyLicenseXML;
    }

    public static void setSpecifyLicenseXML(String value) {
        g_specifyLicenseXML = value;
        LicenseFileServiceImpl.findAndReadLicFile();
    }

    @Override
    public LicenseFeatureInfo getFeatureInfo() {
        return this.m_featureInfo;
    }

    @Override
    public String getErrorMessage(int code) {
        String string = "";
        switch (code) {
            case 0: {
                string = "";
                break;
            }
            case 4000: {
                string = "SuperMap_License_Error_Cannot_Find_LicenseInstance";
                break;
            }
            case 4001: {
                string = "SuperMap_License_Error_Hasp_Load_Library_Error";
                break;
            }
            case 5000: {
                string = "SuperMap_licensefile_7C_unknown_error";
                break;
            }
            case 5001: {
                string = "SuperMap_licensefile_7C_later_than_ExpiredDate";
                break;
            }
            case 5002: {
                string = "SuperMap_License_Error_early_than_StartDate";
                break;
            }
            case 5003: {
                string = "SuperMap_licensefile_7C_wrong_license_data";
                break;
            }
            case 5004: {
                string = "SuperMap_licensefile_7C_wrong_product_version";
                break;
            }
            case 5005: {
                string = "SuperMap_licensefile_7C_encrypt_failed";
                break;
            }
            case 5006: {
                string = "SuperMap_licensefile_7C_computer_name_error";
                break;
            }
            case 5007: {
                string = "SuperMap_licensefile_7C_featrue_not_found";
                break;
            }
            case 5008: {
                string = "SuperMap_licensefile_7C_specify_MAC_not_found";
                break;
            }
            case 5009: {
                string = "SuperMap_licensefile_7C_wrong_feature_in_license_data";
                break;
            }
            case 5010: {
                string = "SuperMap_licensefile_7C_lost_license_file";
                break;
            }
            default: {
                string = "unknown error code: " + code;
            }
        }
        return string;
    }

    @Override
    public String getImplName() {
        return "FILE";
    }

    private static byte[] decrypt(byte[] encrypted) {
        BigInteger bigInteger = new BigInteger("97940149900808251375534752128742394515589720894419487281414832262018030644275525014643445585879780364114176383835238013142689819073723152973127922693584355350878117626063464407872142659013727087204174268107953820379456111862924759697130141776327730513730393977765958470441797160670328283419007898268490444631");
        BigInteger bigInteger2 = new BigInteger("65537");
        BigInteger bigInteger3 = new BigInteger(encrypted);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        return bigInteger4.toByteArray();
    }

    private static int verifyLicense(String encryptData, LicenseFeatureInfo featureInfo, String signature) {
        String[] stringArray = encryptData.split("\\|");
        if (stringArray.length != 7) {
            return SuperMap_License_Error_EncryptFailed;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        String string6 = stringArray[5];
        String string7 = stringArray[6];
        if (!string2.equals(VERSION)) {
            return SuperMap_License_Error_WrongProductVersion;
        }
        String string8 = new Integer((int)featureInfo.getID()).toString();
        if (!string.equals(string8)) {
            return SuperMap_License_Error_WrongFeatureInLicData;
        }
        int n = LicenseFileServiceImpl.verifyLicenseDate(string5, true, featureInfo);
        if (n != 0) {
            return n;
        }
        n = LicenseFileServiceImpl.verifyLicenseDate(string6, false, featureInfo);
        if (n != 0) {
            return n;
        }
        featureInfo.m_maxlogins = Integer.parseInt(string7);
        featureInfo.m_connectmode = string3;
        int n2 = Integer.parseInt(string3);
        switch (n2) {
            case 4: {
                if (string4.toUpperCase().equals(LicenseFileServiceImpl.getComputerName().toUpperCase())) break;
                return SuperMap_License_Error_ComputerNameError;
            }
            case 3: {
                if (LicenseFileServiceImpl.verifyMACAddress(string4)) break;
                return SuperMap_License_Error_SpecifyMACNotFound;
            }
            case 2: {
                if (!string4.toUpperCase().equals(signature.toUpperCase())) {
                    return SuperMap_License_Error_WrongLicenseData;
                }
                featureInfo.m_isTrial = true;
                break;
            }
            case 5: {
                if (string4.toUpperCase().equals(signature.toUpperCase())) break;
                return SuperMap_License_Error_WrongLicenseData;
            }
            case 6: {
                if (LicenseFileServiceImpl.verifyConfusionMACAddress(string4)) break;
                return SuperMap_License_Error_SpecifyMACNotFound;
            }
        }
        return 0;
    }

    private static String getComputerName() {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return string;
    }

    private static int verifyLicenseDate(String strDate, boolean isStartDate, LicenseFeatureInfo featureInfo) {
        Date date = new Date();
        int n = Integer.parseInt(strDate.substring(0, 4));
        int n2 = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int n3 = Integer.parseInt(strDate.substring(6));
        Calendar calendar = Calendar.getInstance();
        if (isStartDate) {
            calendar.set(n, n2, n3, 0, 0, 0);
        } else {
            calendar.set(n, n2, n3, 23, 59, 59);
        }
        Date date2 = calendar.getTime();
        if (isStartDate) {
            if (date.before(date2)) {
                return SuperMap_License_Error_EarlyStartDate;
            }
            featureInfo.m_startTime = date2;
        } else {
            if (date.after(date2)) {
                return SuperMap_License_Error_LaterExpiredDate;
            }
            featureInfo.m_expiredTime = date2;
        }
        return 0;
    }

    private static boolean verifyMACAddress(String macAddress) {
        if (g_MACList == null) {
            LicenseFileServiceImpl.getAllMac();
        }
        for (String string : g_MACList) {
            if (!string.equals(macAddress)) continue;
            return true;
        }
        return false;
    }

    private static boolean verifyConfusionMACAddress(String signature) {
        if (g_MACNumList == null) {
            LicenseFileServiceImpl.getAllMac();
        }
        Long l = Long.parseLong(signature, 16);
        for (Long l2 : g_MACNumList) {
            if (!l.equals(l2)) continue;
            return true;
        }
        return false;
    }

    private static void getAllMac() {
        g_MACList = new ArrayList<String>();
        g_MACNumList = new ArrayList<Long>();
        String string = "";
        string = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1 ? "-" : ":";
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface == null || networkInterface.getHardwareAddress() == null || networkInterface.isPointToPoint()) continue;
                byte[] byArray = networkInterface.getHardwareAddress();
                StringBuffer stringBuffer = new StringBuffer();
                if (byArray == null || byArray.length <= 1) continue;
                stringBuffer.append(LicenseFileServiceImpl.hexByte(byArray[0]));
                stringBuffer.append(string);
                stringBuffer.append(LicenseFileServiceImpl.hexByte(byArray[1]));
                stringBuffer.append(string);
                stringBuffer.append(LicenseFileServiceImpl.hexByte(byArray[2]));
                stringBuffer.append(string);
                stringBuffer.append(LicenseFileServiceImpl.hexByte(byArray[3]));
                stringBuffer.append(string);
                stringBuffer.append(LicenseFileServiceImpl.hexByte(byArray[4]));
                stringBuffer.append(string);
                stringBuffer.append(LicenseFileServiceImpl.hexByte(byArray[5]));
                g_MACList.add(stringBuffer.toString().toUpperCase());
                Long l = Math.round((double)(0xFF & byArray[0]) * Math.pow(2.0, 40.0));
                Long l2 = Math.round((double)(0xFF & byArray[1]) * Math.pow(2.0, 32.0));
                Long l3 = Math.round((double)(0xFF & byArray[2]) * Math.pow(2.0, 24.0));
                Long l4 = Math.round((double)(0xFF & byArray[3]) * Math.pow(2.0, 16.0));
                Long l5 = Math.round((double)(0xFF & byArray[4]) * Math.pow(2.0, 8.0));
                int n = 0xFF & byArray[5];
                Long l6 = l + l2 + l3 + l4 + l5 + (long)n;
                Long l7 = 281401388481450L;
                g_MACNumList.add(l6 + l7);
            }
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
    }

    private static String hexByte(byte b) {
        String string = "000000" + Integer.toHexString(b);
        return string.substring(string.length() - 2);
    }

    static {
        PROGRAM_PATH = "C:/Program Files/Common Files/SuperMap/License/";
        OPT_PATH = "/opt/SuperMap/License/";
    }
}

