/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.FieldInfoNative;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldInfosNative;
import com.supermap.data.FieldType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalInvalidState;
import com.supermap.data.InternalResource;

public class FieldInfo
extends InternalHandleDisposable {
    private FieldInfos m_fieldInfos = null;

    public FieldInfo() {
        this.setHandle(FieldInfoNative.jni_New(), true);
        this.reset();
    }

    public FieldInfo(FieldInfo fieldInfo) {
        if (fieldInfo == null || fieldInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("fieldInfo", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(FieldInfoNative.jni_NewFromFieldInfo(fieldInfo.getHandle()), true);
    }

    public FieldInfo(String name, FieldType type) {
        this();
        this.setName(name);
        this.setType(type);
    }

    FieldInfo(long handle, FieldInfos fieldInfos) {
        this.setHandle(handle, false);
        this.m_fieldInfos = fieldInfos;
        InternalHandleDisposable.makeSureNativeObjectLive(fieldInfos);
    }

    FieldInfo(long handle) {
        this.setHandle(handle, false);
    }

    public boolean isZeroLengthAllowed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.m_fieldInfos != null && this.m_fieldInfos.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        return FieldInfoNative.jni_GetIsZeroLengthAllowed(this.getHandle());
    }

    public void setZeroLengthAllowed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.m_fieldInfos != null && this.m_fieldInfos.getDataset().getHandle() != 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        FieldInfoNative.jni_SetIsZeroLengthAllowed(this.getHandle(), value);
    }

    public String getCaption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.m_fieldInfos != null && this.m_fieldInfos.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        return FieldInfoNative.jni_GetCaption(this.getHandle(), 0L);
    }

    public void setCaption(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.resetUGCHandle();
        if (this.m_fieldInfos != null && this.m_fieldInfos.getDataset() != null && this.m_fieldInfos.getDataset().getHandle() != 0L) {
            FieldInfoNative.jni_SetCaption(this.getHandle(), value, this.m_fieldInfos.getDataset().getHandle());
        } else {
            FieldInfoNative.jni_SetCaption(this.getHandle(), value, 0L);
        }
    }

    public String getDefaultValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.m_fieldInfos != null && this.m_fieldInfos.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        return FieldInfoNative.jni_GetDefaultValue(this.getHandle());
    }

    public void setDefaultValue(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.m_fieldInfos != null && this.m_fieldInfos.getDataset().getHandle() != 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        FieldInfoNative.jni_SetDefaultValue(this.getHandle(), value);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.m_fieldInfos != null && this.m_fieldInfos.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        return FieldInfoNative.jni_GetName(this.getHandle());
    }

    public void setName(String value) {
        InternalInvalidState internalInvalidState;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.resetUGCHandle();
        if (this.m_fieldInfos != null) {
            if (this.m_fieldInfos.getHandle() == 0L) {
                String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_fieldInfos.getDataset() == null) {
                if (this.m_fieldInfos.indexOf(value) != -1) {
                    String string = InternalResource.loadString("value", "FieldInfo_NameIsNotAvaliable", "data_resources");
                    throw new IllegalArgumentException(string);
                }
            } else {
                String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
                throw new IllegalStateException(string);
            }
        }
        if ((internalInvalidState = FieldInfo.isValidFieldName(value)) != null) {
            String string = "";
            if (internalInvalidState.equals(InternalInvalidState.BEYONDLIMIT)) {
                string = "FieldInfo_NameLengthBeyondLimit";
            } else if (internalInvalidState.equals(InternalInvalidState.INVALIDCHAR)) {
                string = "FieldInfo_NameContainInvalidChar";
            } else if (internalInvalidState.equals(InternalInvalidState.ISEMPTY)) {
                string = "FieldInfo_NameIsEmpty";
            } else if (internalInvalidState.equals(InternalInvalidState.PREFIXERROR)) {
                string = "FieldInfo_NameInvalidPrefix";
            }
            String string2 = InternalResource.loadString("value", string, "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (value.toUpperCase().startsWith("SM")) {
            String string = InternalResource.loadString("setName(String value)", "FieldInfos_Unsupported", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        FieldInfoNative.jni_SetName(this.getHandle(), value);
    }

    public boolean isRequired() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.m_fieldInfos != null && this.m_fieldInfos.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        return FieldInfoNative.jni_GetIsRequired(this.getHandle());
    }

    public void setRequired(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.m_fieldInfos != null && this.m_fieldInfos.getDataset().getHandle() != 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        FieldInfoNative.jni_SetIsRequired(this.getHandle(), value);
    }

    public int getMaxLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_fieldInfos != null && this.m_fieldInfos.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        return FieldInfoNative.jni_GetMaxLength(this.getHandle());
    }

    public void setMaxLength(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value:" + String.valueOf(value), "FieldInfo_MaxLengthShouldntBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.resetUGCHandle();
        if (this.m_fieldInfos != null && this.m_fieldInfos.getDataset().getHandle() != 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        FieldInfoNative.jni_SetMaxLength(this.getHandle(), value);
    }

    public FieldType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.m_fieldInfos != null && this.m_fieldInfos.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = FieldInfoNative.jni_GetType(this.getHandle());
        if (n == 12) {
            n = 10;
        }
        return (FieldType)Enum.parseUGCValue(FieldType.class, n);
    }

    public void setType(FieldType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.m_fieldInfos != null && this.m_fieldInfos.getDataset() != null && this.m_fieldInfos.getDataset().getHandle() != 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        FieldInfoNative.jni_SetType(this.getHandle(), value.getUGCValue());
    }

    public boolean isSystemField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.m_fieldInfos != null && this.m_fieldInfos.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        return FieldInfoNative.jni_GetIsSystemField(this.getHandle());
    }

    public FieldInfo clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        return new FieldInfo(this);
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            this.resetUGCHandle();
            FieldInfoNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    @Override
    protected void clearHandle() {
        this.m_fieldInfos = null;
        this.setHandle(0L);
    }

    void reset() {
        if (this.getHandle() != 0L) {
            FieldInfoNative.jni_Reset(this.getHandle());
            this.setMaxLength(255);
        }
    }

    static InternalInvalidState isValidFieldName(String name) {
        int n = FieldInfoNative.jni_IsValidFieldName(name);
        if (n == -1) {
            return null;
        }
        return (InternalInvalidState)Enum.parseUGCValue(InternalInvalidState.class, n);
    }

    protected static FieldInfo createInstance(long handle) {
        FieldInfo fieldInfo = new FieldInfo(handle);
        if (fieldInfo.getCaption().trim().equals("")) {
            fieldInfo.setCaption(fieldInfo.getName());
        }
        InternalHandleDisposable.setIsDisposable(fieldInfo, false);
        return fieldInfo;
    }

    private void resetUGCHandle() {
        if (this.m_fieldInfos != null && this.m_fieldInfos.getDataset() != null && this.m_fieldInfos.getDataset().getHandle() != 0L) {
            int n = this.m_fieldInfos.indexOf(this);
            long l = this.m_fieldInfos.getHandle();
            long l2 = FieldInfosNative.jni_GetFieldInfoByIndex(l, n);
            if (l2 != 0L) {
                this.setHandle(l2, false);
            }
        }
    }
}

