/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.DynamicSegActModifyAttr;
import com.supermap.data.DynamicSegmentInfo;
import com.supermap.data.DynamicSegmentManagerNative;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.InternalResource;

public class DynamicSegmentManager {
    public static DynamicSegmentInfo[] getDynamicSegmentInfos(DatasetVector dynamicDataset) {
        if (dynamicDataset.getDatasource() == null || dynamicDataset.getDatasource().getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DynamicSegmentManager.getCount(dynamicDataset);
        if (n > 0) {
            long[] lArray = new long[n];
            DynamicSegmentInfo[] dynamicSegmentInfoArray = new DynamicSegmentInfo[n];
            DynamicSegmentManagerNative.jni_GetDynamicSegmentInfos(dynamicDataset.getHandle(), dynamicDataset.getDatasource().getHandle(), lArray);
            DynamicSegmentInfo dynamicSegmentInfo = null;
            for (int i = 0; i < n; ++i) {
                dynamicSegmentInfoArray[i] = dynamicSegmentInfo = new DynamicSegmentInfo(lArray[i], dynamicDataset.getDatasource());
            }
            return dynamicSegmentInfoArray;
        }
        return null;
    }

    public static boolean removeDynamicSegmentInfos(DatasetVector dynamicDataset) {
        if (dynamicDataset.getDatasource() == null || dynamicDataset.getDatasource().getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DynamicSegmentManagerNative.jni_RemoveDynamicSegmentInfos(dynamicDataset.getHandle(), dynamicDataset.getDatasource().getHandle());
    }

    public static DynamicSegmentInfo[] getAllDynamicSegmentInfos(Datasource targetDatasource) {
        if (targetDatasource == null || targetDatasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DynamicSegmentManager.getAllCount(targetDatasource);
        if (n > 0) {
            long[] lArray = new long[n];
            DynamicSegmentInfo[] dynamicSegmentInfoArray = new DynamicSegmentInfo[n];
            DynamicSegmentManagerNative.jni_GetAllDynamicSegmentInfos(targetDatasource.getHandle(), lArray);
            for (int i = 0; i < n; ++i) {
                dynamicSegmentInfoArray[i] = new DynamicSegmentInfo(lArray[i], targetDatasource);
            }
            return dynamicSegmentInfoArray;
        }
        return null;
    }

    public static boolean removeAllDynamicSegmentInfos(Datasource targetDatasource) {
        if (targetDatasource == null || targetDatasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DynamicSegmentManagerNative.jni_RemoveAllDynamicSegmentInfos(targetDatasource.getHandle());
    }

    private static int getCount(DatasetVector dataset) {
        if (dataset.getDatasource() == null || dataset.getDatasource().getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DynamicSegmentManagerNative.jni_GetCount(dataset.getHandle(), dataset.getDatasource().getHandle());
        return n;
    }

    private static int getAllCount(Datasource targetDatasource) {
        int n = DynamicSegmentManagerNative.jni_GetAllCount(targetDatasource.getHandle());
        return n;
    }

    public static Boolean processDynamicModifyActions(Datasource datasource, DynamicSegActModifyAttr[] arrActModifyAttr) {
        int n = arrActModifyAttr.length;
        for (int i = 0; i < n; ++i) {
            int n2 = arrActModifyAttr[i].getIDObjModified();
            DatasetVector datasetVector = arrActModifyAttr[i].getTabularDataset();
            String string = arrActModifyAttr[i].getFieldNameModified();
            FieldInfo fieldInfo = datasetVector.getFieldInfos().get(string);
            Object object = arrActModifyAttr[i].getNewFieldValue();
            boolean bl = false;
            if (fieldInfo.getType() == FieldType.INT16 || fieldInfo.getType() == FieldType.INT32 || fieldInfo.getType() == FieldType.INT64) {
                bl = DynamicSegmentManagerNative.jni_ProcessDynamicActions(datasource.getHandle(), n2, datasetVector.getHandle(), fieldInfo.getHandle(), Long.valueOf(object.toString()));
            } else if (fieldInfo.getType() == FieldType.DOUBLE || fieldInfo.getType() == FieldType.SINGLE) {
                bl = DynamicSegmentManagerNative.jni_ProcessDynamicModifyActions2(datasource.getHandle(), n2, datasetVector.getHandle(), fieldInfo.getHandle(), Double.valueOf(object.toString()));
            } else {
                if (fieldInfo.getType() != FieldType.CHAR && fieldInfo.getType() != FieldType.TEXT && fieldInfo.getType() != FieldType.WTEXT) continue;
                bl = DynamicSegmentManagerNative.jni_ProcessDynamicModifyActions1(datasource.getHandle(), n2, datasetVector.getHandle(), fieldInfo.getHandle(), object.toString());
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static Boolean processDynamicAddActions(DatasetVector tablarDT, int nID) {
        return DynamicSegmentManagerNative.jni_ProcessDynamicAddActions(tablarDT.getHandle(), nID);
    }

    public static Boolean processDynamicDeleteActions(DatasetVector tablarDT, int[] nIDs) {
        return DynamicSegmentManagerNative.jni_ProcessDynamicDeleteActions(tablarDT.getHandle(), nIDs);
    }

    protected void clearHandle() {
    }
}

