/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BlockSizeOption;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetImageCollectionInfoNative;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalInvalidState;
import com.supermap.data.InternalResource;
import com.supermap.data.PixelFormat;

public class DatasetImageCollectionInfo
extends InternalHandleDisposable {
    public DatasetImageCollectionInfo() {
        this.setHandle(DatasetImageCollectionInfoNative.jni_New(1), true);
        this.reset();
    }

    public DatasetImageCollectionInfo(DatasetImageCollectionInfo datasetImageCollectionInfo) {
        if (datasetImageCollectionInfo == null) {
            String string = InternalResource.loadString("DatasetImageCollectionInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetImageCollectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetImageCollectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetImageCollectionInfoNative.jni_Clone(datasetImageCollectionInfo.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(datasetImageCollectionInfo);
    }

    public DatasetImageCollectionInfo(String name, PixelFormat pixelFormat, EncodeType encodeType, BlockSizeOption option, int bandCount) {
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (pixelFormat == null) {
            String string = InternalResource.loadString("pixelFormat", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (encodeType == null) {
            String string = InternalResource.loadString("encodeType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        this.setHandle(DatasetImageCollectionInfoNative.jni_New(bandCount), true);
        this.reset();
        this.setName(name);
        this.setPixelFormat(pixelFormat);
        this.setBlockSizeOption(option);
        this.setEncodeType(encodeType);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageCollectionInfoNative.jni_GetName(this.getHandle());
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        InternalInvalidState internalInvalidState = Dataset.isValidDatasetName(value);
        if (internalInvalidState != null) {
            String string = "";
            if (internalInvalidState.equals(InternalInvalidState.ISEMPTY)) {
                string = "Dataset_NameIsEmpty";
            } else if (internalInvalidState.equals(InternalInvalidState.AGAINSYSTEMNAME)) {
                string = "Dataset_NameAgainstSys";
            } else if (internalInvalidState.equals(InternalInvalidState.BEYONDLIMIT)) {
                string = "Dataset_NameBeyondLimit";
            } else if (internalInvalidState.equals(InternalInvalidState.INVALIDCHAR)) {
                string = "Dataset_NameIncludeInvalidChar";
            } else if (internalInvalidState.equals(InternalInvalidState.PREFIXERROR)) {
                string = "Dataset_NameErrorPrefix";
            }
            String string2 = InternalResource.loadString("value", string, "data_resources");
            throw new IllegalArgumentException(string2);
        }
        DatasetImageCollectionInfoNative.jni_SetName(this.getHandle(), value);
    }

    public int getBandCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageCollectionInfoNative.jni_GetBandCount(this.getHandle());
    }

    public void setBandCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "DatasetImage_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetImageCollectionInfoNative.jni_SetBandCount(this.getHandle(), value);
    }

    public PixelFormat getPixelFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetImageCollectionInfoNative.jni_GetPixelFormat(this.getHandle());
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
    }

    public void setPixelFormat(PixelFormat value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetImageCollectionInfoNative.jni_SetPixelFormat(this.getHandle(), value.getUGCValue());
    }

    public BlockSizeOption getBlockSizeOption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetImageCollectionInfoNative.jni_GetBlockSize(this.getHandle());
        return (BlockSizeOption)Enum.parseUGCValue(BlockSizeOption.class, n);
    }

    public void setBlockSizeOption(BlockSizeOption option) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetImageCollectionInfoNative.jni_SetBlockSize(this.getHandle(), option.getUGCValue());
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetImageCollectionInfoNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)Enum.parseUGCValue(EncodeType.class, n);
    }

    public void setEncodeType(EncodeType encodeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (encodeType == null) {
            String string = InternalResource.loadString("encodeType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (encodeType != EncodeType.DCT && encodeType != EncodeType.LZW) {
            encodeType = EncodeType.DCT;
        }
        DatasetImageCollectionInfoNative.jni_SetEncodeType(this.getHandle(), encodeType.getUGCValue());
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            DatasetImageCollectionInfoNative.jni_Delete(super.getHandle());
            this.clearHandle();
        }
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Nmae = ");
        stringBuffer.append(this.getName());
        stringBuffer.append(",PixelFormat = ");
        stringBuffer.append(this.getPixelFormat().name());
        stringBuffer.append(",BlockSize = ");
        stringBuffer.append(this.getBlockSizeOption());
        stringBuffer.append(",EncodeType = ");
        stringBuffer.append(this.getEncodeType().name());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
    }

    void reset() {
        if (this.getHandle() != 0L) {
            DatasetImageCollectionInfoNative.jni_Reset(this.getHandle());
        }
    }
}

