/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.tilestorage;

import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.tilestorage.ImageSizeOption;
import com.supermap.tilestorage.InternalEnum;
import com.supermap.tilestorage.InternalPrjCoordSys;
import com.supermap.tilestorage.InternalResource;
import com.supermap.tilestorage.TileDataType;
import com.supermap.tilestorage.TileStorageExtendInfo;
import com.supermap.tilestorage.TileStorageInfoNative;
import com.supermap.tilestorage.TileStorageType;

public class TileStorageInfo
extends InternalHandleDisposable {
    TileStorageInfo(long handle) {
        this.setHandle(handle, true);
    }

    public TileStorageInfo() {
        long l = TileStorageInfoNative.jni_New();
        this.setHandle(l, true);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileStorageInfoNative.jni_GetName(this.getHandle());
    }

    public String getMapName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileStorageInfoNative.jni_GetMapName(this.getHandle());
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        TileStorageInfoNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[3], dArray[2], dArray[1]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D bounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{bounds.getLeft(), bounds.getTop(), bounds.getRight(), bounds.getBottom()};
        TileStorageInfoNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public PrjCoordSys getPrjCoordSys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        long l = TileStorageInfoNative.jni_GetPrjCoordSys(this.getHandle());
        return InternalPrjCoordSys.createInstance(l, false);
    }

    public void setPrjCoordSys(PrjCoordSys prj) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        TileStorageInfoNative.jni_SetPrjCoordSys(this.getHandle(), InternalHandle.getHandle((InternalHandle)prj));
    }

    public TileStorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        int n = TileStorageInfoNative.jni_GetStorageType(this.getHandle());
        return (TileStorageType)InternalEnum.parseUGCValue(TileStorageType.class, n);
    }

    public TileStorageExtendInfo[] getExtendInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExtendInfos()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        int n = TileStorageInfoNative.jni_GetExtendInfosSize(this.getHandle());
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        TileStorageInfoNative.jni_GetExtendInfos(this.getHandle(), stringArray, stringArray2);
        int n2 = stringArray.length;
        TileStorageExtendInfo[] tileStorageExtendInfoArray = new TileStorageExtendInfo[n2];
        for (int i = 0; i < stringArray.length; ++i) {
            TileStorageExtendInfo tileStorageExtendInfo = new TileStorageExtendInfo();
            tileStorageExtendInfo.setName(stringArray[i]);
            tileStorageExtendInfo.setValue(stringArray2[i]);
            tileStorageExtendInfoArray[i] = tileStorageExtendInfo;
        }
        return tileStorageExtendInfoArray;
    }

    public boolean addExtendInfo(String name, String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addExtendInfo()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileStorageInfoNative.jni_AddExtendInfo(this.getHandle(), name, value);
    }

    public boolean deleteExtendInfo(String name, String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteExtendInfo()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileStorageInfoNative.jni_DeleteExtendInfo(this.getHandle(), name, value);
    }

    public ImageSizeOption getTileStorageSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileStorageSize()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        int n = TileStorageInfoNative.jni_GetTileStorageSize(this.getHandle());
        return (ImageSizeOption)InternalEnum.parseUGCValue(ImageSizeOption.class, n);
    }

    public void setTileStorageSize(ImageSizeOption imageSizeOption) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileStorageSize()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        TileStorageInfoNative.jni_SetTileStorageSize(this.getHandle(), InternalEnum.getUGCValue(imageSizeOption));
    }

    public Point2D getOrigin() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOrigin()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        TileStorageInfoNative.jni_GetOrigin(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setOrigin(Point2D origin) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOrigin()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
        }
        double d = origin.getX();
        double d2 = origin.getY();
        TileStorageInfoNative.jni_SetOrigin(this.getHandle(), d, d2);
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDescription()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
        }
        return TileStorageInfoNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String description) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDescription()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
        }
        TileStorageInfoNative.jni_SetDescription(this.getHandle(), description);
    }

    public TileDataType getDataType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataType()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
        }
        int n = TileStorageInfoNative.jni_GetDataType(this.getHandle());
        return (TileDataType)InternalEnum.parseUGCValue(TileDataType.class, n);
    }

    public void setDataType(TileDataType dataType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDataType()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
        }
        TileStorageInfoNative.jni_SetDataType(this.getHandle(), InternalEnum.getUGCValue(dataType));
    }

    public String getVersion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVersion()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
        }
        return TileStorageInfoNative.jni_GetVersion(this.getHandle());
    }

    public void setVersion(String version) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVersion()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
        }
        TileStorageInfoNative.jni_SetVersion(this.getHandle(), version);
    }

    public double[] getResolutions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getResolutions()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
        }
        return TileStorageInfoNative.jni_GetResolutions(this.getHandle());
    }

    public boolean addResolution(double resolution) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addResolution()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
        }
        return TileStorageInfoNative.jni_AddResolution(this.getHandle(), resolution);
    }

    public boolean deleteResolution(double resolution) {
        return false;
    }

    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
        }
        return TileStorageInfoNative.jni_FromXML(this.getHandle(), xml);
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
        }
        return TileStorageInfoNative.jni_ToXML(this.getHandle());
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "tilestorage_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TileStorageInfoNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public int getTableGridSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTableGridSize()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileStorageInfoNative.jni_GetGetGridSize(this.getHandle());
    }

    public void setTableGridSize(int tableGridSize) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTableGridSize()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        TileStorageInfoNative.jni_SetGetGridSize(this.getHandle(), tableGridSize);
    }

    public void setTileSetName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileSetName()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
        }
        TileStorageInfoNative.jni_SetName(this.getHandle(), name);
    }

    public void setTransParent(Boolean bTran) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileSetName()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
        }
        TileStorageInfoNative.jni_SetTransParent(this.getHandle(), bTran);
    }

    public boolean getTransParent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileSetName()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
        }
        return TileStorageInfoNative.jni_GetTransParent(this.getHandle());
    }
}

