/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.callpy;

import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetGridInfo;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetImageInfo;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.PixelFormat;
import com.supermap.data.Recordset;
import com.supermap.jsuperpy.JFeature;
import com.supermap.jsuperpy.ProcessInfo;
import com.supermap.jsuperpy.Tile;
import com.supermap.jsuperpy.TileMeta;
import com.supermap.jsuperpy.TileRef;
import com.supermap.jsuperpy.callpy.Utils;
import com.supermap.jsuperpy.serializer.DataSerializers;
import com.supermap.jsuperpy.serializer.impl.MapSerializer;
import com.supermap.jsuperpy.serializer.impl.TileSerializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class Processes {
    private static final String PIXELFORMAT = "PixelFormat";
    private static final String NOVALUE = "NoValue";
    private static final String BANDS = "Bands";
    private static final String DATASETTYPE = "DatasetType";
    private static final String FIELDS = "Fields";

    private static int[] getDatasetTileRefInfo(Dataset dataset, int perTileRows, int perTileCols) {
        if (dataset.getType() != DatasetType.GRID && dataset.getType() != DatasetType.IMAGE) {
            throw new IllegalArgumentException("Unsupported dataset type " + dataset.getType());
        }
        int width = 0;
        int height = 0;
        if (dataset.getType() == DatasetType.GRID) {
            width = ((DatasetGrid)dataset).getWidth();
            height = ((DatasetGrid)dataset).getHeight();
        } else {
            width = ((DatasetImage)dataset).getWidth();
            height = ((DatasetImage)dataset).getHeight();
        }
        int colTiles = width / perTileCols;
        if (width % perTileCols != 0) {
            ++colTiles;
        }
        int rowTiles = height / perTileRows;
        if (height % perTileRows != 0) {
            // empty if block
        }
        return new int[]{++rowTiles, colTiles};
    }

    public static TileMeta getDatasetInfo(Dataset dataset) {
        HashMap infos = new HashMap();
        if (dataset.getType() == DatasetType.GRID) {
            DatasetGrid datasetGrid = (DatasetGrid)dataset;
            return new TileMeta(datasetGrid.getHeight(), datasetGrid.getWidth(), datasetGrid.getNoValue(), datasetGrid.getPixelFormat()).setBands(1);
        }
        if (dataset.getType() == DatasetType.IMAGE) {
            DatasetImage datasetImage = (DatasetImage)dataset;
            int bands = datasetImage.getBandCount();
            if (bands > 1) {
                return new TileMeta(datasetImage.getHeight(), datasetImage.getWidth(), datasetImage.getNoData(0), datasetImage.getPixelFormat(0)).setBands(bands);
            }
            if (datasetImage.getPixelFormat(0) == PixelFormat.RGB) {
                return new TileMeta(datasetImage.getHeight(), datasetImage.getWidth(), datasetImage.getNoData(0), PixelFormat.RGB).setBands(3);
            }
            if (datasetImage.getPixelFormat(0) == PixelFormat.RGBA) {
                return new TileMeta(datasetImage.getHeight(), datasetImage.getWidth(), datasetImage.getNoData(0), PixelFormat.RGB).setBands(4);
            }
            return new TileMeta(datasetImage.getHeight(), datasetImage.getWidth(), datasetImage.getNoData(0), datasetImage.getPixelFormat(0)).setBands(bands);
        }
        return null;
    }

    public static TileRef[] getDatasetTileRefs(Dataset dataset, int perTileRows, int perTileCols) {
        int[] rowColTiles = Processes.getDatasetTileRefInfo(dataset, perTileRows, perTileCols);
        int rowTiles = rowColTiles[0];
        int colTiles = rowColTiles[1];
        int width = 0;
        int height = 0;
        if (dataset.getType() == DatasetType.GRID) {
            width = ((DatasetGrid)dataset).getWidth();
            height = ((DatasetGrid)dataset).getHeight();
        } else {
            width = ((DatasetImage)dataset).getWidth();
            height = ((DatasetImage)dataset).getHeight();
        }
        TileRef[] tileRefs = new TileRef[colTiles * rowTiles];
        for (int i = 0; i < rowTiles; ++i) {
            int startRow = i * perTileRows;
            int endRow = (i + 1) * perTileRows - 1;
            if (endRow > height) {
                endRow = height - 1;
            }
            for (int j = 0; j < colTiles; ++j) {
                int startCol = j * perTileCols;
                int endCol = (j + 1) * perTileCols - 1;
                if (endCol > width) {
                    endCol = width - 1;
                }
                tileRefs[i * colTiles + j] = new TileRef(dataset, startCol, endCol, startRow, endRow, j, i);
            }
        }
        return tileRefs;
    }

    public static void writeTileToDataset(Dataset dataset, Tile resultTile, TileRef tileRef) {
        block17: {
            int bandCount;
            int perBandPixelCount;
            DatasetImage resultImage;
            int cols;
            int startCol;
            int startRow;
            double[] resultValues;
            block18: {
                int endCol;
                int endRow;
                block16: {
                    if (resultTile == null) {
                        return;
                    }
                    resultValues = resultTile.getValues();
                    startRow = tileRef.getStartRow();
                    startCol = tileRef.getStartCol();
                    endRow = tileRef.getEndRow();
                    endCol = tileRef.getEncCol();
                    cols = resultTile.getCols();
                    if (dataset.getType() != DatasetType.GRID) break block16;
                    DatasetGrid resultGrid = (DatasetGrid)dataset;
                    for (int i = startRow; i <= endRow; ++i) {
                        for (int j = startCol; j <= endCol; ++j) {
                            resultGrid.setValue(j, i, resultValues[(i - startRow) * cols + (j - startCol)]);
                        }
                    }
                    break block17;
                }
                if (dataset.getType() != DatasetType.IMAGE) break block17;
                resultImage = (DatasetImage)dataset;
                perBandPixelCount = (endCol - startCol + 1) * (endRow - startRow + 1);
                bandCount = resultImage.getBandCount();
                if (bandCount <= 1) break block18;
                for (int nBand = 0; nBand < tileRef.getBands(); ++nBand) {
                    for (int i = tileRef.getStartRow(); i <= tileRef.getEndRow(); ++i) {
                        for (int j = tileRef.getStartCol(); j <= tileRef.getEncCol(); ++j) {
                            resultImage.setValue(j, i, resultValues[(i - startRow) * cols + (j - startCol) + nBand * perBandPixelCount], nBand);
                        }
                    }
                }
                break block17;
            }
            if (bandCount != 1) break block17;
            if (resultImage.getPixelFormat(0) == PixelFormat.RGB) {
                for (int i = tileRef.getStartRow(); i <= tileRef.getEndRow(); ++i) {
                    for (int j = tileRef.getStartCol(); j <= tileRef.getEncCol(); ++j) {
                        double r = resultValues[0 * perBandPixelCount + (i - startRow) * cols + (j - startCol)];
                        double g = resultValues[1 * perBandPixelCount + (i - startRow) * cols + (j - startCol)];
                        double b = resultValues[2 * perBandPixelCount + (i - startRow) * cols + (j - startCol)];
                        resultImage.setValue(j, i, (double)TileRef.rgbToValue(new int[]{(int)r, (int)g, (int)b}), 0);
                    }
                }
            } else if (resultImage.getPixelFormat(0) == PixelFormat.RGBA) {
                for (int i = tileRef.getStartRow(); i <= tileRef.getEndRow(); ++i) {
                    for (int j = tileRef.getStartCol(); j <= tileRef.getEncCol(); ++j) {
                        double r = resultValues[0 * perBandPixelCount + (i - startRow) * cols + (j - startCol)];
                        double g = resultValues[1 * perBandPixelCount + (i - startRow) * cols + (j - startCol)];
                        double b = resultValues[2 * perBandPixelCount + (i - startRow) * cols + (j - startCol)];
                        double a = resultValues[3 * perBandPixelCount + (i - startRow) * cols + (j - startCol)];
                        resultImage.setValue(j, i, (double)TileRef.rgbToValue(new int[]{(int)r, (int)g, (int)b, (int)a}), 0);
                    }
                }
            } else {
                for (int i = tileRef.getStartRow(); i <= tileRef.getEndRow(); ++i) {
                    for (int j = tileRef.getStartCol(); j <= tileRef.getEncCol(); ++j) {
                        resultImage.setValue(j, i, resultValues[(i - startRow) * cols + (j - startCol)], 0);
                    }
                }
            }
        }
    }

    private static Dataset createRasterDataset(Datasource resultDs, String name, Dataset sourceDataset, Tile tile) {
        return Processes.createRasterDataset(resultDs, name, sourceDataset, tile.getMeta().getPixelFormat(), tile.getNoValue(), tile.getMeta().getBands());
    }

    private static Dataset createRasterDataset(Datasource resultDs, String name, Dataset sourceDataset, PixelFormat pixelFormat, double noValue, int bands) {
        if (sourceDataset instanceof DatasetGrid) {
            DatasetGrid gridDt = (DatasetGrid)sourceDataset;
            DatasetGridInfo dtInfo = new DatasetGridInfo();
            dtInfo.setBlockSizeOption(gridDt.getBlockSizeOption());
            dtInfo.setBounds(sourceDataset.getBounds());
            dtInfo.setEncodeType(sourceDataset.getEncodeType());
            dtInfo.setHeight(gridDt.getHeight());
            dtInfo.setWidth(gridDt.getWidth());
            dtInfo.setName(name);
            dtInfo.setPixelFormat(pixelFormat);
            dtInfo.setNoValue(noValue);
            DatasetGrid grid = resultDs.getDatasets().create(dtInfo);
            if (grid == null) {
                throw new RuntimeException("Failed to create result dataset");
            }
            return grid;
        }
        if (sourceDataset instanceof DatasetImage) {
            DatasetImage imageDt = (DatasetImage)sourceDataset;
            DatasetImageInfo dtInfo = new DatasetImageInfo();
            dtInfo.setBlockSizeOption(imageDt.getBlockSizeOption());
            dtInfo.setBounds(sourceDataset.getBounds());
            dtInfo.setEncodeType(sourceDataset.getEncodeType());
            dtInfo.setHeight(imageDt.getHeight());
            dtInfo.setWidth(imageDt.getWidth());
            dtInfo.setName(name);
            if (bands == 3 && pixelFormat == PixelFormat.UBIT8) {
                dtInfo.setBandCount(1);
                dtInfo.setPixelFormat(PixelFormat.RGB);
            } else if (bands == 4 && pixelFormat == PixelFormat.UBIT8) {
                dtInfo.setBandCount(1);
                dtInfo.setPixelFormat(PixelFormat.RGBA);
            } else {
                dtInfo.setBandCount(bands);
                dtInfo.setPixelFormat(pixelFormat);
            }
            DatasetImage image = resultDs.getDatasets().create(dtInfo);
            if (image != null) {
                for (int i = 0; i < image.getBandCount(); ++i) {
                    image.setNoData(noValue, i);
                }
            } else {
                throw new RuntimeException("Failed to create result dataset");
            }
            return image;
        }
        throw new RuntimeException("Unsupported Dataset");
    }

    public static Map<String, Object> process(File pyFile, String entryClassName, Map<String, Object> args) throws Exception {
        return Processes.process(Utils.readPyFile(pyFile), entryClassName, args);
    }

    public static Map<String, Object> process(String pyText, String entryClassName, Map<String, Object> args) throws Exception {
        ServerSocket serverSocket = Utils.startPythonProcess();
        Socket socket = serverSocket.accept();
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        out.writeInt(10);
        ProcessInfo processInfo = new ProcessInfo(pyText, entryClassName, args);
        byte[] processInfoBytes = DataSerializers.encode(processInfo);
        Utils.writeBytesAndLength(processInfoBytes, out);
        DataInputStream in = new DataInputStream(socket.getInputStream());
        byte[] resultBytes = Utils.readBytesAndLength(in);
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (resultBytes == null || resultBytes.length == 0) {
            return results;
        }
        Object decodeValues = new MapSerializer().decode(resultBytes);
        for (Object key : decodeValues.keySet()) {
            results.put(key.toString(), decodeValues.get(key));
        }
        if (in.readInt() != 3) {
            System.out.println("error, invalid command");
        }
        out.writeInt(-1);
        socket.close();
        return results;
    }

    private static void writeProcessInfo(Dataset dataset, String pyText, String entryClassName, Map<String, Object> args, DataOutputStream out) throws IOException {
        HashMap<String, Object> kvArgs = new HashMap<String, Object>();
        kvArgs.putAll(args);
        TileMeta tileMeta = Processes.getDatasetInfo(dataset);
        if (tileMeta != null) {
            kvArgs.put(PIXELFORMAT, tileMeta.getPixelFormat());
            kvArgs.put(NOVALUE, tileMeta.getNoValue());
            kvArgs.put(BANDS, tileMeta.getBands());
        }
        ProcessInfo processInfo = new ProcessInfo(pyText, entryClassName, kvArgs);
        byte[] processInfoBytes = DataSerializers.encode(processInfo);
        Utils.writeBytesAndLength(processInfoBytes, out);
    }

    public static boolean processTileGetTile(Dataset dataset, File pyFile, String entryClassName, int perTileRows, int perTileCols, Datasource resultDs, String name, Map<String, Object> args) throws Exception {
        return Processes.processTileGetTile(dataset, Utils.readPyFile(pyFile), entryClassName, perTileRows, perTileCols, resultDs, name, args);
    }

    public static boolean processTileGetTile(Dataset dataset, String pyText, String entryClassName, int perTileRows, int perTileCols, Datasource resultDs, String name, Map<String, Object> args) throws Exception {
        ServerSocket serverSocket = Utils.startPythonProcess();
        Socket socket = serverSocket.accept();
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        out.writeInt(30);
        Processes.writeProcessInfo(dataset, pyText, entryClassName, args, out);
        Dataset resultDataset = null;
        DataInputStream in = new DataInputStream(socket.getInputStream());
        out.writeInt(5);
        byte[] updateInfoBytes = Utils.readBytesAndLength(in);
        if (updateInfoBytes.length > 0) {
            Object updateInfo = new MapSerializer().decode(updateInfoBytes);
            int bands = -1;
            if (updateInfo.containsKey(BANDS)) {
                bands = Integer.parseInt(updateInfo.get(BANDS).toString());
            }
            PixelFormat pixelFormat = null;
            if (bands > 0 && updateInfo.containsKey(PIXELFORMAT)) {
                pixelFormat = (PixelFormat)updateInfo.get(PIXELFORMAT);
            }
            double noValue = -9999.0;
            if (pixelFormat != null && updateInfo.containsKey(NOVALUE)) {
                noValue = Double.parseDouble(updateInfo.get(NOVALUE).toString());
            }
            if (bands > 0 && pixelFormat != null) {
                resultDataset = Processes.createRasterDataset(resultDs, name, dataset, pixelFormat, noValue, bands);
            }
        }
        TileRef[] tileRefs = Processes.getDatasetTileRefs(dataset, perTileRows, perTileCols);
        TileSerializer tileSerializer = new TileSerializer();
        for (int i = 0; i < tileRefs.length; ++i) {
            if (in.readInt() != 6) continue;
            out.writeInt(31);
            System.out.println(String.format("start process %d/%d tile", i + 1, tileRefs.length));
            TileRef tileRef = tileRefs[i];
            Utils.writeBytesAndLength(tileSerializer.encode(tileRef.getData()), out);
            Tile resultTile = tileSerializer.decode(Utils.readBytesAndLength(in));
            if (resultDataset == null) {
                resultDataset = Processes.createRasterDataset(resultDs, name, dataset, resultTile);
            }
            Processes.writeTileToDataset(resultDataset, resultTile, tileRef);
        }
        if (in.readInt() == 6) {
            out.writeInt(3);
        }
        out.writeInt(-1);
        socket.close();
        return true;
    }

    public static boolean processTilesGetTile(Dataset dataset, File pyFile, String entryClassName, int perTileRows, int perTileCols, int outerRound, Datasource resultDs, String name, Map<String, Object> args) throws Exception {
        return Processes.processTilesGetTile(dataset, Utils.readPyFile(pyFile), entryClassName, perTileRows, perTileCols, outerRound, resultDs, name, args);
    }

    public static boolean processTilesGetTile(Dataset dataset, String pyText, String entryClassName, int perTileRows, int perTileCols, int outerRound, Datasource resultDs, String name, Map<String, Object> args) throws Exception {
        ServerSocket serverSocket = Utils.startPythonProcess();
        Socket socket = serverSocket.accept();
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        out.writeInt(30);
        Processes.writeProcessInfo(dataset, pyText, entryClassName, args, out);
        DataInputStream in = new DataInputStream(socket.getInputStream());
        Dataset resultDataset = null;
        out.writeInt(5);
        byte[] updateInfoBytes = Utils.readBytesAndLength(in);
        if (updateInfoBytes.length > 0) {
            Object updateInfo = new MapSerializer().decode(updateInfoBytes);
            int bands = -1;
            if (updateInfo.containsKey(BANDS)) {
                bands = Integer.parseInt(updateInfo.get(BANDS).toString());
            }
            PixelFormat pixelFormat = null;
            if (bands > 0 && updateInfo.containsKey(PIXELFORMAT)) {
                pixelFormat = (PixelFormat)updateInfo.get(PIXELFORMAT);
            }
            double noValue = -9999.0;
            if (pixelFormat != null && updateInfo.containsKey(NOVALUE)) {
                noValue = Double.parseDouble(updateInfo.get(NOVALUE).toString());
            }
            if (bands > 0 && pixelFormat != null) {
                resultDataset = Processes.createRasterDataset(resultDs, name, dataset, pixelFormat, noValue, bands);
            }
        }
        TileRef[] tileRefs = Processes.getDatasetTileRefs(dataset, perTileRows, perTileCols);
        int[] rowColTileRef = Processes.getDatasetTileRefInfo(dataset, perTileRows, perTileCols);
        int rowTileRef = rowColTileRef[0];
        int colTileRef = rowColTileRef[0];
        TileSerializer tileSerializer = new TileSerializer();
        for (int i = 0; i < tileRefs.length; ++i) {
            if (in.readInt() != 6) continue;
            out.writeInt(32);
            System.out.println(String.format("start process %d/%d tile", i + 1, tileRefs.length));
            TileRef tileRef = tileRefs[i];
            ArrayList<TileRef> roundTileRefs = Processes.getAdjacencyTileRefs(tileRefs, rowTileRef, colTileRef, i, outerRound);
            out.writeInt(roundTileRefs.size() + 1);
            Utils.writeBytesAndLength(tileSerializer.encode(tileRef.getData()), out);
            for (TileRef ref : roundTileRefs) {
                Utils.writeBytesAndLength(tileSerializer.encode(ref.getData()), out);
            }
            Tile resultTile = tileSerializer.decode(Utils.readBytesAndLength(in));
            if (resultDataset == null) {
                resultDataset = Processes.createRasterDataset(resultDs, name, dataset, resultTile);
            }
            Processes.writeTileToDataset(resultDataset, resultTile, tileRef);
        }
        if (in.readInt() == 6) {
            out.writeInt(3);
        }
        out.writeInt(-1);
        socket.close();
        return true;
    }

    public static boolean processTilesGetGeometry(Dataset dataset, File pyFile, String entryClassName, int perTileRows, int perTileCols, int outerRound, Datasource resultDs, String name, Map<String, Object> args) throws Exception {
        return Processes.processTilesGetGeometry(dataset, Utils.readPyFile(pyFile), entryClassName, perTileRows, perTileCols, outerRound, resultDs, name, args);
    }

    private static void parseGeometrys(Object object, ArrayList<Geometry> geos) {
        block5: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                if (object == null) break block5;
                                if (!(object instanceof Geometry)) break block6;
                                geos.add((Geometry)object);
                                break block5;
                            }
                            if (!(object instanceof Geometry[])) break block7;
                            for (Geometry geo : (Geometry[])object) {
                                geos.add(geo);
                            }
                            break block5;
                        }
                        if (!(object instanceof GeoPoint[])) break block8;
                        for (GeoPoint geo : (GeoPoint[])object) {
                            geos.add((Geometry)geo);
                        }
                        break block5;
                    }
                    if (!(object instanceof GeoLine[])) break block9;
                    for (GeoLine geo : (GeoLine[])object) {
                        geos.add((Geometry)geo);
                    }
                    break block5;
                }
                if (!(object instanceof GeoRegion[])) break block10;
                for (GeoRegion geo : (GeoRegion[])object) {
                    geos.add((Geometry)geo);
                }
                break block5;
            }
            if (!(object instanceof Object[])) break block5;
            for (Object obj : (Object[])object) {
                if (!(obj instanceof Geometry)) continue;
                geos.add((Geometry)obj);
            }
        }
    }

    public static boolean processTilesGetGeometry(Dataset dataset, String pyText, String entryClassName, int perTileRows, int perTileCols, int outerRound, Datasource resultDs, String name, Map<String, Object> args) throws Exception {
        ServerSocket serverSocket = Utils.startPythonProcess();
        Socket socket = serverSocket.accept();
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        out.writeInt(30);
        Processes.writeProcessInfo(dataset, pyText, entryClassName, args, out);
        DataInputStream in = new DataInputStream(socket.getInputStream());
        out.writeInt(5);
        Utils.readBytesAndLength(in);
        ArrayList<Geometry> geos = new ArrayList<Geometry>(256);
        TileRef[] tileRefs = Processes.getDatasetTileRefs(dataset, perTileRows, perTileCols);
        int[] rowColTileRef = Processes.getDatasetTileRefInfo(dataset, perTileRows, perTileCols);
        int rowTileRef = rowColTileRef[0];
        int colTileRef = rowColTileRef[0];
        TileSerializer tileSerializer = new TileSerializer();
        for (int i = 0; i < tileRefs.length; ++i) {
            if (in.readInt() != 6) continue;
            out.writeInt(32);
            System.out.println(String.format("start process %d/%d tile", i + 1, tileRefs.length));
            TileRef tileRef = tileRefs[i];
            ArrayList<TileRef> roundTileRefs = Processes.getAdjacencyTileRefs(tileRefs, rowTileRef, colTileRef, i, outerRound);
            out.writeInt(roundTileRefs.size() + 1);
            Utils.writeBytesAndLength(tileSerializer.encode(tileRef.getData()), out);
            for (TileRef ref : roundTileRefs) {
                Utils.writeBytesAndLength(tileSerializer.encode(ref.getData()), out);
            }
            Object result = DataSerializers.deserialize(Utils.readBytesAndLength(in));
            Processes.parseGeometrys(result, geos);
        }
        if (in.readInt() == 6) {
            out.writeInt(3);
        }
        out.writeInt(4);
        Object result = DataSerializers.deserialize(Utils.readBytesAndLength(in));
        Processes.parseGeometrys(result, geos);
        out.writeInt(-1);
        socket.close();
        return Processes.writeGeometrysToDataset(geos, resultDs, name);
    }

    private static boolean writeGeometrysToDataset(ArrayList<Geometry> geos, Datasource resultDs, String name) {
        if (geos.size() > 0) {
            HashSet<GeometryType> geoTypes = new HashSet<GeometryType>();
            for (int i = 0; i < geos.size(); ++i) {
                if (geos.get(i) == null) continue;
                geoTypes.add(geos.get(i).getType());
            }
            DatasetType dtType = DatasetType.CAD;
            if (geoTypes.size() == 1) {
                GeometryType geoType = (GeometryType)geoTypes.iterator().next();
                dtType = Processes.geometryTypeToDatasetType(geoType);
            }
            DatasetVectorInfo dtInfo = new DatasetVectorInfo();
            dtInfo.setType(dtType);
            dtInfo.setName(name);
            DatasetVector resultDT = resultDs.getDatasets().create(dtInfo);
            if (resultDT == null) {
                throw new RuntimeException("Failed to create result dataset");
            }
            Recordset recordset = resultDT.getRecordset(false, CursorType.DYNAMIC);
            if (recordset == null) {
                throw new RuntimeException("Failed to get result recordset");
            }
            recordset.getBatch().begin();
            for (int i = 0; i < geos.size(); ++i) {
                if (geos.get(i) == null) continue;
                recordset.addNew(geos.get(i));
            }
            recordset.getBatch().update();
            recordset.dispose();
            return true;
        }
        return false;
    }

    private static ArrayList<TileRef> getAdjacencyTileRefs(TileRef[] tileRefs, int rowTileRefs, int colTileRefs, int currentRef, int outerRound) {
        int minRow;
        int curRefRow = currentRef / colTileRefs;
        int curRefCol = currentRef % colTileRefs;
        if (outerRound < 0) {
            outerRound = 0;
        }
        if ((minRow = curRefRow - outerRound) < 0) {
            minRow = 0;
        } else if (minRow >= rowTileRefs) {
            minRow = rowTileRefs - 1;
        }
        int maxRow = curRefRow + outerRound;
        if (maxRow < 0) {
            maxRow = 0;
        } else if (maxRow >= rowTileRefs) {
            maxRow = rowTileRefs - 1;
        }
        int minCol = curRefCol - outerRound;
        if (minCol < 0) {
            minCol = 0;
        } else if (minCol >= colTileRefs) {
            minCol = colTileRefs - 1;
        }
        int maxCol = curRefCol + outerRound;
        if (maxCol < 0) {
            maxCol = 0;
        } else if (maxCol >= colTileRefs) {
            maxCol = colTileRefs - 1;
        }
        ArrayList<TileRef> roundRefs = new ArrayList<TileRef>((maxRow - minRow + 1) * (maxCol - minCol + 1) - 1);
        for (int i = minRow; i <= maxRow; ++i) {
            for (int j = minCol; j <= maxCol; ++j) {
                int index = i * colTileRefs + j;
                if (index == currentRef) continue;
                roundRefs.add(tileRefs[index]);
            }
        }
        return roundRefs;
    }

    public static boolean processTilesGetFeature(Dataset dataset, File pyFile, String entryClassName, int perTileRows, int perTileCols, int outerRound, Datasource resultDs, String name, Map<String, Object> args) throws Exception {
        return Processes.processTilesGetFeature(dataset, Utils.readPyFile(pyFile), entryClassName, perTileRows, perTileCols, outerRound, resultDs, name, args);
    }

    private static void parseFeatures(Object object, ArrayList<JFeature> features) {
        block2: {
            block4: {
                block3: {
                    if (object == null) break block2;
                    if (!(object instanceof JFeature)) break block3;
                    features.add((JFeature)object);
                    break block2;
                }
                if (!(object instanceof JFeature[])) break block4;
                for (JFeature feature : (JFeature[])object) {
                    features.add(feature);
                }
                break block2;
            }
            if (!(object instanceof Object[])) break block2;
            for (Object obj : (Object[])object) {
                if (!(obj instanceof JFeature)) continue;
                features.add((JFeature)obj);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean processTilesGetFeature(Dataset dataset, String pyText, String entryClassName, int perTileRows, int perTileCols, int outerRound, Datasource resultDs, String name, Map<String, Object> args) throws Exception {
        ServerSocket serverSocket = Utils.startPythonProcess();
        Socket socket = serverSocket.accept();
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        out.writeInt(30);
        Processes.writeProcessInfo(dataset, pyText, entryClassName, args, out);
        DataInputStream in = new DataInputStream(socket.getInputStream());
        ArrayList<FieldInfo> fieldInfos = null;
        DatasetType datasetType = null;
        out.writeInt(5);
        byte[] bytes = Utils.readBytesAndLength(in);
        if (bytes.length > 0) {
            Object values;
            Object updateInfos = new MapSerializer().decode(bytes);
            if (updateInfos.containsKey(DATASETTYPE)) {
                datasetType = (DatasetType)updateInfos.get(DATASETTYPE);
            }
            if (updateInfos.containsKey(FIELDS) && (values = updateInfos.get(FIELDS)) != null) {
                fieldInfos = new ArrayList<FieldInfo>();
                if (values instanceof FieldInfo[]) {
                    void var21_27;
                    FieldInfo[] fieldInfoArray;
                    FieldInfo[] fieldInfoArray2 = fieldInfoArray = (FieldInfo[])values;
                    int n = fieldInfoArray2.length;
                    boolean bl = false;
                    while (var21_27 < n) {
                        FieldInfo fieldInfo = fieldInfoArray2[var21_27];
                        fieldInfos.add(fieldInfo);
                        ++var21_27;
                    }
                } else if (values instanceof Object[]) {
                    for (Object object : (Object[])values) {
                        if (!(object instanceof FieldInfo)) continue;
                        fieldInfos.add((FieldInfo)object);
                    }
                }
            }
        }
        ArrayList<JFeature> features = new ArrayList<JFeature>(256);
        TileRef[] tileRefs = Processes.getDatasetTileRefs(dataset, perTileRows, perTileCols);
        int[] nArray = Processes.getDatasetTileRefInfo(dataset, perTileRows, perTileCols);
        int rowTileRef = nArray[0];
        int colTileRef = nArray[0];
        TileSerializer tileSerializer = new TileSerializer();
        for (int i = 0; i < tileRefs.length; ++i) {
            if (in.readInt() != 6) continue;
            out.writeInt(32);
            System.out.println(String.format("start process %d/%d tile", i + 1, tileRefs.length));
            TileRef tileRef = tileRefs[i];
            ArrayList<TileRef> roundTileRefs = Processes.getAdjacencyTileRefs(tileRefs, rowTileRef, colTileRef, i, outerRound);
            out.writeInt(roundTileRefs.size() + 1);
            Utils.writeBytesAndLength(tileSerializer.encode(tileRef.getData()), out);
            for (TileRef ref : roundTileRefs) {
                Utils.writeBytesAndLength(tileSerializer.encode(ref.getData()), out);
            }
            Object result = DataSerializers.deserialize(Utils.readBytesAndLength(in));
            Processes.parseFeatures(result, features);
        }
        if (in.readInt() == 6) {
            out.writeInt(3);
        }
        out.writeInt(4);
        Object result = DataSerializers.deserialize(Utils.readBytesAndLength(in));
        Processes.parseFeatures(result, features);
        out.writeInt(-1);
        socket.close();
        return Processes.writeFeaturesToDataset(features, resultDs, name, datasetType, fieldInfos);
    }

    private static boolean writeFeaturesToDataset(ArrayList<JFeature> features, Datasource resultDs, String name, DatasetType datasetType, ArrayList<FieldInfo> aryFieldInfos) {
        if (features.size() > 0) {
            int i;
            DatasetType dtType;
            if (datasetType != null) {
                dtType = datasetType;
            } else {
                HashSet<GeometryType> geoTypes = new HashSet<GeometryType>();
                for (int i2 = 0; i2 < features.size(); ++i2) {
                    if (features.get(i2) == null || features.get(i2).getGeometry() == null) continue;
                    geoTypes.add(features.get(i2).getGeometry().getType());
                }
                dtType = DatasetType.CAD;
                if (geoTypes.size() == 1) {
                    GeometryType geoType = (GeometryType)geoTypes.iterator().next();
                    dtType = Processes.geometryTypeToDatasetType(geoType);
                }
            }
            DatasetVectorInfo dtInfo = new DatasetVectorInfo();
            dtInfo.setType(dtType);
            dtInfo.setName(name);
            DatasetVector resultDT = resultDs.getDatasets().create(dtInfo);
            if (resultDT == null) {
                throw new RuntimeException("Failed to create result dataset");
            }
            FieldInfo[] fieldInfos = null;
            if (aryFieldInfos != null) {
                fieldInfos = new FieldInfo[aryFieldInfos.size()];
                aryFieldInfos.toArray(fieldInfos);
            } else {
                fieldInfos = features.get(0).getFieldInfos();
            }
            resultDT.getFieldInfos().addRange(fieldInfos);
            Recordset recordset = resultDT.getRecordset(false, CursorType.DYNAMIC);
            if (recordset == null) {
                throw new RuntimeException("Failed to get result recordset");
            }
            int[] fieldIndexes = new int[fieldInfos.length];
            FieldInfos ugoFieldInfos = resultDT.getFieldInfos();
            for (i = 0; i < fieldInfos.length; ++i) {
                fieldIndexes[i] = ugoFieldInfos.indexOf(fieldInfos[i].getName());
            }
            recordset.getBatch().begin();
            for (i = 0; i < features.size(); ++i) {
                if (features.get(i) == null) continue;
                recordset.addNew(features.get(i).getGeometry());
                Object[] fieldValues = features.get(i).getValues();
                if (fieldValues == null || fieldValues.length <= 0) continue;
                for (int k = 0; k < fieldValues.length; ++k) {
                    recordset.setObject(fieldInfos[k].getName(), fieldValues[k]);
                }
            }
            recordset.getBatch().update();
            recordset.dispose();
            return true;
        }
        return false;
    }

    private static DatasetType geometryTypeToDatasetType(GeometryType geoType) {
        if (geoType == GeometryType.GEOPOINT) {
            return DatasetType.POINT;
        }
        if (geoType == GeometryType.GEOLINE) {
            return DatasetType.LINE;
        }
        if (geoType == GeometryType.GEOREGION) {
            return DatasetType.REGION;
        }
        return DatasetType.CAD;
    }
}

