/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetType;
import com.supermap.data.PixelFormat;
import com.supermap.jsuperpy.Tile;
import java.nio.ByteOrder;

public class TileRef {
    private Dataset dataset;
    private int startCol;
    private int endCol;
    private int startRow;
    private int endRow;
    private int tileCol;
    private int tileRow;

    public TileRef(Dataset dataset, int startCol, int endCol, int startRow, int endRow, int tileCol, int tileRow) {
        this.dataset = dataset;
        this.startCol = startCol;
        this.endCol = endCol;
        this.startRow = startRow;
        this.endRow = endRow;
        this.tileCol = tileCol;
        this.tileRow = tileRow;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getEncCol() {
        return this.endCol;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public int getTileRow() {
        return this.tileRow;
    }

    public int getTileCol() {
        return this.tileCol;
    }

    public int getBands() {
        if (this.dataset.getType() == DatasetType.GRID) {
            return 1;
        }
        if (this.dataset.getType() == DatasetType.IMAGE) {
            return ((DatasetImage)this.dataset).getBandCount();
        }
        return 0;
    }

    public static int[] valueToRGB(int value) {
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            int r = value & 0xFF;
            int g = value >> 8 & 0xFF;
            int b = value >> 16 & 0xFF;
            int a = value >> 24 & 0xFF;
            return new int[]{r, g, b, a};
        }
        int a = value & 0xFF;
        int b = value >> 8 & 0xFF;
        int g = value >> 16 & 0xFF;
        int r = value >> 24 & 0xFF;
        return new int[]{r, g, b, a};
    }

    public static int rgbToValue(int[] value) {
        if (value.length == 3) {
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                return 0xFF000000 | (value[2] << 16 | (value[1] << 8 | value[0]));
            }
            return value[0] << 24 | (value[1] << 16 | (value[2] << 8 | 0xFF));
        }
        if (value.length == 4) {
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                return value[3] << 24 | (value[2] << 16 | (value[1] << 8 | value[0]));
            }
            return value[0] << 24 | (value[1] << 16 | (value[2] << 8 | value[3]));
        }
        if (value.length == 1) {
            return value[0];
        }
        throw new IllegalArgumentException("invalid input value");
    }

    public Tile getData() {
        int rows = this.endRow - this.startRow + 1;
        int cols = this.endCol - this.startCol + 1;
        int perBandCount = rows * cols;
        if (this.dataset.getType() == DatasetType.GRID) {
            double[] values = new double[rows * cols];
            DatasetGrid datasetGrid = (DatasetGrid)this.dataset;
            for (int i = 0; i < cols; ++i) {
                for (int j = 0; j < rows; ++j) {
                    try {
                        values[j * cols + i] = datasetGrid.getValue(i + this.startCol, j + this.startRow);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw e;
                    }
                }
            }
            return new Tile(rows, cols, datasetGrid.getNoValue(), datasetGrid.getPixelFormat(), 1).addAllValues(values);
        }
        if (this.dataset.getType() == DatasetType.IMAGE) {
            DatasetImage datasetImage = (DatasetImage)this.dataset;
            int bands = datasetImage.getBandCount();
            if (bands > 1) {
                double[] values = new double[rows * cols * bands];
                for (int band = 0; band < bands; ++band) {
                    for (int i = 0; i < cols; ++i) {
                        for (int j = 0; j < rows; ++j) {
                            values[band * perBandCount + j * cols + i] = datasetImage.getValue(i + this.startCol, j + this.startRow, band);
                        }
                    }
                }
                return new Tile(rows, cols, datasetImage.getNoData(0), datasetImage.getPixelFormat(0), bands).addAllValues(values);
            }
            if (datasetImage.getPixelFormat(0) == PixelFormat.RGB) {
                double[] values = new double[rows * cols * 3];
                for (int i = 0; i < cols; ++i) {
                    for (int j = 0; j < rows; ++j) {
                        double value = datasetImage.getValue(i + this.startCol, j + this.startRow, 0);
                        int[] rgb = TileRef.valueToRGB((int)value);
                        values[0 * perBandCount + j * cols + i] = rgb[0];
                        values[1 * perBandCount + j * cols + i] = rgb[1];
                        values[2 * perBandCount + j * cols + i] = rgb[2];
                    }
                }
                return new Tile(rows, cols, datasetImage.getNoData(0), PixelFormat.RGB, 3).addAllValues(values);
            }
            if (datasetImage.getPixelFormat(0) == PixelFormat.RGBA) {
                double[] values = new double[rows * cols * 4];
                for (int i = 0; i < cols; ++i) {
                    for (int j = 0; j < rows; ++j) {
                        double value = datasetImage.getValue(i + this.startCol, j + this.startRow, 0);
                        int[] rgb = TileRef.valueToRGB((int)value);
                        values[0 * perBandCount + j * cols + i] = rgb[0];
                        values[1 * perBandCount + j * cols + i] = rgb[1];
                        values[2 * perBandCount + j * cols + i] = rgb[2];
                        values[3 * perBandCount + j * cols + i] = rgb[3];
                    }
                }
                return new Tile(rows, cols, datasetImage.getNoData(0), PixelFormat.RGB, 4).addAllValues(values);
            }
            double[] values = new double[rows * cols];
            for (int i = 0; i < cols; ++i) {
                for (int j = 0; j < rows; ++j) {
                    values[j * cols + i] = datasetImage.getValue(i + this.startCol, j + this.startRow, 0);
                }
            }
            return new Tile(rows, cols, datasetImage.getNoData(0), datasetImage.getPixelFormat(0), 1).addAllValues(values);
        }
        throw new IllegalArgumentException("Unsupported dataset type " + this.dataset.getType().toString());
    }

    public Tile getData(Double newNoValue) {
        int rows = this.endRow - this.startRow + 1;
        int cols = this.endCol - this.startCol + 1;
        int perBandCount = rows * cols;
        if (this.dataset.getType() == DatasetType.GRID) {
            double[] values = new double[rows * cols];
            DatasetGrid datasetGrid = (DatasetGrid)this.dataset;
            double noValue = datasetGrid.getNoValue();
            boolean isEqual = true;
            if (newNoValue != null) {
                isEqual = noValue == newNoValue;
            }
            for (int i = 0; i < cols; ++i) {
                for (int j = 0; j < rows; ++j) {
                    try {
                        double value = datasetGrid.getValue(i + this.startCol, j + this.startRow);
                        if (!isEqual && value == noValue) {
                            value = newNoValue;
                        }
                        values[j * cols + i] = value;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw e;
                    }
                }
            }
            return new Tile(rows, cols, datasetGrid.getNoValue(), datasetGrid.getPixelFormat(), 1).addAllValues(values);
        }
        if (this.dataset.getType() == DatasetType.IMAGE) {
            DatasetImage datasetImage = (DatasetImage)this.dataset;
            int bands = datasetImage.getBandCount();
            if (bands > 1) {
                double[] values = new double[rows * cols * bands];
                for (int band = 0; band < bands; ++band) {
                    double noValue = datasetImage.getNoData(band);
                    boolean isEqual = true;
                    if (newNoValue != null) {
                        isEqual = noValue == newNoValue;
                    }
                    for (int i = 0; i < cols; ++i) {
                        for (int j = 0; j < rows; ++j) {
                            double value = datasetImage.getValue(i + this.startCol, j + this.startRow, band);
                            if (!isEqual && value == noValue) {
                                value = newNoValue;
                            }
                            values[band * perBandCount + j * cols + i] = value;
                        }
                    }
                }
                return new Tile(rows, cols, datasetImage.getNoData(0), datasetImage.getPixelFormat(0), bands).addAllValues(values);
            }
            if (datasetImage.getPixelFormat(0) == PixelFormat.RGB) {
                double[] values = new double[rows * cols * 3];
                double noValue = datasetImage.getNoData(0);
                boolean isEqual = true;
                if (newNoValue != null) {
                    isEqual = noValue == newNoValue;
                }
                for (int i = 0; i < cols; ++i) {
                    for (int j = 0; j < rows; ++j) {
                        double value = datasetImage.getValue(i + this.startCol, j + this.startRow, 0);
                        if (!isEqual && value == noValue) {
                            value = newNoValue;
                        }
                        int[] rgb = TileRef.valueToRGB((int)value);
                        values[0 * perBandCount + j * cols + i] = rgb[0];
                        values[1 * perBandCount + j * cols + i] = rgb[1];
                        values[2 * perBandCount + j * cols + i] = rgb[2];
                    }
                }
                return new Tile(rows, cols, datasetImage.getNoData(0), PixelFormat.RGB, 3).addAllValues(values);
            }
            if (datasetImage.getPixelFormat(0) == PixelFormat.RGBA) {
                double[] values = new double[rows * cols * 4];
                double noValue = datasetImage.getNoData(0);
                boolean isEqual = true;
                if (newNoValue != null) {
                    isEqual = noValue == newNoValue;
                }
                for (int i = 0; i < cols; ++i) {
                    for (int j = 0; j < rows; ++j) {
                        double value = datasetImage.getValue(i + this.startCol, j + this.startRow, 0);
                        if (!isEqual && value == noValue) {
                            value = newNoValue;
                        }
                        int[] rgb = TileRef.valueToRGB((int)value);
                        values[0 * perBandCount + j * cols + i] = rgb[0];
                        values[1 * perBandCount + j * cols + i] = rgb[1];
                        values[2 * perBandCount + j * cols + i] = rgb[2];
                        values[3 * perBandCount + j * cols + i] = rgb[3];
                    }
                }
                return new Tile(rows, cols, datasetImage.getNoData(0), PixelFormat.RGB, 4).addAllValues(values);
            }
            double[] values = new double[rows * cols];
            double noValue = datasetImage.getNoData(0);
            boolean isEqual = true;
            if (newNoValue != null) {
                isEqual = noValue == newNoValue;
            }
            for (int i = 0; i < cols; ++i) {
                for (int j = 0; j < rows; ++j) {
                    double value = datasetImage.getValue(i + this.startCol, j + this.startRow, 0);
                    if (!isEqual && value == noValue) {
                        value = newNoValue;
                    }
                    values[j * cols + i] = value;
                }
            }
            return new Tile(rows, cols, datasetImage.getNoData(0), datasetImage.getPixelFormat(0), 1).addAllValues(values);
        }
        throw new IllegalArgumentException("Unsupported dataset type " + this.dataset.getType().toString());
    }
}

