/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.processing.CompactFileNative;
import com.supermap.data.processing.CompactFileOpenMode;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalResource;

public class CompactFile
extends InternalHandleDisposable {
    public CompactFile() {
        long l = CompactFileNative.jni_New();
        this.setHandle(l, true);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            CompactFileNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public int Creat(String cfPath, int rowNum, int colNum, String pwd) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Open()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CompactFileNative.jni_Create(this.getHandle(), cfPath, rowNum, colNum, pwd);
    }

    public int Open(String cfPath, String pwd) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Open()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CompactFileNative.jni_Open(this.getHandle(), cfPath, pwd, CompactFileOpenMode.ReadWrite.value());
    }

    public int Open(String cfPath, String pwd, CompactFileOpenMode openmode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Open()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CompactFileNative.jni_Open(this.getHandle(), cfPath, pwd, openmode.value());
    }

    public boolean Close() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Close()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CompactFileNative.jni_Close(this.getHandle());
    }

    public int SetAt(int row, int col, byte[] data) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetAt()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CompactFileNative.jni_SetAt(this.getHandle(), row, col, data);
    }

    public byte[] getAt(int row, int col) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetAt()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CompactFileNative.jni_GetAt(this.getHandle(), row, col);
    }

    public static byte[] getData(String cfPath, String pwd, int row, int col) {
        return CompactFileNative.jni_GetGridData(cfPath, pwd, row, col);
    }
}

