/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.SmoothMethod;
import java.util.Arrays;

public class SurfaceExtractParameter {
    private double m_interval = 0.0;
    private double m_datumValue = 0.0;
    private int m_smoothness = 0;
    private SmoothMethod m_smoothMethod = SmoothMethod.NONE;
    private double m_resampleTolerance = 0.0;
    private double[] m_expectedZValues = null;

    public SurfaceExtractParameter() {
    }

    public SurfaceExtractParameter(double interval, double datumValue) {
        this();
        this.m_interval = interval;
        this.m_datumValue = datumValue;
    }

    public SurfaceExtractParameter(double[] expectedZValues) {
        this();
        this.m_expectedZValues = expectedZValues;
    }

    public double getDatumValue() {
        return this.m_datumValue;
    }

    public double getInterval() {
        return this.m_interval;
    }

    public double getResampleTolerance() {
        return this.m_resampleTolerance;
    }

    public SmoothMethod getSmoothMethod() {
        return this.m_smoothMethod;
    }

    public int getSmoothness() {
        return this.m_smoothness;
    }

    public double[] getExpectedZValues() {
        return this.m_expectedZValues;
    }

    public void setDatumValue(double value) {
        this.m_datumValue = value;
    }

    public void setInterval(double value) {
        this.m_interval = value;
    }

    public void setResampleTolerance(double value) {
        this.m_resampleTolerance = value;
    }

    public void setSmoothMethod(SmoothMethod smoothMothod) {
        this.m_smoothMethod = smoothMothod;
    }

    public void setSmoothness(int value) {
        if (value < 0 || value > 5) {
            String string = InternalResource.loadString("smoothness", "SurfaceExtractParameter_BetweenZeroAndFive", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_smoothness = value;
    }

    public void setExpectedZValues(double[] values) {
        this.m_expectedZValues = values;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{DatumValue=");
        stringBuffer.append(this.getDatumValue());
        stringBuffer.append(",Interval=");
        stringBuffer.append(this.getInterval());
        stringBuffer.append(",SmoothMethod=");
        stringBuffer.append(this.getSmoothMethod().name());
        stringBuffer.append(",Smoothness=");
        stringBuffer.append(this.getSmoothness());
        stringBuffer.append(",ResampleTolerance=");
        stringBuffer.append(this.getResampleTolerance());
        stringBuffer.append(",ExpectedZValues=");
        stringBuffer.append(Arrays.toString(this.getExpectedZValues()));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

