/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.BasicStatisticsAnalystResult;
import com.supermap.analyst.spatialanalyst.FunctionType;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.GridHistogram;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsAnnulusParameter;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsCircleParameter;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsParameter;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsParameterNative;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsRectangleParameter;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsWedgeParameter;
import com.supermap.analyst.spatialanalyst.NeighbourUnitType;
import com.supermap.analyst.spatialanalyst.StatisticsAnalystNative;
import com.supermap.analyst.spatialanalyst.StatisticsCompareType;
import com.supermap.analyst.spatialanalyst.ZonalStatisticsAnalystParameter;
import com.supermap.analyst.spatialanalyst.ZonalStatisticsAnalystResult;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class StatisticsAnalyst {
    private static License m_license;
    private static transient Vector m_steppedListeners;
    private static GridAnalystSetting m_gridAnalystSetting;

    private StatisticsAnalyst() {
    }

    private static GridAnalystSetting getAnalystSetting() {
        return m_gridAnalystSetting;
    }

    private static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            m_gridAnalystSetting = null;
            return;
        }
        if (m_gridAnalystSetting == null) {
            m_gridAnalystSetting = new GridAnalystSetting();
        }
        m_gridAnalystSetting.setBounds(gridAnalystSetting.getBounds());
        m_gridAnalystSetting.setBoundsType(gridAnalystSetting.getBoundsType());
        m_gridAnalystSetting.setCellSizeType(gridAnalystSetting.getCellSizeType());
        m_gridAnalystSetting.setCellSize(gridAnalystSetting.getCellSize());
        m_gridAnalystSetting.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        m_gridAnalystSetting.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        m_gridAnalystSetting.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        m_gridAnalystSetting.setValidRegion(gridAnalystSetting.getValidRegion());
        m_gridAnalystSetting.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static GridHistogram createHistogram(DatasetGrid statisticsGrid, int groupCount) {
        GridHistogram gridHistogram = StatisticsAnalyst.createHistogram(statisticsGrid, groupCount, FunctionType.NONE);
        return gridHistogram;
    }

    public static GridHistogram createHistogram(DatasetGrid statisticsGrid, int groupCount, FunctionType functionType) {
        StatisticsAnalyst.verifyLicense();
        if (statisticsGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsGrid) == 0L) {
            String string = InternalResource.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (groupCount <= 0) {
            String string = InternalResource.loadString("groupCount", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (functionType == FunctionType.LOG && statisticsGrid.getMinValue() <= 0.0) {
            String string = InternalResource.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (functionType == FunctionType.ARCSIN && (statisticsGrid.getMinValue() < -1.0 || statisticsGrid.getMaxValue() > 1.0)) {
            String string = InternalResource.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsGrid);
        long l2 = StatisticsAnalystNative.jni_CreateHistogram(l, groupCount, InternalEnum.getUGCValue(functionType));
        GridHistogram gridHistogram = null;
        if (0L != l2) {
            gridHistogram = new GridHistogram(l2);
        }
        return gridHistogram;
    }

    public static GridHistogram createImageHistogram(DatasetImage statisticsImage, int groupCount, FunctionType functionType, int bandIndex) {
        if (statisticsImage == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsImage) == 0L) {
            String string = InternalResource.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (groupCount <= 0) {
            String string = InternalResource.loadString("groupCount", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = statisticsImage.getBandCount();
        if (bandIndex >= n || bandIndex < 0) {
            String string = InternalResource.loadString("bandIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (functionType == FunctionType.LOG && statisticsImage.getMinValue(bandIndex) <= 0.0) {
            String string = InternalResource.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (functionType == FunctionType.ARCSIN && (statisticsImage.getMinValue(bandIndex) < -1.0 || statisticsImage.getMaxValue(bandIndex) > 1.0)) {
            String string = InternalResource.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsImage);
        long l2 = StatisticsAnalystNative.jni_CreateImageHistogram(l, groupCount, InternalEnum.getUGCValue(functionType), bandIndex);
        GridHistogram gridHistogram = null;
        if (0L != l2) {
            gridHistogram = new GridHistogram(l2);
        }
        return gridHistogram;
    }

    public static GridHistogram[] createImageHistogram(DatasetImage statisticsImage, int groupCount, FunctionType functionType) {
        if (statisticsImage == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsImage) == 0L) {
            String string = InternalResource.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (groupCount <= 0) {
            String string = InternalResource.loadString("groupCount", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsImage);
        int n = statisticsImage.getBandCount();
        GridHistogram[] gridHistogramArray = new GridHistogram[n];
        for (int i = 0; i < n; ++i) {
            if (functionType == FunctionType.LOG && statisticsImage.getMinValue(i) <= 0.0) {
                String string = InternalResource.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (functionType == FunctionType.ARCSIN && (statisticsImage.getMinValue(i) < -1.0 || statisticsImage.getMaxValue(i) > 1.0)) {
                String string = InternalResource.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = StatisticsAnalystNative.jni_CreateImageHistogram(l, groupCount, InternalEnum.getUGCValue(functionType), i);
            GridHistogram gridHistogram = null;
            if (0L != l2) {
                gridHistogram = new GridHistogram(l2);
            }
            gridHistogramArray[i] = gridHistogram;
        }
        return gridHistogramArray;
    }

    public static BasicStatisticsAnalystResult basicStatistics(DatasetGrid statisticsGrid) {
        BasicStatisticsAnalystResult basicStatisticsAnalystResult = StatisticsAnalyst.basicStatistics(statisticsGrid, FunctionType.NONE);
        return basicStatisticsAnalystResult;
    }

    public static BasicStatisticsAnalystResult basicStatistics(DatasetGrid statisticsGrid, FunctionType functionType) {
        StatisticsAnalyst.verifyLicense();
        if (statisticsGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsGrid) == 0L) {
            String string = InternalResource.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (functionType == FunctionType.LOG && statisticsGrid.getMinValue() <= 0.0) {
            String string = InternalResource.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (functionType == FunctionType.ARCSIN && (statisticsGrid.getMinValue() < -1.0 || statisticsGrid.getMaxValue() > 1.0)) {
            String string = InternalResource.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsGrid);
        double[] dArray = StatisticsAnalystNative.jni_BasicStatistics(l, InternalEnum.getUGCValue(functionType));
        BasicStatisticsAnalystResult basicStatisticsAnalystResult = null;
        if (null != dArray && dArray.length > 0) {
            basicStatisticsAnalystResult = new BasicStatisticsAnalystResult(dArray);
        }
        return basicStatisticsAnalystResult;
    }

    public static BasicStatisticsAnalystResult imageBasicStatistics(DatasetImage statisticsImage, FunctionType functionType, int bandIndex) {
        StatisticsAnalyst.verifyLicense();
        if (statisticsImage == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsImage) == 0L) {
            String string = InternalResource.loadString("statisticsImage", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = statisticsImage.getBandCount();
        if (bandIndex >= n || bandIndex < 0) {
            String string = InternalResource.loadString("bandIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (functionType == FunctionType.LOG && statisticsImage.getMinValue(bandIndex) <= 0.0) {
            String string = InternalResource.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (functionType == FunctionType.ARCSIN && (statisticsImage.getMinValue(bandIndex) < -1.0 || statisticsImage.getMaxValue(bandIndex) > 1.0)) {
            String string = InternalResource.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsImage);
        double[] dArray = StatisticsAnalystNative.jni_ImageBasicStatistics(l, InternalEnum.getUGCValue(functionType), bandIndex);
        BasicStatisticsAnalystResult basicStatisticsAnalystResult = null;
        if (null != dArray && dArray.length > 0) {
            basicStatisticsAnalystResult = new BasicStatisticsAnalystResult(dArray);
        }
        return basicStatisticsAnalystResult;
    }

    public static BasicStatisticsAnalystResult[] imageBasicStatistics(DatasetImage statisticsImage, FunctionType functionType) {
        StatisticsAnalyst.verifyLicense();
        if (statisticsImage == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsImage) == 0L) {
            String string = InternalResource.loadString("statisticsImage", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n = statisticsImage.getBandCount();
        for (int i = 0; i < n; ++i) {
            if (functionType == FunctionType.LOG && statisticsImage.getMinValue(i) <= 0.0) {
                String string = InternalResource.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (functionType != FunctionType.ARCSIN || !(statisticsImage.getMinValue(i) < -1.0) && !(statisticsImage.getMaxValue(i) > 1.0)) continue;
            String string = InternalResource.loadString("functionType", "InvalidFunctionType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        BasicStatisticsAnalystResult[] basicStatisticsAnalystResultArray = new BasicStatisticsAnalystResult[n];
        for (int i = 0; i < n; ++i) {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsImage);
            double[] dArray = StatisticsAnalystNative.jni_ImageBasicStatistics(l, InternalEnum.getUGCValue(functionType), i);
            BasicStatisticsAnalystResult basicStatisticsAnalystResult = null;
            if (null != dArray && dArray.length > 0) {
                basicStatisticsAnalystResult = new BasicStatisticsAnalystResult(dArray);
            }
            basicStatisticsAnalystResultArray[i] = basicStatisticsAnalystResult;
        }
        return basicStatisticsAnalystResultArray;
    }

    public static DatasetGrid commonStatistics(DatasetGrid statisticsGrid, double comparedValue, StatisticsCompareType type, boolean isIgnoreNoValue, Datasource targetDatasource, String targetDatasetName) {
        StatisticsAnalyst.verifyLicense();
        Datasource datasource = targetDatasource;
        String string = targetDatasetName;
        if (statisticsGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsGrid) == 0L) {
            String string2 = InternalResource.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            if (m_gridAnalystSetting == null || m_gridAnalystSetting.getOutputDatasource() == null) {
                String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string3);
            }
            datasource = m_gridAnalystSetting.getOutputDatasource();
        }
        if (string == null) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (m_gridAnalystSetting != null && m_gridAnalystSetting.getVectorOutputNamePrefix() != null) {
            string = m_gridAnalystSetting.getVectorOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = 0L;
        l3 = StatisticsAnalystNative.jni_CommonStatistics(l, comparedValue, InternalEnum.getUGCValue(type), isIgnoreNoValue, l2, string);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid commonStatistics(DatasetGrid statisticsGrid, DatasetGrid[] compareDatasets, StatisticsCompareType compareType, boolean isIgnoreNoValue, Datasource targetDatasource, String targetDatasetName) {
        StatisticsAnalyst.verifyLicense();
        Datasource datasource = targetDatasource;
        String string = targetDatasetName;
        if (statisticsGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsGrid) == 0L) {
            String string2 = InternalResource.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            if (m_gridAnalystSetting == null || m_gridAnalystSetting.getOutputDatasource() == null) {
                String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string3);
            }
            datasource = m_gridAnalystSetting.getOutputDatasource();
        }
        if (string == null) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (m_gridAnalystSetting != null && m_gridAnalystSetting.getGridOutputNamePrefix() != null) {
            string = m_gridAnalystSetting.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long[] lArray = new long[compareDatasets.length];
        for (int i = 0; i < compareDatasets.length; ++i) {
            long l;
            lArray[i] = l = InternalHandle.getHandle((com.supermap.data.InternalHandle)compareDatasets[i]);
            if (l != 0L) continue;
            String string6 = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)statisticsGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = 0L;
        l3 = StatisticsAnalystNative.jni_CommonStatistics2(l, lArray, InternalEnum.getUGCValue(compareType), isIgnoreNoValue, l2, string);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid neighbourStatistics(NeighbourStatisticsParameter parameter) {
        StatisticsAnalyst.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        Datasource datasource = parameter.getTargetDatasource();
        String string = parameter.getTargetDatasetName();
        if (parameter.getSourceDataset() == null) {
            String string2 = InternalResource.loadString("SourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (parameter.getTargetDatasource() == null) {
            if (m_gridAnalystSetting == null || m_gridAnalystSetting.getOutputDatasource() == null) {
                String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string3);
            }
            datasource = m_gridAnalystSetting.getOutputDatasource();
        }
        if (string == null) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (m_gridAnalystSetting != null && m_gridAnalystSetting.getGridOutputNamePrefix() != null) {
            string = m_gridAnalystSetting.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = NeighbourStatisticsParameterNative.jni_New();
        int n = InternalEnum.getUGCValue(parameter.getUnitType());
        NeighbourStatisticsParameterNative.jni_SetUnitType(l, n);
        int n2 = InternalEnum.getUGCValue(parameter.getShapeType());
        NeighbourStatisticsParameterNative.jni_SetShapeType(l, n2);
        double d = Math.min(parameter.getSourceDataset().getBounds().getHeight(), parameter.getSourceDataset().getBounds().getWidth()) / 2.0;
        int n3 = Math.min(parameter.getSourceDataset().getHeight(), parameter.getSourceDataset().getWidth()) / 2;
        switch (n2) {
            case 1: {
                NeighbourStatisticsRectangleParameter neighbourStatisticsRectangleParameter = (NeighbourStatisticsRectangleParameter)parameter;
                if (neighbourStatisticsRectangleParameter.getUnitType() == NeighbourUnitType.CELL) {
                    if (neighbourStatisticsRectangleParameter.getHeight() > (double)n3 || neighbourStatisticsRectangleParameter.getWidth() > (double)n3) {
                        String string6 = InternalResource.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string6);
                    }
                } else if (neighbourStatisticsRectangleParameter.getHeight() > d || neighbourStatisticsRectangleParameter.getWidth() > d) {
                    String string7 = InternalResource.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string7);
                }
                NeighbourStatisticsParameterNative.jni_SetWidthHeight(l, neighbourStatisticsRectangleParameter.getWidth(), neighbourStatisticsRectangleParameter.getHeight());
                break;
            }
            case 2: {
                NeighbourStatisticsCircleParameter neighbourStatisticsCircleParameter = (NeighbourStatisticsCircleParameter)parameter;
                if (neighbourStatisticsCircleParameter.getUnitType() == NeighbourUnitType.CELL) {
                    if (neighbourStatisticsCircleParameter.getRadius() > (double)n3) {
                        String string8 = InternalResource.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string8);
                    }
                } else if (neighbourStatisticsCircleParameter.getRadius() > d) {
                    String string9 = InternalResource.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string9);
                }
                NeighbourStatisticsParameterNative.jni_SetRadius(l, neighbourStatisticsCircleParameter.getRadius());
                break;
            }
            case 3: {
                NeighbourStatisticsAnnulusParameter neighbourStatisticsAnnulusParameter = (NeighbourStatisticsAnnulusParameter)parameter;
                if (neighbourStatisticsAnnulusParameter.getUnitType() == NeighbourUnitType.CELL) {
                    if (neighbourStatisticsAnnulusParameter.getInnerRadius() > (double)n3 || neighbourStatisticsAnnulusParameter.getOuterRadius() > (double)n3) {
                        String string10 = InternalResource.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string10);
                    }
                } else if (neighbourStatisticsAnnulusParameter.getInnerRadius() > d || neighbourStatisticsAnnulusParameter.getOuterRadius() > d) {
                    String string11 = InternalResource.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string11);
                }
                NeighbourStatisticsParameterNative.jni_SetAnnulusRadius(l, neighbourStatisticsAnnulusParameter.getInnerRadius(), neighbourStatisticsAnnulusParameter.getOuterRadius());
                break;
            }
            case 4: {
                NeighbourStatisticsWedgeParameter neighbourStatisticsWedgeParameter = (NeighbourStatisticsWedgeParameter)parameter;
                if (neighbourStatisticsWedgeParameter.getUnitType() == NeighbourUnitType.CELL) {
                    if (neighbourStatisticsWedgeParameter.getRadius() > (double)n3) {
                        String string12 = InternalResource.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string12);
                    }
                } else if (neighbourStatisticsWedgeParameter.getRadius() > d) {
                    String string13 = InternalResource.loadString("parameter", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string13);
                }
                NeighbourStatisticsParameterNative.jni_SetRadius(l, neighbourStatisticsWedgeParameter.getRadius());
                NeighbourStatisticsParameterNative.jni_SetWedgeAngle(l, neighbourStatisticsWedgeParameter.getStartAngle(), neighbourStatisticsWedgeParameter.getEndAngle());
                break;
            }
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getSourceDataset());
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        int n4 = InternalEnum.getUGCValue(parameter.getStatisticsMode());
        long l4 = 0L;
        l4 = StatisticsAnalystNative.jni_NeighbourStatistics(l2, l, n4, parameter.isIgnoreNoValue(), l3, string);
        NeighbourStatisticsParameterNative.jni_Dispose(l);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static ZonalStatisticsAnalystResult zonalStatisticsOnRasterValue(ZonalStatisticsAnalystParameter parameter) {
        String string;
        StatisticsAnalyst.verifyLicense();
        if (parameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        Datasource datasource = parameter.getTargetDatasource();
        if (parameter.getTargetDatasource() == null) {
            if (m_gridAnalystSetting == null || m_gridAnalystSetting.getOutputDatasource() == null) {
                String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string3);
            }
            datasource = m_gridAnalystSetting.getOutputDatasource();
        }
        if ((string = parameter.getTargetDatasetName()) == null) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (m_gridAnalystSetting != null && m_gridAnalystSetting.getGridOutputNamePrefix() != null) {
            string = m_gridAnalystSetting.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getZonalDataset());
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getValueDataset());
        long l3 = 0L;
        if (datasource != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        }
        int n = InternalEnum.getUGCValue(parameter.getStatisticsMode());
        long[] lArray = StatisticsAnalystNative.jni_ZonalStatisticsOnRasterValue(l, parameter.getZonalFieldName(), l2, n, l3, string, l3, parameter.getTargetTableName(), parameter.isIgnoreNoValue());
        ZonalStatisticsAnalystResult zonalStatisticsAnalystResult = null;
        if (null != lArray && lArray.length == 2) {
            DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(lArray[0], datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
            DatasetVector datasetVector = null;
            datasetVector = InternalDatasetVector.createInstance(lArray[1], datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
            zonalStatisticsAnalystResult = new ZonalStatisticsAnalystResult(datasetGrid, datasetVector);
        }
        return zonalStatisticsAnalystResult;
    }

    private static boolean zonalStatisticsOnVectorValue(ZonalStatisticsAnalystParameter parameter) {
        StatisticsAnalyst.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (parameter.getTargetDatasource() == null) {
            String string = InternalResource.loadString("TargetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!parameter.getTargetDatasource().getDatasets().isAvailableDatasetName(parameter.getTargetDatasetName())) {
            String string = InternalResource.loadString("TargetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getZonalDataset());
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getValueDataset());
        int n = InternalEnum.getUGCValue((Enum)parameter.getPixelFormat());
        int n2 = InternalEnum.getUGCValue(parameter.getStatisticsMode());
        return StatisticsAnalystNative.jni_ZonalStatisticVectorOnVector(l, parameter.getZonalFieldName(), null, l2, null, 0.0, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "StatisticsAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        StatisticsAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

