/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.ComputeDistanceResult;
import com.supermap.analyst.spatialanalyst.ComputeDistanceResultInternal;
import com.supermap.analyst.spatialanalyst.ComputeDistanceType;
import com.supermap.analyst.spatialanalyst.Generalization;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalGeometry;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.ProximityAnalystNative;
import com.supermap.analyst.spatialanalyst.StatisticsField;
import com.supermap.analyst.spatialanalyst.StatisticsPoint;
import com.supermap.analyst.spatialanalyst.StatisticsType;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.FieldInfos;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.QueryParameter;
import com.supermap.data.Recordset;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Unit;
import java.util.ArrayList;
import java.util.Vector;

public class ProximityAnalyst {
    private static transient Vector<SteppedListener> m_steppedListeners;
    private static License m_license;

    private ProximityAnalyst() {
    }

    public static DatasetVector createThiessenPolygon(DatasetVector sourcePoint, Datasource outputDatasource, String outputDatasetName, GeoRegion clipRegion) {
        ProximityAnalyst.verifyLicense();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourcePoint);
        if (sourcePoint == null || l == 0L) {
            String string = InternalResource.loadString("sourcePoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!sourcePoint.getType().equals((Object)DatasetType.POINT)) {
            String string = InternalResource.loadString("sourcePoint", "ProximityAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (outputDatasource == null || l2 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        long l4 = ProximityAnalystNative.jni_CreateThiessenPolygon(l, l2, outputDatasetName, l3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector createThiessenPolygon(Recordset sourcePointRecordset, Datasource outputDatasource, String outputDatasetName, GeoRegion clipRegion) {
        ProximityAnalyst.verifyLicense();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourcePointRecordset);
        if (sourcePointRecordset == null || l == 0L) {
            String string = InternalResource.loadString("sourcePointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!sourcePointRecordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string = InternalResource.loadString("sourcePointRecordset", "ProximityAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (outputDatasource == null || l2 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        long l4 = ProximityAnalystNative.jni_CreateThiessenPolygonByRecordset(l, l2, outputDatasetName, l3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourcePointRecordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector createThiessenPolygon(Point2Ds sourcePoints, Datasource outputDatasource, String outputDatasetName, GeoRegion clipRegion) {
        ProximityAnalyst.verifyLicense();
        if (sourcePoints == null || sourcePoints.getCount() == 0) {
            String string = InternalResource.loadString("sourcePoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (outputDatasource == null || l == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        int n = sourcePoints.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = sourcePoints.getItem(i).getX();
            dArray2[i] = sourcePoints.getItem(i).getY();
        }
        long l3 = ProximityAnalystNative.jni_CreateThiessPolygonByPoints2Ds(dArray, dArray2, l, outputDatasetName, l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static GeoRegion[] createThiessenPolygon(DatasetVector sourcePoint, GeoRegion clipRegion) {
        ProximityAnalyst.verifyLicense();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourcePoint);
        if (sourcePoint == null || l == 0L) {
            String string = InternalResource.loadString("sourcePoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!sourcePoint.getType().equals((Object)DatasetType.POINT)) {
            String string = InternalResource.loadString("sourcePoint", "ProximityAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        Recordset recordset = sourcePoint.getRecordset(false, CursorType.STATIC);
        GeoRegion[] geoRegionArray = ProximityAnalyst.createThiessenPolygon(recordset, clipRegion);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        recordset.dispose();
        return geoRegionArray;
    }

    public static GeoRegion[] createThiessenPolygon(Recordset sourcePointRecordset, GeoRegion clipRegion) {
        String string;
        ProximityAnalyst.verifyLicense();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourcePointRecordset);
        if (sourcePointRecordset == null || l == 0L) {
            String string2 = InternalResource.loadString("sourcePointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (!sourcePointRecordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string3 = InternalResource.loadString("sourcePointRecordset", "ProximityAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        Datasource datasource = sourcePointRecordset.getDataset().getDatasource();
        DatasetVector datasetVector = ProximityAnalyst.createThiessenPolygon(sourcePointRecordset, datasource, string = datasource.getDatasets().getAvailableDatasetName("name"), clipRegion);
        if (datasetVector == null) {
            return new GeoRegion[0];
        }
        ArrayList<GeoRegion> arrayList = new ArrayList<GeoRegion>();
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        recordset.moveFirst();
        while (!recordset.isEOF()) {
            GeoRegion geoRegion = (GeoRegion)recordset.getGeometry();
            arrayList.add(geoRegion);
            recordset.moveNext();
        }
        int n = arrayList.size();
        GeoRegion[] geoRegionArray = new GeoRegion[n];
        for (int i = 0; i < n; ++i) {
            geoRegionArray[i] = (GeoRegion)arrayList.get(i);
        }
        recordset.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoRegionArray;
    }

    public static GeoRegion[] createThiessenPolygon(Point2Ds sourcePoints, GeoRegion clipRegion) {
        ProximityAnalyst.verifyLicense();
        if (sourcePoints == null || sourcePoints.getCount() < 3) {
            String string = InternalResource.loadString("sourcePoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        int n = sourcePoints.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = sourcePoints.getItem(i).getX();
            dArray2[i] = sourcePoints.getItem(i).getY();
        }
        long[] lArray = ProximityAnalystNative.jni_CreateThiessPolygonByPoints2DsSecond(dArray, dArray2, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        GeoRegion[] geoRegionArray = null;
        if (lArray == null) {
            geoRegionArray = new GeoRegion[]{};
        } else {
            int n2 = lArray.length;
            geoRegionArray = new GeoRegion[n2];
            for (int i = 0; i < n2; ++i) {
                geoRegionArray[i] = (GeoRegion)InternalGeometry.createInstance(lArray[i]);
            }
        }
        return geoRegionArray;
    }

    public static boolean computeMinDistance(Recordset sourceRecordset, Recordset referenceRecordset, double minDistance, double maxDistance, Datasource outputDatasource, String outputDatasetName) {
        return ProximityAnalyst.computeDistanceInternal(sourceRecordset, referenceRecordset, minDistance, maxDistance, outputDatasource, outputDatasetName, ComputeDistanceType.MINDISTANCE);
    }

    public static boolean computeMinDistance(Geometry[] sourceGeometries, Recordset referenceRecordset, double minDistance, double maxDistance, Datasource outputDatasource, String outputDatasetName) {
        return ProximityAnalyst.computeDistanceInternal(sourceGeometries, referenceRecordset, minDistance, maxDistance, outputDatasource, outputDatasetName, ComputeDistanceType.MINDISTANCE);
    }

    public static ComputeDistanceResult[] computeMinDistance(Recordset sourceRecordset, Recordset referenceRecordset, double minDistance, double maxDistance) {
        return ProximityAnalyst.computeDistanceInternal(sourceRecordset, referenceRecordset, minDistance, maxDistance, ComputeDistanceType.MINDISTANCE);
    }

    public static ComputeDistanceResult[] computeMinDistance(Geometry[] sourceGeometries, Recordset referenceRecordset, double minDistance, double maxDistance) {
        return ProximityAnalyst.computeDistanceInternal(sourceGeometries, referenceRecordset, minDistance, maxDistance, ComputeDistanceType.MINDISTANCE);
    }

    public static boolean computeRangeDistance(Recordset sourceRecordset, Recordset referenceRecordset, double minDistance, double maxDistance, Datasource outputDatasource, String outputDatasetName) {
        return ProximityAnalyst.computeDistanceInternal(sourceRecordset, referenceRecordset, minDistance, maxDistance, outputDatasource, outputDatasetName, ComputeDistanceType.RANGEDISTANCE);
    }

    public static boolean computeRangeDistance(Geometry[] sourceGeometries, Recordset referenceRecordset, double minDistance, double maxDistance, Datasource outputDatasource, String outputDatasetName) {
        return ProximityAnalyst.computeDistanceInternal(sourceGeometries, referenceRecordset, minDistance, maxDistance, outputDatasource, outputDatasetName, ComputeDistanceType.RANGEDISTANCE);
    }

    public static ComputeDistanceResult[] computeRangeDistance(Recordset sourceRecordset, Recordset referenceRecordset, double minDistance, double maxDistance) {
        return ProximityAnalyst.computeDistanceInternal(sourceRecordset, referenceRecordset, minDistance, maxDistance, ComputeDistanceType.RANGEDISTANCE);
    }

    public static ComputeDistanceResult[] computeRangeDistance(Geometry[] sourceGeometries, Recordset referenceRecordset, double minDistance, double maxDistance) {
        return ProximityAnalyst.computeDistanceInternal(sourceGeometries, referenceRecordset, minDistance, maxDistance, ComputeDistanceType.RANGEDISTANCE);
    }

    private static boolean computeDistanceInternal(Recordset sourceRecordset, Recordset referenceRecordset, double minDistance, double maxDistance, Datasource outputDatasource, String outputDatasetName, ComputeDistanceType type) {
        ProximityAnalyst.checkParameter(sourceRecordset, referenceRecordset, minDistance, maxDistance, type);
        int n = 1;
        boolean bl = false;
        long[] lArray = new long[]{InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset)};
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (outputDatasetName == null) {
            String string = InternalResource.loadString("outputDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
        datasetVectorInfo.setName(outputDatasetName);
        datasetVectorInfo.setType(DatasetType.TABULAR);
        DatasetVector datasetVector = outputDatasource.getDatasets().create(datasetVectorInfo);
        if (datasetVector == null) {
            return false;
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)referenceRecordset);
        boolean bl2 = ProximityAnalystNative.jni_ComputeDistance(lArray, n, bl, l3, l2, minDistance, maxDistance, type.value());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRecordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)referenceRecordset);
        if (!bl2) {
            outputDatasource.getDatasets().delete(outputDatasetName);
        }
        return bl2;
    }

    private static boolean computeDistanceInternal(Geometry[] sourceGeometries, Recordset referenceRecordset, double minDistance, double maxDistance, Datasource outputDatasource, String outputDatasetName, ComputeDistanceType type) {
        boolean bl;
        ProximityAnalyst.checkParameter(sourceGeometries, referenceRecordset, minDistance, maxDistance, type);
        int n = 0;
        for (bl = false; bl < sourceGeometries.length; bl += 1) {
            if (sourceGeometries[bl] == null) continue;
            ++n;
        }
        if (n == 0) {
            String string = InternalResource.loadString("sourceGeometries", "Global_ArrayLengthShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        bl = true;
        int n2 = n;
        long[] lArray = new long[n2];
        int n3 = 0;
        for (int i = 0; i < sourceGeometries.length; ++i) {
            if (sourceGeometries[i] == null) continue;
            if (sourceGeometries[i].getType() != GeometryType.GEOPOINT) {
                String string = InternalResource.loadString("sourceGeometries", "GeometryTypeMustBePoint", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[n3++] = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceGeometries[i]);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (outputDatasetName == null) {
            String string = InternalResource.loadString("outputDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
        datasetVectorInfo.setName(outputDatasetName);
        datasetVectorInfo.setType(DatasetType.TABULAR);
        DatasetVector datasetVector = outputDatasource.getDatasets().create(datasetVectorInfo);
        if (datasetVector == null) {
            return false;
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)referenceRecordset);
        boolean bl2 = ProximityAnalystNative.jni_ComputeDistance(lArray, n2, bl, l3, l2, minDistance, maxDistance, type.value());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceGeometries);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)referenceRecordset);
        if (!bl2) {
            outputDatasource.getDatasets().delete(outputDatasetName);
        }
        return bl2;
    }

    private static ComputeDistanceResult[] computeDistanceInternal(Recordset sourceRecordset, Recordset referenceRecordset, double minDistance, double maxDistance, ComputeDistanceType type) {
        ProximityAnalyst.checkParameter(sourceRecordset, referenceRecordset, minDistance, maxDistance, type);
        int n = 1;
        boolean bl = false;
        long[] lArray = new long[]{InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset)};
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)referenceRecordset);
        long[] lArray2 = ProximityAnalystNative.jni_ComputeDistance1(lArray, n, bl, l, minDistance, maxDistance, type.value());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRecordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)referenceRecordset);
        if (lArray2 == null || lArray2.length == 0) {
            return null;
        }
        ComputeDistanceResult[] computeDistanceResultArray = new ComputeDistanceResult[lArray2.length];
        for (int i = 0; i < lArray2.length; ++i) {
            ComputeDistanceResultInternal computeDistanceResultInternal = new ComputeDistanceResultInternal(lArray2[i]);
            if (computeDistanceResultInternal.getSourceGeometryID() < 0) {
                computeDistanceResultInternal.dispose();
                continue;
            }
            double d = computeDistanceResultInternal.getDistance();
            int[] nArray = computeDistanceResultInternal.getReferenceGeometryIDs();
            ComputeDistanceResult computeDistanceResult = new ComputeDistanceResult();
            computeDistanceResult.setSourceGeometryID(computeDistanceResultInternal.getSourceGeometryID());
            computeDistanceResult.setReferenceGeometryIDs(nArray);
            computeDistanceResult.setDistance(d);
            computeDistanceResultArray[i] = computeDistanceResult;
            computeDistanceResultInternal.dispose();
        }
        return computeDistanceResultArray;
    }

    private static ComputeDistanceResult[] computeDistanceInternal(Geometry[] sourceGeometries, Recordset referenceRecordset, double minDistance, double maxDistance, ComputeDistanceType type) {
        boolean bl;
        ProximityAnalyst.checkParameter(sourceGeometries, referenceRecordset, minDistance, maxDistance, type);
        int n = 0;
        for (bl = false; bl < sourceGeometries.length; bl += 1) {
            if (sourceGeometries[bl] == null) continue;
            ++n;
        }
        if (n == 0) {
            String string = InternalResource.loadString("sourceGeometries", "Global_ArrayLengthShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        bl = true;
        int n2 = n;
        long[] lArray = new long[n2];
        int n3 = 0;
        for (int i = 0; i < sourceGeometries.length; ++i) {
            if (sourceGeometries[i] == null) continue;
            if (sourceGeometries[i].getType() != GeometryType.GEOPOINT) {
                String string = InternalResource.loadString("sourceGeometries", "GeometryTypeMustBePoint", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[n3++] = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceGeometries[i]);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)referenceRecordset);
        long[] lArray2 = ProximityAnalystNative.jni_ComputeDistance1(lArray, n2, bl, l, minDistance, maxDistance, type.value());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceGeometries);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)referenceRecordset);
        if (lArray2 == null || lArray2.length == 0) {
            return null;
        }
        ComputeDistanceResult[] computeDistanceResultArray = new ComputeDistanceResult[lArray2.length];
        for (int i = 0; i < lArray2.length; ++i) {
            ComputeDistanceResultInternal computeDistanceResultInternal = new ComputeDistanceResultInternal(lArray2[i]);
            if (computeDistanceResultInternal.getSourceGeometryID() < 0) {
                computeDistanceResultInternal.dispose();
                continue;
            }
            double d = computeDistanceResultInternal.getDistance();
            int[] nArray = computeDistanceResultInternal.getReferenceGeometryIDs();
            ComputeDistanceResult computeDistanceResult = new ComputeDistanceResult();
            computeDistanceResult.setSourceGeometryID(computeDistanceResultInternal.getSourceGeometryID());
            computeDistanceResult.setReferenceGeometryIDs(nArray);
            computeDistanceResult.setDistance(d);
            computeDistanceResultArray[i] = computeDistanceResult;
            computeDistanceResultInternal.dispose();
        }
        return computeDistanceResultArray;
    }

    private static boolean checkParameter(Geometry[] sourceGeometries, Recordset referenceRecordset, double minDistance, double maxDistance, ComputeDistanceType type) {
        if (referenceRecordset == null) {
            String string = InternalResource.loadString("referenceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)referenceRecordset);
        if (l == 0L) {
            String string = InternalResource.loadString("referenceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        DatasetType datasetType = referenceRecordset.getDataset().getType();
        if (datasetType != DatasetType.POINT && datasetType != DatasetType.LINE && datasetType != DatasetType.REGION && datasetType != DatasetType.NETWORK) {
            String string = InternalResource.loadString("referenceRecordset", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetType == DatasetType.NETWORK && referenceRecordset.getDataset().getChildDataset().getType() != DatasetType.POINT) {
            String string = InternalResource.loadString("referenceRecordset", "Unsupport_3D_DatasetVector", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (minDistance < 0.0) {
            String string = InternalResource.loadString("minDistance", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (maxDistance < 0.0) {
            maxDistance = -1.0;
        }
        if (type == ComputeDistanceType.MINDISTANCE && maxDistance == 0.0) {
            String string = InternalResource.loadString("maxDistance", "CanNotBeZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (type == ComputeDistanceType.RANGEDISTANCE && maxDistance <= 0.0) {
            String string = InternalResource.loadString("maxDistance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (maxDistance > 0.0 && maxDistance < minDistance) {
            String string = InternalResource.loadString("maxDistance", "MaxDistance_CannotBeLess_MinDistance", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceGeometries == null) {
            String string = InternalResource.loadString("sourceGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        return true;
    }

    private static boolean checkParameter(Recordset sourceRecordset, Recordset referenceRecordset, double minDistance, double maxDistance, ComputeDistanceType type) {
        PrjCoordSys prjCoordSys;
        if (referenceRecordset == null) {
            String string = InternalResource.loadString("referenceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)referenceRecordset);
        if (l == 0L) {
            String string = InternalResource.loadString("referenceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (minDistance < 0.0) {
            String string = InternalResource.loadString("minDistance", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (maxDistance < 0.0) {
            maxDistance = -1.0;
        }
        if (type == ComputeDistanceType.MINDISTANCE && maxDistance == 0.0) {
            String string = InternalResource.loadString("maxDistance", "CanNotBeZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (type == ComputeDistanceType.RANGEDISTANCE && maxDistance <= 0.0) {
            String string = InternalResource.loadString("maxDistance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (maxDistance > 0.0 && maxDistance < minDistance) {
            String string = InternalResource.loadString("maxDistance", "MaxDistance_CannotBeLess_MinDistance", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceRecordset == null) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        DatasetType datasetType = sourceRecordset.getDataset().getType();
        if (datasetType != DatasetType.POINT) {
            String string = InternalResource.loadString("sourceRecordset", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetType datasetType2 = referenceRecordset.getDataset().getType();
        if (datasetType2 != DatasetType.POINT && datasetType2 != DatasetType.LINE && datasetType2 != DatasetType.REGION && datasetType2 != DatasetType.NETWORK) {
            String string = InternalResource.loadString("referenceRecordset", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetType2 == DatasetType.NETWORK && referenceRecordset.getDataset().getChildDataset().getType() != DatasetType.POINT) {
            String string = InternalResource.loadString("referenceRecordset", "Unsupport_3D_DatasetVector", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        PrjCoordSys prjCoordSys2 = sourceRecordset.getDataset().getPrjCoordSys();
        if (!Generalization.isPrjCoordSysIdentical(prjCoordSys2, prjCoordSys = referenceRecordset.getDataset().getPrjCoordSys())) {
            String string = InternalResource.loadString("sourceRecordset and referenceRecordset", "Projection_Not_Same", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return true;
    }

    public static DatasetVector rarefyPoints(DatasetVector sourceDataset, double radius, String resultDatasetName, Datasource outputDatasource, boolean isSaveAttributes) {
        if (sourceDataset == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        if (l == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l2 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resultDatasetName == null || resultDatasetName.isEmpty()) {
            String string = InternalResource.loadString("resultDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (radius < 0.0 || radius == 0.0) {
            String string = InternalResource.loadString("radius", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getType() != DatasetType.POINT) {
            String string = InternalResource.loadString("pointDataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
        datasetVectorInfo.setName(outputDatasource.getDatasets().getAvailableDatasetName(resultDatasetName));
        datasetVectorInfo.setType(sourceDataset.getType());
        DatasetVector datasetVector = outputDatasource.getDatasets().create(datasetVectorInfo);
        if (datasetVector == null) {
            return null;
        }
        datasetVector.open();
        datasetVector.setPrjCoordSys(sourceDataset.getPrjCoordSys());
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        boolean bl = false;
        bl = ProximityAnalystNative.jni_RarefyDt(l, l3, radius, isSaveAttributes);
        if (bl) {
            return datasetVector;
        }
        outputDatasource.getDatasets().delete(datasetVector.getName());
        return null;
    }

    public static DatasetVector summaryPoints(DatasetVector sourceDataset, double radius, Unit unit, StatisticsField[] statisticFields, Datasource outputDatasource, String resultDatasetName, boolean isRandomSavePnt, boolean isSaveAttributes) {
        if (sourceDataset == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        if (l == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        QueryParameter queryParameter = new QueryParameter();
        queryParameter.setCursorType(CursorType.STATIC);
        Recordset recordset = sourceDataset.query(queryParameter);
        DatasetVector datasetVector = null;
        datasetVector = ProximityAnalyst.summaryPoints(recordset, radius, unit, statisticFields, outputDatasource, resultDatasetName, isRandomSavePnt, isSaveAttributes);
        if (recordset != null) {
            recordset.dispose();
        }
        return datasetVector;
    }

    public static DatasetVector summaryPoints(Recordset recordset, double radius, Unit unit, StatisticsField[] statisticFields, Datasource outputDatasource, String resultDatasetName, boolean isRandomSavePnt, boolean isSaveAttributes) {
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (l == 0L) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l2 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resultDatasetName == null || resultDatasetName.isEmpty()) {
            String string = InternalResource.loadString("resultDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (radius < 0.0 || radius == 0.0) {
            String string = InternalResource.loadString("radius", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset.getDataset().getType() != DatasetType.POINT) {
            String string = InternalResource.loadString("pointDataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(resultDatasetName)) {
            String string = InternalResource.loadString("resultDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = statisticFields.length;
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int[] nArray = new int[n];
        FieldInfos fieldInfos = recordset.getFieldInfos();
        DatasetVector datasetVector = recordset.getDataset();
        for (int i = 0; i < statisticFields.length; ++i) {
            int n2 = fieldInfos.indexOf(statisticFields[i].getSourceField());
            if (n2 == -1) {
                String string = InternalResource.loadString("SourceField", "FieldInfo_NameIsNotExist", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            stringArray[i] = statisticFields[i].getSourceField();
            if (isSaveAttributes) {
                if (!datasetVector.isAvailableFieldName(statisticFields[i].getResultField())) {
                    String string = InternalResource.loadString("ResultField", "FieldInfo_NameIsNotAvaliable", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
            } else if (statisticFields[i].getResultField() == null || statisticFields[i].getResultField().startsWith("sm")) {
                String string = InternalResource.loadString("ResultField", "FieldInfo_NameIsNotAvaliable", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            stringArray2[i] = statisticFields[i].getResultField();
            nArray[i] = statisticFields[i].getMode().value();
        }
        long l3 = ProximityAnalystNative.jni_summaryPoints(l, radius, unit.value(), stringArray, stringArray2, nArray, l2, resultDatasetName, isSaveAttributes, isRandomSavePnt);
        DatasetVector datasetVector2 = null;
        if (l3 != 0L) {
            datasetVector2 = InternalDatasetVector.createInstance(l3, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector2);
        }
        return datasetVector2;
    }

    public static StatisticsPoint[] rarefyPoints(StatisticsPoint[] sourcePoints, double radius) {
        if (sourcePoints == null) {
            String string = InternalResource.loadString("sourcePoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourcePoints.length == 0) {
            String string = InternalResource.loadString("sourcePoints", "Global_ArrayLengthShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (radius < 0.0 || radius == 0.0) {
            String string = InternalResource.loadString("radius", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = sourcePoints.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (sourcePoints[i].getPoint() != null) {
                dArray[i] = sourcePoints[i].getPoint().getX();
                dArray2[i] = sourcePoints[i].getPoint().getY();
                nArray[i] = sourcePoints[i].getStatisticsCount();
                continue;
            }
            nArray[i] = 0;
        }
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        int[] nArray2 = new int[n];
        int n2 = ProximityAnalystNative.jni_RarefyDt2(dArray, dArray2, nArray, n, radius, dArray3, dArray4, nArray2);
        if (n2 > 0) {
            StatisticsPoint[] statisticsPointArray = new StatisticsPoint[n2];
            for (int i = 0; i < n2; ++i) {
                statisticsPointArray[i] = new StatisticsPoint(new Point2D(dArray3[i], dArray4[i]), nArray2[i]);
            }
            return statisticsPointArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector<SteppedListener> vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "ProximityAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        ProximityAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    public static DatasetVector createThiessenPolygon(DatasetVector sourcePoint, Datasource outputDatasource, String outputDatasetName, GeoRegion clipRegion, String[] statisticsFields, StatisticsType[] statisticsTypes) {
        ProximityAnalyst.verifyLicense();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourcePoint);
        if (sourcePoint == null || l == 0L) {
            String string = InternalResource.loadString("sourcePoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!sourcePoint.getType().equals((Object)DatasetType.POINT)) {
            String string = InternalResource.loadString("sourcePoint", "ProximityAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (outputDatasource == null || l2 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        ProximityAnalyst.checkStatisticsField(sourcePoint, statisticsFields, statisticsTypes);
        int[] nArray = new int[statisticsTypes.length];
        for (int i = 0; i < statisticsTypes.length; ++i) {
            nArray[i] = statisticsTypes[i].value();
        }
        long l3 = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        long l4 = ProximityAnalystNative.jni_CreateThiessenPolygon2(l, l2, outputDatasetName, l3, statisticsFields, nArray);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector createThiessenPolygon(Recordset sourcePointRecordset, Datasource outputDatasource, String outputDatasetName, GeoRegion clipRegion, String[] statisticsFields, StatisticsType[] statisticsTypes) {
        ProximityAnalyst.verifyLicense();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourcePointRecordset);
        if (sourcePointRecordset == null || l == 0L) {
            String string = InternalResource.loadString("sourcePointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!sourcePointRecordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string = InternalResource.loadString("sourcePointRecordset", "ProximityAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (outputDatasource == null || l2 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        ProximityAnalyst.checkStatisticsField(sourcePointRecordset.getDataset(), statisticsFields, statisticsTypes);
        long l3 = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        int[] nArray = new int[statisticsTypes.length];
        for (int i = 0; i < statisticsTypes.length; ++i) {
            nArray[i] = statisticsTypes[i].value();
        }
        long l4 = ProximityAnalystNative.jni_CreateThiessenPolygonByRecordset2(l, l2, outputDatasetName, l3, statisticsFields, nArray);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourcePointRecordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    private static void checkStatisticsField(DatasetVector dataset, String[] statisticsFields, StatisticsType[] statisticsTypes) {
        if (statisticsFields == null || statisticsTypes == null) {
            return;
        }
        if (dataset == null) {
            return;
        }
        if (statisticsFields == null && statisticsTypes != null || statisticsFields != null && statisticsTypes == null) {
            String string = InternalResource.loadString("statisticFields && statisticTypes", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (statisticsFields.length != statisticsTypes.length) {
            String string = InternalResource.loadString("statisticFields && statisticTypes", "StatisticsFieldAndStaticsTypeCountMustEqual", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < statisticsFields.length; ++i) {
            if (statisticsFields[i] != null && !statisticsFields[i].isEmpty()) continue;
            String string = InternalResource.loadString(String.format("statisticFields[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public static boolean autoComputeProjectPoint(Recordset sourceRecordset, Recordset referenceRecordset, double maxDistance, Datasource outputDatasource, String outputDatasetName) {
        double d = 0.0;
        ComputeDistanceType computeDistanceType = ComputeDistanceType.MINDISTANCE;
        ProximityAnalyst.checkParameter(sourceRecordset, referenceRecordset, d, maxDistance, computeDistanceType);
        int n = 1;
        boolean bl = false;
        long[] lArray = new long[]{InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset)};
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (outputDatasetName == null) {
            String string = InternalResource.loadString("outputDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
        datasetVectorInfo.setName(outputDatasetName);
        datasetVectorInfo.setType(DatasetType.TABULAR);
        DatasetVector datasetVector = outputDatasource.getDatasets().create(datasetVectorInfo);
        if (datasetVector == null) {
            return false;
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)referenceRecordset);
        boolean bl2 = ProximityAnalystNative.jni_autoComputeProjectPoint(lArray, n, bl, l3, l2, d, maxDistance, computeDistanceType.value());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRecordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)referenceRecordset);
        if (!bl2) {
            outputDatasource.getDatasets().delete(outputDatasetName);
        }
        return bl2;
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

