/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.OverlayAnalystOutputType;
import java.util.ArrayList;

public class OverlayAnalystParameter {
    private ArrayList m_sourceRetainedFields;
    private ArrayList m_operationRetainedFields;
    private double m_tolerance;
    private OverlayAnalystOutputType m_OutputType;
    private boolean m_singleResult;

    public OverlayAnalystParameter() {
        this.m_sourceRetainedFields = new ArrayList();
        this.m_operationRetainedFields = new ArrayList();
        this.m_tolerance = 0.0;
        this.m_OutputType = OverlayAnalystOutputType.INPUT;
        this.m_singleResult = true;
    }

    public OverlayAnalystParameter(OverlayAnalystParameter overlayAnalystParameter) {
        if (overlayAnalystParameter == null) {
            String string = InternalResource.loadString("overlayAnalystParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        this.setSourceRetainedFields(overlayAnalystParameter.getSourceRetainedFields());
        this.setOperationRetainedFields(overlayAnalystParameter.getOperationRetainedFields());
        this.setTolerance(overlayAnalystParameter.getTolerance());
        this.m_OutputType = overlayAnalystParameter.getOutputType();
        this.setSingleResult(overlayAnalystParameter.isSingleResult());
    }

    public String[] getSourceRetainedFields() {
        int n = this.m_sourceRetainedFields.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_sourceRetainedFields.get(i).toString();
        }
        return stringArray;
    }

    public void setSourceRetainedFields(String[] value) {
        int n;
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n2 = value.length;
        for (n = 0; n < n2; ++n) {
            if (value[n] != null && !value[n].trim().equalsIgnoreCase("")) continue;
            String string = InternalResource.loadString("value[" + n + "]", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_sourceRetainedFields.clear();
        for (n = 0; n < n2; ++n) {
            this.m_sourceRetainedFields.add(value[n]);
        }
    }

    public String[] getOperationRetainedFields() {
        int n = this.m_operationRetainedFields.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_operationRetainedFields.get(i).toString();
        }
        return stringArray;
    }

    public void setOperationRetainedFields(String[] value) {
        int n;
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n2 = value.length;
        for (n = 0; n < n2; ++n) {
            if (value[n] != null && !value[n].trim().equalsIgnoreCase("")) continue;
            String string = InternalResource.loadString("value[" + n + "]", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_operationRetainedFields.clear();
        for (n = 0; n < n2; ++n) {
            this.m_operationRetainedFields.add(value[n]);
        }
    }

    public double getTolerance() {
        return this.m_tolerance;
    }

    public void setTolerance(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "OverlayAnalystParameter_ToleranceShouldEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_tolerance = value;
    }

    public OverlayAnalystOutputType getOutputType() {
        return this.m_OutputType;
    }

    public void setOutputType(OverlayAnalystOutputType value) {
        this.m_OutputType = value;
    }

    public boolean isSingleResult() {
        return this.m_singleResult;
    }

    public void setSingleResult(boolean value) {
        this.m_singleResult = value;
    }
}

