/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.GridHistogramNative;
import com.supermap.analyst.spatialanalyst.HistogramSegmentInfo;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;

public class GridHistogram
extends InternalHandle {
    private long m_handle;

    protected GridHistogram(long ugcHandle) {
        this.m_handle = ugcHandle;
    }

    public int getGroupCount() {
        if (this.m_handle == 0L) {
            String string = InternalResource.loadString("handle", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = GridHistogramNative.jni_GetGroupCount(this.m_handle);
        return n;
    }

    public void setGroupCount(int count) {
        if (this.m_handle == 0L) {
            String string = InternalResource.loadString("handle", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (count <= 0) {
            String string = InternalResource.loadString("GroupCount", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GridHistogramNative.jni_SetGroupCount(this.m_handle, count);
    }

    public int[] getFrequencies() {
        if (this.m_handle == 0L) {
            String string = InternalResource.loadString("handle", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int[] nArray = GridHistogramNative.jni_GetFrequencies(this.m_handle);
        return nArray;
    }

    public HistogramSegmentInfo[] getSegmentInfos() {
        if (this.m_handle == 0L) {
            String string = InternalResource.loadString("handle", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int[] nArray = GridHistogramNative.jni_GetFrequencies(this.m_handle);
        int n = nArray.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        GridHistogramNative.jni_GetSegmentInfos(this.m_handle, dArray, dArray2, dArray3, dArray4);
        HistogramSegmentInfo[] histogramSegmentInfoArray = new HistogramSegmentInfo[n];
        for (int i = 0; i < n; ++i) {
            histogramSegmentInfoArray[i] = new HistogramSegmentInfo(dArray[i], dArray2[i], dArray3[i], dArray4[i], nArray[i]);
        }
        return histogramSegmentInfoArray;
    }

    public void dispose() {
        if (this.m_handle == 0L) {
            String string = InternalResource.loadString("handle", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GridHistogramNative.jni_Dispose(this.m_handle);
    }
}

