/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.GeoStyle;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.ThemeRange;
import com.supermap.mapping.ThemeRangeNative;

public class ThemeRangeItem {
    private double m_start = InternalToolkitMapping.FLT_MIN_VALUE;
    private double m_end = InternalToolkitMapping.FLT_MAX_VALUE;
    private boolean m_isVisible = true;
    private String m_caption = "UntitledThemeRangeItem";
    private GeoStyle m_style = null;
    private boolean isUserThemeRange = false;
    private ThemeRange m_themeRange = null;

    public ThemeRangeItem() {
        GeoStyle geoStyle = new GeoStyle();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle, false);
        this.m_style = geoStyle;
        this.isUserThemeRange = false;
    }

    public ThemeRangeItem(double start, double end, GeoStyle style) {
        if (style == null) {
            String string = InternalResource.loadString("ThemeRangeItem(double start, double end, GeoStyle style)", "Global_ArgumentNull", "mapping_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_start = start;
        this.m_end = end;
        GeoStyle geoStyle = style.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle, false);
        this.m_style = geoStyle;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
        this.isUserThemeRange = false;
    }

    public ThemeRangeItem(double start, double end, GeoStyle style, String caption) {
        if (style == null) {
            String string = InternalResource.loadString("ThemeRangeItem(double start, double end, GeoStyle style,String caption)", "Global_ArgumentNull", "mapping_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_start = start;
        this.m_end = end;
        this.m_caption = caption;
        GeoStyle geoStyle = style.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle, false);
        this.m_style = geoStyle;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
        this.isUserThemeRange = false;
    }

    public ThemeRangeItem(ThemeRangeItem themeRangeItem) {
        if (themeRangeItem == null) {
            String string = InternalResource.loadString("themeRangeItem", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeRangeItem.isUserThemeRange) {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeRangeItem.m_themeRange);
            if (l == 0L) {
                String string = InternalResource.loadString("themeRengeItem", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            int n = themeRangeItem.m_themeRange.getRangeItemsList().indexOf(themeRangeItem);
            if (n == -1) {
                String string = InternalResource.loadString("themeRangeItem", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        this.m_start = themeRangeItem.getStart();
        this.m_end = themeRangeItem.getEnd();
        this.m_isVisible = themeRangeItem.isVisible();
        this.m_caption = themeRangeItem.getCaption();
        GeoStyle geoStyle = themeRangeItem.getStyle().clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle, false);
        this.m_style = geoStyle;
        this.isUserThemeRange = false;
    }

    ThemeRangeItem(ThemeRange themeRange) {
        this.m_themeRange = themeRange;
        this.isUserThemeRange = true;
    }

    public double getStart() {
        double d = 0.0;
        if (this.isUserThemeRange) {
            int n = this.m_themeRange.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getStart()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange);
            if (l == 0L) {
                String string = InternalResource.loadString("getStart()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            d = ThemeRangeNative.jni_GetValueAt(l, n);
        } else {
            d = this.m_start;
        }
        return d;
    }

    public void setStart(double start) {
        if (this.isUserThemeRange) {
            int n = this.m_themeRange.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setStart(double start)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange);
            if (l == 0L) {
                String string = InternalResource.loadString("setStart(double start)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeRangeNative.jni_SetValueAt(l, n, start);
        }
        this.m_start = start;
    }

    public double getEnd() {
        double d = 0.0;
        if (this.isUserThemeRange) {
            int n = this.m_themeRange.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getEnd()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange);
            if (l == 0L) {
                String string = InternalResource.loadString("getEnd()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            d = ThemeRangeNative.jni_GetValueAt(l, n + 1);
        } else {
            d = this.m_end;
        }
        return d;
    }

    public void setEnd(double end) {
        if (this.isUserThemeRange) {
            int n = this.m_themeRange.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setEnd(double end)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange);
            if (l == 0L) {
                String string = InternalResource.loadString("setEnd(double end)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeRangeNative.jni_SetValueAt(l, n + 1, end);
        }
        this.m_end = end;
    }

    public boolean isVisible() {
        boolean bl = false;
        if (this.isUserThemeRange) {
            int n = this.m_themeRange.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange);
            if (l == 0L) {
                String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            bl = ThemeRangeNative.jni_GetIsVisibleAt(l, n);
        } else {
            bl = this.m_isVisible;
        }
        return bl;
    }

    public void setVisible(boolean value) {
        if (this.isUserThemeRange) {
            int n = this.m_themeRange.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange);
            if (l == 0L) {
                String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeRangeNative.jni_SetIsVisibleAt(l, n, value);
        }
        this.m_isVisible = value;
    }

    public GeoStyle getStyle() {
        if (this.isUserThemeRange) {
            long l;
            int n = this.m_themeRange.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_style == null && (l = ThemeRangeNative.jni_GetStyleAt(l2, n)) != 0L) {
                this.m_style = InternalGeoStyle.createInstance(l);
            }
        }
        return this.m_style;
    }

    public void setStyle(GeoStyle style) {
        long l;
        if (style == null) {
            String string = InternalResource.loadString("setStyle(GeoStyle style)", "Global_ArgumentNull", "mapping_resources");
            throw new NullPointerException(string);
        }
        int n = -1;
        long l2 = 0L;
        if (this.isUserThemeRange) {
            n = this.m_themeRange.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange);
            if (l2 == 0L) {
                String string = InternalResource.loadString("setStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style)) == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle = style.clone();
        long l3 = 0L;
        if (this.isUserThemeRange) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
            ThemeRangeNative.jni_SetStyleAt(l2, n, l3);
        } else {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle, false);
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
            if (this.m_style == null) {
                this.m_style = geoStyle;
            } else {
                InternalGeoStyle.changeHandle(this.m_style, l3);
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    public String getCaption() {
        String string = null;
        if (this.isUserThemeRange) {
            int n = this.m_themeRange.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string2 = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange);
            if (l == 0L) {
                String string3 = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string3);
            }
            string = ThemeRangeNative.jni_GetCaptionAt(l, n);
        } else {
            string = this.m_caption == null ? "" : this.m_caption;
        }
        return string;
    }

    public void setCaption(String caption) {
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserThemeRange) {
            int n = this.m_themeRange.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange);
            if (l == 0L) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeRangeNative.jni_SetCaptionAt(l, n, caption);
        }
        this.m_caption = caption;
    }

    public String toString() {
        if (this.isUserThemeRange) {
            int n = this.m_themeRange.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange);
            if (l == 0L) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Caption = ");
        stringBuffer.append(this.getCaption());
        stringBuffer.append(",Start = ");
        stringBuffer.append(this.getStart());
        stringBuffer.append(",End = ");
        stringBuffer.append(this.getEnd());
        stringBuffer.append(",Visible = ");
        stringBuffer.append(this.isVisible());
        stringBuffer.append(",Style = ");
        stringBuffer.append(this.getStyle().toString());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    protected void finalize() {
        if (this.m_style != null && !this.isUserThemeRange) {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_style, true);
            this.m_style.dispose();
        }
    }

    void clearHandle() {
        if (this.m_style != null) {
            InternalGeoStyle.clearHandle(this.m_style);
            this.m_style = null;
        }
    }

    void refreshStyle(long handle) {
        if (this.isUserThemeRange && this.m_style != null) {
            InternalGeoStyle.refreshHandle(this.m_style, handle);
        }
    }
}

